/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.cmpdesign.app.v2.bill;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.hr.base.HRBillBaseInfo;
import com.kingdee.eas.hr.base.HRBillStateEnum;
import com.kingdee.eas.hr.base.util.HRParamUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.api.bean.SHRCodingRule;
import com.kingdee.shr.base.syssetting.api.service.SHRCodingRuleApi;
import com.kingdee.shr.cmpdesign.AdjustSalaryCauseInfo;
import com.kingdee.shr.cmpdesign.CmpStandardInfo;
import com.kingdee.shr.cmpdesign.CmpStdLevelInfo;
import com.kingdee.shr.cmpdesign.CmpStdPointInfo;
import com.kingdee.shr.cmpdesign.CmpStdScopeInfo;
import com.kingdee.shr.cmpdesign.CmpStdValueCollection;
import com.kingdee.shr.cmpdesign.CmpStdValueFactory;
import com.kingdee.shr.cmpdesign.CmpStdValueInfo;
import com.kingdee.shr.cmpdesign.app.v2.bill.AbstractAdjustSalaryApplyControllerBean;
import com.kingdee.shr.cmpdesign.app.v2.bill.AdjBillSourceEnum;
import com.kingdee.shr.cmpdesign.app.v2.bill.AdjustSalaryApplyCollection;
import com.kingdee.shr.cmpdesign.app.v2.bill.AdjustSalaryApplyEntryCollection;
import com.kingdee.shr.cmpdesign.app.v2.bill.AdjustSalaryApplyEntryInfo;
import com.kingdee.shr.cmpdesign.app.v2.bill.AdjustSalaryApplyFactory;
import com.kingdee.shr.cmpdesign.app.v2.bill.AdjustSalaryApplyInfo;
import com.kingdee.shr.cmpdesign.app.v2.bill.IAdjustSalaryApply;
import com.kingdee.shr.cmpdesign.app.v2.notice.AdjustSalaryNoticeFacadeFactory;
import com.kingdee.shr.cmpdesign.app.v2.notice.NoticeParamInfo;
import com.kingdee.shr.cmpdesign.exception.AdjustBillException;
import com.kingdee.shr.cmpdesign.fix.ApplyBill2FixAdjustSalary;
import com.kingdee.shr.cmpdesign.fix.FixAdjustBillProxy;
import com.kingdee.shr.cmpdesign.fix.FixAdjustSalaryExecute;
import com.kingdee.shr.cmpdesign.util.AdjustSalaryUtils;
import com.kingdee.shr.cmpdesign.v2.notice.util.NoticeDaoUtils;
import com.kingdee.shr.compensation.AdjustEmpORelationInfo;
import com.kingdee.shr.compensation.AdjustPersonRecordCollection;
import com.kingdee.shr.compensation.AdjustPersonRecordFactory;
import com.kingdee.shr.compensation.AdjustPersonRecordInfo;
import com.kingdee.shr.compensation.CmpItemInfo;
import com.kingdee.shr.compensation.FixAdjustSalaryCollection;
import com.kingdee.shr.compensation.FixAdjustSalaryFactory;
import com.kingdee.shr.compensation.FixAdjustSalaryInfo;
import com.kingdee.shr.compensation.FixAdjustSalaryRecordFacadeFactory;
import com.kingdee.shr.compensation.util.CmpDateUtil;
import com.kingdee.shr.compensation.util.CmpSQLUtil;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import com.kingdee.shr.ml.util.SHRServerResource;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdjustSalaryApplyControllerBean
extends AbstractAdjustSalaryApplyControllerBean {
    private static final Logger logger = LoggerFactory.getLogger(AdjustSalaryApplyControllerBean.class);

    protected void _abortBizBill(Context ctx, String billId) throws BOSException, EASBizException {
        if (!StringUtils.isEmpty((String)billId)) {
            IAdjustSalaryApply iAdjustSalaryApply = AdjustSalaryApplyFactory.getLocalInstance(ctx);
            AdjustSalaryApplyInfo billInfo = iAdjustSalaryApply.getAdjustSalaryApplyInfo((IObjectPK)new ObjectUuidPK(billId));
            if (null == billInfo) {
                logger.error(MessageFormat.format(" when AdjustSalaryApplyControllerBean._abortBizBill invocked, getAdjustSalaryApplyInfo is null ! billId:{0}", billId));
                return;
            }
            HRBillStateEnum billState = billInfo.getBillState();
            if (HRBillStateEnum.SUBMITED.equals((Object)billState) || HRBillStateEnum.AUDITING.equals((Object)billState) || HRBillStateEnum.AUDITEND.equals((Object)billState)) {
                SelectorItemCollection selector = new SelectorItemCollection();
                billInfo.setBillState(HRBillStateEnum.SAVED);
                selector.add(new SelectorItemInfo("billState"));
                try {
                    AdjustSalaryUtils.updateEntryBillState(ctx, billId, HRBillStateEnum.SAVED);
                }
                catch (BOSException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    String getCalSubmitSchemeItemError = SHRServerResource.getString((String)"com.kingdee.shr.cmpdesign.resource.AdjustMultiLanResource", (String)"getCalSubmitSchemeItemError", (Context)ctx);
                    if (getCalSubmitSchemeItemError.equals(e.getMessage())) {
                        String getAdjustSalaryRuleItemError = SHRServerResource.getString((String)"com.kingdee.shr.cmpdesign.resource.AdjustMultiLanResource", (String)"getAdjustSalaryRuleItemError", (Context)ctx);
                        throw new BOSException(getAdjustSalaryRuleItemError);
                    }
                    throw new BOSException(e.getMessage());
                }
                iAdjustSalaryApply.updatePartial(billInfo, selector);
                this.abortWorkFlow(ctx, billId);
                this.clearProcInstBizInfo(ctx, billInfo);
            } else {
                logger.error(MessageFormat.format("billInfo,id: {0}", String.valueOf(billInfo.getId())));
            }
        } else {
            logger.error(" when BatchSubmitShemeBillControllerBean._abortBizBill invocked, param billId is empty! please check param ");
        }
        DbUtil.execute((Context)ctx, (String)"UPDATE T_HR_SAdjustSalaryApply SET FAUDITORID = '' WHERE FID = ?", (Object[])new Object[]{billId});
    }

    @Override
    protected void _antiApproval(Context ctx, String billId) throws BOSException, EASBizException {
        IAdjustSalaryApply iAdjustSalaryApply = AdjustSalaryApplyFactory.getLocalInstance(ctx);
        AdjustSalaryApplyInfo info = iAdjustSalaryApply.getAdjustSalaryApplyInfo("where id = '" + billId + "'");
        info.setLastUpdateUser(ContextUtil.getCurrentUserInfo((Context)ctx));
        String submitSchemeId = info.getAdjustSalaryRule().getId().toString();
        String calShemeTableName = AdjustSalaryUtils.getCalShemeTableName(ctx, submitSchemeId);
        Timestamp now = new Timestamp(new Date().getTime());
        String updateSql = " UPDATE " + calShemeTableName + " SET FBILLSTATE = ?  WHERE FBILLID = ? ";
        DbUtil.execute((Context)ctx, (String)updateSql, (Object[])new Object[]{0, billId});
        String updateBillSql = "update T_HR_SAdjustSalaryApply set  FAUDITORID = '' ,FBillState = ? , FLastUpdateTime = ? where fid = ? ";
        Object[] param = new Object[]{HRBillStateEnum.SAVED.getValue(), now, billId};
        DbUtil.execute((Context)ctx, (String)updateBillSql, (Object[])param);
        this.checkNoticeDataExist(ctx, billId);
        try {
            boolean adj003Param = this.getAdj003Param(ctx, info.getHrOrgUnit().getId().toString());
            if (!adj003Param) {
                this.updateCmpStruct(ctx, billId, calShemeTableName);
            }
            this.udpEntryState(ctx, info, 0);
        }
        catch (EASBizException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    public void checkNoticeDataExist(Context ctx, String billId) throws EASBizException, BOSException {
        try {
            NoticeDaoUtils.validateEntryBeforeAntiApproval(ctx, billId);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("adjBillId", billId);
        AdjustSalaryNoticeFacadeFactory.getLocalInstance(ctx).deleteNoticeDataByAdjBillId(param);
    }

    private void updateCmpStruct(Context ctx, String billId, String calShemeTableName) throws Exception {
        String lang = ctx.getLocale().getLanguage();
        IRowSet rowSet = null;
        String personFilter = " select fpersonid from " + calShemeTableName + " where fbillId = '" + billId + "' ";
        Map<String, FixAdjustSalaryInfo> map = AdjustSalaryUtils.getLastFixAdjustInfo(ctx, personFilter);
        StringBuilder str = new StringBuilder();
        str.append(" SELECT A01.FBILLID, A01.FEFFECTDAY, A01.FPERSONID, A01.FPayHrOrgUnitID, A01.FCMPITEMID, A02.FNAME_" + lang + " PERNAME, adjitem.FNAME_" + lang + " ITEMNAME, A01.FID  ");
        str.append(" FROM ").append(calShemeTableName).append(" AA");
        str.append(" left join T_HR_SAdjustSalaryApply s on s.fid = AA.Fbillid ");
        str.append(" left join t_hr_scalsubmitscheme cal on cal.fid = s.FAdjustSalaryRuleID ");
        str.append(" left join T_HR_SBatchAdjustRuleItem rul on rul.FCalSubmitSchemeID = cal.fid ");
        str.append(" left join T_HR_AdjustSalaryItem adjitem on adjitem.fid = rul.FAdjustSalaryItemID ");
        str.append(" left join t_hr_scmpitem item on item.fid = adjitem.FCmpItemID ");
        str.append(" left join T_HR_SFIXADJUSTSALARY A01 ON AA.FPERSONID = A01.FPERSONID and (AA.FHrOrgUnitID = A01.FPayHrOrgUnitID or (AA.FHrOrgUnitID is null and A01.FPayHrOrgUnitID is null)) AND item.fid = A01.FCMPITEMID and AA.FBillID = A01.FBILLID ");
        str.append(" INNER JOIN T_BD_PERSON A02 ON AA.FPERSONID = A02.FID ");
        str.append(" WHERE AA.FBILLID  = '").append(billId).append("'");
        rowSet = DbUtil.executeQuery((Context)ctx, (String)str.toString());
        HashMap<String, HashSet> messageMap = new HashMap<String, HashSet>();
        while (rowSet.next()) {
            HashSet itemNameSet;
            String key = rowSet.getString("FPayHrOrgUnitID") + "_" + rowSet.getString("FPERSONID") + "_" + rowSet.getString("FCMPITEMID");
            java.sql.Date effdt = rowSet.getDate("FEFFECTDAY");
            if (StringUtils.isEmpty((String)rowSet.getString("FID")) || !map.containsKey(key) || !map.get(key).getEffectDay().after(effdt)) continue;
            String personName = rowSet.getString("PERNAME");
            String itemName = rowSet.getString("ITEMNAME");
            if (messageMap.containsKey(personName)) {
                itemNameSet = (HashSet)messageMap.get(personName);
                itemNameSet.add(itemName);
                continue;
            }
            itemNameSet = new HashSet();
            itemNameSet.add(itemName);
            messageMap.put(personName, itemNameSet);
        }
        if (!messageMap.isEmpty()) {
            StringBuilder strBuff = new StringBuilder();
            for (Map.Entry entry : messageMap.entrySet()) {
                String personNameKey = (String)entry.getKey();
                HashSet itemNameValueSet = (HashSet)entry.getValue();
                Iterator setIt = itemNameValueSet.iterator();
                StringBuilder itemStrBuff = new StringBuilder();
                while (setIt.hasNext()) {
                    String itemStr = (String)setIt.next();
                    itemStrBuff.append(itemStr).append(",");
                }
                String temp = itemStrBuff.substring(0, itemStrBuff.toString().length() - 1);
                String label36 = NoticeDaoUtils.getMultiLan(ctx, "label51");
                String messageStr = MessageFormat.format(label36, personNameKey, temp) + "<br/>";
                strBuff.append(messageStr);
            }
            throw new EASBizException(new NumericExceptionSubItem("001", strBuff.toString()));
        }
        Calendar calendar = Calendar.getInstance();
        calendar.set(2199, 11, 31, 0, 0, 0);
        calendar.set(14, 0);
        String deleteSql = "DELETE FROM T_HR_SFIXADJUSTSALARY WHERE FID = ?";
        String updateSql = "UPDATE T_HR_SFIXADJUSTSALARY SET FLEFFECTDAY = ? WHERE FID = ? ";
        String delRecSql = "DELETE FROM T_HR_SFIXADJUSTPAYHRRECORD WHERE FSOURCEID = ? ";
        String updateRecSql = "UPDATE T_HR_SFIXADJUSTPAYHRRECORD SET FLEFFDT = ? WHERE FSOURCEID = ?";
        ArrayList<Object[]> delList = new ArrayList<Object[]>();
        ArrayList<Object[]> updateList = new ArrayList<Object[]>();
        str = new StringBuilder();
        str.append(" SELECT A01.FID NEWFID, A01.FLEFFECTDAY NEWLEFFDT, A02.FID OLDID, A02.FLeffectSource leffSource, A04.FLeffectDate,A02.FSysLFDBak ");
        str.append(" FROM T_HR_SFIXADJUSTSALARY A01 ");
        str.append(" LEFT JOIN T_HR_SFIXADJUSTSALARY A02 ON A01.FOLDFIXADJUSTSALARYID = A02.FID ");
        str.append(" LEFT JOIN T_HR_SAdjustEmpORelation A03 ON A03.FID = A02.FAdjEmpORelationID ");
        str.append(" LEFT JOIN T_HR_SAdjustPersonRecord A04 ON A04.FID = A03.FPersonRecordID ");
        str.append(" WHERE A01.FBILLID = '").append(billId).append("'");
        rowSet = DbUtil.executeQuery((Context)ctx, (String)str.toString());
        String leffSource = null;
        while (rowSet.next()) {
            java.sql.Date sysLFDBak;
            Object[] param = new Object[]{rowSet.getString("NEWFID")};
            delList.add(param);
            leffSource = rowSet.getString("leffSource");
            if (leffSource == null) continue;
            param = new Object[2];
            java.sql.Date recordLFD = rowSet.getDate("FLeffectDate");
            Object object = param[0] = recordLFD != null ? recordLFD : new java.sql.Date(calendar.getTime().getTime());
            if (leffSource.equals("20") && (sysLFDBak = rowSet.getDate("FSysLFDBak")) != null) {
                param[0] = sysLFDBak;
            }
            param[1] = rowSet.getString("OLDID");
            updateList.add(param);
        }
        FixAdjustSalaryCollection coll = FixAdjustSalaryFactory.getLocalInstance((Context)ctx).getFixAdjustSalaryCollection("where billId = '" + billId + "'");
        ArrayList<FixAdjustSalaryInfo> list = new ArrayList<FixAdjustSalaryInfo>();
        for (int i = 0; i < coll.size(); ++i) {
            list.add(coll.get(i));
        }
        FixAdjustSalaryRecordFacadeFactory.getLocalInstance((Context)ctx).saveRecord(list, "abort");
        DbUtil.executeBatch((Context)ctx, (String)deleteSql, delList);
        DbUtil.executeBatch((Context)ctx, (String)delRecSql, delList);
        if (updateList.size() > 0) {
            DbUtil.executeBatch((Context)ctx, (String)updateSql, updateList);
            DbUtil.executeBatch((Context)ctx, (String)updateRecSql, updateList);
        }
    }

    private Map<String, Object> updateCmpStruct(Context ctx, String billId, String entryIdsInsql, String calShemeTableName) throws Exception, EASBizException {
        String lang = ctx.getLocale().getLanguage();
        String personFilter = " select fpersonid  from " + calShemeTableName + " where fbillId = '" + billId + "' and fid in " + entryIdsInsql;
        Map<String, FixAdjustSalaryInfo> map = AdjustSalaryUtils.getLastFixAdjustInfo(ctx, personFilter);
        StringBuilder str = new StringBuilder();
        str.append(" SELECT A01.FBILLID, A01.FEFFECTDAY, A01.FPERSONID, A01.FPayHrOrgUnitID, A01.FCMPITEMID, A02.FNAME_").append(lang).append(" PERNAME, adjitem.FNAME_").append(lang).append(" ITEMNAME, A01.FID,AA.fid AS ENTRYID  ");
        str.append(" FROM ").append(calShemeTableName).append(" AA");
        str.append(" left join T_HR_SAdjustSalaryApply s on s.fid = AA.Fbillid ");
        str.append(" left join t_hr_scalsubmitscheme cal on cal.fid = s.FAdjustSalaryRuleID ");
        str.append(" left join T_HR_SBatchAdjustRuleItem rul on rul.FCalSubmitSchemeID = cal.fid ");
        str.append(" left join T_HR_AdjustSalaryItem adjitem on adjitem.fid = rul.FAdjustSalaryItemID ");
        str.append(" left join t_hr_scmpitem item on item.fid = adjitem.FCmpItemID ");
        str.append(" left join T_HR_SFIXADJUSTSALARY A01 ON AA.FPERSONID = A01.FPERSONID and (AA.FHrOrgUnitID = A01.FPayHrOrgUnitID or (AA.FHrOrgUnitID is null and A01.FPayHrOrgUnitID is null)) AND item.fid = A01.FCMPITEMID and AA.FBillID = A01.FBILLID ");
        str.append(" INNER JOIN T_BD_PERSON A02 ON AA.FPERSONID = A02.FID ");
        str.append(" WHERE AA.FBILLID  = '").append(billId).append("' and AA.fid in ").append(entryIdsInsql);
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)str.toString());
        HashMap<String, Map<String, HashSet>> messageMap = new HashMap<String, Map<String, HashSet>>();
        HashSet<String> entryIdSet = new HashSet<String>();
        while (rowSet.next()) {
            String key = rowSet.getString("FPayHrOrgUnitID") + "_" + rowSet.getString("FPERSONID") + "_" + rowSet.getString("FCMPITEMID");
            java.sql.Date effdt = rowSet.getDate("FEFFECTDAY");
            String entryId = rowSet.getString("ENTRYID");
            if (!StringUtils.isEmpty((String)entryId) && map.containsKey(key) && map.get(key).getEffectDay().after(effdt)) {
                HashSet itemNameSet;
                Map<String, HashSet> entryMap;
                String personName = rowSet.getString("PERNAME");
                String itemName = rowSet.getString("ITEMNAME");
                if (messageMap.containsKey(entryId)) {
                    entryMap = (Map)messageMap.get(entryId);
                    itemNameSet = (HashSet)entryMap.get("itemNameSet");
                    itemNameSet.add(itemName);
                    continue;
                }
                entryMap = new HashMap();
                itemNameSet = new HashSet();
                itemNameSet.add(itemName);
                entryMap.put("itemNameSet", itemNameSet);
                entryMap.put("personName", (HashSet)((Object)personName));
                messageMap.put(entryId, entryMap);
                continue;
            }
            entryIdSet.add(entryId);
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        HashMap<String, String> errorMap = new HashMap<String, String>();
        if (!messageMap.isEmpty()) {
            for (Map.Entry entry : messageMap.entrySet()) {
                Map entryMap = (Map)entry.getValue();
                String entryId = (String)entry.getKey();
                entryIdSet.remove(entryId);
                String personName = entryMap.get("personName").toString();
                HashSet itemNameValueSet = (HashSet)entryMap.get("itemNameSet");
                Iterator setIt = itemNameValueSet.iterator();
                StringBuilder itemStrBuff = new StringBuilder();
                while (setIt.hasNext()) {
                    String itemStr = (String)setIt.next();
                    itemStrBuff.append(itemStr).append(",");
                }
                String temp = itemStrBuff.substring(0, itemStrBuff.toString().length() - 1);
                String label36 = SHRServerResource.getString((String)"com.kingdee.shr.cmpdesign.resource.AdjustMultiLanResource", (String)"label36", (Context)ctx);
                String messageStr = MessageFormat.format(label36, personName, temp);
                errorMap.put(entryId, messageStr);
            }
            resultMap.put("errorMap", errorMap);
        }
        entryIdsInsql = CmpSQLUtil.createInSql((Context)ctx, entryIdSet, (String)"T_HR_SAdjustSalaryNoticeEntry", (String)"fid");
        resultMap.put("entryIds", entryIdsInsql);
        if (entryIdSet.isEmpty()) {
            return resultMap;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.set(2199, 11, 31, 0, 0, 0);
        String deleteSql = "DELETE FROM T_HR_SFIXADJUSTSALARY WHERE FID = ?";
        String updateSql = "UPDATE T_HR_SFIXADJUSTSALARY SET FLEFFECTDAY = ? WHERE FID = ? ";
        String delRecSql = "DELETE FROM T_HR_SFIXADJUSTPAYHRRECORD WHERE FSOURCEID = ? ";
        String updateRecSql = "UPDATE T_HR_SFIXADJUSTPAYHRRECORD SET FLEFFDT = ? WHERE FSOURCEID = ?";
        ArrayList<Object[]> delList = new ArrayList<Object[]>();
        ArrayList<Object[]> updateList = new ArrayList<Object[]>();
        str = new StringBuilder();
        str.append(" SELECT A01.FID NEWFID, A01.FLEFFECTDAY NEWLEFFDT, A02.FID OLDID, A02.FLeffectSource leffSource, A04.FLeffectDate,A02.FSysLFDBak ");
        str.append(" FROM T_HR_SFIXADJUSTSALARY A01 ");
        str.append(" LEFT JOIN T_HR_SFIXADJUSTSALARY A02 ON A01.FOLDFIXADJUSTSALARYID = A02.FID ");
        str.append(" LEFT JOIN T_HR_SAdjustEmpORelation A03 ON A03.FID = A02.FAdjEmpORelationID ");
        str.append(" LEFT JOIN T_HR_SAdjustPersonRecord A04 ON A04.FID = A03.FPersonRecordID ");
        str.append(" WHERE A01.FBILLID = '").append(billId).append("' and A01.fpersonid in (select fpersonid from ").append(calShemeTableName).append(" where fid in ").append(entryIdsInsql).append(") ");
        rowSet = DbUtil.executeQuery((Context)ctx, (String)str.toString());
        while (rowSet.next()) {
            java.sql.Date sysLFDBak;
            Object[] param = new Object[]{rowSet.getString("NEWFID")};
            delList.add(param);
            String leffSource = rowSet.getString("leffSource");
            if (leffSource == null) continue;
            param = new Object[2];
            java.sql.Date recordLFD = rowSet.getDate("FLeffectDate");
            Object object = param[0] = recordLFD != null ? recordLFD : new java.sql.Date(calendar.getTime().getTime());
            if (leffSource.equals("20") && (sysLFDBak = rowSet.getDate("FSysLFDBak")) != null) {
                param[0] = sysLFDBak;
            }
            param[1] = rowSet.getString("OLDID");
            updateList.add(param);
        }
        FixAdjustSalaryCollection coll = FixAdjustSalaryFactory.getLocalInstance((Context)ctx).getFixAdjustSalaryCollection("where billId = '" + billId + "'");
        ArrayList<FixAdjustSalaryInfo> list = new ArrayList<FixAdjustSalaryInfo>();
        for (int i = 0; i < coll.size(); ++i) {
            list.add(coll.get(i));
        }
        FixAdjustSalaryRecordFacadeFactory.getLocalInstance((Context)ctx).saveRecord(list, "resetConfirm");
        DbUtil.executeBatch((Context)ctx, (String)deleteSql, delList);
        DbUtil.executeBatch((Context)ctx, (String)delRecSql, delList);
        if (updateList.size() > 0) {
            DbUtil.executeBatch((Context)ctx, (String)updateSql, updateList);
            DbUtil.executeBatch((Context)ctx, (String)updateRecSql, updateList);
        }
        return resultMap;
    }

    public IObjectPK save(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        AdjustSalaryApplyInfo info = (AdjustSalaryApplyInfo)model;
        this.beforeSave(ctx, info);
        IObjectPK idPk = null;
        if (info.getId() == null || StringUtils.isEmpty((String)info.getId().toString())) {
            IObjectPK objectPK = this.dealSave(ctx, info);
            model.setId(BOSUuid.read((String)objectPK.toString()));
            idPk = objectPK;
        } else {
            this.dealUpdate(ctx, info);
            idPk = new ObjectUuidPK(info.getId());
        }
        return idPk;
    }

    public IObjectPK submit(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        AdjustSalaryApplyInfo info = (AdjustSalaryApplyInfo)model;
        this.beforeSave(ctx, info);
        AdjustSalaryApplyEntryCollection coll = info.getEntry();
        info.setBillState(HRBillStateEnum.SUBMITED);
        info.put("entry", null);
        IObjectPK idPk = super.submit(ctx, (CoreBaseInfo)info);
        if (null != coll && coll.size() > 0 && (coll.get(0).getPerson() != null || coll.get(0).getHrOrgUnit() != null)) {
            info.put("entry", (Object)coll);
            if (info.getId() == null || StringUtils.isEmpty((String)info.getId().toString())) {
                IObjectPK objectPK = this.dealSave(ctx, info);
                model.setId(BOSUuid.read((String)objectPK.toString()));
            } else {
                this.dealUpdate(ctx, info);
                idPk = new ObjectUuidPK(info.getId());
            }
        }
        AdjustSalaryUtils.updateEntryBillState(ctx, info, HRBillStateEnum.SUBMITED);
        return idPk;
    }

    public IObjectPK _submitEffect(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        AdjustSalaryApplyInfo info = (AdjustSalaryApplyInfo)model;
        this.beforeSave(ctx, info);
        IAdjustSalaryApply iAdjustSalaryApply = AdjustSalaryApplyFactory.getLocalInstance(ctx);
        SelectorItemCollection selector = new SelectorItemCollection();
        info.setBillState(HRBillStateEnum.SAVED);
        selector.add(new SelectorItemInfo("billState"));
        iAdjustSalaryApply.updatePartial(info, selector);
        AdjustSalaryUtils.updateEntryBillState(ctx, info, HRBillStateEnum.SAVED);
        IObjectPK idPk = null;
        if (null != info.getEntry() && info.getEntry().size() > 0 && info.getEntry().get(0).getPerson() != null) {
            if (info.getId() == null || StringUtils.isEmpty((String)info.getId().toString())) {
                idPk = this.dealSave(ctx, info);
            } else {
                this.dealUpdate(ctx, info);
                idPk = new ObjectUuidPK(info.getId());
            }
        } else {
            info.put("entry", null);
            this.update(ctx, (IObjectPK)new ObjectUuidPK(info.getId()), info);
            idPk = new ObjectUuidPK(info.getId());
        }
        boolean noticeControl = this.noticeParamControl(ctx, info.getId().toString());
        if (!this.getAdj003Param(ctx, info.getHrOrgUnit().getId().toString()) && noticeControl) {
            this.udpAdjustPersonRecord(ctx, info.getId());
            this.udpEntryState(ctx, info, 1);
        }
        info.setBillState(HRBillStateEnum.AUDITED);
        selector.add(new SelectorItemInfo("billState"));
        iAdjustSalaryApply.updatePartial(info, selector);
        AdjustSalaryUtils.updateEntryBillState(ctx, info, HRBillStateEnum.AUDITED);
        return idPk;
    }

    protected boolean getAdj003Param(Context ctx, String hrOrgId) {
        boolean isControl = false;
        try {
            if (!StringUtils.isEmpty((String)hrOrgId)) {
                isControl = HRParamUtil.getParamOfHR((Context)ctx, (String)"shr_adj_003", (String)hrOrgId);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return isControl;
    }

    protected void udpEntryState(Context ctx, AdjustSalaryApplyInfo info, int state) {
        try {
            String adjustSalaryRuleId = info.getAdjustSalaryRule().getId().toString();
            String entryTable = AdjustSalaryUtils.getCalShemeTableName(ctx, adjustSalaryRuleId);
            String updateSql = "update " + entryTable + " set FState = " + state + " ,FInvalidateDesc='',FInvalidateOperatorId='',FInvalidateTime=null where FBillId = '" + info.getId().toString() + "' ";
            CmpSQLUtil.executeUpdate((Context)ctx, (String)updateSql);
            String updateNoticeSql = "update T_HR_SAdjustSalaryNoticeEntry set FAdjEntryState=" + state + " where FIsRemove <> 1 and FNoticeBillId in (select fid from T_HR_SAdjustSalaryNoticeBill where FIsRemove <> 1 and FAdjBillId=?)";
            DbUtil.execute((Context)ctx, (String)updateNoticeSql, (Object[])new Object[]{info.getId().toString()});
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    protected void udpEntryState(Context ctx, AdjustSalaryApplyInfo info, String entryInSql, int state) {
        try {
            String billId = info.getId().toString();
            String adjustSalaryRuleId = info.getAdjustSalaryRule().getId().toString();
            String entryTable = AdjustSalaryUtils.getCalShemeTableName(ctx, adjustSalaryRuleId);
            String updateSql = "update " + entryTable + " set FState = " + state + " where FBillId = '" + billId + "' and fid in " + entryInSql;
            CmpSQLUtil.executeUpdate((Context)ctx, (String)updateSql);
            this.updateNoticeState(ctx, billId, entryInSql, 0);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    protected IObjectPK dealSave(Context ctx, AdjustSalaryApplyInfo info) throws BOSException, EASBizException {
        String adjustSalaryRuleId = info.getAdjustSalaryRule().getId().toString();
        Map<String, Object> map = AdjustSalaryUtils.getBillColumnListAndBillEntryTableName(ctx, adjustSalaryRuleId);
        List colNames = (List)map.get("colNames");
        List colTypes = (List)map.get("colTypes");
        Map dataLength = (Map)map.get("dataLength");
        Map dataDot = (Map)map.get("dataDot");
        String billEntryTable = map.get("fBillEntryTableName").toString();
        AdjustSalaryApplyEntryCollection coll = info.getEntry();
        logger.info("com.kingdee.shr.cmpdesign.app.v2.bill.AdjustSalaryApplyControllerBean->dealSaveBill:" + info);
        info.put("entry", null);
        IObjectPK objectPK = this.addnew(ctx, info);
        String billId = objectPK.toString();
        String personSqlIds = this.assemblePersonSqlIds(coll);
        Map<String, AdjustPersonRecordInfo> adjRecords = this.verifyAdjSalaryBillDate(ctx, personSqlIds, info.getHrOrgUnit().getId().toString());
        ArrayList<String> customerFields = new ArrayList<String>();
        this.getCustomerFields(customerFields);
        String insertCol = AdjustSalaryUtils.assembleInsertSql(ctx, billEntryTable, colNames, billId, customerFields);
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        String datestr = "";
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        logger.info("com.kingdee.shr.cmpdesign.app.v2.bill.AdjustSalaryApplyControllerBean->dealSaveBillEntry:" + (Object)((Object)coll));
        for (int i = 0; i < coll.size(); ++i) {
            int j;
            AdjustSalaryApplyEntryInfo entryinfo = coll.get(i);
            AdjustPersonRecordInfo adjRecordInfo = adjRecords.get(entryinfo.getPerson().getId().toString());
            List<Object> insertParam = this.insertParam(entryinfo, info, adjRecordInfo);
            Object[] batchParam = new Object[insertParam.size() + colNames.size()];
            for (j = 0; j < insertParam.size(); ++j) {
                batchParam[j] = insertParam.get(j);
            }
            try {
                for (j = 0; j < colNames.size(); ++j) {
                    String fieldSn = (String)colNames.get(j);
                    Object object = entryinfo.get(fieldSn);
                    if ("1".equals(colTypes.get(j)) && object != null && object.toString().length() > (Integer)dataLength.get(fieldSn)) {
                        batchParam[insertParam.size() + j] = object.toString().substring(0, (Integer)dataLength.get(fieldSn) - 1);
                        continue;
                    }
                    if ("0".equals(colTypes.get(j)) && object != null) {
                        batchParam[insertParam.size() + j] = new BigDecimal(object.toString()).setScale((int)((Integer)dataDot.get(fieldSn)), RoundingMode.HALF_UP);
                        continue;
                    }
                    if ("2".equals(colTypes.get(j))) {
                        if (object != null && object.toString().trim().length() > 0) {
                            datestr = object.toString();
                            batchParam[insertParam.size() + j] = new java.sql.Date(dateFormat.parse(datestr).getTime());
                            continue;
                        }
                        batchParam[insertParam.size() + j] = null;
                        continue;
                    }
                    batchParam[insertParam.size() + j] = object;
                }
            }
            catch (ParseException e) {
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
            paramList.add(batchParam);
        }
        if (paramList.size() > 0) {
            CmpSQLUtil.executeBatch((Context)ctx, (String)insertCol, paramList);
        }
        return objectPK;
    }

    protected void getCustomerFields(List<String> customerFields) {
    }

    protected List<Object> insertParam(AdjustSalaryApplyEntryInfo entryinfo, AdjustSalaryApplyInfo info, AdjustPersonRecordInfo adjRecordInfo) {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(BOSUuid.create((String)"11436768").toString());
        params.add(new java.sql.Date(new Date().getTime()));
        params.add(entryinfo.getEffectDate() == null ? null : CmpDateUtil.toSqlDate((Date)entryinfo.getEffectDate()));
        params.add(entryinfo.getLeffectDate() == null ? adjRecordInfo.getLeffectDate() : CmpDateUtil.toSqlDate((Date)entryinfo.getLeffectDate()));
        params.add(entryinfo.getHrOrgUnit() == null ? null : entryinfo.getHrOrgUnit().getId().toString());
        params.add(entryinfo.getPerson() == null ? null : entryinfo.getPerson().getId().toString());
        params.add(entryinfo.getAdminOrgUnit() == null ? null : entryinfo.getAdminOrgUnit().getId().toString());
        params.add(entryinfo.getPosition() == null ? null : entryinfo.getPosition().getId().toString());
        params.add(entryinfo.getAdjustEmpORelation() == null ? null : entryinfo.getAdjustEmpORelation().getId().toString());
        params.add(entryinfo.getCurrency() == null ? "dfd38d11-00fd-1000-e000-1ebdc0a8100dDEB58FDC" : entryinfo.getCurrency().getId().toString());
        params.add(entryinfo.getDescription(LocaleUtils.locale_l1));
        params.add(entryinfo.getDescription(LocaleUtils.locale_l2));
        params.add(entryinfo.getDescription(LocaleUtils.locale_l3));
        params.add(0);
        params.add(20);
        params.add(null);
        params.add(info.getAdjustSalaryRule().getId().toString());
        params.add(entryinfo.getForwarnContent());
        params.add(entryinfo.getCmpStandard() == null ? null : entryinfo.getCmpStandard().getId().toString());
        params.add(entryinfo.getCmpStdLevel() == null ? null : entryinfo.getCmpStdLevel().getId().toString());
        params.add(entryinfo.getCmpStdPoint() == null ? null : entryinfo.getCmpStdPoint().getId().toString());
        params.add(entryinfo.getCmpStdScope() == null ? null : entryinfo.getCmpStdScope().getId().toString());
        params.add(0);
        this.customerParam(entryinfo, params);
        return params;
    }

    protected List<Object> updateParam(AdjustSalaryApplyEntryInfo entryinfo, AdjustSalaryApplyInfo info, AdjustPersonRecordInfo adjRecordInfo) {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(new java.sql.Date(new Date().getTime()));
        params.add(entryinfo.getEffectDate() == null ? null : CmpDateUtil.toSqlDate((Date)entryinfo.getEffectDate()));
        params.add(entryinfo.getHrOrgUnit() == null ? null : (entryinfo.getHrOrgUnit().getId() == null ? entryinfo.get("tempId") : entryinfo.getHrOrgUnit().getId().toString()));
        params.add(entryinfo.getPerson() == null ? null : (entryinfo.getPerson().getId() == null ? entryinfo.get("tempId") : entryinfo.getPerson().getId().toString()));
        params.add(entryinfo.getAdminOrgUnit() == null ? null : (entryinfo.getAdminOrgUnit().getId() == null ? entryinfo.get("tempId") : entryinfo.getAdminOrgUnit().getId().toString()));
        params.add(entryinfo.getPosition() == null ? null : (entryinfo.getPosition().getId() == null ? entryinfo.get("tempId") : entryinfo.getPosition().getId().toString()));
        params.add(entryinfo.getCurrency() == null ? "dfd38d11-00fd-1000-e000-1ebdc0a8100dDEB58FDC" : entryinfo.getCurrency().getId().toString());
        params.add(entryinfo.getDescription(LocaleUtils.locale_l1));
        params.add(entryinfo.getDescription(LocaleUtils.locale_l2));
        params.add(entryinfo.getDescription(LocaleUtils.locale_l3));
        params.add(entryinfo.getLeffectDate() == null ? adjRecordInfo.getLeffectDate() : CmpDateUtil.toSqlDate((Date)entryinfo.getLeffectDate()));
        params.add(entryinfo.getCmpStandard() != null ? (entryinfo.getCmpStandard() != null && entryinfo.getCmpStandard().getId() != null ? entryinfo.getCmpStandard().getId().toString() : entryinfo.get("tempId")) : null);
        params.add(entryinfo.getCmpStdLevel() != null ? (entryinfo.getCmpStdLevel() != null && entryinfo.getCmpStdLevel().getId() != null ? entryinfo.getCmpStdLevel().getId().toString() : entryinfo.get("tempId")) : null);
        params.add(entryinfo.getCmpStdPoint() != null ? (entryinfo.getCmpStdPoint() != null && entryinfo.getCmpStdPoint().getId() != null ? entryinfo.getCmpStdPoint().getId().toString() : entryinfo.get("tempId")) : null);
        params.add(entryinfo.getCmpStdScope() != null ? (entryinfo.getCmpStdScope() != null && entryinfo.getCmpStdScope().getId() != null ? entryinfo.getCmpStdScope().getId().toString() : entryinfo.get("tempId")) : null);
        params.add(entryinfo.getAdjustEmpORelation() == null ? null : (entryinfo.getAdjustEmpORelation().getId() == null ? entryinfo.get("tempId") : entryinfo.getAdjustEmpORelation().getId().toString()));
        params.add(0);
        this.customerParam(entryinfo, params);
        return params;
    }

    protected void customerParam(AdjustSalaryApplyEntryInfo entryinfo, List<Object> params) {
    }

    protected void dealUpdate(Context ctx, AdjustSalaryApplyInfo info) throws BOSException, EASBizException {
        String adjustSalaryRuleId = info.getAdjustSalaryRule().getId().toString();
        Map<String, Object> map = AdjustSalaryUtils.getBillColumnListExcludeCalItem(ctx, adjustSalaryRuleId);
        List colNames = (List)map.get("colNames");
        List colTypes = (List)map.get("colTypes");
        String billEntryTable = map.get("fBillEntryTableName").toString();
        AdjustSalaryApplyEntryCollection coll = info.getEntry();
        info.put("entry", null);
        String billId = info.getId().toString();
        boolean exist = true;
        try {
            exist = AdjustSalaryApplyFactory.getLocalInstance(ctx).exists("where id = '" + billId + "'");
        }
        catch (EASBizException e1) {
            logger.error(e1.getMessage(), (Throwable)e1);
        }
        if (exist) {
            this.update(ctx, (IObjectPK)new ObjectUuidPK(info.getId()), info);
        } else {
            this.addnew(ctx, info);
        }
        ArrayList<String> customerFields = new ArrayList<String>();
        this.getCustomerFields(customerFields);
        String updateSql = AdjustSalaryUtils.assembleUpdateSql(ctx, billEntryTable, colNames, customerFields);
        String insertCol = AdjustSalaryUtils.assembleInsertSql(ctx, billEntryTable, colNames, billId, customerFields);
        ArrayList<Object[]> paramUpdateList = new ArrayList<Object[]>();
        ArrayList<Object[]> paramInsertList = new ArrayList<Object[]>();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String personSqlIds = this.assemblePersonSqlIds(coll);
        Map<String, AdjustPersonRecordInfo> adjRecords = this.verifyAdjSalaryBillDate(ctx, personSqlIds, info.getHrOrgUnit().getId().toString());
        for (int i = 0; i < coll.size(); ++i) {
            String datestr;
            Object object;
            String dataType;
            int j;
            AdjustSalaryApplyEntryInfo entryinfo = coll.get(i);
            AdjustPersonRecordInfo adjRecordInfo = adjRecords.get(entryinfo.getPerson().getId().toString());
            if (entryinfo.getId() != null) {
                List<Object> updateParam = this.updateParam(entryinfo, info, adjRecordInfo);
                Object[] batchUpdateParam = new Object[updateParam.size() + 1 + colNames.size()];
                for (j = 0; j < updateParam.size(); ++j) {
                    batchUpdateParam[j] = updateParam.get(j);
                }
                try {
                    for (j = 0; j < colNames.size(); ++j) {
                        dataType = (String)colTypes.get(j);
                        object = entryinfo.get((String)colNames.get(j));
                        if ("2".equals(dataType)) {
                            if (object != null && object.toString().trim().length() > 0) {
                                datestr = object.toString();
                                batchUpdateParam[updateParam.size() + j] = new java.sql.Date(dateFormat.parse(datestr).getTime());
                                continue;
                            }
                            batchUpdateParam[updateParam.size() + j] = null;
                            continue;
                        }
                        batchUpdateParam[updateParam.size() + j] = object;
                    }
                }
                catch (ParseException e) {
                    throw new BOSException(e.getMessage(), (Throwable)e);
                }
                batchUpdateParam[updateParam.size() + colNames.size()] = entryinfo.getId().toString();
                paramUpdateList.add(batchUpdateParam);
                continue;
            }
            List<Object> insertParam = this.insertParam(entryinfo, info, adjRecordInfo);
            Object[] batchInsertParam = new Object[insertParam.size() + colNames.size()];
            for (j = 0; j < insertParam.size(); ++j) {
                batchInsertParam[j] = insertParam.get(j);
            }
            try {
                for (j = 0; j < colNames.size(); ++j) {
                    dataType = (String)colTypes.get(j);
                    object = entryinfo.get((String)colNames.get(j));
                    if ("2".equals(dataType)) {
                        if (object != null && object.toString().trim().length() > 0) {
                            datestr = object.toString();
                            batchInsertParam[insertParam.size() + j] = new java.sql.Date(dateFormat.parse(datestr).getTime());
                            continue;
                        }
                        batchInsertParam[insertParam.size() + j] = null;
                        continue;
                    }
                    batchInsertParam[insertParam.size() + j] = object;
                }
            }
            catch (ParseException e) {
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
            paramInsertList.add(batchInsertParam);
        }
        if (paramUpdateList.size() > 0) {
            CmpSQLUtil.executeBatch((Context)ctx, (String)updateSql.toString(), paramUpdateList);
        }
        if (paramInsertList.size() > 0) {
            CmpSQLUtil.executeBatch((Context)ctx, (String)insertCol.toString(), paramInsertList);
        }
    }

    private String assemblePersonSqlIds(AdjustSalaryApplyEntryCollection coll) {
        StringBuilder ids = new StringBuilder();
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            AdjustSalaryApplyEntryInfo info = coll.get(i);
            ids.append("'").append(info.getPerson().getId().toString()).append("'");
            if (i == coll.size() - 1) continue;
            ids.append(",");
        }
        return ids.toString();
    }

    public Map<String, AdjustPersonRecordInfo> verifyAdjSalaryBillDate(Context ctx, String personSqlIds, String adjHrOrgId) {
        HashMap<String, AdjustPersonRecordInfo> map = new HashMap<String, AdjustPersonRecordInfo>();
        String oql = "select person.id, effectDate, leffectDate where person.id in (" + personSqlIds + ") and hrOrgUnit.id = '" + adjHrOrgId + "' ";
        try {
            AdjustPersonRecordCollection coll = AdjustPersonRecordFactory.getLocalInstance((Context)ctx).getAdjustPersonRecordCollection(oql);
            AdjustPersonRecordInfo info = null;
            for (int i = 0; i < coll.size(); ++i) {
                info = coll.get(i);
                map.put(info.getPerson().getId().toString(), info);
            }
        }
        catch (BOSException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return map;
    }

    @Override
    protected void _setPassState(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        this.setState(ctx, billId, HRBillStateEnum.AUDITED);
        AdjustSalaryUtils.updateEntryBillState(ctx, billId.toString(), HRBillStateEnum.AUDITED);
        boolean noticeControl = this.noticeParamControl(ctx, billId.toString());
        AdjustSalaryApplyInfo info = AdjustSalaryApplyFactory.getLocalInstance(ctx).getAdjustSalaryApplyInfo((IObjectPK)new ObjectUuidPK(billId));
        if (!this.getAdj003Param(ctx, info.getHrOrgUnit().getId().toString()) && noticeControl) {
            this.udpAdjustPersonRecord(ctx, billId);
            this.udpEntryState(ctx, info, 1);
        }
    }

    public boolean noticeParamControl(Context ctx, String billId) throws BOSException, EASBizException {
        NoticeParamInfo paramInfo = NoticeDaoUtils.getNoticeParamInfo(ctx);
        boolean noticeControl = paramInfo.isNoticeControl();
        if (!noticeControl) {
            return true;
        }
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("adjBillId", billId);
        AdjustSalaryNoticeFacadeFactory.getLocalInstance(ctx).createNoticeData(param);
        return !paramInfo.isConfirmAuth();
    }

    protected void udpAdjustPersonRecord(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        FixAdjustSalaryInfo fixInfo = null;
        AdjustSalaryApplyInfo bill = AdjustSalaryApplyFactory.getLocalInstance(ctx).getAdjustSalaryApplyInfo((IObjectPK)new ObjectUuidPK(billId.toString()));
        String adjustSalaryRuleId = bill.getAdjustSalaryRule().getId().toString();
        Map<Object, Object> entryMap = new HashMap();
        entryMap = AdjustSalaryUtils._getBillColumnListAndBillEntryTableName(ctx, adjustSalaryRuleId, true);
        String billEntryTableName = AdjustSalaryUtils.getCalShemeTableName(ctx, adjustSalaryRuleId);
        List colNames = (List)entryMap.get("colNames");
        boolean existAdjReason = AdjustSalaryUtils.checkAdjustReason(ctx, adjustSalaryRuleId);
        List<Object> coll = new ArrayList();
        coll = AdjustSalaryUtils.assembleAdjBaseTableData(ctx, billEntryTableName, null, billId.toString(), colNames, existAdjReason);
        Map<String, Boolean> aeoMap = this.queryUseDefaultByBillId(ctx, billEntryTableName, null, billId.toString());
        Map mapping = (Map)entryMap.get("mapping");
        Map<String, String> floatRateMap = AdjustSalaryUtils.getFloatRateMap(ctx);
        Map<String, List<String>> cmpStd2ItemMap = this.queryCmpStandardAndCmpItem(ctx);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("coll", coll);
        map.put("entryMap", entryMap);
        map.put("hrOrgUnitId", bill.getHrOrgUnit().getId().toString());
        FixAdjustSalaryExecute proxy = FixAdjustBillProxy.getinstance(ctx, map);
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            Map info = (Map)coll.get(i);
            FixAdjustSalaryCollection fixList = new FixAdjustSalaryCollection();
            for (String colName : colNames) {
                fixInfo = new FixAdjustSalaryInfo();
                if (info.get(colName) == null) continue;
                String cmpItemId = mapping.get(colName).toString();
                boolean hasCmpStandard = false;
                if (info.get("FCmpStandardID") != null && cmpStd2ItemMap.get(info.get("FCmpStandardID")).contains(cmpItemId)) {
                    hasCmpStandard = true;
                }
                this.initEntity(ctx, fixInfo, info, colName, cmpItemId, bill.getHrOrgUnit(), floatRateMap, bill, hasCmpStandard);
                this.otherParam(ctx, fixInfo, info);
                if (fixInfo.getAdjEmpORelation() != null && fixInfo.getAdjEmpORelation().getId() != null && aeoMap.get(fixInfo.getAdjEmpORelation().getId().toString()) != null) {
                    fixInfo.setUseDefault(aeoMap.get(fixInfo.getAdjEmpORelation().getId().toString()).booleanValue());
                } else {
                    fixInfo.setUseDefault(Boolean.TRUE.booleanValue());
                }
                fixList.add(fixInfo);
            }
            proxy.save(ctx, fixList);
        }
    }

    protected Map<String, List<String>> queryCmpStandardAndCmpItem(Context ctx) throws BOSException {
        HashMap map = Maps.newHashMap();
        CmpStdValueCollection collection = CmpStdValueFactory.getLocalInstance(ctx).getCmpStdValueCollection("select cmpStdItem.cmpStandard.id, cmpStdItem.cmpItem.id");
        for (int i = 0; i < collection.size(); ++i) {
            CmpStdValueInfo cmpStdValueInfo = collection.get(i);
            String stdId = cmpStdValueInfo.getCmpStdItem().getCmpStandard().getId().toString();
            String cmpItemId = cmpStdValueInfo.getCmpStdItem().getCmpItem().getId().toString();
            map.putIfAbsent(stdId, Lists.newArrayList());
            List cmpItemList = (List)map.get(stdId);
            cmpItemList.add(cmpItemId);
        }
        return map;
    }

    protected Map<String, Boolean> queryUseDefaultByBillId(Context ctx, String billEntryTableName, String fidIn, String billId) throws BOSException {
        StringBuilder str = new StringBuilder();
        str.append(" select tt.FAdjustEmpORelationID, t0.FUseDefault from ");
        str.append(billEntryTableName);
        str.append(" tt left join t_hr_sadjustemporelation t0 on tt.FAdjustEmpORelationID = t0.FID ");
        str.append(" where 1 = 1 ");
        if (CmpStrUtil.isNotEmpty((String)fidIn)) {
            str.append(" and tt.fid in (").append(fidIn).append(")");
        }
        if (CmpStrUtil.isNotEmpty((String)billId)) {
            str.append(" and tt.fbillid in ('").append(billId).append("')");
        }
        IRowSet rs = CmpSQLUtil.executeQuery((Context)ctx, (String)str.toString());
        HashMap<String, Boolean> aeoMap = new HashMap<String, Boolean>();
        try {
            while (rs.next()) {
                String adjustEmpORelationID = rs.getString("FAdjustEmpORelationID");
                boolean useDefault = rs.getObject("FUseDefault") == null ? Boolean.TRUE.booleanValue() : rs.getBoolean("FUseDefault");
                aeoMap.put(adjustEmpORelationID, useDefault);
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return aeoMap;
    }

    protected void initEntity(Context ctx, FixAdjustSalaryInfo fixInfo, Map<String, Object> info, String colName, String cmpItemId, HROrgUnitInfo adjHrOrgUnit, Map<String, String> floatRateMap, AdjustSalaryApplyInfo bill, boolean hasCmpStandard) {
        AdjustEmpORelationInfo adjEmpORelation = new AdjustEmpORelationInfo();
        adjEmpORelation.setId(BOSUuid.read((String)info.get("FAdjustEmpORelationID").toString()));
        fixInfo.setAdjEmpORelation(adjEmpORelation);
        AdminOrgUnitInfo adminOrgUnit = new AdminOrgUnitInfo();
        adminOrgUnit.setId(BOSUuid.read((String)info.get("FAdminOrgUnitID").toString()));
        fixInfo.setAdminOrgUnit(adminOrgUnit);
        PositionInfo position = new PositionInfo();
        position.setId(BOSUuid.read((String)info.get("FPositionID").toString()));
        fixInfo.setPosition(position);
        String payHrOrgUnitId = (String)info.get("FHrOrgUnitID");
        if (!StringUtils.isEmpty((String)payHrOrgUnitId)) {
            HROrgUnitInfo hrOrg = new HROrgUnitInfo();
            hrOrg.setId(BOSUuid.read((String)payHrOrgUnitId));
            fixInfo.setPayHrOrgUnit(hrOrg);
        }
        fixInfo.setAdjHrOrgUnit(adjHrOrgUnit);
        CmpItemInfo cmpItem = new CmpItemInfo();
        cmpItem.setId(BOSUuid.read((String)cmpItemId));
        fixInfo.setCmpItem(cmpItem);
        fixInfo.setEffectDay((Date)CmpDateUtil.toSqlDate((Object)info.get("FEffectDate")));
        fixInfo.setLeffectDay(info.get("FLeffectDate") != null ? CmpDateUtil.toSqlDate((Object)info.get("FLeffectDate")) : null);
        fixInfo.setMoney(info.get(colName) != null ? new BigDecimal(info.get(colName).toString()) : null);
        PersonInfo person = new PersonInfo();
        person.setId(BOSUuid.read((String)info.get("FPersonID").toString()));
        fixInfo.setPerson(person);
        fixInfo.setRemark(info.get("fdescription_l1") != null ? info.get("fdescription_l1").toString() : null, LocaleUtils.locale_l1);
        fixInfo.setRemark(info.get("fdescription_l2") != null ? info.get("fdescription_l2").toString() : null, LocaleUtils.locale_l2);
        fixInfo.setRemark(info.get("fdescription_l3") != null ? info.get("fdescription_l3").toString() : null, LocaleUtils.locale_l3);
        fixInfo.setBillId(info.get("FBillID").toString());
        CurrencyInfo currency = new CurrencyInfo();
        currency.setId(BOSUuid.read((String)info.get("FCurrencyID").toString()));
        fixInfo.setCurrency(currency);
        if (hasCmpStandard) {
            if (info.get("FCmpStandardID") != null) {
                CmpStandardInfo standard = new CmpStandardInfo();
                standard.setId(BOSUuid.read((String)info.get("FCmpStandardID").toString()));
                fixInfo.setStandard(standard);
            }
            if (info.get("FCmpStdLevelID") != null) {
                CmpStdLevelInfo stdLevel = new CmpStdLevelInfo();
                stdLevel.setId(BOSUuid.read((String)info.get("FCmpStdLevelID").toString()));
                fixInfo.setStdLevel(stdLevel);
                String floatRate = floatRateMap.get(info.get("FCmpStdLevelID").toString());
                fixInfo.setFloatRate(floatRate);
            }
            if (info.get("FCmpStdPointID") != null) {
                CmpStdPointInfo stdPoint = new CmpStdPointInfo();
                stdPoint.setId(BOSUuid.read((String)info.get("FCmpStdPointID").toString()));
                fixInfo.setStdPoint(stdPoint);
            }
            if (info.get("FCmpStdScopeID") != null) {
                CmpStdScopeInfo stdScope = new CmpStdScopeInfo();
                stdScope.setId(BOSUuid.read((String)info.get("FCmpStdScopeID").toString()));
                fixInfo.setStdScope(stdScope);
            }
        }
        if (bill != null && bill.getBillSource() != AdjBillSourceEnum.Manual_Add) {
            fixInfo.setCreator(bill.getCreator());
            fixInfo.setLastUpdateUser(bill.getLastUpdateUser());
        }
    }

    protected void otherParam(Context ctx, FixAdjustSalaryInfo fixInfo, Map<String, Object> info) {
        if (info.get("S10") != null && !StringUtils.isEmpty((String)info.get("S10").toString())) {
            AdjustSalaryCauseInfo adjCause = new AdjustSalaryCauseInfo();
            adjCause.setId(BOSUuid.read((String)info.get("S10").toString()));
            fixInfo.setAdjustSalaryCause(adjCause);
        }
    }

    @Override
    protected void _setNoPassState(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        this.setState(ctx, billId, HRBillStateEnum.AUDITEND);
        AdjustSalaryUtils.updateEntryBillState(ctx, billId.toString(), HRBillStateEnum.AUDITEND);
    }

    @Override
    protected void _setApproveState(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        this.setState(ctx, billId, HRBillStateEnum.AUDITING);
        AdjustSalaryUtils.updateEntryBillState(ctx, billId.toString(), HRBillStateEnum.AUDITING);
    }

    @Override
    protected void _setEditState(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        this.setState(ctx, billId, HRBillStateEnum.SUBMITED);
        AdjustSalaryUtils.updateEntryBillState(ctx, billId.toString(), HRBillStateEnum.SUBMITED);
    }

    private void setState(Context ctx, BOSUuid billId, HRBillStateEnum state) throws BOSException {
        String sql = "UPDATE T_HR_SADJUSTSALARYAPPLY SET FBILLSTATE = ? WHERE FID = ? ";
        Object[] param = new Object[]{state.getValue(), billId.toString()};
        DbUtil.execute((Context)ctx, (String)sql, (Object[])param);
    }

    protected void _setSaved(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        String billId = billID.toString();
        if (!StringUtils.isEmpty((String)billId)) {
            IAdjustSalaryApply adjustSalaryApplyBill = AdjustSalaryApplyFactory.getLocalInstance(ctx);
            AdjustSalaryApplyInfo adjustSalaryApplyInfo = adjustSalaryApplyBill.getAdjustSalaryApplyInfo((IObjectPK)new ObjectUuidPK(billId));
            if (null == adjustSalaryApplyInfo) {
                logger.error(MessageFormat.format(" when CmpWorkFlowMainBillControllerBean._setSaved invocked, getCmpWorkFlowMainBillInfo is null ! billId:{0}", billId));
                return;
            }
            HRBillStateEnum billState = adjustSalaryApplyInfo.getBillState();
            if (HRBillStateEnum.SUBMITED.equals((Object)billState) || HRBillStateEnum.AUDITING.equals((Object)billState) || HRBillStateEnum.AUDITEND.equals((Object)billState)) {
                SelectorItemCollection selector = new SelectorItemCollection();
                adjustSalaryApplyInfo.setBillState(HRBillStateEnum.SAVED);
                selector.add(new SelectorItemInfo("billState"));
                AdjustSalaryUtils.updateEntryBillState(ctx, billId, HRBillStateEnum.SAVED);
                adjustSalaryApplyBill.updatePartial(adjustSalaryApplyInfo, selector);
                this.abortWorkFlow(ctx, billId);
                this.clearProcInstBizInfo(ctx, adjustSalaryApplyInfo);
            } else {
                logger.error(MessageFormat.format("billInfo,id: {0}", String.valueOf(adjustSalaryApplyInfo.getId())));
            }
        } else {
            logger.error(" when AdjustSalaryApplyControllerBean._setSaved invocked, param billId is empty! please check param ");
        }
    }

    @Override
    protected IObjectPK _saveApplyBillEntry(Context ctx, Map params) throws BOSException, EASBizException {
        Map map = (Map)params.get("map");
        List baseDataList = (List)params.get("baseDataList");
        AdjustSalaryApplyInfo info = (AdjustSalaryApplyInfo)params.get("info");
        List colNames = (List)map.get("colNames");
        List colTypes = (List)map.get("colTypes");
        String billEntryTable = map.get("fBillEntryTableName").toString();
        IObjectPK objectPK = this.addnew(ctx, info);
        HashMap<String, Date> leffDayMap = new HashMap<String, Date>();
        String hrOrgUnitId = info.getHrOrgUnit().getId().toString();
        AdjustPersonRecordCollection reCol = AdjustPersonRecordFactory.getLocalInstance((Context)ctx).getAdjustPersonRecordCollection(" where hrOrgUnit.id = '" + hrOrgUnitId + "' ");
        AdjustPersonRecordInfo recordInfo = null;
        for (int i = 0; i < reCol.size(); ++i) {
            recordInfo = reCol.get(i);
            leffDayMap.put(recordInfo.getPerson().getId().toString(), recordInfo.getLeffectDate());
        }
        String insertCol = AdjustSalaryUtils.assembleInsertSql(ctx, billEntryTable, colNames, objectPK.toString());
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        for (int i = 0; i < baseDataList.size(); ++i) {
            int j;
            Map baseData = (Map)baseDataList.get(i);
            List<Object> insertParam = this.insertParam(baseData, leffDayMap, info);
            Object[] batchParam = new Object[insertParam.size() + colNames.size()];
            for (j = 0; j < insertParam.size(); ++j) {
                batchParam[j] = insertParam.get(j);
            }
            try {
                for (j = 0; j < colNames.size(); ++j) {
                    String dataType = (String)colTypes.get(j);
                    Object object = baseData.get(colNames.get(j));
                    if ("2".equals(dataType)) {
                        if (object != null && object.toString().trim().length() > 0) {
                            String datestr = object.toString();
                            batchParam[insertParam.size() + j] = new java.sql.Date(dateFormat.parse(datestr).getTime());
                            continue;
                        }
                        batchParam[insertParam.size() + j] = null;
                        continue;
                    }
                    batchParam[insertParam.size() + j] = object;
                }
            }
            catch (ParseException e) {
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
            paramList.add(batchParam);
        }
        if (paramList.size() > 0) {
            CmpSQLUtil.executeBatch((Context)ctx, (String)insertCol, paramList);
        }
        return objectPK;
    }

    protected List<Object> insertParam(Map<String, Object> baseData, Map<String, Date> leffDayMap, AdjustSalaryApplyInfo info) {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(BOSUuid.create((String)"11436768").toString());
        params.add(new java.sql.Date(new Date().getTime()));
        params.add(baseData.get("FEffectDate"));
        params.add(leffDayMap.get(baseData.get("FPersonID")) == null ? CmpDateUtil.toSqlDate((Date)CmpDateUtil.getMaxEndDate()) : leffDayMap.get(baseData.get("FPersonID")));
        params.add(baseData.get("FHrOrgUnitID") == null ? null : baseData.get("FHrOrgUnitID"));
        params.add(baseData.get("FPersonID") == null ? null : baseData.get("FPersonID"));
        params.add(baseData.get("FAdminOrgUnitID") == null ? null : baseData.get("FAdminOrgUnitID"));
        params.add(baseData.get("FPositionID") == null ? null : baseData.get("FPositionID"));
        params.add(baseData.get("FAdjustEmpORelationID") == null ? null : baseData.get("FAdjustEmpORelationID"));
        params.add(baseData.get("FCurrencyID") == null ? "dfd38d11-00fd-1000-e000-1ebdc0a8100dDEB58FDC" : baseData.get("FCurrencyID"));
        params.add(baseData.get("fdescription_l1"));
        params.add(baseData.get("fdescription_l2"));
        params.add(baseData.get("fdescription_l3"));
        params.add(0);
        params.add(10);
        params.add(baseData.get("FID"));
        params.add(info.getAdjustSalaryRule().getId().toString());
        params.add(baseData.get("FForwarnContent"));
        params.add(null);
        params.add(null);
        params.add(null);
        params.add(null);
        params.add(0);
        return params;
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.beforeDelete(ctx, pk);
        super._delete(ctx, pk);
    }

    protected void beforeDelete(Context ctx, IObjectPK pk) throws EASBizException {
        if (pk == null) {
            throw new AdjustBillException(AdjustBillException.NOTGET);
        }
        try {
            AdjustSalaryApplyInfo info = AdjustSalaryApplyFactory.getLocalInstance(ctx).getAdjustSalaryApplyInfo(pk);
            if (!info.getBillState().equals((Object)HRBillStateEnum.SAVED)) {
                throw new AdjustBillException(AdjustBillException.ADJNOTDELETE);
            }
            this.deleteRowEntry(ctx, info);
        }
        catch (BOSException e) {
            e.printStackTrace();
            throw new AdjustBillException(null, e);
        }
    }

    protected void beforeSave(Context ctx, AdjustSalaryApplyInfo info) throws EASBizException, BOSException {
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        String orgID = info.getHrOrgUnit().getId().toString();
        if (StringUtils.isEmpty((String)info.getNumber()) && iCodingRuleManager.isExist((IObjectValue)info, orgID)) {
            try {
                SHRCodingRule shrCodingRule = SHRCodingRuleApi.getCodingNumber((Context)ctx, (IObjectValue)info, (String)orgID);
                String number = shrCodingRule.getCodingRuleNumber();
                info.setNumber(number);
            }
            catch (Exception e) {
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
        }
        super.checkNumberBlank(ctx, null, (CoreBillBaseInfo)info);
        super.checkNumberDup(ctx, null, (CoreBillBaseInfo)info);
        HRBillStateEnum oldBillState = null;
        if (info.getId() != null) {
            AdjustSalaryApplyCollection applyInfoC = this.getAdjustSalaryApplyCollection(ctx, "select id,billState where id = '" + info.getId().toString() + "'");
            oldBillState = applyInfoC.isEmpty() ? null : applyInfoC.get(0).getBillState();
        }
        super.checkHRBillWorkFlowIsEdit(ctx, (HRBillBaseInfo)info, oldBillState);
    }

    protected boolean _checkNumberDup(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        CoreBillBaseInfo coreBillBaseInfo = (CoreBillBaseInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)coreBillBaseInfo.getString("number"), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (coreBillBaseInfo.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)coreBillBaseInfo.getId().toString(), CompareType.NOTEQUALS));
            filter.setMaskString("#0 and #1");
        }
        if (super._exists(ctx, filter)) {
            throw new EASBizException(EASBizException.CHECKDUPNUMBER, new Object[]{coreBillBaseInfo.getString("number"), ""});
        }
        return true;
    }

    private void deleteRowEntry(Context ctx, AdjustSalaryApplyInfo info) {
        try {
            if (info.getId() != null) {
                String fBillEntryTableName = AdjustSalaryUtils.getCalShemeTableName(ctx, info.getAdjustSalaryRule().getId().toString());
                StringBuilder deleteSql = new StringBuilder("delete from ");
                deleteSql.append(fBillEntryTableName).append(" where FBillID ='").append(info.getId());
                deleteSql.append("'");
                try {
                    DbUtil.execute((Context)ctx, (String)deleteSql.toString());
                }
                catch (BOSException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (BOSException e) {
            logger.error(e.getMessage());
        }
    }

    @Override
    protected void _revokeEntry(Context ctx, Map params) throws BOSException, EASBizException {
        Map oneData = (Map)params.get("oneData");
        String fid = (String)params.get("fid");
        String calShemeTableName = (String)params.get("calShemeTableName");
        try {
            this.updateCmpStruct(ctx, calShemeTableName, oneData);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        this.udpAdjustEntryState(ctx, "'" + fid + "'", false, calShemeTableName);
    }

    private void updateCmpStruct(Context ctx, String calShemeTableName, Map<String, Object> map) throws EASBizException, BOSException, SQLException {
        IRowSet rowSet = null;
        String billId = (String)map.get("billId");
        String payHrOrgUnit = (String)map.get("payHrOrgUnit");
        String personId = (String)map.get("personId");
        String cmpItem = (String)map.get("cmpItem");
        Calendar calendar = Calendar.getInstance();
        calendar.set(2199, 11, 31, 0, 0, 0);
        calendar.set(14, 0);
        String deleteSql = "DELETE FROM T_HR_SFIXADJUSTSALARY WHERE FID = ?";
        String updateSql = "UPDATE T_HR_SFIXADJUSTSALARY SET FLEFFECTDAY = ? WHERE FID = ? ";
        String delRecSql = "DELETE FROM T_HR_SFIXADJUSTPAYHRRECORD WHERE FSOURCEID = ? ";
        String updateRecSql = "UPDATE T_HR_SFIXADJUSTPAYHRRECORD SET FLEFFDT = ? WHERE FSOURCEID = ?";
        ArrayList<Object[]> delList = new ArrayList<Object[]>();
        ArrayList<Object[]> updateList = new ArrayList<Object[]>();
        StringBuilder str = new StringBuilder();
        str.append(" SELECT A01.FID NEWFID, A01.FLEFFECTDAY NEWLEFFDT, A02.FID OLDID, A02.FLeffectSource leffSource, A04.FLeffectDate,A02.FSysLFDBak ");
        str.append(" FROM T_HR_SFIXADJUSTSALARY A01 ");
        str.append(" LEFT JOIN T_HR_SFIXADJUSTSALARY A02 ON A01.FOLDFIXADJUSTSALARYID = A02.FID ");
        str.append(" LEFT JOIN T_HR_SAdjustEmpORelation A03 ON A03.FID = A02.FAdjEmpORelationID ");
        str.append(" LEFT JOIN T_HR_SAdjustPersonRecord A04 ON A04.FID = A03.FPersonRecordID ");
        str.append(" WHERE A01.FBILLID = '").append(billId).append("' AND A01.FPersonID = '").append(personId).append("'");
        if (StringUtils.isEmpty((String)payHrOrgUnit)) {
            str.append(" AND A01.FPayHrOrgUnitID is null and A01.FCmpItemID = '").append(cmpItem).append("'");
        } else {
            str.append(" AND A01.FPayHrOrgUnitID = '").append(payHrOrgUnit).append("' and A01.FCmpItemID = '").append(cmpItem).append("'");
        }
        rowSet = DbUtil.executeQuery((Context)ctx, (String)str.toString());
        while (rowSet.next()) {
            java.sql.Date sysLFDBak;
            Object[] param = new Object[]{rowSet.getString("NEWFID")};
            delList.add(param);
            String leffSource = rowSet.getString("leffSource");
            if (leffSource == null) continue;
            param = new Object[2];
            java.sql.Date recordLFD = rowSet.getDate("FLeffectDate");
            Object object = param[0] = recordLFD != null ? recordLFD : new java.sql.Date(calendar.getTime().getTime());
            if (leffSource.equals("20") && (sysLFDBak = rowSet.getDate("FSysLFDBak")) != null) {
                param[0] = sysLFDBak;
            }
            param[1] = rowSet.getString("OLDID");
            updateList.add(param);
        }
        String oql = "where billId = '" + billId + "'  and cmpItem='" + cmpItem + "' and person='" + personId + "'";
        oql = StringUtils.isEmpty((String)payHrOrgUnit) ? oql + " and  payHrOrgUnit is null" : oql + " and  payHrOrgUnit = '" + payHrOrgUnit + "' ";
        FixAdjustSalaryCollection coll = FixAdjustSalaryFactory.getLocalInstance((Context)ctx).getFixAdjustSalaryCollection(oql);
        ArrayList<FixAdjustSalaryInfo> list = new ArrayList<FixAdjustSalaryInfo>();
        for (int i = 0; i < coll.size(); ++i) {
            list.add(coll.get(i));
        }
        FixAdjustSalaryRecordFacadeFactory.getLocalInstance((Context)ctx).saveRecord(list, "abort");
        DbUtil.executeBatch((Context)ctx, (String)deleteSql, delList);
        DbUtil.executeBatch((Context)ctx, (String)delRecSql, delList);
        if (updateList.size() > 0) {
            DbUtil.executeBatch((Context)ctx, (String)updateSql, updateList);
            DbUtil.executeBatch((Context)ctx, (String)updateRecSql, updateList);
        }
    }

    @Override
    protected Map _validationEntry(Context ctx, Map params) throws BOSException, EASBizException {
        String fids = (String)params.get("fids");
        String adjustSalaryRuleId = (String)params.get("adjustSalaryRuleId");
        String calShemeTableName = (String)params.get("calShemeTableName");
        Map map = this.udpAdjustPersonRecord(ctx, fids, adjustSalaryRuleId);
        Map success = (Map)map.get("success");
        if (null != success && !success.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry entry : success.entrySet()) {
                String fid = (String)entry.getKey();
                sb.append("'").append(fid).append("',");
            }
            String fidString = sb.toString();
            if (!StringUtils.isEmpty((String)fidString)) {
                fidString = fidString.substring(0, fidString.length() - 1);
                this.udpAdjustEntryState(ctx, fidString, true, calShemeTableName);
            }
        }
        return map;
    }

    protected Map udpAdjustPersonRecord(Context ctx, String fids, String adjustSalaryRuleId) throws BOSException, EASBizException {
        ApplyBill2FixAdjustSalary execute = new ApplyBill2FixAdjustSalary();
        FixAdjustSalaryInfo fixInfo = null;
        Map<String, Object> entryMap = AdjustSalaryUtils._getBillColumnListAndBillEntryTableName(ctx, adjustSalaryRuleId, true);
        String billEntryTableName = AdjustSalaryUtils.getCalShemeTableName(ctx, adjustSalaryRuleId);
        List colNames = (List)entryMap.get("colNames");
        boolean existAdjReason = AdjustSalaryUtils.checkAdjustReason(ctx, adjustSalaryRuleId);
        List<Object> coll = new ArrayList();
        coll = AdjustSalaryUtils.assembleAdjBaseTableData(ctx, billEntryTableName, fids, null, colNames, existAdjReason);
        Map mapping = (Map)entryMap.get("mapping");
        Map<String, String> floatRateMap = AdjustSalaryUtils.getFloatRateMap(ctx);
        Map<String, Boolean> aeoMap = this.queryUseDefaultByBillId(ctx, billEntryTableName, fids, null);
        Map<String, List<String>> cmpStd2ItemMap = this.queryCmpStandardAndCmpItem(ctx);
        HashMap map = new HashMap();
        HashMap<String, String> success = new HashMap<String, String>();
        HashMap<String, String> fail = new HashMap<String, String>();
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            Map info = (Map)coll.get(i);
            String adjHrOrgUnitID = (String)info.get("FAdjHrOrgUnitID");
            String fid = (String)info.get("FID");
            HROrgUnitInfo adjHrOrgUnit = new HROrgUnitInfo();
            adjHrOrgUnit.setId(BOSUuid.read((String)adjHrOrgUnitID));
            try {
                for (String colName : colNames) {
                    fixInfo = new FixAdjustSalaryInfo();
                    if (info.get(colName) == null) continue;
                    String cmpItemId = mapping.get(colName).toString();
                    boolean hasCmpStandard = false;
                    if (info.get("FCmpStandardID") != null && cmpStd2ItemMap.get(info.get("FCmpStandardID")).contains(cmpItemId)) {
                        hasCmpStandard = true;
                    }
                    this.initEntity(ctx, fixInfo, info, colName, cmpItemId, adjHrOrgUnit, floatRateMap, null, hasCmpStandard);
                    this.otherParam(ctx, fixInfo, info);
                    if (fixInfo.getAdjEmpORelation() != null && fixInfo.getAdjEmpORelation().getId() != null && aeoMap.get(fixInfo.getAdjEmpORelation().getId().toString()) != null) {
                        fixInfo.setUseDefault(aeoMap.get(fixInfo.getAdjEmpORelation().getId().toString()).booleanValue());
                    } else {
                        fixInfo.setUseDefault(Boolean.TRUE.booleanValue());
                    }
                    execute.save(ctx, fixInfo);
                }
                success.put(fid, "");
                continue;
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                fail.put(fid, e.getMessage());
            }
        }
        map.put("success", success);
        map.put("fail", fail);
        return map;
    }

    protected void udpAdjustEntryState(Context ctx, String fids, boolean type, String calShemeTableName) throws BOSException {
        int state = type ? 1 : 0;
        String updateSql = " update " + calShemeTableName + " set FState = " + state + " where fid in (" + fids + ")";
        DbUtil.execute((Context)ctx, (String)updateSql);
        String updateNoticeSql = "update T_HR_SAdjustSalaryNoticeEntry set FAdjEntryState=" + state + " where FAdjEntryId in (" + fids + ") and FIsRemove <> 1 ";
        DbUtil.execute((Context)ctx, (String)updateNoticeSql);
    }

    @Override
    protected Map _batchAbortCmpStructAndState(Context ctx, Map param) throws BOSException, EASBizException {
        if (param.get("billId") == null || param.get("entryIds") == null) {
            return null;
        }
        String billId = param.get("billId").toString();
        String entryIds = param.get("entryIds").toString();
        String entryIdsInsql = "(" + CmpSQLUtil.createInSql((Context)ctx, (String)entryIds, (String)"T_HR_SAdjustSalaryApplyEntry", (String)"FID") + ")";
        AdjustSalaryApplyInfo adjBill = NoticeDaoUtils.getAdjBillInfo(ctx, billId);
        if (adjBill == null || adjBill.getAdjustSalaryRule() == null || adjBill.getHrOrgUnit() == null) {
            return null;
        }
        String hrOrgId = adjBill.getHrOrgUnit().getId().toString();
        String submitSchemeId = adjBill.getAdjustSalaryRule().getId().toString();
        String calShemeTableName = AdjustSalaryUtils.getCalShemeTableName(ctx, submitSchemeId);
        try {
            boolean adj003Param = this.getAdj003Param(ctx, hrOrgId);
            if (!adj003Param) {
                Map<String, Object> resultMap = this.updateCmpStruct(ctx, billId, entryIdsInsql, calShemeTableName);
                if (resultMap.get("entryIds") != null) {
                    this.udpEntryState(ctx, adjBill, resultMap.get("entryIds").toString(), 0);
                }
                return resultMap;
            }
            this.updateNoticeState(ctx, billId, entryIdsInsql, 0);
        }
        catch (EASBizException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return null;
    }

    public void updateNoticeState(Context ctx, String adjBillId, String entryInSql, int state) throws BOSException {
        String updateNoticeSql = "update T_HR_SAdjustSalaryNoticeEntry set FAdjEntryState=" + state + ", FConfirmState=" + 4 + ",FConfirmTime=null,FConfirmType=null,FResetTime=now() where FAdjEntryId in " + entryInSql + " and FIsRemove <> 1 and FNoticeBillId in (select fid from T_HR_SAdjustSalaryNoticeBill where FIsRemove <> 1 and FAdjBillId=?)";
        DbUtil.execute((Context)ctx, (String)updateNoticeSql, (Object[])new Object[]{adjBillId});
    }
}

