/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.cmpdesign.app.v2.mapping;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.EmpPosOrgRelationCollection;
import com.kingdee.eas.hr.base.EmpPosOrgRelationFactory;
import com.kingdee.eas.hr.base.EmpPosOrgRelationInfo;
import com.kingdee.eas.hr.base.HRBillBaseInfo;
import com.kingdee.eas.hr.emp.SalaryItemInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.cmpdesign.CmpStandardInfo;
import com.kingdee.shr.cmpdesign.CmpStdLevelFactory;
import com.kingdee.shr.cmpdesign.CmpStdLevelInfo;
import com.kingdee.shr.cmpdesign.CmpStdPointInfo;
import com.kingdee.shr.cmpdesign.CmpStdScopeInfo;
import com.kingdee.shr.cmpdesign.app.v2.base.AdjustSalaryItemInfo;
import com.kingdee.shr.cmpdesign.app.v2.bill.AdjBillSourceEnum;
import com.kingdee.shr.cmpdesign.app.v2.bill.AdjustSalaryApplyEntryCollection;
import com.kingdee.shr.cmpdesign.app.v2.bill.AdjustSalaryApplyEntryInfo;
import com.kingdee.shr.cmpdesign.app.v2.bill.AdjustSalaryApplyFactory;
import com.kingdee.shr.cmpdesign.app.v2.bill.AdjustSalaryApplyInfo;
import com.kingdee.shr.cmpdesign.app.v2.mapping.AbstractGenCmpAdjDataFromEmpFacadeControllerBean;
import com.kingdee.shr.cmpdesign.app.v2.mapping.AdjustItemMappingSchemeCollection;
import com.kingdee.shr.cmpdesign.app.v2.mapping.AdjustItemMappingSchemeInfo;
import com.kingdee.shr.cmpdesign.app.v2.mapping.DataArchivingType;
import com.kingdee.shr.cmpdesign.app.v2.mapping.DataSyncType;
import com.kingdee.shr.cmpdesign.app.v2.mapping.EmpAdjustItemMappingTableCollection;
import com.kingdee.shr.cmpdesign.app.v2.mapping.EmpAdjustItemMappingTableFactory;
import com.kingdee.shr.cmpdesign.app.v2.mapping.EmpAdjustItemMappingTableInfo;
import com.kingdee.shr.cmpdesign.app.v2.mapping.GenCmpAdjDataFromEmpFacadeFactory;
import com.kingdee.shr.cmpdesign.app.v2.mapping.SubmitItemMappingSchemeCollection;
import com.kingdee.shr.cmpdesign.app.v2.mapping.SubmitItemMappingSchemeInfo;
import com.kingdee.shr.cmpdesign.app.v2.mapping.YesNoEnum;
import com.kingdee.shr.cmpdesign.app.v2.mapping.dealSpecial.DealSpecialItem;
import com.kingdee.shr.cmpdesign.app.v2.mapping.dealSpecial.SpecialItemInfo;
import com.kingdee.shr.cmpdesign.app.v2.mapping.dealSpecial.impl.DealSignatureFee;
import com.kingdee.shr.cmpdesign.fix.ApplyBill2FixAdjustSalary;
import com.kingdee.shr.cmpdesign.util.AdjustSalaryUtils;
import com.kingdee.shr.compensation.AdjustEmpORelationCollection;
import com.kingdee.shr.compensation.AdjustEmpORelationFactory;
import com.kingdee.shr.compensation.AdjustEmpORelationInfo;
import com.kingdee.shr.compensation.CmpEmpORelationCollection;
import com.kingdee.shr.compensation.CmpEmpORelationFactory;
import com.kingdee.shr.compensation.CmpEmpORelationInfo;
import com.kingdee.shr.compensation.CmpItemInfo;
import com.kingdee.shr.compensation.FixAdjustSalaryCollection;
import com.kingdee.shr.compensation.FixAdjustSalaryFactory;
import com.kingdee.shr.compensation.FixAdjustSalaryInfo;
import com.kingdee.shr.compensation.SscTypeEnum;
import com.kingdee.shr.compensation.app.integrate.BatchSubmitShemeBillEntryCollection;
import com.kingdee.shr.compensation.app.integrate.BatchSubmitShemeBillEntryInfo;
import com.kingdee.shr.compensation.app.integrate.BatchSubmitShemeBillFactory;
import com.kingdee.shr.compensation.app.integrate.BatchSubmitShemeBillInfo;
import com.kingdee.shr.compensation.app.integrate.CalSubmitItemInfo;
import com.kingdee.shr.compensation.app.integrate.CalSubmitSchemeFactory;
import com.kingdee.shr.compensation.app.integrate.CalSubmitSchemeInfo;
import com.kingdee.shr.compensation.app.integrate.SubBillSource;
import com.kingdee.shr.compensation.app.integrate.SubmitElementInfo;
import com.kingdee.shr.compensation.integrate.verify.CycleVerify;
import com.kingdee.shr.compensation.integrate.verify.SubmitBillDisableElementSubmitPeriodVerify;
import com.kingdee.shr.compensation.integrate.verify.SubmitBillEnableElementSubmitPeriodVerify;
import com.kingdee.shr.compensation.util.CmpDateUtil;
import com.kingdee.shr.compensation.util.CmpSQLUtil;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import com.kingdee.shr.compensation.util.adj.RecEmpAdjSalaryUtil;
import com.kingdee.shr.compensation.util.db.CmpInSql;
import com.kingdee.shr.compensation.util.db.CmpInSqlFactory;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.UuidException;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.log4j.Logger;

public class GenCmpAdjDataFromEmpFacadeControllerBean
extends AbstractGenCmpAdjDataFromEmpFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.cmpdesign.app.v2.mapping.GenCmpAdjDataFromEmpFacadeControllerBean");
    public static final String SCHEME_IS_CYCLE = "SCHEME_IS_CYCLE";
    public static final String ITEM_DATA_LENGTH = "ITEM_DATA_LENGTH";
    public static final String ITEM_DATA_DATA_DOT = "ITEM_DATA_DATA_DOT";
    public static final String RMB_CURRENCY_ID = "dfd38d11-00fd-1000-e000-1ebdc0a8100dDEB58FDC";
    private Map<String, String> orgMappingTableMap = new HashMap<String, String>();
    private Map<String, String> selfOrgMappingTableMap = new HashMap<String, String>();
    private Map<String, EmpAdjustItemMappingTableInfo> mappingTableMap = new HashMap<String, EmpAdjustItemMappingTableInfo>();
    private Map<String, List<String>> tableMapOrg = new HashMap<String, List<String>>();
    private Map<String, YesNoEnum> adjustSchemeMaintainPayHrOrgMap = new HashMap<String, YesNoEnum>();
    private Map<String, YesNoEnum> cmpItemMaintainPayHrOrgMap = new HashMap<String, YesNoEnum>();
    private Map<String, AdjustSalaryApplyInfo> adjBillMap = new HashMap<String, AdjustSalaryApplyInfo>();
    private Map<String, BatchSubmitShemeBillInfo> subBillMap = new HashMap<String, BatchSubmitShemeBillInfo>();
    private List<Map<String, Object>> exceptions = new ArrayList<Map<String, Object>>();
    private String endKsqlDate = "";
    protected Set<String> includSubOrgCmpSchemeIdSet = new HashSet<String>();
    private Map<String, FixAdjustSalaryCollection> collMap = new HashMap<String, FixAdjustSalaryCollection>();
    private static final String MAPPING_TABLE_SELECTORS = "id,dataSyncType,dataArchivingType,hrOrgUnit,enableCurrency,currency,adjustItemMapping.*,adjustItemMapping.empAdjustItem.*,adjustItemMapping.adjustItem.*,adjustItemMapping.adjustScheme.*,adjustItemMapping.cmpItem.*,submitItemMapping.*,submitItemMapping.empAdjustItem.*,submitItemMapping.submitElement.*,submitItemMapping.submitItem.*,submitItemMapping.submitScheme.*,adjBusinessTypeRecord.adjBusinessType.*";

    @Override
    protected void _genCmpAdjData(Context ctx, int nDays) throws BOSException {
        this.initHisFixAdjust(ctx);
        this.endKsqlDate = this.getEndDate(nDays);
        this.loopTableGenCmpAdjData(ctx);
    }

    protected void initHisFixAdjust(Context ctx) throws BOSException {
        String sql = "select distinct FPersonID from T_HR_EmpSalaryAdjustment where FSalaryDealState = 0";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        HashSet<String> personList = new HashSet<String>();
        try {
            while (rs.next()) {
                personList.add(rs.getString("FPersonID"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        CmpInSql cmpInSql = CmpInSqlFactory.getInstance();
        String personSqlId = cmpInSql.createInSqlBaseOnFId(ctx, personList);
        String oql = " where person.id in " + personSqlId;
        oql = oql + " order by person.id, payHrOrgUnit.id, cmpItem.id, effectDay ";
        FixAdjustSalaryCollection oldColl = FixAdjustSalaryFactory.getLocalInstance((Context)ctx).getFixAdjustSalaryCollection(oql);
        FixAdjustSalaryCollection temp = null;
        String key = null;
        String personId = null;
        String cmpItemId = null;
        String payHrOrgUnitId = null;
        for (int i = 0; i < oldColl.size(); ++i) {
            FixAdjustSalaryInfo oldFix = oldColl.get(i);
            personId = oldFix.getPerson().getId().toString();
            cmpItemId = oldFix.getCmpItem().getId().toString();
            payHrOrgUnitId = oldFix.getPayHrOrgUnit() == null ? null : oldFix.getPayHrOrgUnit().getId().toString();
            key = personId + "_" + cmpItemId + "_" + payHrOrgUnitId;
            if (this.collMap.get(key) != null) {
                temp = this.collMap.get(key);
            } else {
                temp = new FixAdjustSalaryCollection();
                this.collMap.put(key, temp);
            }
            temp.add(oldFix);
        }
    }

    protected void loopTableGenCmpAdjData(Context ctx) throws BOSException {
        List<String> adjBusinessTypes = this.getAdjBusinessType(ctx);
        for (String businessType : adjBusinessTypes) {
            logger.info((Object)("com.kingdee.shr.cmpdesign.app.v2.mapping.GenCmpAdjDataFromEmpFacadeControllerBean.loop-->start:businessType: " + this.getAdjBillSource(businessType).getAlias()));
            this.initOrgMappingTable(ctx, 1, businessType);
            this.initMappingTable(ctx, CmpStrUtil.convertSetToSqlString(this.tableMapOrg.keySet()));
            Set<String> keySet = this.mappingTableMap.keySet();
            for (String tableId : keySet) {
                EmpAdjustItemMappingTableInfo tableInfo = this.mappingTableMap.get(tableId);
                DataSyncType dataSyncType = tableInfo.getDataSyncType();
                DataArchivingType dataArchivingType = tableInfo.getDataArchivingType();
                List<String> hrOrgUnitList = this.tableMapOrg.get(tableId);
                String hrOrgUnitIds = CmpStrUtil.convertListToString(hrOrgUnitList);
                SubmitItemMappingSchemeCollection submitItemMapping = tableInfo.getSubmitItemMapping();
                AdjustItemMappingSchemeCollection adjustItemMapping = tableInfo.getAdjustItemMapping();
                this.maintainPayHrOrg(tableInfo);
                this.genCmpData(ctx, tableInfo, submitItemMapping, "'" + tableInfo.getHrOrgUnit().getId().toString() + "'", null, null);
                if (DataSyncType.timing == dataSyncType && DataArchivingType.afterCreateBillArchiving == dataArchivingType) {
                    this.genAdjData(ctx, tableInfo, adjustItemMapping, hrOrgUnitIds, null, null);
                    continue;
                }
                if (DataSyncType.timing != dataSyncType || DataArchivingType.directArchiving != dataArchivingType) continue;
                this.directGenAdjData(ctx, tableInfo, adjustItemMapping, hrOrgUnitIds, null, null);
            }
            this._dealSpecialItem(ctx, null, businessType);
            logger.info((Object)("com.kingdee.shr.cmpdesign.app.v2.mapping.GenCmpAdjDataFromEmpFacadeControllerBean.loop-->end:businessType: " + this.getAdjBillSource(businessType).getAlias()));
        }
    }

    private void maintainPayHrOrg(EmpAdjustItemMappingTableInfo tableInfo) {
        AdjustItemMappingSchemeCollection adjustItemMapping = tableInfo.getAdjustItemMapping();
        if (adjustItemMapping.isEmpty()) {
            return;
        }
        DataArchivingType dataArchivingType = tableInfo.getDataArchivingType();
        if (DataArchivingType.afterCreateBillArchiving == dataArchivingType) {
            for (int i = 0; i < adjustItemMapping.size(); ++i) {
                AdjustItemMappingSchemeInfo schemeInfo = adjustItemMapping.get(i);
                this.adjustSchemeMaintainPayHrOrgMap.put(schemeInfo.getAdjustScheme().getId().toString(), schemeInfo.getMaintainPayHrOrg());
            }
        } else {
            for (int i = 0; i < adjustItemMapping.size(); ++i) {
                AdjustItemMappingSchemeInfo schemeInfo = adjustItemMapping.get(i);
                this.cmpItemMaintainPayHrOrgMap.put(schemeInfo.getCmpItem().getId().toString(), schemeInfo.getMaintainPayHrOrg());
            }
        }
    }

    protected String getEndDate(int nDays) {
        Date nowDate = new Date();
        Calendar instance = Calendar.getInstance();
        instance.setTime(nowDate);
        instance.set(11, 0);
        instance.set(12, 0);
        instance.set(13, 0);
        instance.set(14, 0);
        return CmpDateUtil.toKSqlDate((Date)CmpDateUtil.getAddDate((Date)instance.getTime(), (int)(0 - nDays)));
    }

    protected Map<String, Object> getSubmitBillEntryNeedInfo(Context ctx, SubmitItemMappingSchemeCollection submitItemMapping) throws BOSException {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        HashMap<String, Boolean> cycleSchemeMap = new HashMap<String, Boolean>();
        HashMap<String, Integer> submitItemLengthMap = new HashMap<String, Integer>();
        HashMap<String, Integer> submitItemDataDotMap = new HashMap<String, Integer>();
        resultMap.put(SCHEME_IS_CYCLE, cycleSchemeMap);
        resultMap.put(ITEM_DATA_LENGTH, submitItemLengthMap);
        resultMap.put(ITEM_DATA_DATA_DOT, submitItemDataDotMap);
        if (submitItemMapping == null || submitItemMapping.size() == 0) {
            return resultMap;
        }
        HashSet<String> schemeIdSet = new HashSet<String>();
        HashSet<String> submitItemIdSet = new HashSet<String>();
        String subSchemeId = "";
        String subItemId = "";
        int size = submitItemMapping.size();
        for (int i = 0; i < size; ++i) {
            CalSubmitItemInfo subItem;
            SubmitItemMappingSchemeInfo mappingSchemeInfo = submitItemMapping.get(i);
            if (mappingSchemeInfo == null) continue;
            CalSubmitSchemeInfo adjustScheme = mappingSchemeInfo.getSubmitScheme();
            if (adjustScheme != null) {
                subSchemeId = adjustScheme.getId().toString();
                if (!StringUtils.isEmpty((String)subItemId)) {
                    schemeIdSet.add(subSchemeId);
                }
            }
            if ((subItem = mappingSchemeInfo.getSubmitItem()) == null || StringUtils.isEmpty((String)(subItemId = subItem.getId().toString()))) continue;
            submitItemIdSet.add(subItemId);
        }
        this.getIsCycleScheme(ctx, cycleSchemeMap, schemeIdSet);
        this.getItemDataLenAndDataDot(ctx, submitItemLengthMap, submitItemDataDotMap, submitItemIdSet);
        resultMap.put(SCHEME_IS_CYCLE, cycleSchemeMap);
        resultMap.put(ITEM_DATA_LENGTH, submitItemLengthMap);
        resultMap.put(ITEM_DATA_DATA_DOT, submitItemDataDotMap);
        return resultMap;
    }

    protected void getItemDataLenAndDataDot(Context ctx, Map<String, Integer> submitItemLengthMap, Map<String, Integer> submitItemDataDotMap, Set<String> submitItemIdSet) throws BOSException {
        CmpInSql instance = CmpInSqlFactory.getInstance();
        String createInSqlBaseOnFId = instance.createInSqlBaseOnFId(ctx, submitItemIdSet);
        String sql = " SELECT  FIELDSN,FDATATYPE,FDATALENGTH,FDATADOT FROM T_HR_SCALSUBMITITEM where FdataType in ('0','1') and FID in " + createInSqlBaseOnFId;
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (rowSet.next()) {
                int fieldSn = rowSet.getInt("FIELDSN");
                int dataLength = rowSet.getInt("FDATALENGTH");
                String dataType = rowSet.getString("FDATATYPE");
                int dataDot = rowSet.getInt("FDATADOT");
                String key = "S" + fieldSn;
                if ("0".equals(dataType)) {
                    submitItemDataDotMap.put(key, dataDot);
                    continue;
                }
                if (!"1".equals(dataType)) continue;
                submitItemLengthMap.put(key, dataLength);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        instance.release(ctx);
    }

    protected void getIsCycleScheme(Context ctx, Map<String, Boolean> cycleSchemeMap, Set<String> schemeIdSet) throws BOSException {
        CmpInSql instance = CmpInSqlFactory.getInstance();
        String createInSqlBaseOnFId = instance.createInSqlBaseOnFId(ctx, schemeIdSet);
        String sql = " SELECT FID,FISCYCLE FROM T_HR_SCalSubmitScheme where FID in " + createInSqlBaseOnFId;
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (rowSet.next()) {
                String id = rowSet.getString("FID");
                int isCycle = rowSet.getInt("FISCYCLE");
                if (StringUtils.isEmpty((String)id)) continue;
                cycleSchemeMap.put(id, isCycle == 1);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        instance.release(ctx);
    }

    protected void initIncludSubOrgSet() {
        this.includSubOrgCmpSchemeIdSet.add(this.getMultiIncentiveAwardSchemeId());
        this.includSubOrgCmpSchemeIdSet.add(this.getSignatureFeeSchemeId());
    }

    protected String getMultiIncentiveAwardSchemeId() {
        return "jJ0AAAAA1thRn/us";
    }

    protected String getSignatureFeeSchemeId() {
        return "8r0AAAAVg9VRn/us";
    }

    protected void genCmpData(Context ctx, EmpAdjustItemMappingTableInfo mappingTable, SubmitItemMappingSchemeCollection submitItemMapping, String hrOrgUnitId, String personId, String empORelId) throws BOSException {
        logger.info((Object)("com.kingdee.shr.cmpdesign.app.v2.mapping.GenCmpAdjDataFromEmpFacadeControllerBean.genCmpData-->submitItemMapping: " + (Object)((Object)submitItemMapping)));
        if (null == submitItemMapping || submitItemMapping.size() == 0 || mappingTable.getAdjBusinessTypeRecord().isEmpty()) {
            return;
        }
        String adjBusinessTypeId = mappingTable.getAdjBusinessTypeRecord().get(0).getAdjBusinessType().getId().toString();
        this.initIncludSubOrgSet();
        Map<String, Map<String, String>> subSchemeMapitemMapper = this.getEmpItemMapperSubItem(submitItemMapping);
        logger.info((Object)("com.kingdee.shr.cmpdesign.app.v2.mapping.GenCmpAdjDataFromEmpFacadeControllerBean.genCmpData-->subSchemeMapitemMapper: " + subSchemeMapitemMapper));
        if (subSchemeMapitemMapper.size() > 0) {
            String subSchemeId = "";
            String sqlFormat = this.getCmpQuerySql(personId, empORelId, adjBusinessTypeId);
            Set<Map.Entry<String, Map<String, String>>> entrySet = subSchemeMapitemMapper.entrySet();
            Iterator<Map.Entry<String, Map<String, String>>> iterator = entrySet.iterator();
            ArrayList<Object[]> updateESAStateParams = new ArrayList<Object[]>();
            HashMap<String, Object> submitBillEntryNeedMap = new HashMap();
            try {
                submitBillEntryNeedMap = this.getSubmitBillEntryNeedInfo(ctx, submitItemMapping);
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
            boolean enableCurrency = mappingTable.isEnableCurrency();
            CurrencyInfo currency = null;
            if (!enableCurrency) {
                currency = mappingTable.getCurrency();
            }
            while (iterator.hasNext()) {
                String tempPersonId = "";
                String perItemPersonid = "";
                try {
                    Map.Entry<String, Map<String, String>> entry = iterator.next();
                    subSchemeId = entry.getKey();
                    Map<String, String> empAdjItemMapperCmpItemMap = entry.getValue();
                    Set<String> empAdjItemIds = empAdjItemMapperCmpItemMap.keySet();
                    String getSubSchemeAdminLongN = "select b.FLONGNUMBER  from T_HR_SCalSubmitScheme a INNER JOIN T_ORG_ADmin b ON A.FADMINORGUNITID = B.FID where a.fid ='" + subSchemeId + "'";
                    IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)getSubSchemeAdminLongN);
                    String longNumber = "";
                    if (rowSet.next()) {
                        longNumber = rowSet.getString("FLONGNUMBER");
                    }
                    String tempHROrgUnitId = hrOrgUnitId;
                    if (this.includSubOrgCmpSchemeIdSet.contains(subSchemeId) && this.selfOrgMappingTableMap.containsKey(hrOrgUnitId)) {
                        tempHROrgUnitId = CmpStrUtil.convertListToString(this.tableMapOrg.get(mappingTable.getId().toString()));
                    }
                    String sql = sqlFormat.replace("@_HRORGUNITID", tempHROrgUnitId).replace("@_SALARYITEM", CmpStrUtil.convertSetToSqlString(empAdjItemIds)).replace("@_ADMINRANGE", "select fid from T_ORG_ADmin where flongnumber like '" + longNumber + "%'");
                    logger.info((Object)("com.kingdee.shr.cmpdesign.app.v2.mapping.GenCmpAdjDataFromEmpFacadeControllerBean.genCmpData-->sql: " + sql));
                    rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
                    Map<String, Object[]> initBillApplyer = this.initBillApplyer(ctx, rowSet);
                    rowSet.beforeFirst();
                    HashSet<String> esaIdSet = new HashSet<String>();
                    String subBillMapKey = "";
                    String tempEffEctDate = "";
                    String perItemEffect = "";
                    String tempAffairId = "";
                    String perAffairId = "";
                    if (rowSet.size() < 1) continue;
                    while (rowSet.next()) {
                        try {
                            tempPersonId = rowSet.getString("FPERSONID");
                            tempEffEctDate = rowSet.getString("FEffect");
                            tempAffairId = rowSet.getString("FAffairId");
                            if (!StringUtils.isEmpty((String)perItemPersonid) && (!perItemPersonid.equals(tempPersonId) || perItemPersonid.equals(tempPersonId) && !perAffairId.equals(tempAffairId) || perItemPersonid.equals(tempPersonId) && !perItemEffect.equals(tempEffEctDate))) {
                                this.savePerPersonSubBill(ctx, subBillMapKey, updateESAStateParams, esaIdSet);
                                esaIdSet.clear();
                                this.subBillMap.remove(subBillMapKey);
                            }
                            esaIdSet.add(rowSet.getString("ESAID"));
                            perItemPersonid = tempPersonId;
                            perItemEffect = tempEffEctDate;
                            perAffairId = tempAffairId;
                            subBillMapKey = subSchemeId + "###" + tempPersonId + "###";
                            this.assembleSubBillInfo(ctx, rowSet, subSchemeId, empAdjItemMapperCmpItemMap, initBillApplyer, submitBillEntryNeedMap, currency);
                        }
                        catch (Exception e) {
                            HashMap<String, Object> err = new HashMap<String, Object>();
                            err.put("personId", tempPersonId);
                            err.put("exception", e);
                            if (e instanceof EASBizException) {
                                err.put("type", "Biz");
                            } else {
                                err.put("type", "Sys");
                            }
                            this.exceptions.add(err);
                        }
                    }
                    this.savePerPersonSubBill(ctx, subBillMapKey, updateESAStateParams, esaIdSet);
                    esaIdSet.clear();
                    this.subBillMap.remove(subBillMapKey);
                }
                catch (Exception e) {
                    HashMap<String, Object> err = new HashMap<String, Object>();
                    err.put("personId", tempPersonId);
                    err.put("exception", e);
                    if (e instanceof EASBizException) {
                        err.put("type", "Biz");
                    } else {
                        err.put("type", "Sys");
                    }
                    this.exceptions.add(err);
                }
            }
            logger.info((Object)("com.kingdee.shr.cmpdesign.app.v2.mapping.GenCmpAdjDataFromEmpFacadeControllerBean.genCmpData-->saveErrLog:" + this.exceptions.size()));
            try {
                if (this.exceptions != null && this.exceptions.size() > 0) {
                    GenCmpAdjDataFromEmpFacadeFactory.getLocalInstance(ctx).saveErrLog(this.exceptions);
                }
            }
            catch (EASBizException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            logger.info((Object)("com.kingdee.shr.cmpdesign.app.v2.mapping.GenCmpAdjDataFromEmpFacadeControllerBean.genCmpData-->updateEmpSalaryState" + updateESAStateParams.toArray()));
            RecEmpAdjSalaryUtil.updateEmpSalaryState((Context)ctx, updateESAStateParams);
        }
    }

    protected Map<String, Map<String, String>> getEmpItemMapperSubItem(SubmitItemMappingSchemeCollection submitItemMapping) {
        HashMap<String, Map<String, String>> subSchemeMapitemMapper = new HashMap<String, Map<String, String>>();
        String subSchemeId = "";
        String empAdjItemId = "";
        String subItemId = "";
        int size = submitItemMapping.size();
        for (int i = 0; i < size; ++i) {
            SubmitItemMappingSchemeInfo mappingSchemeInfo = submitItemMapping.get(i);
            CalSubmitSchemeInfo adjustScheme = mappingSchemeInfo.getSubmitScheme();
            SalaryItemInfo empAdjustItem = mappingSchemeInfo.getEmpAdjustItem();
            CalSubmitItemInfo subItem = mappingSchemeInfo.getSubmitItem();
            SubmitElementInfo submitElement = mappingSchemeInfo.getSubmitElement();
            String submitElementId = "";
            if (null != submitElement) {
                submitElementId = submitElement.getId().toString();
            }
            subSchemeId = adjustScheme.getId().toString();
            empAdjItemId = empAdjustItem.getId().toString();
            subItemId = subItem.getId().toString();
            subItemId = "S" + subItem.getFieldSn();
            if (!StringUtils.isEmpty((String)submitElementId)) {
                subItemId = subItemId + "###" + submitElementId;
            }
            Map empAdjItemMapperCmpItemMap = subSchemeMapitemMapper.containsKey(subSchemeId) ? (Map)subSchemeMapitemMapper.get(subSchemeId) : new HashMap();
            empAdjItemMapperCmpItemMap.put(empAdjItemId, subItemId);
            subSchemeMapitemMapper.put(subSchemeId, empAdjItemMapperCmpItemMap);
        }
        return subSchemeMapitemMapper;
    }

    protected void beforeSaveSubBill(Context ctx, BatchSubmitShemeBillInfo submitShemeBillInfo) {
    }

    protected void savePerPersonSubBill(Context ctx, String personId, List<Object[]> updateESAStateParams, Set<String> esaIdSet) throws BOSException, EASBizException, UuidException {
        BatchSubmitShemeBillInfo submitShemeBillInfo = this.subBillMap.get(personId);
        if (null == submitShemeBillInfo) {
            return;
        }
        String number = RecEmpAdjSalaryUtil.createBillNumber((Context)ctx, (String)submitShemeBillInfo.getHrOrgUnit().toString(), (HRBillBaseInfo)submitShemeBillInfo);
        submitShemeBillInfo.setNumber(number);
        this.beforeSaveSubBill(ctx, submitShemeBillInfo);
        logger.info((Object)("com.kingdee.shr.cmpdesign.app.v2.mapping.GenCmpAdjDataFromEmpFacadeControllerBean.savePerPersonSubBill-->personId: " + submitShemeBillInfo.getEntry().get(0).getPerson().getId() + " submitShemeBillInfo: " + submitShemeBillInfo));
        submitShemeBillInfo.setId(BOSUuid.create((String)"B11DBA5C"));
        if (!this.verifyCyclePeriod(ctx, submitShemeBillInfo) || !this.verifyPeriod(ctx, submitShemeBillInfo)) {
            return;
        }
        this.otherCheck(ctx);
        IObjectPK billId = BatchSubmitShemeBillFactory.getLocalInstance((Context)ctx).save((CoreBaseInfo)submitShemeBillInfo);
        BatchSubmitShemeBillFactory.getLocalInstance((Context)ctx).setPassState(BOSUuid.read((String)billId.toString()));
        this.afterSaveSubBill(ctx, submitShemeBillInfo);
        for (String tempid : esaIdSet) {
            Object[] param = new Object[]{billId.toString(), tempid};
            updateESAStateParams.add(param);
        }
    }

    public void otherCheck(Context ctx) throws BOSException {
        try {
            boolean isFixed = false;
            String sql = "select flag from T_HR_SCommonDataUpgrade where fbusinessType = 1";
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (rowSet.next()) {
                isFixed = rowSet.getBoolean("flag");
            }
            if (!isFixed) {
                this.upgrade(ctx);
            }
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    public void upgrade(Context ctx) throws BOSException {
        try {
            String sql = "SELECT FCALSHEMETABLENAME TBaseName,FBILLENTRYTABLENAME TEntryName FROM T_HR_SCalShemeTableRelation";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                String entryName = rs.getString("TEntryName");
                this.udpDealStatus(ctx, entryName);
            }
        }
        catch (Exception exception) {
            throw new BOSException((Throwable)exception);
        }
    }

    protected void udpDealStatus(Context ctx, String entryName) throws BOSException {
        try {
            String sql = "If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME = 'FDealStatus' and KSQL_COL_TABNAME='%s') ALTER TABLE %s ADD FDealStatus int DEFAULT 0";
            DbUtil.execute((Context)ctx, (String)String.format(sql, entryName, entryName));
            String updateSql = "update " + entryName + " set FDealStatus = 1 where FDealStatus is null ";
            DbUtil.execute((Context)ctx, (String)updateSql);
        }
        catch (Exception exception) {
            throw new BOSException((Throwable)exception);
        }
    }

    public boolean verifyCyclePeriod(Context ctx, BatchSubmitShemeBillInfo info) throws EASBizException, BOSException {
        try {
            new CycleVerify(null).doVerifyCycle(ctx, info);
        }
        catch (Exception e) {
            if (info.getEntry() != null && info.getEntry().get(0) != null) {
                HashMap<String, Object> err = new HashMap<String, Object>();
                err.put("personId", info.getEntry().get(0).getPerson().getId().toString());
                err.put("exception", e);
                if (e instanceof EASBizException) {
                    err.put("type", "Biz");
                } else {
                    err.put("type", "Sys");
                }
                this.exceptions.add(err);
            }
            return false;
        }
        return true;
    }

    public boolean verifyPeriod(Context ctx, BatchSubmitShemeBillInfo info) throws EASBizException, BOSException {
        CalSubmitSchemeInfo submitScheme = CalSubmitSchemeFactory.getLocalInstance((Context)ctx).getCalSubmitSchemeInfo((IObjectPK)new ObjectUuidPK(info.getSubmitScheme().getId().toString()));
        try {
            if (submitScheme.isIsEnableSubmitElement()) {
                new SubmitBillEnableElementSubmitPeriodVerify().verify(ctx, info);
            } else {
                new SubmitBillDisableElementSubmitPeriodVerify().verify(ctx, info);
            }
        }
        catch (Exception e) {
            if (info.getEntry() != null && info.getEntry().get(0) != null) {
                HashMap<String, Object> err = new HashMap<String, Object>();
                err.put("personId", info.getEntry().get(0).getPerson().getId().toString());
                err.put("exception", e);
                if (e instanceof EASBizException) {
                    err.put("type", "Biz");
                } else {
                    err.put("type", "Sys");
                }
                this.exceptions.add(err);
            }
            return false;
        }
        return true;
    }

    protected void afterSaveSubBill(Context ctx, BatchSubmitShemeBillInfo submitShemeBillInfo) {
    }

    protected BatchSubmitShemeBillInfo getSubBillInfo(IRowSet rowSet, String subSchemeId, Map<String, Object[]> initBillApplyer) throws SQLException {
        BatchSubmitShemeBillInfo submitShemeBillInfo;
        String personId = rowSet.getString("FPERSONID");
        String subBillMapKey = subSchemeId + "###" + personId + "###";
        if (this.subBillMap.containsKey(subBillMapKey)) {
            submitShemeBillInfo = this.subBillMap.get(subBillMapKey);
        } else {
            submitShemeBillInfo = new BatchSubmitShemeBillInfo();
            String hrOrgUnitId = rowSet.getString("fhrorgunitid");
            HROrgUnitInfo hrOrgUnitInfo = new HROrgUnitInfo();
            hrOrgUnitInfo.setId(BOSUuid.read((String)hrOrgUnitId));
            submitShemeBillInfo.setHrOrgUnit(hrOrgUnitInfo);
            AdminOrgUnitInfo adminOrgUnitInfo = new AdminOrgUnitInfo();
            String adminOrgUnitId = rowSet.getString("FAdminOrgID");
            adminOrgUnitInfo.setId(BOSUuid.read((String)adminOrgUnitId));
            submitShemeBillInfo.setAdminOrg(adminOrgUnitInfo);
            String esaId = rowSet.getString("ESAID");
            Object[] applierInfo = initBillApplyer.get(esaId);
            if (applierInfo != null && applierInfo.length >= 2) {
                submitShemeBillInfo.setApplyDate((Date)applierInfo[1]);
                PersonInfo applier = (PersonInfo)applierInfo[0];
                submitShemeBillInfo.setProposer(applier);
            }
            CalSubmitSchemeInfo subSchemeInfo = new CalSubmitSchemeInfo();
            subSchemeInfo.setId(BOSUuid.read((String)subSchemeId));
            submitShemeBillInfo.setSubmitScheme(subSchemeInfo);
            submitShemeBillInfo.setBillSource(SubBillSource.Inner_Data);
            submitShemeBillInfo.setIsSsc(SscTypeEnum.NORMAL);
            this.subBillMap.put(subBillMapKey, submitShemeBillInfo);
        }
        return submitShemeBillInfo;
    }

    protected void setProposerAdminOrg(Context ctx, BatchSubmitShemeBillInfo submitShemeBillInfo) {
        if (submitShemeBillInfo.getProposer() == null) {
            return;
        }
        String personId = submitShemeBillInfo.getProposer().getId().toString();
        String oql = "select adminOrg.id, adminOrg.name where person.id = '" + personId + "' and assignType = 1 order by endDateTime desc";
        try {
            EmpPosOrgRelationCollection collection = EmpPosOrgRelationFactory.getLocalInstance((Context)ctx).getEmpPosOrgRelationCollection(oql);
            if (collection.isEmpty()) {
                return;
            }
            Date now = new Date();
            EmpPosOrgRelationInfo cmpEmpORelationInfo = null;
            for (int i = 0; i < collection.size(); ++i) {
                EmpPosOrgRelationInfo info = collection.get(i);
                if (null == info.getEndDateTime() || info.getEndDateTime().compareTo(now) <= 0) continue;
                cmpEmpORelationInfo = info;
                break;
            }
            if (null == cmpEmpORelationInfo) {
                cmpEmpORelationInfo = collection.get(0);
            }
            AdminOrgUnitInfo proposerAdminOrg = new AdminOrgUnitInfo();
            proposerAdminOrg.setId(BOSUuid.read((String)cmpEmpORelationInfo.getAdminOrg().getId().toString()));
            submitShemeBillInfo.setProposerAdminOrg(proposerAdminOrg);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    protected void assembleSubBillEntry(IRowSet rowSet, BatchSubmitShemeBillInfo submitShemeBillInfo, Map<String, String> empAdjItemMapperCmpItemMap, Map<String, Object> submitBillEntryNeedMap, CurrencyInfo currency) throws SQLException {
        Map stringItemLenMap = (Map)submitBillEntryNeedMap.get(ITEM_DATA_LENGTH);
        Map numberItemMap = (Map)submitBillEntryNeedMap.get(ITEM_DATA_DATA_DOT);
        boolean isExistSameCurrency = false;
        BatchSubmitShemeBillEntryCollection entry = submitShemeBillInfo.getEntry();
        BatchSubmitShemeBillEntryInfo entryInfo = new BatchSubmitShemeBillEntryInfo();
        String currencyId = rowSet.getString("FCurrencyId");
        if (currency != null && currency.getId() != null && !StringUtils.isEmpty((String)currency.getId().toString())) {
            currencyId = currency.getId().toString();
        }
        if (StringUtils.isEmpty((String)currencyId)) {
            currencyId = entry != null && entry.size() > 0 && entry.get(0).getCurrency() != null ? entry.get(0).getCurrency().getId().toString() : RMB_CURRENCY_ID;
        }
        String submitElementIdForCheck = null;
        String empAdjItemId = rowSet.getString("FSalaryItem");
        String subItemSn = empAdjItemMapperCmpItemMap.get(empAdjItemId);
        if (subItemSn.contains("###")) {
            String[] split = subItemSn.split("###");
            submitElementIdForCheck = split[1];
        }
        String submitElementNullVal = "null";
        if (StringUtils.isEmpty(submitElementIdForCheck)) {
            submitElementIdForCheck = submitElementNullVal;
        }
        String checkKey = currencyId + "###" + submitElementIdForCheck;
        if (entry != null) {
            int size = entry.size();
            for (int i = 0; i < size; ++i) {
                String tmpKey;
                BatchSubmitShemeBillEntryInfo billEntryInfo = entry.get(i);
                if (billEntryInfo == null || billEntryInfo.getCurrency() == null) continue;
                String existCurrencyId = billEntryInfo.getCurrency().getId().toString();
                String entryElement = submitElementNullVal;
                if (billEntryInfo.getSubmitElement() != null && billEntryInfo.getSubmitElement().getId() != null && !StringUtils.isEmpty((String)billEntryInfo.getSubmitElement().getId().toString())) {
                    entryElement = billEntryInfo.getSubmitElement().getId().toString();
                }
                if (!(tmpKey = existCurrencyId + "###" + entryElement).equals(checkKey)) continue;
                entryInfo = billEntryInfo;
                isExistSameCurrency = true;
            }
        }
        String personId = rowSet.getString("FPERSONID");
        PersonInfo person = new PersonInfo();
        person.setId(BOSUuid.read((String)personId));
        entryInfo.setPerson(person);
        String adjeorId = rowSet.getString("EORID");
        CmpEmpORelationInfo cmpEmpORelationInfo = new CmpEmpORelationInfo();
        cmpEmpORelationInfo.setId(BOSUuid.read((String)adjeorId));
        entryInfo.setCmpEmpORelation(cmpEmpORelationInfo);
        String positionId = rowSet.getString("fpositionid");
        PositionInfo positionInfo = new PositionInfo();
        positionInfo.setId(BOSUuid.read((String)positionId));
        entryInfo.setPosition(positionInfo);
        entryInfo.setHrOrgUnit(submitShemeBillInfo.getHrOrgUnit());
        entryInfo.setAdminOrgUnit(submitShemeBillInfo.getAdminOrg());
        java.sql.Date effecDate = rowSet.getDate("FEffectDate");
        entryInfo.setEffectDate((Date)effecDate);
        entryInfo.put("effectday", (Object)effecDate);
        java.sql.Date leffDt = rowSet.getDate("FLeffdt");
        if (null != leffDt) {
            entryInfo.setLeffectDate((Date)leffDt);
        }
        CurrencyInfo currencyInfo = new CurrencyInfo();
        if (!StringUtils.isEmpty((String)currencyId)) {
            currencyInfo.setId(BOSUuid.read((String)currencyId));
            entryInfo.setCurrency(currencyInfo);
        }
        String itemValue = rowSet.getString("FItemVal");
        if (subItemSn.contains("###")) {
            String[] split = subItemSn.split("###");
            itemValue = this.handleDataLenAndDataDot(stringItemLenMap, numberItemMap, itemValue, subItemSn);
            entryInfo.put(split[0], (Object)itemValue);
            SubmitElementInfo submitElementInfo = new SubmitElementInfo();
            submitElementInfo.setId(BOSUuid.read((String)split[1]));
            entryInfo.setSubmitElement(submitElementInfo);
        } else {
            itemValue = this.handleDataLenAndDataDot(stringItemLenMap, numberItemMap, itemValue, subItemSn);
            entryInfo.put(subItemSn, (Object)itemValue);
        }
        String[] descriptions = new String[]{StringUtils.isEmpty((String)entryInfo.getDescription(LocaleUtils.locale_l1)) ? "" : entryInfo.getDescription(LocaleUtils.locale_l1), StringUtils.isEmpty((String)entryInfo.getDescription(LocaleUtils.locale_l2)) ? "" : entryInfo.getDescription(LocaleUtils.locale_l2), StringUtils.isEmpty((String)entryInfo.getDescription(LocaleUtils.locale_l3)) ? "" : entryInfo.getDescription(LocaleUtils.locale_l3)};
        String[] results = this.assembleDescription(rowSet, descriptions);
        entryInfo.setDescription(results[0], LocaleUtils.locale_l1);
        entryInfo.setDescription(results[1], LocaleUtils.locale_l2);
        entryInfo.setDescription(results[2], LocaleUtils.locale_l3);
        if (!isExistSameCurrency) {
            entry.add(entryInfo);
        }
    }

    protected String handleDataLenAndDataDot(Map<String, Integer> stringItemLenMap, Map<String, Integer> numberItemMap, String itemValue, String subItemSn) {
        if (stringItemLenMap.containsKey(subItemSn)) {
            Integer len = stringItemLenMap.get(subItemSn);
            if (itemValue != null && len != null && itemValue.length() > len) {
                itemValue = itemValue.substring(0, len);
            }
        }
        if (numberItemMap.containsKey(subItemSn)) {
            Integer dataDot = numberItemMap.get(subItemSn);
            if (!StringUtils.isEmpty((String)itemValue)) {
                BigDecimal numVal = new BigDecimal(itemValue);
                numVal = numVal.setScale((int)dataDot, 4);
                itemValue = numVal.toString();
            }
        }
        return itemValue;
    }

    protected String[] assembleDescription(IRowSet rowSet, String[] descriptions) throws SQLException {
        String[] results = descriptions;
        int MAX_LENGTH = 170;
        String des1 = rowSet.getString("FDescription_l1");
        String des2 = rowSet.getString("FDescription_l2");
        String des3 = rowSet.getString("FDescription_l3");
        String temp = null;
        if (!StringUtils.isEmpty((String)des1) && !descriptions[0].contains(des1) && (temp = des1 + ";" + descriptions[0]).length() < MAX_LENGTH) {
            results[0] = temp;
        }
        if (!StringUtils.isEmpty((String)des2) && !descriptions[1].contains(des2) && (temp = des2 + ";" + descriptions[1]).length() < MAX_LENGTH) {
            results[1] = temp;
        }
        if (!StringUtils.isEmpty((String)des3) && !descriptions[2].contains(des3) && (temp = des3 + ";" + descriptions[2]).length() < MAX_LENGTH) {
            results[2] = temp;
        }
        return results;
    }

    protected void assembleSubBillInfo(Context ctx, IRowSet rowSet, String subSchemeId, Map<String, String> empAdjItemMapperCmpItemMap, Map<String, Object[]> initBillApplyer, Map<String, Object> submitBillEntryNeedMap, CurrencyInfo currency) throws SQLException {
        BatchSubmitShemeBillInfo submitShemeBillInfo = this.getSubBillInfo(rowSet, subSchemeId, initBillApplyer);
        this.setProposerAdminOrg(ctx, submitShemeBillInfo);
        this.assembleSubBillEntry(rowSet, submitShemeBillInfo, empAdjItemMapperCmpItemMap, submitBillEntryNeedMap, currency);
    }

    protected void genAdjData(Context ctx, EmpAdjustItemMappingTableInfo tableInfo, AdjustItemMappingSchemeCollection adjustItemMapping, String hrOrgUnitId, String personId, String empORelId) throws BOSException {
        logger.info((Object)("com.kingdee.shr.cmpdesign.app.v2.mapping.GenCmpAdjDataFromEmpFacadeControllerBean.genAdjData-->adjustItemMapping: " + (Object)((Object)adjustItemMapping)));
        if (null == adjustItemMapping || adjustItemMapping.size() == 0 || tableInfo.getAdjBusinessTypeRecord().isEmpty()) {
            return;
        }
        String adjBusinessTypeId = tableInfo.getAdjBusinessTypeRecord().get(0).getAdjBusinessType().getId().toString();
        Map<String, Map<String, String>> adjSchemeMapitemMapper = this.getEmpItemMapperAdjItem(adjustItemMapping);
        String adjSchemeId = "";
        logger.info((Object)("com.kingdee.shr.cmpdesign.app.v2.mapping.GenCmpAdjDataFromEmpFacadeControllerBean.genAdjData-->adjSchemeMapitemMapper: " + adjSchemeMapitemMapper));
        if (adjSchemeMapitemMapper.size() > 0) {
            String sqlFormat = this.getAdjQuerySql(personId, empORelId, adjBusinessTypeId);
            Set<Map.Entry<String, Map<String, String>>> entrySet = adjSchemeMapitemMapper.entrySet();
            Iterator<Map.Entry<String, Map<String, String>>> iterator = entrySet.iterator();
            ArrayList<Object[]> updateESAStateParams = new ArrayList<Object[]>();
            HashSet<String> esaIdSet = null;
            HashMap<String, String> lastCurrencyMap = new HashMap<String, String>();
            String tempPersonId = "";
            String perItemPersonid = "";
            while (iterator.hasNext()) {
                try {
                    Map.Entry<String, Map<String, String>> entry = iterator.next();
                    adjSchemeId = entry.getKey();
                    Map<String, String> empAdjItemMapperAdjItemMap = entry.getValue();
                    Set<String> empAdjItemIds = empAdjItemMapperAdjItemMap.keySet();
                    String sql = sqlFormat.replace("@_HRORGUNITID", hrOrgUnitId).replace("@_SALARYITEM", CmpStrUtil.convertSetToSqlString(empAdjItemIds));
                    logger.info((Object)("com.kingdee.shr.cmpdesign.app.v2.mapping.GenCmpAdjDataFromEmpFacadeControllerBean.genAdjData-->sql: " + sql));
                    IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
                    Map<String, Object[]> initBillApplyer = this.initBillApplyer(ctx, rowSet);
                    rowSet.beforeFirst();
                    esaIdSet = new HashSet<String>();
                    String adjBillMapKey = "";
                    String tempCurrencyId = "";
                    String perCurrencyId = "";
                    String tempAffairId = "";
                    String perAffairId = "";
                    if (rowSet.size() < 1) continue;
                    while (rowSet.next()) {
                        try {
                            tempPersonId = rowSet.getString("FPERSONID");
                            tempCurrencyId = rowSet.getString("FCurrencyID");
                            tempAffairId = rowSet.getString("FAffairId");
                            String currencyMapKey = adjSchemeId + "###" + tempPersonId;
                            String lastCurrencyId = (String)lastCurrencyMap.get(currencyMapKey);
                            if (StringUtils.isEmpty((String)tempCurrencyId)) {
                                tempCurrencyId = !StringUtils.isEmpty((String)lastCurrencyId) ? lastCurrencyId : RMB_CURRENCY_ID;
                            }
                            if (!StringUtils.isEmpty((String)perItemPersonid) && (!perItemPersonid.equals(tempPersonId) || perItemPersonid.equals(tempPersonId) && !perAffairId.equals(tempAffairId) || perItemPersonid.equals(tempPersonId) && !perCurrencyId.equals(tempCurrencyId))) {
                                this.savePerPersonAdjBill(ctx, adjBillMapKey, updateESAStateParams, esaIdSet);
                                esaIdSet.clear();
                                this.adjBillMap.remove(adjBillMapKey);
                                lastCurrencyMap.put(currencyMapKey, tempCurrencyId);
                            }
                            esaIdSet.add(rowSet.getString("ESAID"));
                            perItemPersonid = tempPersonId;
                            perCurrencyId = tempCurrencyId;
                            perAffairId = tempAffairId;
                            adjBillMapKey = adjSchemeId + "###" + tempPersonId + "###" + tempCurrencyId;
                            this.assembleAdjBillInfo(ctx, rowSet, adjSchemeId, empAdjItemMapperAdjItemMap, initBillApplyer, tempCurrencyId);
                        }
                        catch (Exception e) {
                            HashMap<String, Object> err = new HashMap<String, Object>();
                            err.put("personId", tempPersonId);
                            err.put("exception", e);
                            if (e instanceof EASBizException) {
                                err.put("type", "Biz");
                            } else {
                                err.put("type", "Sys");
                            }
                            this.exceptions.add(err);
                        }
                    }
                    this.savePerPersonAdjBill(ctx, adjBillMapKey, updateESAStateParams, esaIdSet);
                    esaIdSet.clear();
                    this.adjBillMap.remove(adjBillMapKey);
                }
                catch (Exception e) {
                    HashMap<String, Object> err = new HashMap<String, Object>();
                    err.put("personId", tempPersonId);
                    err.put("exception", e);
                    if (e instanceof EASBizException) {
                        err.put("type", "Biz");
                    } else {
                        err.put("type", "Sys");
                    }
                    this.exceptions.add(err);
                }
            }
            logger.info((Object)("com.kingdee.shr.cmpdesign.app.v2.mapping.GenCmpAdjDataFromEmpFacadeControllerBean.genAdjData-->saveErrLog:" + this.exceptions.size()));
            try {
                if (this.exceptions != null && this.exceptions.size() > 0) {
                    GenCmpAdjDataFromEmpFacadeFactory.getLocalInstance(ctx).saveErrLog(this.exceptions);
                }
            }
            catch (EASBizException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            logger.info((Object)("com.kingdee.shr.cmpdesign.app.v2.mapping.GenCmpAdjDataFromEmpFacadeControllerBean.genAdjData-->updateEmpSalaryState" + updateESAStateParams.toArray()));
            RecEmpAdjSalaryUtil.updateEmpSalaryState((Context)ctx, updateESAStateParams);
        }
    }

    protected Map<String, Integer> getCmpItemDataDot(Context ctx, AdjustItemMappingSchemeCollection adjustItemMapping) throws BOSException {
        HashMap<String, Integer> resultMap = new HashMap<String, Integer>();
        String cmpItemId = "";
        if (adjustItemMapping != null) {
            HashSet<String> cmpItemIdSet = new HashSet<String>();
            int size = adjustItemMapping.size();
            for (int i = 0; i < size; ++i) {
                AdjustItemMappingSchemeInfo mappingSchemeInfo = adjustItemMapping.get(i);
                if (mappingSchemeInfo == null || mappingSchemeInfo.getCmpItem() == null || StringUtils.isEmpty((String)(cmpItemId = mappingSchemeInfo.getCmpItem().getId().toString()))) continue;
                cmpItemIdSet.add(cmpItemId);
            }
            CmpInSql instance = CmpInSqlFactory.getInstance();
            String createInSqlBaseOnFId = instance.createInSqlBaseOnFId(ctx, cmpItemIdSet);
            String sql = "SELECT FID,FDATADOT FROM T_HR_SCmpItem where FDataType=0 and FID in " + createInSqlBaseOnFId;
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            try {
                while (rowSet.next()) {
                    resultMap.put(rowSet.getString("FID"), rowSet.getInt("FDATADOT"));
                }
            }
            catch (SQLException throwables) {
                logger.error((Object)throwables.getMessage(), (Throwable)throwables);
                throw new BOSException(throwables.getMessage(), (Throwable)throwables);
            }
            instance.release(ctx);
        }
        return resultMap;
    }

    protected void directGenAdjData(Context ctx, EmpAdjustItemMappingTableInfo tableInfo, AdjustItemMappingSchemeCollection adjustItemMapping, String hrOrgUnitId, String personId, String empORelId) throws BOSException {
        block12: {
            logger.info((Object)("com.kingdee.shr.cmpdesign.app.v2.mapping.GenCmpAdjDataFromEmpFacadeControllerBean.directGenAdjData-->adjustItemMapping: " + (Object)((Object)adjustItemMapping)));
            if (null == adjustItemMapping || adjustItemMapping.size() == 0 || tableInfo.getAdjBusinessTypeRecord().isEmpty()) {
                return;
            }
            String adjBusinessTypeId = tableInfo.getAdjBusinessTypeRecord().get(0).getAdjBusinessType().getId().toString();
            Map<String, String> mappingMap = this.getEmpItemMapperCmpItem(adjustItemMapping);
            FixAdjustSalaryInfo info = null;
            ArrayList<Object[]> updateESAStateParams = new ArrayList<Object[]>();
            try {
                Map<String, Integer> cmpItemDataDot = this.getCmpItemDataDot(ctx, adjustItemMapping);
                if (mappingMap.size() <= 0) break block12;
                ApplyBill2FixAdjustSalary execute = new ApplyBill2FixAdjustSalary();
                String sqlFormat = this.getAdjQuerySql(personId, empORelId, adjBusinessTypeId);
                Set<String> empAdjItemIds = mappingMap.keySet();
                String sql = sqlFormat.replace("@_HRORGUNITID", hrOrgUnitId).replace("@_SALARYITEM", CmpStrUtil.convertSetToSqlString(empAdjItemIds));
                logger.info((Object)("com.kingdee.shr.cmpdesign.app.v2.mapping.GenCmpAdjDataFromEmpFacadeControllerBean.directGenAdjData-->sql: " + sql));
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
                String tempPersonId = "";
                while (rowSet.next()) {
                    try {
                        Date effdt;
                        String payHrOrgId;
                        tempPersonId = rowSet.getString("FPERSONID");
                        info = this.combineFixAdjustInfo(ctx, rowSet, mappingMap, cmpItemDataDot);
                        if (null == info) continue;
                        String cmpItemId = info.getCmpItem().getId().toString();
                        if (!this.checkCmpItem(tempPersonId, cmpItemId, payHrOrgId = info.getPayHrOrgUnit() == null ? null : info.getPayHrOrgUnit().getId().toString(), effdt = info.getEffectDay())) {
                            logger.info((Object)("\u85aa\u916c\u7ed3\u6784\u6821\u9a8c\u5931\u8d25\uff1a\u3010" + personId + "_" + cmpItemId + "_" + payHrOrgId + "_" + effdt + "\u3011"));
                            continue;
                        }
                        execute.save(ctx, info);
                        Object[] object = new Object[]{null, rowSet.getString("ESAID")};
                        updateESAStateParams.add(object);
                    }
                    catch (Exception e) {
                        HashMap<String, Object> err = new HashMap<String, Object>();
                        err.put("personId", tempPersonId);
                        err.put("exception", e);
                        if (e instanceof EASBizException) {
                            err.put("type", "Biz");
                        } else {
                            err.put("type", "Sys");
                        }
                        this.exceptions.add(err);
                    }
                }
                logger.info((Object)("com.kingdee.shr.cmpdesign.app.v2.mapping.GenCmpAdjDataFromEmpFacadeControllerBean.genAdjData-->saveErrLog:" + this.exceptions.size()));
                try {
                    if (this.exceptions != null && this.exceptions.size() > 0) {
                        GenCmpAdjDataFromEmpFacadeFactory.getLocalInstance(ctx).saveErrLog(this.exceptions);
                    }
                }
                catch (EASBizException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
                logger.info((Object)("com.kingdee.shr.cmpdesign.app.v2.mapping.GenCmpAdjDataFromEmpFacadeControllerBean.genAdjData-->updateEmpSalaryState" + updateESAStateParams.toArray()));
                RecEmpAdjSalaryUtil.updateEmpSalaryState((Context)ctx, updateESAStateParams);
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
        }
    }

    protected FixAdjustSalaryInfo combineFixAdjustInfo(Context ctx, IRowSet rowSet, Map<String, String> mappingMap, Map<String, Integer> cmpItemDataDot) throws Exception {
        String salaryscopeId;
        String salarypointId;
        String salarylevelId;
        String standarId;
        Integer dataDot;
        String itemValue;
        FixAdjustSalaryInfo info = new FixAdjustSalaryInfo();
        String hrOrgUnitId = rowSet.getString("fhrorgunitid");
        HROrgUnitInfo hrOrgUnitInfo = new HROrgUnitInfo();
        hrOrgUnitInfo.setId(BOSUuid.read((String)hrOrgUnitId));
        info.setAdjHrOrgUnit(hrOrgUnitInfo);
        String adminOrgId = rowSet.getString("FAdminOrgID");
        AdminOrgUnitInfo adminOrgUnitInfo = new AdminOrgUnitInfo();
        adminOrgUnitInfo.setId(BOSUuid.read((String)adminOrgId));
        info.setAdminOrgUnit(adminOrgUnitInfo);
        String personId = rowSet.getString("FPERSONID");
        PersonInfo person = new PersonInfo();
        person.setId(BOSUuid.read((String)personId));
        info.setPerson(person);
        String adjeorId = rowSet.getString("EORID");
        AdjustEmpORelationInfo adjustEmpORelationInfo = new AdjustEmpORelationInfo();
        adjustEmpORelationInfo.setId(BOSUuid.read((String)adjeorId));
        info.setAdjEmpORelation(adjustEmpORelationInfo);
        String positionId = rowSet.getString("fpositionid");
        PositionInfo positionInfo = new PositionInfo();
        positionInfo.setId(BOSUuid.read((String)positionId));
        info.setPosition(positionInfo);
        String currencyId = rowSet.getString("FCurrencyId");
        CurrencyInfo currencyInfo = new CurrencyInfo();
        if (!StringUtils.isEmpty((String)currencyId)) {
            currencyInfo.setId(BOSUuid.read((String)currencyId));
            info.setCurrency(currencyInfo);
        }
        String empAdjItemId = rowSet.getString("FSalaryItem");
        String cmpItemId = mappingMap.get(empAdjItemId);
        CmpItemInfo cmpItemInfo = new CmpItemInfo();
        cmpItemInfo.setId(BOSUuid.read((String)cmpItemId));
        info.setCmpItem(cmpItemInfo);
        if (YesNoEnum.YES == this.cmpItemMaintainPayHrOrgMap.get(cmpItemId)) {
            info.setPayHrOrgUnit(hrOrgUnitInfo);
        }
        if (CmpStrUtil.isEmpty((String)(itemValue = rowSet.getString("FItemVal")))) {
            return null;
        }
        BigDecimal itemNumVal = new BigDecimal(itemValue);
        if (!StringUtils.isEmpty((String)cmpItemId) && itemNumVal != null && (dataDot = cmpItemDataDot.get(cmpItemId)) != null) {
            itemNumVal = itemNumVal.setScale((int)dataDot, 4);
        }
        info.setMoney(itemNumVal);
        java.sql.Date effecDate = rowSet.getDate("FEffectDate");
        info.setEffectDay((Date)effecDate);
        java.sql.Date leffDt = rowSet.getDate("FLeffdt");
        if (null != leffDt) {
            info.setLeffectDay((Date)leffDt);
        }
        if (!StringUtils.isEmpty((String)(standarId = rowSet.getString("FSALARYSTANDARDID")))) {
            CmpStandardInfo cmpStandardInfo = new CmpStandardInfo();
            cmpStandardInfo.setId(BOSUuid.read((String)standarId));
            info.setStandard(cmpStandardInfo);
        }
        if (!StringUtils.isEmpty((String)(salarylevelId = rowSet.getString("FSALARYLEVEL")))) {
            CmpStdLevelInfo stdLevelInfo = CmpStdLevelFactory.getLocalInstance(ctx).getCmpStdLevelInfo((IObjectPK)new ObjectUuidPK(salarylevelId));
            info.setStdLevel(stdLevelInfo);
            info.setFloatRate(stdLevelInfo.getFloatRate());
        }
        if (!StringUtils.isEmpty((String)(salarypointId = rowSet.getString("FSALARYPOINT")))) {
            CmpStdPointInfo cmpStdPointInfo = new CmpStdPointInfo();
            cmpStdPointInfo.setId(BOSUuid.read((String)salarypointId));
            info.setStdPoint(cmpStdPointInfo);
        }
        if (!StringUtils.isEmpty((String)(salaryscopeId = rowSet.getString("FSALARYSCOPE")))) {
            CmpStdScopeInfo scopeInfo = new CmpStdScopeInfo();
            scopeInfo.setId(BOSUuid.read((String)salaryscopeId));
            info.setStdScope(scopeInfo);
        }
        String des1 = rowSet.getString("FDescription_l1");
        String des2 = rowSet.getString("FDescription_l2");
        String des3 = rowSet.getString("FDescription_l3");
        info.setRemark(des1, LocaleUtils.locale_l1);
        info.setRemark(des2, LocaleUtils.locale_l2);
        info.setRemark(des3, LocaleUtils.locale_l3);
        info.setUseDefault(rowSet.getBoolean("useDefault"));
        String applierId = rowSet.getString("PROPOSERID");
        if (StringUtils.isEmpty((String)applierId)) {
            return info;
        }
        try {
            UserInfo user = UserFactory.getLocalInstance((Context)ctx).getUserInfo("where person.id = '" + applierId + "'");
            info.setCreator(user);
            info.setLastUpdateUser(user);
        }
        catch (Exception e) {
            logger.info((Object)e.getMessage(), (Throwable)e);
        }
        return info;
    }

    protected Map<String, String> getEmpItemMapperCmpItem(AdjustItemMappingSchemeCollection adjustItemMapping) {
        HashMap<String, String> map = new HashMap<String, String>();
        String cmpItemId = "";
        String empAdjItemId = "";
        int size = adjustItemMapping.size();
        for (int i = 0; i < size; ++i) {
            AdjustItemMappingSchemeInfo mappingSchemeInfo = adjustItemMapping.get(i);
            cmpItemId = mappingSchemeInfo.getCmpItem().getId().toString();
            empAdjItemId = mappingSchemeInfo.getEmpAdjustItem().getId().toString();
            map.put(empAdjItemId, cmpItemId);
        }
        return map;
    }

    protected Map<String, Map<String, String>> getEmpItemMapperAdjItem(AdjustItemMappingSchemeCollection adjustItemMapping) {
        HashMap<String, Map<String, String>> adjSchemeMapitemMapper = new HashMap<String, Map<String, String>>();
        String adjSchemeId = "";
        String empAdjItemId = "";
        String adjItemId = "";
        int size = adjustItemMapping.size();
        for (int i = 0; i < size; ++i) {
            AdjustItemMappingSchemeInfo mappingSchemeInfo = adjustItemMapping.get(i);
            CalSubmitSchemeInfo adjustScheme = mappingSchemeInfo.getAdjustScheme();
            SalaryItemInfo empAdjustItem = mappingSchemeInfo.getEmpAdjustItem();
            AdjustSalaryItemInfo adjustItem = mappingSchemeInfo.getAdjustItem();
            adjSchemeId = adjustScheme.getId().toString();
            empAdjItemId = empAdjustItem.getId().toString();
            adjItemId = adjustItem.getId().toString();
            adjItemId = "S" + adjustItem.getFieldSn();
            Map empAdjItemMapperAdjItemMap = adjSchemeMapitemMapper.containsKey(adjSchemeId) ? (Map)adjSchemeMapitemMapper.get(adjSchemeId) : new HashMap();
            empAdjItemMapperAdjItemMap.put(empAdjItemId, adjItemId);
            adjSchemeMapitemMapper.put(adjSchemeId, empAdjItemMapperAdjItemMap);
        }
        return adjSchemeMapitemMapper;
    }

    protected void savePerPersonAdjBill(Context ctx, String personId, List<Object[]> updateESAStateParams, Set<String> esaIdSet) throws BOSException, EASBizException {
        AdjustSalaryApplyInfo adjustSalaryApplyInfo = this.adjBillMap.get(personId);
        if (null == adjustSalaryApplyInfo) {
            return;
        }
        logger.info((Object)("com.kingdee.shr.cmpdesign.app.v2.mapping.GenCmpAdjDataFromEmpFacadeControllerBean.createBillNumber-->adjustSalaryApplyInfo: " + adjustSalaryApplyInfo));
        String number = RecEmpAdjSalaryUtil.createBillNumber((Context)ctx, (String)adjustSalaryApplyInfo.getHrOrgUnit().toString(), (HRBillBaseInfo)adjustSalaryApplyInfo);
        adjustSalaryApplyInfo.setNumber(number);
        if (!this.beforeSaveAdjBill(ctx, adjustSalaryApplyInfo)) {
            return;
        }
        logger.info((Object)("com.kingdee.shr.cmpdesign.app.v2.mapping.GenCmpAdjDataFromEmpFacadeControllerBean.savePerPersonAdjBill-->adjustSalaryApplyInfo: " + adjustSalaryApplyInfo));
        IObjectPK billId = AdjustSalaryApplyFactory.getLocalInstance(ctx).save((CoreBaseInfo)adjustSalaryApplyInfo);
        AdjustSalaryApplyFactory.getLocalInstance(ctx).setPassState(BOSUuid.read((String)billId.toString()));
        this.afterSaveAdjBill(ctx, adjustSalaryApplyInfo);
        for (String tempid : esaIdSet) {
            Object[] param = new Object[]{billId.toString(), tempid};
            updateESAStateParams.add(param);
        }
    }

    protected boolean beforeSaveAdjBill(Context ctx, AdjustSalaryApplyInfo info) throws BOSException, EASBizException {
        String adjustSalaryRuleId = info.getAdjustSalaryRule().getId().toString();
        Map<String, String> mapping = AdjustSalaryUtils.getAdjItem2CmpItem(ctx, adjustSalaryRuleId);
        AdjustSalaryApplyEntryCollection entrys = info.getEntry();
        for (int i = 0; i < entrys.size(); ++i) {
            AdjustSalaryApplyEntryInfo entry = entrys.get(i);
            String personId = entry.getPerson().getId().toString();
            String payHrOrgId = entry.getHrOrgUnit() == null ? null : entry.getHrOrgUnit().getId().toString();
            Date effdt = entry.getEffectDate();
            for (String colName : mapping.keySet()) {
                String fieldSn = mapping.get(colName);
                if (entry.get(fieldSn) == null || this.checkCmpItem(personId, colName, payHrOrgId, effdt)) continue;
                logger.info((Object)("\u85aa\u916c\u7ed3\u6784\u6821\u9a8c\u5931\u8d25\uff1a\u3010" + personId + "_" + colName + "_" + payHrOrgId + "_" + effdt + "\u3011"));
                return false;
            }
        }
        return true;
    }

    protected boolean checkCmpItem(String personId, String cmpItemId, String payHrOrgId, Date effdt) throws BOSException, EASBizException {
        String key = personId + "_" + cmpItemId + "_" + payHrOrgId;
        boolean checkPayHrOrgSame = true;
        if (payHrOrgId != null && this.collMap.get(personId + "_" + cmpItemId + "_" + null) != null) {
            checkPayHrOrgSame = false;
        }
        if (payHrOrgId == null) {
            for (Map.Entry<String, FixAdjustSalaryCollection> entry : this.collMap.entrySet()) {
                String entryKey = entry.getKey();
                String entryKeyPayHrOrgId = entryKey.substring(entryKey.lastIndexOf("_") + 1);
                if (entryKey.indexOf(personId + "_" + cmpItemId) <= -1 || "null".equalsIgnoreCase(entryKeyPayHrOrgId)) continue;
                checkPayHrOrgSame = false;
                break;
            }
        }
        if (!checkPayHrOrgSame) {
            HashMap<String, String> err = new HashMap<String, String>();
            err.put("personId", personId);
            err.put("errMsg", "fixAdjustSalary payHrOrgUnit is not same\uff1a" + personId + "_" + cmpItemId + "_" + payHrOrgId);
            err.put("type", "Biz");
            this.exceptions.add(err);
            return false;
        }
        boolean checkSameEffectDate = false;
        FixAdjustSalaryCollection coll = this.collMap.get(key);
        if (coll != null) {
            FixAdjustSalaryInfo lastInfo = null;
            FixAdjustSalaryInfo nextInfo = null;
            int size = coll.size();
            for (int i = 0; i < size; ++i) {
                String oldEffdtStr;
                FixAdjustSalaryInfo fixInfo = coll.get(i);
                String effdtStr = CmpDateUtil.getDateStr((Date)effdt);
                if (effdtStr.equals(oldEffdtStr = CmpDateUtil.getDateStr((Date)fixInfo.getEffectDay()))) {
                    checkSameEffectDate = true;
                    break;
                }
                if (fixInfo.getEffectDay().before(effdt)) {
                    lastInfo = fixInfo;
                    continue;
                }
                if (!fixInfo.getEffectDay().after(effdt) || null != nextInfo) continue;
                nextInfo = fixInfo;
            }
            Date leffectDay = null;
            try {
                leffectDay = DateTimeUtils.parseDate((String)"2199-12-31");
            }
            catch (ParseException e) {
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            String maxDate = format.format(leffectDay);
            if (null != lastInfo && lastInfo.getLeffectDay() != null && effdt != null && maxDate != null && format.format(lastInfo.getLeffectDay()).compareTo(maxDate) < 0 && lastInfo.getLeffectDay().compareTo(effdt) >= 0) {
                checkSameEffectDate = true;
            }
        }
        if (checkSameEffectDate) {
            HashMap<String, String> err = new HashMap<String, String>();
            err.put("personId", personId);
            err.put("errMsg", "fixAdjustSalary effectDay is same\uff1a" + personId + "_" + cmpItemId + "_" + payHrOrgId + "_" + effdt);
            err.put("type", "Biz");
            this.exceptions.add(err);
            return false;
        }
        if (coll == null) {
            coll = new FixAdjustSalaryCollection();
        }
        FixAdjustSalaryInfo fixAdjust = new FixAdjustSalaryInfo();
        fixAdjust.setEffectDay(effdt);
        fixAdjust.setLeffectDay(CmpDateUtil.getMaxEndDate());
        coll.add(fixAdjust);
        coll.sort("effectDay");
        this.collMap.put(key, coll);
        return true;
    }

    protected void afterSaveAdjBill(Context ctx, AdjustSalaryApplyInfo info) {
    }

    protected Map<String, Object[]> initBillApplyer(Context ctx, IRowSet rowSet) throws SQLException {
        HashMap<String, Object[]> result = new HashMap<String, Object[]>();
        String esaId = "";
        if (rowSet.size() == 0) {
            return result;
        }
        String applierId = "";
        PersonInfo applier = null;
        while (rowSet.next()) {
            applier = null;
            esaId = rowSet.getString("ESAID");
            java.sql.Date applyDate = rowSet.getDate("APPLYDATE");
            applierId = rowSet.getString("PROPOSERID");
            if (applierId != null && !"".equals(applierId)) {
                applier = new PersonInfo();
                applier.setId(BOSUuid.read((String)applierId));
            }
            Object[] param = new Object[]{applier, applyDate};
            result.put(esaId, param);
        }
        return result;
    }

    protected void assembleAdjBillInfo(Context ctx, IRowSet rowSet, String adjSchemeId, Map<String, String> empAdjItemMapperAdjItemMap, Map<String, Object[]> initBillApplyer, String tempCurrencyId) throws SQLException {
        AdjustSalaryApplyInfo adjustSalaryApplyInfo = this.getAdjustSalaryApplyInfo(ctx, rowSet, adjSchemeId, initBillApplyer, tempCurrencyId);
        this.assembleAdjBillEntry(rowSet, adjustSalaryApplyInfo, empAdjItemMapperAdjItemMap, tempCurrencyId);
    }

    protected AdjustSalaryApplyInfo getAdjustSalaryApplyInfo(Context ctx, IRowSet rowSet, String adjSchemeId, Map<String, Object[]> initBillApplyer, String tempCurrencyId) throws SQLException {
        AdjustSalaryApplyInfo adjustSalaryApplyInfo;
        String personId = rowSet.getString("FPERSONID");
        String currencyId = tempCurrencyId;
        String adjBillMapKey = adjSchemeId + "###" + personId + "###" + currencyId;
        if (this.adjBillMap.containsKey(adjBillMapKey)) {
            adjustSalaryApplyInfo = this.adjBillMap.get(adjBillMapKey);
        } else {
            String hrOrgUnitId = "";
            String adminOrgUnitId = "";
            String esaId = "";
            adjustSalaryApplyInfo = new AdjustSalaryApplyInfo();
            hrOrgUnitId = rowSet.getString("fhrorgunitid");
            HROrgUnitInfo hrOrgUnitInfo = new HROrgUnitInfo();
            hrOrgUnitInfo.setId(BOSUuid.read((String)hrOrgUnitId));
            adjustSalaryApplyInfo.setHrOrgUnit(hrOrgUnitInfo);
            AdminOrgUnitInfo adminOrgUnitInfo = new AdminOrgUnitInfo();
            adminOrgUnitId = rowSet.getString("FAdminOrgID");
            adminOrgUnitInfo.setId(BOSUuid.read((String)adminOrgUnitId));
            adjustSalaryApplyInfo.setAdminOrg(adminOrgUnitInfo);
            esaId = rowSet.getString("ESAID");
            Object[] applierInfo = initBillApplyer.get(esaId);
            if (applierInfo != null && applierInfo.length >= 2) {
                adjustSalaryApplyInfo.setApplyDate((Date)applierInfo[1]);
                PersonInfo applier = (PersonInfo)applierInfo[0];
                adjustSalaryApplyInfo.setProposer(applier);
                try {
                    UserInfo user = UserFactory.getLocalInstance((Context)ctx).getUserInfo("where person.id = '" + applier.getId().toString() + "'");
                    adjustSalaryApplyInfo.setCreator(user);
                    adjustSalaryApplyInfo.setLastUpdateUser(user);
                }
                catch (Exception e) {
                    logger.info((Object)e.getMessage(), (Throwable)e);
                }
            }
            CalSubmitSchemeInfo adjSchemeInfo = new CalSubmitSchemeInfo();
            adjSchemeInfo.setId(BOSUuid.read((String)adjSchemeId));
            adjustSalaryApplyInfo.setAdjustSalaryRule(adjSchemeInfo);
            String type = rowSet.getString("FSalaryAdjustTypeID");
            adjustSalaryApplyInfo.setBillSource(this.getAdjBillSource(type));
            this.adjBillMap.put(adjBillMapKey, adjustSalaryApplyInfo);
        }
        return adjustSalaryApplyInfo;
    }

    protected void assembleAdjBillEntry(IRowSet rowSet, AdjustSalaryApplyInfo adjustSalaryApplyInfo, Map<String, String> empAdjItemMapperAdjItemMap, String tempCurrencyId) throws SQLException {
        String salaryscopeId;
        String salarypointId;
        String salarylevelId;
        AdjustSalaryApplyEntryCollection entry = adjustSalaryApplyInfo.getEntry();
        AdjustSalaryApplyEntryInfo entryInfo = entry.size() == 0 ? new AdjustSalaryApplyEntryInfo() : entry.get(0);
        String personId = rowSet.getString("FPERSONID");
        PersonInfo person = new PersonInfo();
        person.setId(BOSUuid.read((String)personId));
        entryInfo.setPerson(person);
        String adjeorId = rowSet.getString("EORID");
        AdjustEmpORelationInfo adjustEmpORelationInfo = new AdjustEmpORelationInfo();
        adjustEmpORelationInfo.setId(BOSUuid.read((String)adjeorId));
        entryInfo.setAdjustEmpORelation(adjustEmpORelationInfo);
        String positionId = rowSet.getString("fpositionid");
        PositionInfo positionInfo = new PositionInfo();
        positionInfo.setId(BOSUuid.read((String)positionId));
        entryInfo.setPosition(positionInfo);
        String adjustSchemeId = adjustSalaryApplyInfo.getAdjustSalaryRule().getId().toString();
        if (YesNoEnum.YES == this.adjustSchemeMaintainPayHrOrgMap.get(adjustSchemeId)) {
            entryInfo.setHrOrgUnit(adjustSalaryApplyInfo.getHrOrgUnit());
        }
        entryInfo.setAdminOrgUnit(adjustSalaryApplyInfo.getAdminOrg());
        java.sql.Date effecDate = rowSet.getDate("FEffectDate");
        entryInfo.setEffectDate(effecDate);
        java.sql.Date leffDt = rowSet.getDate("FLeffdt");
        if (null != leffDt) {
            entryInfo.setLeffectDate(leffDt);
        }
        CurrencyInfo currencyInfo = new CurrencyInfo();
        String currencyId = tempCurrencyId;
        if (!StringUtils.isEmpty((String)currencyId)) {
            currencyInfo.setId(BOSUuid.read((String)currencyId));
            entryInfo.setCurrency(currencyInfo);
        }
        String empAdjItemId = rowSet.getString("FSalaryItem");
        String itemValue = rowSet.getString("FItemVal");
        String adjItemSn = empAdjItemMapperAdjItemMap.get(empAdjItemId);
        entryInfo.put(adjItemSn, itemValue);
        String standarId = rowSet.getString("FSALARYSTANDARDID");
        if (!StringUtils.isEmpty((String)standarId)) {
            CmpStandardInfo cmpStandardInfo = new CmpStandardInfo();
            cmpStandardInfo.setId(BOSUuid.read((String)standarId));
            entryInfo.setCmpStandard(cmpStandardInfo);
        }
        if (!StringUtils.isEmpty((String)(salarylevelId = rowSet.getString("FSALARYLEVEL")))) {
            CmpStdLevelInfo stdLevelInfo = new CmpStdLevelInfo();
            stdLevelInfo.setId(BOSUuid.read((String)salarylevelId));
            entryInfo.setCmpStdLevel(stdLevelInfo);
        }
        if (!StringUtils.isEmpty((String)(salarypointId = rowSet.getString("FSALARYPOINT")))) {
            CmpStdPointInfo cmpStdPointInfo = new CmpStdPointInfo();
            cmpStdPointInfo.setId(BOSUuid.read((String)salarypointId));
            entryInfo.setCmpStdPoint(cmpStdPointInfo);
        }
        if (!StringUtils.isEmpty((String)(salaryscopeId = rowSet.getString("FSALARYSCOPE")))) {
            CmpStdScopeInfo scopeInfo = new CmpStdScopeInfo();
            scopeInfo.setId(BOSUuid.read((String)salaryscopeId));
            entryInfo.setCmpStdScope(scopeInfo);
        }
        String[] descriptions = new String[]{StringUtils.isEmpty((String)entryInfo.getDescription(LocaleUtils.locale_l1)) ? "" : entryInfo.getDescription(LocaleUtils.locale_l1), StringUtils.isEmpty((String)entryInfo.getDescription(LocaleUtils.locale_l2)) ? "" : entryInfo.getDescription(LocaleUtils.locale_l2), StringUtils.isEmpty((String)entryInfo.getDescription(LocaleUtils.locale_l3)) ? "" : entryInfo.getDescription(LocaleUtils.locale_l3)};
        String[] results = this.assembleDescription(rowSet, descriptions);
        entryInfo.setDescription(results[0], LocaleUtils.locale_l1);
        entryInfo.setDescription(results[1], LocaleUtils.locale_l2);
        entryInfo.setDescription(results[2], LocaleUtils.locale_l3);
        logger.info((Object)("com.kingdee.shr.cmpdesign.app.v2.mapping.GenCmpAdjDataFromEmpFacadeControllerBean.assembleAdjBillEntry-->assembleAdjBillEntry: " + entryInfo));
        if (entry.size() == 0) {
            entry.add(entryInfo);
        }
    }

    protected String getCmpQuerySql(String personId, String empORelId, String adjBusinessTypeId) {
        String sql = RecEmpAdjSalaryUtil.getCmpAdjQuerySql((String)personId, (String)empORelId, (String)this.endKsqlDate, (String)"CMP", (String)adjBusinessTypeId);
        return sql;
    }

    protected String getAdjQuerySql(String personId, String empORelId, String adjBusinessTypeId) {
        String sql = RecEmpAdjSalaryUtil.getCmpAdjQuerySql((String)personId, (String)empORelId, (String)this.endKsqlDate, (String)"ADJ", (String)adjBusinessTypeId);
        return sql;
    }

    protected Map<String, String> initOrgMappingTable(Context ctx, int dataSyncType, String businessType) throws BOSException {
        this.orgMappingTableMap = new HashMap<String, String>();
        this.tableMapOrg = new HashMap<String, List<String>>();
        this.selfOrgMappingTableMap = new HashMap<String, String>();
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT ORGM.FHRORGID, ORGM.FMAPPINGTABLEID,ORGM.FUseHr ");
        sql.append(" FROM T_HR_SORGMAPPINGTABLE ORGM ");
        sql.append(" INNER JOIN T_HR_SEMPADJITEMMAPPINGTABLE TA ON ORGM.FMAPPINGTABLEID = TA.FID ");
        sql.append(" WHERE FDATASYNCTYPE = ").append(dataSyncType);
        sql.append(" and FSTATE = ").append(1);
        sql.append(" and ORGM.FBusinessType = '").append(businessType).append("'");
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            String hrOrgId = "";
            String tableId = "";
            String useHrId = "";
            while (rowSet.next()) {
                hrOrgId = rowSet.getString("FHRORGID");
                tableId = rowSet.getString("FMAPPINGTABLEID");
                useHrId = rowSet.getString("FUseHr");
                this.orgMappingTableMap.put(hrOrgId, tableId);
                List<String> orgList = this.tableMapOrg.containsKey(tableId) ? this.tableMapOrg.get(tableId) : new ArrayList<String>();
                orgList.add(hrOrgId);
                this.tableMapOrg.put(tableId, orgList);
                if (StringUtils.isEmpty((String)useHrId) || !useHrId.equals(hrOrgId)) continue;
                this.selfOrgMappingTableMap.put(useHrId, tableId);
            }
        }
        catch (Exception e) {
            logger.info((Object)e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        logger.error((Object)("com.kingdee.shr.cmpdesign.app.v2.mapping.GenCmpAdjDataFromEmpFacadeControllerBean.initOrgMappingTable--->" + this.orgMappingTableMap));
        return this.orgMappingTableMap;
    }

    protected Map<String, EmpAdjustItemMappingTableInfo> initMappingTable(Context ctx, String mappingTableIds) throws BOSException {
        this.mappingTableMap = new HashMap<String, EmpAdjustItemMappingTableInfo>();
        if (StringUtils.isEmpty((String)mappingTableIds)) {
            return this.mappingTableMap;
        }
        try {
            String oql = this.getEmpAdjItemMappingTableOql(mappingTableIds);
            EmpAdjustItemMappingTableCollection tableCollection = EmpAdjustItemMappingTableFactory.getLocalInstance(ctx).getEmpAdjustItemMappingTableCollection(oql.toString());
            if (null == tableCollection || tableCollection.size() == 0) {
                return this.mappingTableMap;
            }
            int size = tableCollection.size();
            for (int i = 0; i < size; ++i) {
                EmpAdjustItemMappingTableInfo tableInfo = tableCollection.get(i);
                this.mappingTableMap.put(tableInfo.getId().toString(), tableInfo);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        logger.info((Object)("com.kingdee.shr.cmpdesign.app.v2.mapping.GenCmpAdjDataFromEmpFacadeControllerBean.initOrgMappingTable--->" + this.mappingTableMap));
        return this.mappingTableMap;
    }

    protected String getEmpAdjItemMappingTableOql(String mappingTableIds) {
        StringBuilder oql = new StringBuilder();
        oql.append(" select ").append(MAPPING_TABLE_SELECTORS);
        oql.append(" where id in (").append(mappingTableIds).append(")");
        return oql.toString();
    }

    protected EmpAdjustItemMappingTableInfo getMappingTable(Context ctx, String hrOrgUnitId, boolean isSelfAdd, String businessType) throws BOSException {
        String tableId;
        EmpAdjustItemMappingTableInfo tableInfo = null;
        if (isSelfAdd) {
            if (null != this.selfOrgMappingTableMap.get(hrOrgUnitId) && this.mappingTableMap.containsKey(this.selfOrgMappingTableMap.get(hrOrgUnitId))) {
                tableId = this.orgMappingTableMap.get(hrOrgUnitId);
                tableInfo = this.mappingTableMap.get(tableId);
            }
        } else if (null != this.orgMappingTableMap.get(hrOrgUnitId) && this.mappingTableMap.containsKey(this.orgMappingTableMap.get(hrOrgUnitId))) {
            tableId = this.orgMappingTableMap.get(hrOrgUnitId);
            tableInfo = this.mappingTableMap.get(tableId);
        }
        if (null == tableInfo) {
            StringBuilder oql = new StringBuilder();
            oql.append(" select ").append(MAPPING_TABLE_SELECTORS);
            oql.append(" where id in (select FMAPPINGTABLEID from T_HR_SORGMAPPINGTABLE where ");
            if (isSelfAdd) {
                oql.append("FUseHr ");
            } else {
                oql.append("FHRORGID ");
            }
            oql.append(" = '").append(hrOrgUnitId).append("')");
            oql.append(" and adjBusinessTypeRecord.adjBusinessType.id = '").append(businessType).append("'");
            try {
                tableInfo = EmpAdjustItemMappingTableFactory.getLocalInstance(ctx).getEmpAdjustItemMappingTableInfo(oql.toString());
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
        }
        return tableInfo;
    }

    protected void initCmpSubMappingTable(Context ctx, String hrOrgUnitIds) throws BOSException {
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT ORGM.FHRORGID, ORGM.FMAPPINGTABLEID ");
        sql.append(" FROM T_HR_SORGMAPPINGTABLE ORGM ");
        sql.append(" INNER JOIN T_HR_SEMPADJITEMMAPPINGTABLE TA ON ORGM.FMAPPINGTABLEID = TA.FID ");
        sql.append(" WHERE FDATASYNCTYPE = ").append(0);
        sql.append(" and FSTATE = ").append(1);
        sql.append(" and ORGM.FHrOrgID = ORGM.FUseHr ");
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            String hrOrgId = "";
            String tableId = "";
            while (rowSet.next()) {
                hrOrgId = rowSet.getString("FHRORGID");
                tableId = rowSet.getString("FMAPPINGTABLEID");
                this.orgMappingTableMap.put(hrOrgId, tableId);
                List<String> orgList = this.tableMapOrg.containsKey(tableId) ? this.tableMapOrg.get(tableId) : new ArrayList<String>();
                orgList.add(hrOrgId);
                this.tableMapOrg.put(tableId, orgList);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        logger.info((Object)("com.kingdee.shr.cmpdesign.app.v2.mapping.GenCmpAdjDataFromEmpFacadeControllerBean.initOrgMappingTable--->" + this.orgMappingTableMap));
    }

    @Override
    protected void _genCmpData(Context ctx, String cmpEmpORelIds) throws BOSException {
        logger.info((Object)("com.kingdee.shr.cmpdesign.app.v2.mapping.GenCmpAdjDataFromEmpFacadeControllerBean._genCmpData-->_genCmpData: " + cmpEmpORelIds));
        String oql = "select personCmp.hrOrgUnit.id, id where id in " + cmpEmpORelIds;
        CmpEmpORelationCollection ceoList = CmpEmpORelationFactory.getLocalInstance((Context)ctx).getCmpEmpORelationCollection(oql);
        Map<String, String> hrOrgMap = this.assembleORel2Record(ceoList);
        List<String> adjBusinessTypes = this.getAdjBusinessType(ctx);
        for (String businessType : adjBusinessTypes) {
            logger.info((Object)("com.kingdee.shr.cmpdesign.app.v2.mapping.GenCmpAdjDataFromEmpFacadeControllerBean._genCmpData-->start:businessType: " + this.getAdjBillSource(businessType).getAlias()));
            this.initOrgMappingTable(ctx, 0, businessType);
            this.initMappingTable(ctx, CmpStrUtil.convertSetToSqlString(this.tableMapOrg.keySet()));
            EmpAdjustItemMappingTableInfo mappingTable = null;
            for (Map.Entry<String, String> entry : hrOrgMap.entrySet()) {
                String hrOrgId = entry.getKey();
                String hrOrgSqlId = "'" + hrOrgId + "'";
                if (this.selfOrgMappingTableMap.get(hrOrgId) == null) continue;
                mappingTable = this.getMappingTable(ctx, hrOrgId, true, businessType);
                SubmitItemMappingSchemeCollection submitItemMapping = mappingTable.getSubmitItemMapping();
                this.genCmpData(ctx, mappingTable, submitItemMapping, hrOrgSqlId, null, hrOrgMap.get(hrOrgId));
            }
            cmpEmpORelIds = cmpEmpORelIds.replace("(", "").replace(")", "");
            logger.info((Object)("com.kingdee.shr.cmpdesign.app.v2.mapping.GenCmpAdjDataFromEmpFacadeControllerBean.dealSignatureFee-->dealSignatureFee:" + cmpEmpORelIds));
            this._dealSpecialItem(ctx, cmpEmpORelIds, businessType);
            logger.info((Object)("com.kingdee.shr.cmpdesign.app.v2.mapping.GenCmpAdjDataFromEmpFacadeControllerBean._genCmpData-->end:businessType: " + this.getAdjBillSource(businessType).getAlias()));
        }
    }

    @Override
    protected void _genAdjData(Context ctx, String adjEmpORelIds) throws BOSException {
        this.initHisFixAdjust(ctx);
        logger.info((Object)("com.kingdee.shr.cmpdesign.app.v2.mapping.GenCmpAdjDataFromEmpFacadeControllerBean._genAdjData-->adjEmpORelIds: " + adjEmpORelIds));
        String oql = "select personRecord.hrOrgUnit.id, id where id in " + adjEmpORelIds;
        AdjustEmpORelationCollection aeoList = AdjustEmpORelationFactory.getLocalInstance((Context)ctx).getAdjustEmpORelationCollection(oql);
        Map<String, String> hrOrgMap = this.assembleORel2Record(aeoList);
        List<String> adjBusinessTypes = this.getAdjBusinessType(ctx);
        for (String businessType : adjBusinessTypes) {
            logger.info((Object)("com.kingdee.shr.cmpdesign.app.v2.mapping.GenCmpAdjDataFromEmpFacadeControllerBean._genAdjData-->start:businessType: " + this.getAdjBillSource(businessType).getAlias()));
            this.initOrgMappingTable(ctx, 0, businessType);
            this.initMappingTable(ctx, CmpStrUtil.convertSetToSqlString(this.tableMapOrg.keySet()));
            EmpAdjustItemMappingTableInfo mappingTable = null;
            for (Map.Entry<String, String> entry : hrOrgMap.entrySet()) {
                String hrOrgId = entry.getKey();
                String hrOrgSqlId = "'" + hrOrgId + "'";
                if (this.orgMappingTableMap.get(hrOrgId) == null) continue;
                mappingTable = this.getMappingTable(ctx, hrOrgId, false, businessType);
                DataSyncType dataSyncType = mappingTable.getDataSyncType();
                DataArchivingType dataArchivingType = mappingTable.getDataArchivingType();
                this.maintainPayHrOrg(mappingTable);
                AdjustItemMappingSchemeCollection adjustItemMapping = mappingTable.getAdjustItemMapping();
                if (DataSyncType.realTime == dataSyncType && DataArchivingType.afterCreateBillArchiving == dataArchivingType) {
                    this.genAdjData(ctx, mappingTable, adjustItemMapping, hrOrgSqlId, null, hrOrgMap.get(hrOrgId));
                    continue;
                }
                if (DataSyncType.realTime != dataSyncType || DataArchivingType.directArchiving != dataArchivingType) continue;
                this.directGenAdjData(ctx, mappingTable, adjustItemMapping, hrOrgSqlId, null, hrOrgMap.get(hrOrgId));
            }
            logger.info((Object)("com.kingdee.shr.cmpdesign.app.v2.mapping.GenCmpAdjDataFromEmpFacadeControllerBean._genAdjData-->end:businessType: " + this.getAdjBillSource(businessType).getAlias()));
        }
    }

    protected List<String> getAdjBusinessType(Context ctx) throws BOSException {
        ArrayList<String> types = new ArrayList<String>();
        String sql = "SELECT distinct FBusinessType FROM T_HR_SORGMAPPINGTABLE";
        IRowSet rs = CmpSQLUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (rs.next()) {
                types.add(rs.getString("FBusinessType"));
            }
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return types;
    }

    protected Map<String, String> assembleORel2Record(Object o) {
        int i;
        AdjustEmpORelationCollection list;
        HashMap<String, String> map = new HashMap<String, String>();
        String recordId = null;
        String sqlId = null;
        if (o instanceof AdjustEmpORelationCollection) {
            list = (AdjustEmpORelationCollection)o;
            for (i = 0; i < list.size(); ++i) {
                recordId = list.get(i).getPersonRecord().getHrOrgUnit().getId().toString();
                if (map.get(recordId) != null) {
                    sqlId = (String)map.get(recordId) + ",'" + list.get(i).getId().toString() + "'";
                    map.put(recordId, sqlId);
                    continue;
                }
                map.put(recordId, "'" + list.get(i).getId().toString() + "'");
            }
        }
        if (o instanceof CmpEmpORelationCollection) {
            list = (CmpEmpORelationCollection)o;
            for (i = 0; i < list.size(); ++i) {
                recordId = list.get(i).getPersonCmp().getHrOrgUnit().getId().toString();
                if (map.get(recordId) != null) {
                    sqlId = (String)map.get(recordId) + ",'" + list.get(i).getId().toString() + "'";
                    map.put(recordId, sqlId);
                    continue;
                }
                map.put(recordId, "'" + list.get(i).getId().toString() + "'");
            }
        }
        return map;
    }

    @Override
    protected void _saveErrLog(Context ctx, List param) throws BOSException, EASBizException {
        if (param == null || param.size() == 0) {
            return;
        }
        logger.info((Object)("com.kingdee.shr.cmpdesign.app.v2.mapping.GenCmpAdjDataFromEmpFacadeControllerBean.genCmpOrAdjData-->saveErrLog-intoTable:" + param.size()));
        Date date = new Date(System.currentTimeMillis());
        String insertSql = "insert into T_HR_SGenCmpAdjDataLog values (?, ?, ?, ?)";
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        Map map = null;
        for (int i = 0; i < param.size(); ++i) {
            map = (Map)param.get(i);
            Exception e = (Exception)map.get("exception");
            Object[] parameter = new Object[]{map.get("personId") == null ? "" : String.valueOf(map.get("personId")), (String)map.get("type"), map.get("errMsg") != null ? String.valueOf(map.get("errMsg")) : (ExceptionUtils.getFullStackTrace((Throwable)e) == null ? e.getMessage() : ExceptionUtils.getFullStackTrace((Throwable)e)), new Timestamp(System.currentTimeMillis())};
            params.add(parameter);
        }
        DbUtil.executeBatch((Context)ctx, (String)insertSql, params);
        try {
            String clearSql = "delete from T_HR_SGenCmpAdjDataLog where FCreateTime < (select min(t.FCreateTime) from (select top 1000 FCreateTime from T_HR_SGenCmpAdjDataLog order by FCreateTime desc) t)";
            DbUtil.execute((Context)ctx, (String)clearSql);
        }
        catch (Exception e1) {
            logger.info((Object)e1.getMessage(), (Throwable)e1);
        }
    }

    @Override
    protected void _dealSpecialItem(Context ctx, String empOrgIds, String businessType) throws BOSException {
        String subSchemeId = this.getSignatureFeeSchemeId();
        String getSubSchemeAdminLongN = "select b.FLONGNUMBER ADMINLONGNUM, c.FLONGNUMBER HRLONGNUM, a.FSTATE  from T_HR_SCalSubmitScheme a INNER JOIN T_ORG_ADmin b ON A.FADMINORGUNITID = B.FID INNER JOIN T_ORG_HRO c ON A.FHrOrgUnitID = C.FID where a.fid ='" + subSchemeId + "'";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)getSubSchemeAdminLongN);
        HashSet<String> empAdjItemIds = new HashSet<String>();
        empAdjItemIds.add("SrEAAADcDCbD25kv");
        try {
            String adminLongNum = "";
            String hrLongNum = "";
            int state = 0;
            if (rowSet.next()) {
                adminLongNum = rowSet.getString("ADMINLONGNUM");
                hrLongNum = rowSet.getString("HRLONGNUM");
                state = rowSet.getInt("FSTATE");
            }
            if (state != 1) {
                return;
            }
            String sqlFormat = this.getCmpQuerySql(null, empOrgIds, businessType);
            String sql = sqlFormat.replace("@_HRORGUNITID", "select fid from T_ORG_HRO where flongnumber like '" + hrLongNum + "%'").replace("@_SALARYITEM", CmpStrUtil.convertSetToSqlString(empAdjItemIds)).replace("@_ADMINRANGE", "select fid from T_ORG_ADmin where flongnumber like '" + adminLongNum + "%'");
            logger.info((Object)("com.kingdee.shr.cmpdesign.app.v2.mapping.GenCmpAdjDataFromEmpFacadeControllerBean.dealSignatureFee-->" + sql));
            rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (rowSet.size() == 0) {
                return;
            }
            Map<String, Object[]> initBillApplyer = this.initBillApplyer(ctx, rowSet);
            rowSet.beforeFirst();
            String tempPersonId = "";
            while (rowSet.next()) {
                try {
                    tempPersonId = rowSet.getString("FPERSONID");
                    DealSpecialItem specialItemMethod = this.dealSpecialItemMethod(rowSet);
                    if (null == specialItemMethod) continue;
                    specialItemMethod.dealSpecialItem(ctx, this.assembleItemParam(rowSet, initBillApplyer));
                }
                catch (Exception e) {
                    HashMap<String, Object> err = new HashMap<String, Object>();
                    err.put("personId", tempPersonId);
                    err.put("exception", e);
                    if (e instanceof EASBizException) {
                        err.put("type", "Biz");
                    } else {
                        err.put("type", "Sys");
                    }
                    this.exceptions.add(err);
                }
            }
            logger.info((Object)("com.kingdee.shr.cmpdesign.app.v2.mapping.GenCmpAdjDataFromEmpFacadeControllerBean.genSpecialData-->saveErrLog:" + this.exceptions.size()));
            try {
                if (this.exceptions == null || this.exceptions.size() < 1) {
                    return;
                }
                GenCmpAdjDataFromEmpFacadeFactory.getLocalInstance(ctx).saveErrLog(this.exceptions);
            }
            catch (EASBizException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    protected DealSpecialItem dealSpecialItemMethod(IRowSet rowSet) throws Exception {
        DealSignatureFee dealSpeItem = new DealSignatureFee();
        return dealSpeItem;
    }

    protected SpecialItemInfo assembleItemParam(IRowSet rowSet, Map<String, Object[]> initBillApplyer) {
        SpecialItemInfo info = new SpecialItemInfo();
        info.setRowSet(rowSet);
        info.setInitBillApplyer(initBillApplyer);
        return info;
    }

    protected AdjBillSourceEnum getAdjBillSource(String type) {
        if ("0M/DJ21aSTDgU8gEEazWFyCeof4=".equals(type)) {
            return AdjBillSourceEnum.Become_Fix_Pay;
        }
        if ("0M+dAbZcUvbgU8gEEazwoSCeof4=".equals(type)) {
            return AdjBillSourceEnum.Recr_Add_PAY;
        }
        if ("0M+dAbZdUvbgU8gEEazwoSCeof4=".equals(type)) {
            return AdjBillSourceEnum.Induct_Add_Pay;
        }
        if ("0M+dAbZeUvbgU8gEEazwoSCeof4=".equals(type)) {
            return AdjBillSourceEnum.Fluction_Fix_Pay;
        }
        return AdjBillSourceEnum.Induct_Add_Pay;
    }
}

