/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.cmpdesign.app.v2.bill;

import com.google.common.collect.Sets;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.EASResource;
import com.kingdee.bos.util.backport.Arrays;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.api.bean.BatchMessageTipsBody;
import com.kingdee.shr.base.syssetting.api.bean.BatchMessageTipsHeader;
import com.kingdee.shr.cmpdesign.app.v2.bill.AbstractAdjustSalaryApplyEntryControllerBean;
import com.kingdee.shr.cmpdesign.util.AdjustSalaryUtils;
import com.kingdee.shr.compensation.FixAdjustSalaryCollection;
import com.kingdee.shr.compensation.FixAdjustSalaryFactory;
import com.kingdee.shr.compensation.FixAdjustSalaryInfo;
import com.kingdee.shr.compensation.FixAdjustSalaryRecordFacadeFactory;
import com.kingdee.shr.compensation.util.db.CmpInSql;
import com.kingdee.shr.compensation.util.db.CmpInSqlFactory;
import java.sql.Date;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.log4j.Logger;

public class AdjustSalaryApplyEntryControllerBean
extends AbstractAdjustSalaryApplyEntryControllerBean {
    private static final Logger LOG = Logger.getLogger(AdjustSalaryApplyEntryControllerBean.class);

    @Override
    protected BatchMessageTipsHeader _invalidate(Context ctx, Map param) throws BOSException {
        String entryIds = (String)param.get("entryIds");
        String invalidateDesc = (String)param.get("invalidateDesc");
        String operator = (String)param.get("operator");
        String submitSchemeId = (String)param.get("submitSchemeId");
        String calSchemeTableName = AdjustSalaryUtils.getCalShemeTableName(ctx, submitSchemeId);
        String lan = ctx.getLocale().getLanguage();
        CmpInSql cmpInSql = CmpInSqlFactory.getInstance();
        List all = Arrays.asList((Object[])entryIds.split(","));
        String ids = cmpInSql.createInSqlBaseOnFId(ctx, (Collection)all);
        String personFilter = " select FPersonId from " + calSchemeTableName + " where fid in " + ids;
        Map<String, FixAdjustSalaryInfo> map = AdjustSalaryUtils.getLastFixAdjustInfo(ctx, personFilter);
        String str = " SELECT AA.FState, AA.fid entryId, A01.FBILLID, A01.FEFFECTDAY, A01.FPersonId, A01.FPayHrOrgUnitID, A01.FCMPITEMID, adjItem.FNAME_" + lan + " ITEMNAME, A01.FID, s.FBillState  FROM " + calSchemeTableName + " AA left join T_HR_SAdjustSalaryApply s on s.fid = AA.Fbillid  left join t_hr_sCalSubmitScheme cal on cal.fid = s.FAdjustSalaryRuleID  left join T_HR_SBatchAdjustRuleItem rul on rul.FCalSubmitSchemeID = cal.fid  left join T_HR_AdjustSalaryItem adjItem on adjItem.fid = rul.FAdjustSalaryItemID  left join t_hr_sCmpItem item on item.fid = adjItem.FCmpItemID  left join T_HR_SFixAdjustSalary A01 ON AA.FPersonId = A01.FPersonId and (AA.FHrOrgUnitID = A01.FPayHrOrgUnitID or (AA.FHrOrgUnitID is null and A01.FPayHrOrgUnitID is null)) AND item.fid = A01.FCMPITEMID and AA.FBillID = A01.FBILLID  WHERE AA.Fid in " + ids;
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)str);
        try {
            BatchMessageTipsHeader tips = new BatchMessageTipsHeader();
            tips.setBillId(entryIds);
            HashSet successSet = Sets.newHashSet();
            HashSet failedSet = Sets.newHashSet();
            while (rowSet.next()) {
                BatchMessageTipsBody body;
                String entryId = rowSet.getString("entryId");
                if (failedSet.contains(entryId)) {
                    successSet.remove(entryId);
                    continue;
                }
                Optional<BatchMessageTipsBody> optional = tips.getResult().stream().filter(e -> e.getId().equals(entryId)).findFirst();
                if (!optional.isPresent()) {
                    body = new BatchMessageTipsBody();
                    tips.getResult().add(body);
                    body.setId(entryId);
                } else {
                    body = optional.get();
                }
                int entryState = rowSet.getInt("FState");
                int billState = rowSet.getInt("FBillState");
                if (entryState == 3) {
                    body.setMuitTipsState(false);
                    body.setMuitTipsMessage(EASResource.getString((String)"com.kingdee.shr.cmpdesign.resource.AdjustSalaryNoticeResource", (String)"15"));
                    failedSet.add(entryId);
                    continue;
                }
                if (billState != 3) {
                    body.setMuitTipsMessage(EASResource.getString((String)"com.kingdee.shr.cmpdesign.resource.AdjustSalaryNoticeResource", (String)"31"));
                    failedSet.add(entryId);
                    continue;
                }
                String key = rowSet.getString("FPayHrOrgUnitID") + "_" + rowSet.getString("FPersonId") + "_" + rowSet.getString("FCMPITEMID");
                Date effdt = rowSet.getDate("FEFFECTDAY");
                if (map.containsKey(key) && map.get(key).getEffectDay().after(effdt)) {
                    body.setMuitTipsState(false);
                    body.setMuitTipsMessage(EASResource.getString((String)"com.kingdee.shr.cmpdesign.resource.AdjustSalaryNoticeResource", (String)"16"));
                    failedSet.add(entryId);
                    continue;
                }
                body.setMuitTipsState(true);
                body.setMuitTipsMessage(EASResource.getString((String)"com.kingdee.shr.cmpdesign.resource.AdjustSalaryNoticeResource", (String)"17"));
                successSet.add(entryId);
            }
            if (!successSet.isEmpty()) {
                String inSQL = cmpInSql.createInSqlBaseOnFId(ctx, (Collection)successSet);
                this.updateCmpStructure(ctx, inSQL, calSchemeTableName);
                this.updateApplyEntryAndNoticeEntry(ctx, inSQL, calSchemeTableName, operator, invalidateDesc);
            }
            tips.setSuccessCount(successSet.size());
            tips.setFailureCount(all.size() - successSet.size());
            return tips;
        }
        catch (EASBizException | SQLException e2) {
            LOG.error((Object)"_invalidate error: ", e2);
            throw new BOSException(e2);
        }
    }

    private void updateApplyEntryAndNoticeEntry(Context ctx, String inSQL, String calSchemeTableName, String operator, String invalidateDesc) throws BOSException {
        Object[] param = new Object[]{invalidateDesc, operator};
        String updateApplyEntrySQL = "update " + calSchemeTableName + " set FState = " + 3 + ", FInvalidateDesc = ?, FInvalidateOperatorId = ?, FInvalidateTime = now() where fid in " + inSQL;
        DbUtil.execute((Context)ctx, (String)updateApplyEntrySQL, (Object[])param);
        String updateNoticeEntrySQL = "update T_HR_SAdjustSalaryNoticeEntry set FAdjEntryState = 3, FInvalidateDesc = ?, FLastUpdateUserId = ?, FLastUpdateTime = now() where FAdjEntryId in " + inSQL;
        DbUtil.execute((Context)ctx, (String)updateNoticeEntrySQL, (Object[])param);
    }

    private void updateCmpStructure(Context ctx, String entryIdsInSql, String calSchemeTableName) throws BOSException, SQLException, EASBizException {
        Calendar calendar = Calendar.getInstance();
        calendar.set(2199, 11, 31, 0, 0, 0);
        calendar.set(14, 0);
        ArrayList<Object[]> delList = new ArrayList<Object[]>();
        ArrayList<Object[]> updateList = new ArrayList<Object[]>();
        String str = " SELECT entry.FBillId, A01.FID NEWFID, A01.FLEFFECTDAY NEWLEFFDT, A02.FID OLDID, A02.FLeffectSource leffSource, A04.FLeffectDate, A02.FSysLFDBak  FROM T_HR_SFIXADJUSTSALARY A01  LEFT JOIN T_HR_SFIXADJUSTSALARY A02 ON A01.FOLDFIXADJUSTSALARYID = A02.FID  LEFT JOIN T_HR_SAdjustEmpORelation A03 ON A03.FID = A02.FAdjEmpORelationID  LEFT JOIN T_HR_SAdjustPersonRecord A04 ON A04.FID = A03.FPersonRecordID  INNER JOIN " + calSchemeTableName + " entry ON A01.FPersonId = entry.FPersonId and A01.FBillId = entry.FBillID and entry.fid in " + entryIdsInSql;
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)str);
        HashSet billIds = Sets.newHashSet();
        while (rowSet.next()) {
            Date sysLFDBak;
            String billId = rowSet.getString("FBillId");
            billIds.add(billId);
            Object[] param = new Object[]{rowSet.getString("NEWFID")};
            delList.add(param);
            String leffSource = rowSet.getString("leffSource");
            if (leffSource == null) continue;
            param = new Object[2];
            Date recordLFD = rowSet.getDate("FLeffectDate");
            recordLFD = recordLFD == null ? new Date(calendar.getTime().getTime()) : recordLFD;
            param[0] = recordLFD;
            if (leffSource.equals("20") && (sysLFDBak = rowSet.getDate("FSysLFDBak")) != null) {
                param[0] = sysLFDBak;
            }
            param[1] = rowSet.getString("OLDID");
            updateList.add(param);
        }
        CmpInSql cmpInSql = CmpInSqlFactory.getInstance();
        String billIdInSQL = cmpInSql.createInSqlBaseOnFId(ctx, (Collection)billIds);
        FixAdjustSalaryCollection coll = FixAdjustSalaryFactory.getLocalInstance((Context)ctx).getFixAdjustSalaryCollection("where billId in " + billIdInSQL);
        ArrayList<FixAdjustSalaryInfo> list = new ArrayList<FixAdjustSalaryInfo>();
        for (int i = 0; i < coll.size(); ++i) {
            list.add(coll.get(i));
        }
        FixAdjustSalaryRecordFacadeFactory.getLocalInstance((Context)ctx).saveRecord(list, "Invalidate Adjust Salary Apply Entry");
        String deleteSql = "DELETE FROM T_HR_SFIXADJUSTSALARY WHERE FID = ?";
        DbUtil.executeBatch((Context)ctx, (String)deleteSql, delList);
        String delRecSql = "DELETE FROM T_HR_SFIXADJUSTPAYHRRECORD WHERE FSOURCEID = ? ";
        DbUtil.executeBatch((Context)ctx, (String)delRecSql, delList);
        if (updateList.size() > 0) {
            String updateSql = "UPDATE T_HR_SFIXADJUSTSALARY SET FLEFFECTDAY = ? WHERE FID = ? ";
            DbUtil.executeBatch((Context)ctx, (String)updateSql, updateList);
            String updateRecSql = "UPDATE T_HR_SFIXADJUSTPAYHRRECORD SET FLEFFDT = ? WHERE FSOURCEID = ?";
            DbUtil.executeBatch((Context)ctx, (String)updateRecSql, updateList);
        }
    }
}

