/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.cmpdesign.fix;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.SqlParam;
import com.kingdee.eas.hr.base.app.filter.FilterUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.json.JSONUtils;
import com.kingdee.shr.baseconfig.StructureConfigColumnsInfo;
import com.kingdee.shr.baseconfig.StructureConfigInfo;
import com.kingdee.shr.cmpdesign.CmpStandardInfo;
import com.kingdee.shr.cmpdesign.CmpStdPropCollection;
import com.kingdee.shr.cmpdesign.CmpStdPropFactory;
import com.kingdee.shr.cmpdesign.CmpStdPropInfo;
import com.kingdee.shr.cmpdesign.fix.ICmpStdRefer;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class CmpStdReferFacade
implements ICmpStdRefer {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.cmpdesign.fix.CmpStdReferFacade");
    private List<String> columnList = new ArrayList<String>();
    private List<Refer> referList = new ArrayList<Refer>();
    private static String SPLIT = "_";
    private static String PERSON_ID = "cmp_person.id";

    @Override
    public Map<String, String> getSelectColumns(Context ctx, CmpStandardInfo info) throws BOSException {
        HashMap<String, String> selectMapping = new HashMap<String, String>();
        String referInfo = info.getReferInfo();
        this.getReferInfo(ctx, referInfo);
        StringBuilder sb = new StringBuilder();
        if (null == this.referList || this.referList.size() < 1) {
            return selectMapping;
        }
        Refer refer = this.referList.get(0);
        List<Field> fields = refer.getFields();
        for (Field field : fields) {
            sb.append("'").append(field.getFieldId()).append("',");
        }
        String ids = sb.substring(0, sb.length() - 1);
        String oql = "select configField.factField.structureConfig.clientNumber,configField.factField.Number where id in (" + ids + ") order by sortSn ";
        CmpStdPropCollection coll = CmpStdPropFactory.getLocalInstance(ctx).getCmpStdPropCollection(oql);
        sb = new StringBuilder();
        this.columnList.clear();
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            CmpStdPropInfo propInfo = coll.get(i);
            StructureConfigColumnsInfo column = propInfo.getConfigField().getFactField();
            StructureConfigInfo structureConfig = column.getStructureConfig();
            String clientNumber = structureConfig.getClientNumber();
            String number = column.getNumber();
            selectMapping.put(clientNumber + "." + number, clientNumber + "." + number);
            this.columnList.add(clientNumber + "." + number);
        }
        return selectMapping;
    }

    @Override
    public String getSql(Context ctx, String personIds, CmpStandardInfo info) throws BOSException {
        String sql = null;
        SqlParam param = new SqlParam();
        Map<String, String> selectMapping = this.getSelectColumns(ctx, info);
        selectMapping.put(PERSON_ID, PERSON_ID);
        FilterInfo filter = null;
        try {
            filter = new FilterInfo(" cmp_person.id in (" + personIds + ")");
        }
        catch (ParserException e) {
            e.printStackTrace();
            logger.error((Object)e);
        }
        param.setSelectMapping(selectMapping);
        param.setScheme("002");
        param.setHistoryMode(false);
        param.setFilterInfo(filter);
        try {
            sql = FilterUtil.getSql((Context)ctx, (SqlParam)param);
        }
        catch (EASBizException e) {
            e.printStackTrace();
            logger.error((Object)e);
        }
        return sql;
    }

    @Override
    public Map<String, Set<String>> getPersonLevel(Context ctx, String personIds, CmpStandardInfo info) throws BOSException {
        ArrayList<PersonRefer> list = new ArrayList<PersonRefer>();
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
        HashSet levelSet = null;
        String sql = this.getSql(ctx, personIds, info);
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (rowSet.next()) {
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < this.columnList.size(); ++i) {
                    sb.append(rowSet.getObject(this.columnList.get(i))).append(SPLIT);
                }
                PersonRefer personRefer = new PersonRefer(rowSet.getString(PERSON_ID), sb.toString());
                logger.error((Object)("person \uff1a " + rowSet.getString(PERSON_ID) + " : " + sb.toString()));
                list.add(personRefer);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        for (Refer refer : this.referList) {
            String stdV = refer.getFieldToString();
            String levelId = refer.getLevelId();
            logger.error((Object)("Salaryleve\uff1a" + levelId + ":" + stdV));
            for (PersonRefer per : list) {
                String perV = per.getValue();
                String perId = per.getId();
                if (!map.containsKey(perId)) {
                    levelSet = new HashSet();
                    map.put(perId, levelSet);
                }
                if (!stdV.equals(perV)) continue;
                ((Set)map.get(perId)).add(levelId);
            }
        }
        return map;
    }

    private void getReferInfo(Context ctx, String referInfo) throws BOSException {
        if (StringUtils.isEmpty((String)referInfo)) {
            return;
        }
        Map[] mapArr = (Map[])JSONUtils.convertJsonToObject((Context)ctx, (String)referInfo, Map[].class);
        this.referList.clear();
        for (int i = 0; i < mapArr.length; ++i) {
            Map referMap = mapArr[i];
            List fields = (List)referMap.get("fields");
            if (null == fields || fields.size() == 0) continue;
            String levelId = (String)referMap.get("levelId");
            Refer refer = new Refer(levelId);
            for (Map map : fields) {
                Field field = new Field((String)map.get("fieldId"), (String)map.get("id"), (String)map.get("value"));
                refer.addField(field);
            }
            this.referList.add(refer);
        }
    }

    class PersonRefer {
        String id;
        String value;

        PersonRefer(String id, String value) {
            this.id = id;
            this.value = value;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    class Field {
        String fieldId;
        String id;
        String value;

        Field(String fieldId, String id, String value) {
            this.fieldId = fieldId;
            this.id = id;
            this.value = value;
        }

        public String getFieldId() {
            return this.fieldId;
        }

        public String getId() {
            return this.id;
        }

        public String getValue() {
            return this.value;
        }
    }

    class Refer {
        String levelId;
        List<Field> fields;

        Refer(String levelId) {
            this.levelId = levelId;
        }

        void addField(Field newField) {
            if (null == this.fields) {
                this.fields = new LinkedList<Field>();
                this.fields.add(newField);
                return;
            }
            this.fields.add(newField);
        }

        public String getLevelId() {
            return this.levelId;
        }

        public List<Field> getFields() {
            return this.fields;
        }

        public String getFieldToString() {
            StringBuilder sb = new StringBuilder();
            if (null == this.fields || this.fields.size() < 1) {
                return null;
            }
            int size = this.fields.size();
            for (int i = 0; i < size; ++i) {
                sb.append(this.fields.get(i).getValue()).append(SPLIT);
            }
            return sb.toString();
        }
    }
}

