/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.cmpdesign.service;

import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.hraux.BasicItemInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.validaterule.formula.SalaryCalFunction2;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class CmpStdCalFunctionService
extends SalaryCalFunction2 {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.cmpdesign.service.CmpStdCalFunctionService");

    public double getCmpStandardValue(Context ctx, String mainTableName, Map paramMap, HashMap tempMap, BasicItemInfo calScheme, String mainTableRowFilter, String cmpStdName, String cmpItemName, String cmpStdLevelName, String cmpStdPointName) {
        Map result;
        String tempMapKey = "CmpStdCalFunctionService_getCmpStandardValue_" + cmpStdName;
        if (tempMap.get(tempMapKey) == null) {
            try {
                tempMap.put(tempMapKey, this.initCmpStdValues(ctx, mainTableName, cmpStdName));
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                tempMap.put(tempMapKey, new HashMap());
            }
        }
        if ((result = (Map)tempMap.get(tempMapKey)).containsKey(cmpItemName)) {
            Map itemMap = (Map)result.get(cmpItemName);
            if (null != itemMap && itemMap.containsKey(cmpStdLevelName)) {
                Map poScMap = (Map)itemMap.get(cmpStdLevelName);
                if (null != poScMap && poScMap.containsKey(cmpStdPointName)) {
                    return (Double)poScMap.get(cmpStdPointName);
                }
                return 0.0;
            }
            return 0.0;
        }
        return 0.0;
    }

    private Map<String, Map<String, Map<String, Double>>> initCmpStdValues(Context ctx, String mainTableName, String cmpStdName) throws Exception {
        HashMap<String, Map<String, Map<String, Double>>> result = new HashMap<String, Map<String, Map<String, Double>>>();
        StringBuffer sqlBuffer = new StringBuffer();
        String language = ctx.getLocale().getLanguage();
        sqlBuffer.append(" select FLevelType from T_HR_SCmpStandard where fname_").append(language).append(" = '").append(cmpStdName).append("' ");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlBuffer.toString());
        if (rowSet == null || rowSet.size() < 1) {
            return result;
        }
        boolean isCmpPoint = false;
        while (rowSet.next()) {
            isCmpPoint = 0 == rowSet.getInt("FLevelType");
        }
        sqlBuffer = new StringBuffer();
        sqlBuffer.append(" select ");
        sqlBuffer.append(" item.fname_").append(language).append(" itemName, ");
        sqlBuffer.append(" lev.fname_").append(language).append(" levelName, ");
        if (isCmpPoint) {
            sqlBuffer.append(" po.fname_").append(language).append(" poScName, ");
        } else {
            sqlBuffer.append(" sc.fname_").append(language).append(" poScName, ");
        }
        sqlBuffer.append(" va.Fvalue value ");
        sqlBuffer.append(" from T_HR_SCmpStandard std ");
        sqlBuffer.append(" inner join  T_HR_SCmpStdLevel lev on std.fid = lev.fcmpstandardid ");
        if (isCmpPoint) {
            sqlBuffer.append(" inner join  T_HR_SCmpStdPoint po on std.fid = po.fcmpstandardid ");
        } else {
            sqlBuffer.append(" inner join  T_HR_ScmpStdScope sc on std.fid = sc.fcmpstandardid ");
        }
        sqlBuffer.append(" inner join  T_HR_SCmpStdValue va on lev.fid = va.fcmpstdlevelid ");
        if (isCmpPoint) {
            sqlBuffer.append(" and va.fcmpstdpointid = po.fid ");
        } else {
            sqlBuffer.append(" and va.fcmpstdscopeid = sc.fid ");
        }
        sqlBuffer.append(" inner join  T_HR_SCmpStdItem stditem on std.fid = stditem.fcmpstandardid and stditem.fid = va.fcmpstditemid ");
        sqlBuffer.append(" inner join  T_HR_SCmpItem item on stditem.fcmpitemid = item.fid ");
        sqlBuffer.append(" where ");
        sqlBuffer.append(" std.fname_").append(language).append(" = '").append(cmpStdName).append("' ");
        sqlBuffer.append(" order by item.Findex, lev.FSortSn ");
        if (isCmpPoint) {
            sqlBuffer.append(" ,po.FSortSn ");
        } else {
            sqlBuffer.append(" ,sc.FSortSn ");
        }
        rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlBuffer.toString());
        if (rowSet == null || rowSet.size() < 1) {
            return result;
        }
        String itemName = "";
        String levelName = "";
        String poScName = "";
        double value = 0.0;
        while (rowSet.next()) {
            itemName = rowSet.getString("itemName");
            levelName = rowSet.getString("levelName");
            Map levelMap = result.containsKey(itemName) ? (Map)result.get(itemName) : new HashMap();
            poScName = rowSet.getString("poScName");
            Map valueMap = levelMap.containsKey(levelName) ? (Map)levelMap.get(levelName) : new HashMap();
            value = rowSet.getDouble("value");
            valueMap.put(poScName, value);
            levelMap.put(levelName, valueMap);
            result.put(itemName, levelMap);
        }
        return result;
    }
}

