/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.cmpdesign.service;

import java.util.ArrayList;
import java.util.List;

public class SeriesNumService {
    public static final String[] CN_SERIES = new String[]{"\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u4e03", "\u516b", "\u4e5d", "\u5341", "\u5341\u4e00", "\u5341\u4e8c", "\u5341\u4e09", "\u5341\u56db", "\u5341\u4e94", "\u5341\u516d", "\u5341\u4e03", "\u5341\u516b", "\u5341\u4e5d", "\u4e8c\u5341", "\u4e8c\u5341\u4e00", "\u4e8c\u5341\u4e8c", "\u4e8c\u5341\u4e09", "\u4e8c\u5341\u56db", "\u4e8c\u5341\u4e94", "\u4e8c\u5341\u516d", "\u4e8c\u5341\u4e03", "\u4e8c\u5341\u516b", "\u4e8c\u5341\u4e5d", "\u4e09\u5341", "\u4e09\u5341\u4e00", "\u4e09\u5341\u4e8c", "\u4e09\u5341\u4e09", "\u4e09\u5341\u56db", "\u4e09\u5341\u4e94", "\u4e09\u5341\u516d", "\u4e09\u5341\u4e03", "\u4e09\u5341\u516b", "\u4e09\u5341\u4e5d", "\u56db\u5341", "\u56db\u5341\u4e00", "\u56db\u5341\u4e8c", "\u56db\u5341\u4e09", "\u56db\u5341\u56db", "\u56db\u5341\u4e94", "\u56db\u5341\u516d", "\u56db\u5341\u4e03", "\u56db\u5341\u516b", "\u56db\u5341\u4e5d", "\u4e94\u5341"};
    public static final String DIGITAL = "digital";
    public static final String CN = "Chinese Series";
    public static final String BRACKETS_DIGITAL = "Digital Series in Parentheses";
    public static final String BRACKETS_CN = "Chinese Series in Parentheses";
    public static final String BRACKETS_STYLE_EN = "(%s)";
    public static final String BRACKETS_STYLE2_CN = "\uff08%s\uff09";

    public List<String> generateSeriesNumList(String seriesType, int count) {
        if (DIGITAL.equals(seriesType)) {
            boolean havingBrackets = false;
            return this.getDigitalList(count, havingBrackets);
        }
        if (CN.equals(seriesType)) {
            if (count > CN_SERIES.length) {
                throw new RuntimeException("");
            }
            boolean havingBrackets = false;
            return this.getCNList(count, havingBrackets);
        }
        if (BRACKETS_DIGITAL.equals(seriesType)) {
            boolean havingBrackets = true;
            return this.getDigitalList(count, havingBrackets);
        }
        if (BRACKETS_CN.equals(seriesType)) {
            if (count > CN_SERIES.length) {
                throw new RuntimeException("");
            }
            boolean havingBrackets = true;
            return this.getCNList(count, havingBrackets);
        }
        return null;
    }

    private List<String> getDigitalList(int count, boolean havingBrackets) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 1; i <= count; ++i) {
            String num = havingBrackets ? String.format(BRACKETS_STYLE_EN, i) : String.valueOf(i);
            list.add(num);
        }
        return list;
    }

    private List<String> getCNList(int count, boolean havingBrackets) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < count; ++i) {
            String num = havingBrackets ? String.format(BRACKETS_STYLE2_CN, CN_SERIES[i]) : CN_SERIES[i];
            list.add(num);
        }
        return list;
    }
}

