/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.shr.base.syssetting.util.SHRCheck;
import com.kingdee.shr.compensation.CalResultEditedFactory;
import com.kingdee.shr.compensation.CalResultEditedLogFactory;
import com.kingdee.shr.compensation.CalResultEditedLogInfo;
import com.kingdee.shr.compensation.CalSchemeFactory;
import com.kingdee.shr.compensation.CalSchemeInfo;
import com.kingdee.shr.compensation.CmpCalTableFactory;
import com.kingdee.shr.compensation.CmpCalTableInfo;
import com.kingdee.shr.compensation.CmpItemDataPermFactory;
import com.kingdee.shr.compensation.CmpItemDataType;
import com.kingdee.shr.compensation.CmpItemFactory;
import com.kingdee.shr.compensation.CmpItemInfo;
import com.kingdee.shr.compensation.app.AbstractCalResultEditedFacadeControllerBean;
import com.kingdee.shr.compensation.app.formula.common.FunctionTools;
import com.kingdee.shr.compensation.cache.core.CacheServiceManager;
import com.kingdee.shr.compensation.cache.core.ICmpCacheSevice;
import com.kingdee.shr.compensation.helper.CmpConstants;
import com.kingdee.shr.compensation.util.CmpCalUtil;
import com.kingdee.shr.compensation.util.CmpExcelUtil;
import com.kingdee.shr.compensation.util.CmpSQLUtil;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import com.kingdee.util.StringUtils;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.log4j.Logger;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class CalResultEditedFacadeControllerBean
extends AbstractCalResultEditedFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.compensation.app.CalResultEditedFacadeControllerBean");
    private Map<String, String[]> allCalPerson;

    @Override
    protected List _assembleItemEditableColumns(Context ctx, String cmpschemeId) throws BOSException, EASBizException {
        ArrayList itemList = new ArrayList();
        String[] param = cmpschemeId.split("_");
        cmpschemeId = param[0];
        String[] columnModel = param.length > 1 ? param[1].split(",") : null;
        StringBuffer formulaSql = new StringBuffer();
        String l = LocaleUtils.getShortCode((Context)ctx);
        formulaSql.append("select");
        formulaSql.append(" fieldsn,fdatatype,fdatalength,b.fname_" + l + ",b.fdatadot");
        formulaSql.append(" from t_hr_scalschemeitem a,t_hr_scmpitem b");
        formulaSql.append(" where a.FCALSCHEMEID ='" + cmpschemeId + "'");
        formulaSql.append(" and a.FCMPITEMID = b.fid");
        formulaSql.append(" and exists (");
        formulaSql.append(" select 1 from t_hr_scalformula c");
        formulaSql.append(" where c.FCALITEM = 'S' || tochar(b.fieldsn)");
        formulaSql.append(" and fiscal = 1");
        formulaSql.append(" and fiseditable = 1");
        formulaSql.append(" and c.FCALSCHEMEID = a.FCALSCHEMEID");
        formulaSql.append(")");
        String personId = HRFilterUtils.getCurrentPersonId((Context)ctx);
        CalSchemeInfo calScheme = CalSchemeFactory.getLocalInstance(ctx).getCalSchemeInfo("select hrOrgUnit.id where id='" + cmpschemeId + "'");
        String hrOrgUnitId = calScheme.getHrOrgUnit().getId().toString();
        boolean isSetCmpItemDataPerm = CmpItemDataPermFactory.getLocalInstance(ctx).exists("where person.id='" + personId + "' and hrOrgUnit.id='" + hrOrgUnitId + "'");
        if (isSetCmpItemDataPerm) {
            formulaSql.append(" and  b.fieldsn in(");
            formulaSql.append(" select item.fieldsn from t_hr_scmpitemdataperm perm");
            formulaSql.append(" inner join t_hr_scmpitem item");
            formulaSql.append(" on item.fid=perm.fcmpitemid");
            formulaSql.append(" where perm.fpersonid ='");
            formulaSql.append(personId);
            formulaSql.append("' and perm.FHrOrgUnitID='").append(hrOrgUnitId);
            formulaSql.append("' and perm.fisedit=1");
            formulaSql.append(")");
        }
        formulaSql.append(" order by a.fsortsn,b.fnumber");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)formulaSql.toString());
        if (rowSet.size() == 0) {
            return itemList;
        }
        StringBuffer cmpItemFieldsnStr = new StringBuffer();
        HashSet<String> fieldsnSet = new HashSet<String>();
        try {
            LinkedHashMap itemMap = new LinkedHashMap();
            while (rowSet.next()) {
                Object dataDot;
                String itemName = (String)rowSet.getObject("fname_" + l + "");
                String fieldsn = rowSet.getObject("fieldsn").toString();
                if (fieldsnSet.contains(fieldsn)) continue;
                fieldsnSet.add(fieldsn);
                if (cmpItemFieldsnStr.length() > 0) {
                    cmpItemFieldsnStr.append(",");
                }
                cmpItemFieldsnStr.append(fieldsn);
                Object dataTypeValue = rowSet.getObject("fdatatype");
                Object dataLength = rowSet.getObject("fdatalength");
                String dataTypeEnum = dataTypeValue.toString().equals("0") ? "number" : "string";
                Object tempDot = dataDot = rowSet.getObject("fdatadot");
                dataDot = 10;
                String dataType = dataTypeValue.toString().equals("0") ? "numeric(20," + dataDot + ")" : "nvarchar(" + dataLength + ")";
                this.alterTable(ctx, "S" + fieldsn, dataType);
                HashMap<String, Object> item = new HashMap<String, Object>();
                item.put("label", itemName);
                item.put("name", "calTable.s" + fieldsn);
                item.put("type", dataTypeEnum);
                item.put("dot", tempDot.toString());
                item.put("length", dataLength == null ? "null" : dataLength);
                if ("number".equals(dataTypeEnum)) {
                    HashMap extendOptions = new HashMap();
                    HashMap<String, Object> numberOptions = new HashMap<String, Object>();
                    numberOptions.put("decimalPrecision", Integer.parseInt(tempDot.toString()));
                    numberOptions.put("ignoreDecimalFormatter", false);
                    numberOptions.put("roundType", "round");
                    extendOptions.put("numberOptions", numberOptions);
                    item.put("extendOptions", extendOptions);
                }
                itemMap.put(fieldsn, item);
            }
            if (columnModel != null && columnModel.length > 0) {
                for (int i = 0; i < columnModel.length; ++i) {
                    String column = columnModel[i];
                    if (!itemMap.containsKey(column)) continue;
                    itemList.add(itemMap.get(column));
                }
            } else {
                Iterator keyIt = itemMap.keySet().iterator();
                while (keyIt.hasNext()) {
                    itemList.add(itemMap.get(keyIt.next()));
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return itemList;
    }

    private void alterTable(Context ctx, String field, String type) throws BOSException {
        StringBuffer alterSql = new StringBuffer();
        alterSql.append("if not exists");
        alterSql.append(" (select * from KSQL_USERCOLUMNS");
        alterSql.append(" where KSQL_COL_NAME = '" + field + "'");
        alterSql.append(" and KSQL_COL_TABNAME = 't_hr_scalresultedited')");
        alterSql.append(" alter table t_hr_scalresultedited add " + field + " " + type);
        DbUtil.execute((Context)ctx, (String)alterSql.toString());
    }

    @Override
    protected List _getData(Context ctx, String cmpCalTableIds, String columnModel, Map queryParam) throws BOSException, EASBizException {
        List<Map<String, Object>> datas = new ArrayList<Map<String, Object>>();
        String calSchemeId = (String)queryParam.get("cmpschemeid");
        String calTableIdsSql = (String)queryParam.get("calTableIdsSql");
        if (calTableIdsSql == null || "".equals(calTableIdsSql)) {
            return datas;
        }
        StringBuffer calTableIdfilter = new StringBuffer();
        if (cmpCalTableIds == null || cmpCalTableIds.equals("")) {
            calTableIdfilter.append("select caltable.fid from T_HR_SCALRESULTEDITED result");
            calTableIdfilter.append(" inner join T_HR_SCMPCALTABLE  caltable");
            calTableIdfilter.append(" on result.fcmpcaltableid = caltable.fid");
            calTableIdfilter.append(" inner join T_HR_SCALSCHEME scheme");
            calTableIdfilter.append(" on scheme.FPERIODYEAR = caltable.FPERIODYEAR");
            calTableIdfilter.append(" and scheme.FPERIODMONTH = caltable.FPERIODMONTH");
            calTableIdfilter.append(" and scheme.FCALTIME = caltable.FCALTIME");
            calTableIdfilter.append(" where scheme.fid = '" + calSchemeId + "'");
            calTableIdfilter.append(" and caltable.FCALSTATE <= 7 ");
            if (calTableIdsSql != null && !"".equals(calTableIdsSql)) {
                calTableIdfilter.append(" and caltable.fid in (" + calTableIdsSql + ") ");
            }
        } else {
            for (String id : cmpCalTableIds.split(",")) {
                if (calTableIdfilter.length() > 0) {
                    calTableIdfilter.append(",");
                }
                calTableIdfilter.append("'" + id.trim() + "'");
            }
        }
        String cmpItemStrWithoutPrefix = this.getCmpItemsWithoutPrefix(columnModel);
        String[] cmpItems = cmpItemStrWithoutPrefix.split(",");
        String filter = (String)queryParam.get("filter");
        String sorter = (String)queryParam.get("sorter");
        String sord = (String)queryParam.get("sord");
        CalSchemeInfo calScheme = CalSchemeFactory.getLocalInstance(ctx).getCalSchemeInfo("where id='" + calSchemeId + "'");
        String endDate = "{ts'" + calScheme.getEndDate().toString() + "'}";
        String filterSql = this.assembleFilterSql(filter, ctx);
        String orderSql = this.assembleOrderSql(sorter, sord, ctx);
        String selector = this.assembleCalTableSelector(cmpItemStrWithoutPrefix, ctx);
        StringBuffer calTableSql = new StringBuffer();
        calTableSql.append("select ");
        calTableSql.append(selector);
        calTableSql.append(" from t_hr_scmpcaltable t");
        calTableSql.append(" inner join (");
        calTableSql.append(" select his.* from t_bd_personhis his");
        calTableSql.append(" inner join (");
        calTableSql.append(" select max(t_bd_personhis.feffdt) feffdt,t_bd_personhis.fhistoryrelateid");
        calTableSql.append(" from t_bd_personhis");
        calTableSql.append(" where t_bd_personhis.feffdt <= " + endDate);
        calTableSql.append(" group by fhistoryrelateid) maxhis");
        calTableSql.append(" on his.fhistoryrelateid = maxhis.fhistoryrelateid");
        calTableSql.append(" and his.feffdt = maxhis.feffdt) person");
        calTableSql.append(" on person.fhistoryrelateid = t.fpersonid");
        calTableSql.append(" where t.fid in(");
        calTableSql.append(calTableIdfilter);
        calTableSql.append(") and (t.FIsNotNeedCal = 0 or t.FIsNotNeedCal is null)");
        if (filterSql != null && !filterSql.equals("")) {
            calTableSql.append(filterSql);
        }
        if (orderSql != null) {
            calTableSql.append(orderSql);
        }
        IRowSet calTableRowSet = DbUtil.executeQuery((Context)ctx, (String)calTableSql.toString());
        String[] columnsArr = selector.split(",");
        try {
            while (calTableRowSet.next()) {
                HashMap<String, Object> dataMap = new HashMap<String, Object>();
                for (String column : columnsArr) {
                    String columnAlias = column.substring(column.indexOf(" ") + 1);
                    Object dbValue = calTableRowSet.getObject(columnAlias);
                    if (columnAlias.matches("s\\d{1,}")) {
                        String itemFieldSn = columnAlias.substring(1);
                        CmpItemInfo cmpItemInfo = this.getCmpItemInfo(ctx, Integer.valueOf(itemFieldSn));
                        if (cmpItemInfo.getDataType() == CmpItemDataType.STRING && "null".equals(dbValue)) {
                            dbValue = null;
                        }
                        if (cmpItemInfo.getDataType() == CmpItemDataType.NUMBER) {
                            int dataDot = cmpItemInfo.getDataDot().getValue();
                            if (null != dbValue) {
                                dbValue = FunctionTools.getRound(dataDot, ((BigDecimal)dbValue).doubleValue());
                            }
                        }
                    }
                    dataMap.put("calTable." + columnAlias, dbValue);
                }
                datas.add(dataMap);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        String calResultEditedSelector = this.assembleResultEditedSelector(cmpItemStrWithoutPrefix);
        StringBuffer calResulteditedSql = new StringBuffer();
        calResulteditedSql.append("select ");
        calResulteditedSql.append(calResultEditedSelector);
        calResulteditedSql.append(" from t_hr_scalresultedited edited");
        calResulteditedSql.append(" inner join t_hr_scmpcaltable caltable");
        calResulteditedSql.append(" on edited.fcmpcaltableid = caltable.fid");
        calResulteditedSql.append(" where fcmpcaltableid in(");
        calResulteditedSql.append(calTableIdfilter);
        calResulteditedSql.append(") and caltable.FIsNotNeedCal = 0");
        IRowSet calResultEditedRowSet = DbUtil.executeQuery((Context)ctx, (String)calResulteditedSql.toString());
        try {
            block7: while (calResultEditedRowSet.next()) {
                String calTableId = calResultEditedRowSet.getString("calTableId");
                for (int i = 0; i < datas.size(); ++i) {
                    if (!datas.get(i).get("calTable.calTableId").equals(calTableId)) continue;
                    for (String string : cmpItems) {
                        if (calResultEditedRowSet.getObject(string) == null) continue;
                        Object value = calResultEditedRowSet.getObject(string);
                        if (value instanceof BigDecimal) {
                            String itemFieldSn = string.substring(1);
                            CmpItemInfo editTtem = this.getCmpItemInfo(ctx, Integer.valueOf(itemFieldSn));
                            int dataDot = editTtem.getDataDot().getValue();
                            value = FunctionTools.getRound(dataDot, ((BigDecimal)value).doubleValue());
                        }
                        datas.get(i).put("calTable." + string, value);
                    }
                    continue block7;
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        if (StringUtil.isEmptyString((String)sorter)) {
            datas = this.sortDatas(cmpCalTableIds, datas);
        }
        return datas;
    }

    @Override
    protected void _save(Context ctx, Map rowData) throws BOSException, EASBizException {
        List changeRowData = (List)rowData.get("model");
        List allData = (List)rowData.get("allData");
        List colModel = (List)rowData.get("colModel");
        Map<String, String> dataTypeMap = this.assembleDataTypeMap(colModel);
        this.saveCalResultEdited(ctx, changeRowData, dataTypeMap);
        this.updateLog(ctx, changeRowData);
        this.updateCalTable(ctx, changeRowData);
        Map row = (Map)changeRowData.get(0);
        String calTableId = (String)row.get("id");
        if (CmpStrUtil.isNullOrEmpty(calTableId)) {
            calTableId = (String)row.get("calTable.calTableId");
        }
        CmpCalTableInfo calTable = CmpCalTableFactory.getLocalInstance(ctx).getCmpCalTableInfo("where id='" + calTableId + "'");
        String cmpSchemeId = calTable.getCalScheme().getId().toString();
        CmpCalUtil.updateNewCalSchemeState(ctx, cmpSchemeId);
    }

    @Override
    protected void _delete(Context ctx, String calTableIds, Map paramMap) throws BOSException, EASBizException {
        List rowData = (List)paramMap.get("rowData");
        this.updateLog(ctx, rowData);
        String colModel = (String)paramMap.get("colModel");
        StringBuffer deleteSql = new StringBuffer();
        deleteSql.append("delete from t_hr_scalresultedited where fcmpcaltableid in(");
        deleteSql.append(calTableIds);
        deleteSql.append(")");
        DbUtil.execute((Context)ctx, (String)deleteSql.toString());
        if (null != colModel) {
            this.afterDelete(ctx, calTableIds, colModel);
        }
    }

    @Override
    protected List _getEditedItems(Context ctx, String calTableIds) throws BOSException, EASBizException {
        calTableIds = StringEscapeUtils.escapeSql((String)calTableIds);
        ArrayList editedItemList = new ArrayList();
        StringBuffer cmpCalTableIdsWithQuotes = new StringBuffer();
        for (String id : calTableIds.split(",")) {
            if (cmpCalTableIdsWithQuotes.length() > 0) {
                cmpCalTableIdsWithQuotes.append(",");
            }
            cmpCalTableIdsWithQuotes.append("'" + id.trim() + "'");
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select * from t_hr_scalresultedited");
        sql.append(" where fcmpcaltableid in(");
        sql.append(cmpCalTableIdsWithQuotes);
        sql.append(")");
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rowSet.next()) {
                ResultSetMetaData metaData = rowSet.getMetaData();
                for (int i = 1; i < metaData.getColumnCount() + 1; ++i) {
                    Object value;
                    String columnName = metaData.getColumnName(i);
                    if (!columnName.matches("[sS]\\d{1,}") || (value = rowSet.getObject(columnName)) == null || value.toString().trim().length() <= 0) continue;
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("calTable.calTableId", rowSet.getObject("FCMPCALTABLEID"));
                    map.put("field", "cmp_ctb." + columnName.toLowerCase(Locale.ENGLISH));
                    editedItemList.add(map);
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return editedItemList;
    }

    @Override
    protected void _alterColumn(Context ctx, int fieldsn, int dataDot) throws BOSException, EASBizException {
        StringBuffer alterSql = new StringBuffer();
        alterSql.append("if exists(select * from KSQL_USERCOLUMNS");
        alterSql.append(" where KSQL_COL_NAME='S" + fieldsn + "'");
        alterSql.append(" and KSQL_COL_TABNAME='t_hr_scalresultedited')");
        alterSql.append(" begin");
        alterSql.append(" alter table t_hr_scalresultedited add col_bak numeric(20," + dataDot + ")");
        alterSql.append(" update t_hr_scalresultedited set col_bak = S" + fieldsn);
        alterSql.append(" alter table t_hr_scalresultedited drop column S" + fieldsn);
        alterSql.append(" alter table t_hr_scalresultedited add S" + fieldsn + " numeric(20," + dataDot + ")");
        alterSql.append(" update t_hr_scalresultedited set S" + fieldsn + "=col_bak");
        alterSql.append(" alter table t_hr_scalresultedited drop column col_bak");
        alterSql.append(" end");
        DbUtil.execute((Context)ctx, (String)alterSql.toString());
    }

    private String getCmpItemsWithoutPrefix(String columnModel) {
        String[] columns;
        StringBuffer cmpItems = new StringBuffer();
        for (String col : columns = columnModel.split(",")) {
            if (!(col = col.split("\\.")[1]).matches("s\\d{1,}")) continue;
            if (cmpItems.length() > 0) {
                cmpItems.append("," + col.trim());
                continue;
            }
            cmpItems.append(col.trim());
        }
        return cmpItems.toString();
    }

    private String assembleFilterSql(String filter, Context ctx) {
        if (StringUtil.isEmptyString((String)filter)) {
            return null;
        }
        String l = LocaleUtils.getShortCode((Context)ctx);
        filter = filter.replaceAll("\\(", "");
        filter = filter.replaceAll("\\)", "");
        StringBuffer filterSql = new StringBuffer();
        for (String filterItem : filter.split(" and ")) {
            filterSql.append(" and ( ");
            if (filterItem.contains("number")) {
                filterSql.append(filterItem.replace(filterItem.split("  ")[0], "person.fnumber"));
            } else if (filterItem.contains("name")) {
                filterSql.append(filterItem.replace(filterItem.split("  ")[0], "person.fname_" + l + ""));
            }
            filterSql.append(") ");
        }
        return filterSql.toString();
    }

    private String assembleOrderSql(String sorter, String sord, Context ctx) {
        if (StringUtil.isEmptyString((String)sorter) || StringUtil.isEmptyString((String)sord)) {
            return null;
        }
        String l = LocaleUtils.getShortCode((Context)ctx);
        String sorterItem = null;
        sorterItem = sorter.contains("personNumber") ? "person.fnumber" : (sorter.contains("personName") ? "person.fname_" + l + "" : sorter.split("\\.")[1].toUpperCase(Locale.ENGLISH));
        StringBuffer sql = new StringBuffer();
        sql.append(" order by ");
        sql.append(sorterItem);
        sql.append(" ");
        sql.append(sord);
        return sql.toString();
    }

    private String assembleCalTableSelector(String cmpItemStrWithoutPrefix, Context ctx) {
        StringBuffer selectStr = new StringBuffer();
        String l = LocaleUtils.getShortCode((Context)ctx);
        selectStr.append("t.fid calTableId");
        selectStr.append(",person.fname_" + l + " personName");
        selectStr.append(",person.fnumber personNumber");
        if (cmpItemStrWithoutPrefix != null && cmpItemStrWithoutPrefix.length() > 0) {
            selectStr.append("," + cmpItemStrWithoutPrefix);
        }
        return selectStr.toString();
    }

    private String assembleResultEditedSelector(String cmpItemsStr) {
        StringBuffer selector = new StringBuffer();
        selector.append("caltable.fid calTableId");
        if (cmpItemsStr != null && cmpItemsStr.length() > 0) {
            String[] cmpItems;
            for (String item : cmpItems = cmpItemsStr.split(",")) {
                selector.append(",edited.");
                selector.append(item);
                selector.append(" " + item);
            }
        }
        return selector.toString();
    }

    private void afterDelete(Context ctx, String calTableIds, String colModel) throws BOSException {
        StringBuffer setSql = new StringBuffer();
        for (String col : colModel.split(",")) {
            String field = col.split("\\.")[1];
            if (!field.matches("s\\d{1,}")) continue;
            setSql.append("," + field + "=null");
        }
        if (setSql.length() == 0) {
            return;
        }
        StringBuffer updateSql = new StringBuffer();
        updateSql.append("update t_hr_scmpcaltable");
        updateSql.append(" set fcalstate=1,");
        updateSql.append(" FCalTaxDataState = case ");
        updateSql.append(" when FCalTaxDataState = 1 then 3 ");
        updateSql.append(" when FCalTaxDataState = 2 then 3 ");
        updateSql.append(" when FCalTaxDataState in (3,4) then 3 ");
        updateSql.append(" when FCalTaxDataState = 5 then 3 ");
        updateSql.append(" else 0 end");
        updateSql.append(setSql);
        updateSql.append(" where fid in(");
        updateSql.append(calTableIds);
        updateSql.append(") and FIsNotNeedCal = 0");
        DbUtil.execute((Context)ctx, (String)updateSql.toString());
    }

    private Map<String, String> assembleDataTypeMap(List colModel) {
        HashMap<String, String> dataTypeMap = new HashMap<String, String>();
        for (int i = 1; i < colModel.size(); ++i) {
            Map col = (Map)colModel.get(i);
            String fieldsn = col.get("name").toString().split("\\.")[1];
            if (!fieldsn.matches("s\\d{1,}")) continue;
            String dataType = (String)col.get("dataType");
            dataType = StringUtils.isEmpty((String)dataType) ? (String)col.get("type") : dataType;
            dataTypeMap.put(fieldsn, dataType);
        }
        return dataTypeMap;
    }

    private String getUpdateCalResultEditedSql(Context ctx, Map<String, Object> row, Map<String, String> dataTypeMap) throws BOSException {
        String calTableId = (String)row.get("id");
        if (CmpStrUtil.isNullOrEmpty(calTableId)) {
            calTableId = (String)row.get("calTable.calTableId");
        }
        StringBuffer updateSql = new StringBuffer();
        String nowDate = new SimpleDateFormat("yyyy-MM-dd").format(new Date());
        updateSql.append("update t_hr_scalresultedited set flastupdatetime={ts'" + nowDate + "'} ");
        StringBuffer valueSql = new StringBuffer();
        Set<Map.Entry<String, Object>> set = row.entrySet();
        for (Map.Entry<String, Object> entry : set) {
            String field;
            String key = entry.getKey();
            if (key.indexOf(".") == -1 || !(field = key.split("\\.")[1]).matches("s\\d{1,}")) continue;
            Object value = null;
            if (dataTypeMap.get(field).equals("number")) {
                value = entry.getValue();
                value = "".equals(value.toString()) ? null : new BigDecimal(value.toString()).toPlainString();
            } else if (dataTypeMap.get(field).equals("string")) {
                value = StringEscapeUtils.escapeSql((String)entry.getValue().toString());
                value = "'" + value + "'";
            }
            valueSql.append("," + field.toUpperCase(Locale.ENGLISH) + "=" + (null == value ? "null" : value));
        }
        updateSql.append(valueSql);
        updateSql.append(" where fcmpcaltableid='");
        updateSql.append(calTableId);
        updateSql.append("'");
        return updateSql.toString();
    }

    private void saveCalResultEdited(Context ctx, List<Map<String, Object>> rows, Map<String, String> dataTypeMap) throws EASBizException, BOSException {
        int size = rows.size();
        Object[] sqls = new String[size];
        String calId = "";
        for (int i = 0; i < size; ++i) {
            boolean exits;
            Map<String, Object> row = rows.get(i);
            calId = (String)row.get("id");
            if (CmpStrUtil.isNullOrEmpty(calId)) {
                calId = (String)row.get("calTable.calTableId");
            }
            sqls[i] = (exits = CalResultEditedFactory.getLocalInstance(ctx).exists("where cmpCalTable.id='" + calId + "'")) ? this.getUpdateCalResultEditedSql(ctx, row, dataTypeMap) : this.getInsertCalResultEditedSql(ctx, row, dataTypeMap);
        }
        CmpSQLUtil.executeBatchSql(ctx, sqls);
    }

    private String getInsertCalResultEditedSql(Context ctx, Map<String, Object> row, Map<String, String> dataTypeMap) throws BOSException {
        StringBuffer insertSql = new StringBuffer();
        insertSql.append("insert into t_hr_scalresultedited (");
        insertSql.append(" fid,fcmpcaltableid");
        StringBuffer valueSql = new StringBuffer();
        valueSql.append(" values(");
        BOSObjectType type = new BOSObjectType("7BD34EB2");
        BOSUuid id = BOSUuid.create((BOSObjectType)type);
        valueSql.append("'" + id + "'");
        String calTableId = (String)row.get("id");
        if (CmpStrUtil.isNullOrEmpty(calTableId)) {
            calTableId = (String)row.get("calTable.calTableId");
        }
        valueSql.append(",'" + calTableId + "'");
        Set<Map.Entry<String, Object>> set = row.entrySet();
        for (Map.Entry<String, Object> entry : set) {
            String field;
            String key = entry.getKey();
            if (key.indexOf(".") == -1 || !(field = key.split("\\.")[1]).matches("s\\d{1,}")) continue;
            insertSql.append("," + field.toUpperCase(Locale.ENGLISH));
            String value = null;
            if (dataTypeMap.get(field).equals("number")) {
                value = "".equals(entry.getValue()) ? null : new BigDecimal(entry.getValue().toString()).toPlainString();
            } else {
                value = StringEscapeUtils.escapeSql((String)entry.getValue().toString());
                value = "'" + value + "'";
            }
            valueSql.append("," + (null == value ? "null" : value));
        }
        insertSql.append(")");
        valueSql.append(")");
        insertSql.append(valueSql);
        return insertSql.toString();
    }

    private void updateLog(Context ctx, List changeRowData) throws EASBizException, BOSException {
        CoreBaseCollection coll = new CoreBaseCollection();
        for (int i = 0; i < changeRowData.size(); ++i) {
            Map row = (Map)changeRowData.get(i);
            String calTableId = (String)row.get("id");
            if (CmpStrUtil.isNullOrEmpty(calTableId)) {
                calTableId = (String)row.get("calTable.calTableId");
            }
            CmpCalTableInfo calTable = CmpCalTableFactory.getLocalInstance(ctx).getCmpCalTableInfo("where id='" + calTableId + "'");
            Set set = row.entrySet();
            for (Map.Entry entry : set) {
                String key = (String)entry.getKey();
                if (key.indexOf(".") == -1 || !key.split("\\.")[1].matches("s\\d{1,}")) continue;
                CalResultEditedLogInfo entity = new CalResultEditedLogInfo();
                String itemFieldSn = key.split("\\.")[1].substring(1);
                CmpItemInfo item = CmpItemFactory.getLocalInstance(ctx).getCmpItemInfo("where fieldSn='" + itemFieldSn + "'");
                entity.setItemNameHis(item.getName());
                entity.setCmpItem(item);
                StringBuffer sql = new StringBuffer();
                sql.append("select S" + itemFieldSn);
                sql.append(" from t_hr_scmpcaltable");
                sql.append(" where fid = '");
                sql.append(calTableId);
                sql.append("'");
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                String preValue = "";
                try {
                    while (rowSet.next()) {
                        Object objectValue = rowSet.getObject("S" + itemFieldSn);
                        if (objectValue != null) {
                            preValue = objectValue.toString();
                            preValue = this.setPrecision(ctx, preValue, itemFieldSn);
                        }
                        entity.setPreValue(preValue);
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                Object value = row.get(key);
                String newValue = value instanceof Double ? Double.toString((Double)value) : (String)value;
                newValue = this.setPrecision(ctx, newValue, itemFieldSn);
                if (newValue.equals(preValue)) continue;
                entity.setNewValue(newValue);
                entity.setCalScheme(calTable.getCalScheme());
                entity.setPerson(calTable.getPerson());
                entity.setPeriodYear(calTable.getPeriodYear());
                entity.setPeriodMonth(calTable.getPeriodMonth());
                entity.setCalTime(calTable.getCalTime());
                coll.add((CoreBaseInfo)entity);
            }
        }
        CalResultEditedLogFactory.getLocalInstance(ctx).save(coll);
    }

    private void updateCalTable(Context ctx, List allData) throws BOSException, EASBizException {
        ArrayList<String> sqls = new ArrayList<String>();
        StringBuilder sql = null;
        for (int i = 0; i < allData.size(); ++i) {
            sql = new StringBuilder("update t_hr_scmpcaltable set fcalstate=1,");
            sql.append(" FCalTaxDataState = case ");
            sql.append(" when FCalTaxDataState = 1 then 3 ");
            sql.append(" when FCalTaxDataState = 2 then 3 ");
            sql.append(" when FCalTaxDataState in (3,4) then 3 ");
            sql.append(" when FCalTaxDataState = 5 then 3 ");
            sql.append(" else 0 end");
            Map row = (Map)allData.get(i);
            Set set = row.entrySet();
            for (Map.Entry entry : set) {
                String field;
                String key = (String)entry.getKey();
                if (key.split("\\.").length < 2 || !(field = key.split("\\.")[1]).matches("s\\d{1,}")) continue;
                sql.append("," + field.toUpperCase(Locale.ENGLISH) + "=");
                Object value = null;
                if (!entry.getValue().toString().equals("")) {
                    value = entry.getValue();
                    value = this.setPrecision(ctx, value.toString(), field.substring(1));
                    value = StringEscapeUtils.escapeSql((String)value.toString());
                }
                if (this.getCmpItemInfo(ctx, Integer.valueOf(field.substring(1))).getDataType().equals((Object)CmpItemDataType.STRING)) {
                    if (value == null) {
                        sql.append("''");
                        continue;
                    }
                    sql.append("'" + value + "'");
                    continue;
                }
                sql.append(value);
            }
            String calTableId = (String)row.get("calTable.calTableId");
            if (CmpStrUtil.isEmpty(calTableId)) {
                calTableId = (String)row.get("id");
            }
            if (StringUtils.isEmpty((String)calTableId)) continue;
            sql.append(" where fid='" + calTableId + "'");
            sqls.add(sql.toString());
        }
        CmpSQLUtil.executeBatchSql(ctx, sqls.toArray(new String[sqls.size()]));
    }

    private CmpItemInfo getCmpItemInfo(Context ctx, int cmpItemFieldSn) {
        ICmpCacheSevice cacheService = CacheServiceManager.getCmpCacheServiceInstance();
        CmpItemInfo cmpItem = (CmpItemInfo)cacheService.get("getCmpItemInfo_" + cmpItemFieldSn);
        if (cmpItem == null) {
            try {
                cmpItem = CmpItemFactory.getLocalInstance(ctx).getCmpItemInfo("where fieldSn=" + cmpItemFieldSn);
                cacheService.put("getCmpItemInfo_" + cmpItemFieldSn, cmpItem);
                return cmpItem;
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
        return cmpItem;
    }

    private String setPrecision(Context ctx, String stringValue, String itemFieldSn) throws EASBizException, BOSException {
        CmpItemInfo item = this.getCmpItemInfo(ctx, Integer.valueOf(itemFieldSn));
        if (item.getDataType() == CmpItemDataType.STRING) {
            return stringValue;
        }
        if (StringUtils.isEmpty((String)stringValue)) {
            return stringValue;
        }
        String newValue = null;
        if (stringValue.contains("0E-")) {
            stringValue = "0";
        }
        int dataDot = item.getDataDot().getValue();
        newValue = FunctionTools.getRound(dataDot, new BigDecimal(stringValue).doubleValue());
        return newValue;
    }

    private List<Map<String, Object>> sortDatas(String cmpCalTableIds, List<Map<String, Object>> datas) {
        if (cmpCalTableIds == null || cmpCalTableIds.equals("")) {
            return datas;
        }
        ArrayList<Map<String, Object>> newDatas = new ArrayList<Map<String, Object>>();
        String[] idArr = cmpCalTableIds.split(",");
        block0: for (int i = 0; i < idArr.length; ++i) {
            for (int j = 0; j < datas.size(); ++j) {
                if (!idArr[i].equals(datas.get(j).get("calTable.calTableId"))) continue;
                newDatas.add(datas.get(j));
                continue block0;
            }
        }
        return newDatas;
    }

    @Override
    protected String _getTemplatePath(Context ctx, String calSchemeId) throws BOSException {
        try {
            List itemList = this._assembleItemEditableColumns(ctx, calSchemeId);
            XSSFWorkbook wb = this.initWorkBook(ctx);
            this.initColModel(wb, itemList, ctx);
            String path = this.doGetTemplatePath(wb);
            return path;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private XSSFWorkbook initWorkBook(Context ctx) {
        XSSFWorkbook wb = new XSSFWorkbook();
        XSSFSheet sheet = wb.createSheet("template");
        XSSFRow row = null;
        Cell cell = null;
        row = sheet.createRow(0);
        cell = row.createCell(0);
        cell.setCellValue(EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpImportDynResource", (String)"label32", (Locale)ctx.getLocale()) + "\uff1a\r\n" + EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpImportDynResource", (String)"label33", (Locale)ctx.getLocale()) + "\r\n" + EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpImportDynResource", (String)"label34", (Locale)ctx.getLocale()) + "\uff1aYYYY-MM-DD,2014-10-16\r\n" + EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpImportDynResource", (String)"label35", (Locale)ctx.getLocale()) + "10000," + EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpImportDynResource", (String)"label36", (Locale)ctx.getLocale()) + "10,000\u3002" + EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpImportDynResource", (String)"label37", (Locale)ctx.getLocale()));
        XSSFCellStyle cellStyle = wb.createCellStyle();
        cellStyle.setWrapText(true);
        cell.setCellStyle((CellStyle)cellStyle);
        row.setHeight((short)2800);
        return wb;
    }

    private void initColModel(XSSFWorkbook wb, List<Map<String, Object>> itemList, Context ctx) {
        XSSFSheet sheet = wb.getSheet("template");
        sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, 3 + itemList.size() - 1));
        Map<String, CellStyle> styles = CmpExcelUtil.createStyles((Workbook)wb);
        CellStyle textStyle = styles.get("bodyText");
        sheet.setDefaultColumnStyle(0, textStyle);
        XSSFRow row = sheet.createRow(1);
        row.setHeight((short)400);
        Cell cell = row.createCell(0);
        String personName = EASResource.getString((String)"com.kingdee.shr.compensation.resource.CalPersonResource", (String)"personName", (Locale)ctx.getLocale());
        String personNumber = EASResource.getString((String)"com.kingdee.shr.compensation.resource.CalPersonResource", (String)"personNumber", (Locale)ctx.getLocale());
        cell.setCellValue(personNumber);
        cell.setCellStyle(styles.get("mustInputHead"));
        cell = row.createCell(1);
        cell.setCellValue(personName);
        cell.setCellStyle(styles.get("mustInputHead"));
        int itemCount = 0;
        for (Map<String, Object> cmpItem : itemList) {
            if (itemCount >= 250) break;
            cell = row.createCell(2 + itemCount++);
            cell.setCellValue((String)cmpItem.get("label"));
            cell.setCellStyle(styles.get("head"));
        }
        for (int i = 0; i < 2 + itemCount; ++i) {
            sheet.setColumnWidth(i, 4000);
        }
    }

    private String doGetTemplatePath(XSSFWorkbook wb) throws Exception {
        File file = new File(SHRCheck.checkFilePath((String)CmpConstants.TEMP_DIR));
        if (!file.exists()) {
            file.mkdirs();
        }
        String path = CmpConstants.TEMP_DIR + UUID.randomUUID() + ".xlsx";
        FileOutputStream out = new FileOutputStream(SHRCheck.checkFilePath((String)path));
        wb.write((OutputStream)out);
        out.close();
        return path;
    }

    @Override
    protected Map _importData(Context ctx, Closeable workbook, String calSchemeId) throws BOSException {
        try {
            String field;
            Workbook wb;
            Sheet sheet;
            int size;
            HashMap<Integer, String> errorMap = new HashMap<Integer, String>();
            this.initAllCalPerson(ctx, calSchemeId);
            if (this.allCalPerson == null) {
                errorMap.put(1, EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpCalLockResource", (String)"label33", (Locale)ctx.getLocale()) + "!");
            }
            if ((size = (sheet = (wb = (Workbook)workbook).getSheetAt(0)).getPhysicalNumberOfRows()) == 2) {
                errorMap.put(1, EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpCalLockResource", (String)"label34", (Locale)ctx.getLocale()) + "!");
            }
            Row fieldRow = sheet.getRow(1);
            int colNum = fieldRow.getPhysicalNumberOfCells();
            List itemColModelList = this._assembleItemEditableColumns(ctx, calSchemeId);
            HashMap<String, String> itemMap = new HashMap<String, String>();
            for (Map item : itemColModelList) {
                String itemName = (String)item.get("label");
                itemMap.put(itemName, itemName);
            }
            ArrayList<String> fields = new ArrayList<String>();
            HashMap<String, String> dataTypeMap = new HashMap<String, String>();
            String personNameResource = EASResource.getString((String)"com.kingdee.shr.compensation.resource.CalPersonResource", (String)"personName", (Locale)ctx.getLocale());
            String personNumberResource = EASResource.getString((String)"com.kingdee.shr.compensation.resource.CalPersonResource", (String)"personNumber", (Locale)ctx.getLocale());
            String check = EASResource.getString((String)"com.kingdee.shr.compensation.resource.CalPersonResource", (String)"check", (Locale)ctx.getLocale());
            for (int i = 0; i < colNum && !StringUtils.isEmpty((String)(field = (String)CmpExcelUtil.getCellValue(fieldRow.getCell(i)))); ++i) {
                if (field.equals(personNumberResource)) {
                    if (fields.contains("number")) {
                        errorMap.put(1, EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpCalLockResource", (String)"label36", (Locale)ctx.getLocale()) + ":\"" + field + "\"" + EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpCalLockResource", (String)"label37", (Locale)ctx.getLocale()));
                        break;
                    }
                    fields.add("number");
                    continue;
                }
                if (field.equals(personNameResource)) {
                    if (fields.contains("name")) {
                        errorMap.put(1, EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpCalLockResource", (String)"label36", (Locale)ctx.getLocale()) + ":\"" + field + "\"" + EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpCalLockResource", (String)"label37", (Locale)ctx.getLocale()));
                        break;
                    }
                    fields.add("name");
                    continue;
                }
                if (field.equals(check)) continue;
                boolean invalid = true;
                for (int j = 0; j < itemColModelList.size(); ++j) {
                    Map colModel = (Map)itemColModelList.get(j);
                    if (fields.contains(colModel.get("name"))) {
                        errorMap.put(1, EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpCalLockResource", (String)"label36", (Locale)ctx.getLocale()) + ":\"" + field + "\"" + EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpCalLockResource", (String)"label37", (Locale)ctx.getLocale()));
                        invalid = false;
                        break;
                    }
                    if (!colModel.get("label").equals(field)) continue;
                    String itemName = colModel.get("name").toString();
                    String dataType = colModel.get("type").toString();
                    dataTypeMap.put(itemName.split("\\.")[1], dataType);
                    fields.add(itemName);
                    itemColModelList.remove(j);
                    invalid = false;
                    break;
                }
                if (!invalid) continue;
                errorMap.put(1, EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpCalLockResource", (String)"label40", (Locale)ctx.getLocale()) + ":\"" + field + "\"" + EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpCalLockResource", (String)"label41", (Locale)ctx.getLocale()));
                break;
            }
            colNum = fields.size();
            if (errorMap.size() == 0) {
                ArrayList<Map<String, Object>> rowList = new ArrayList<Map<String, Object>>();
                for (int i = 2; i < size; ++i) {
                    HashMap<String, Object> row = new HashMap<String, Object>();
                    Row dataRow = sheet.getRow(i);
                    String personNumber = null;
                    for (int j = 0; j < colNum; ++j) {
                        Object cellValue = CmpExcelUtil.getCellValue(dataRow.getCell(j));
                        if (((String)fields.get(j)).equals("number")) {
                            String calTableId = this.getCalTableIdByNumber((String)cellValue);
                            if (calTableId == null) {
                                errorMap.put(i, EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpCalLockResource", (String)"label35", (Locale)ctx.getLocale()) + cellValue + EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpCalLockResource", (String)"label42", (Locale)ctx.getLocale()));
                                break;
                            }
                            personNumber = (String)cellValue;
                            row.put("calTable.calTableId", calTableId);
                        } else if (((String)fields.get(j)).equals("name")) {
                            String personName = this.getPersonNameByNumber(personNumber);
                            if (personName == null || !personName.equals(cellValue)) {
                                errorMap.put(i, EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpCalLockResource", (String)"label39", (Locale)ctx.getLocale()) + cellValue + EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpCalLockResource", (String)"label42", (Locale)ctx.getLocale()));
                                break;
                            }
                        } else if (!((String)fields.get(j)).equals("name") && !cellValue.equals("")) {
                            String fieldSn = ((String)fields.get(j)).split("\\.")[1];
                            if (((String)dataTypeMap.get(fieldSn)).equals("number") && !cellValue.equals("") && !((String)cellValue).matches("^(-?[1-9](\\d+)?|0)(\\.\\d+)?$")) {
                                errorMap.put(i, EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpCalLockResource", (String)"label43", (Locale)ctx.getLocale()) + (j + 1) + EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpCalLockResource", (String)"label44", (Locale)ctx.getLocale()));
                                break;
                            }
                            row.put((String)fields.get(j), cellValue);
                        }
                        if (this.getCalStateByNumber(personNumber) < 8) continue;
                        errorMap.put(i, EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpCalLockResource", (String)"label32", (Locale)ctx.getLocale()));
                        break;
                    }
                    rowList.add(row);
                }
                if (errorMap.size() == 0) {
                    this.saveCalResultEdited(ctx, rowList, dataTypeMap);
                    this.updateLog(ctx, rowList);
                    this.updateCalTable(ctx, rowList);
                }
            }
            HashMap<String, Object> retMap = new HashMap<String, Object>();
            if (errorMap.size() == 0) {
                retMap.put("errorPath", "");
            } else {
                String errorPath = this.writeErrMsgToFile(wb, errorMap, ctx);
                retMap.put("errorPath", errorPath);
            }
            retMap.put("allDataInvFlag", false);
            retMap.put("result", "success");
            return retMap;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private String getCalTableIdByNumber(String number) {
        String[] calTableIdAndName;
        if (this.allCalPerson != null && (calTableIdAndName = this.allCalPerson.get(number)) != null) {
            return calTableIdAndName[0];
        }
        return null;
    }

    private String getPersonNameByNumber(String number) {
        String[] calTableIdAndName;
        if (this.allCalPerson != null && (calTableIdAndName = this.allCalPerson.get(number)) != null) {
            return calTableIdAndName[1];
        }
        return null;
    }

    private Integer getCalStateByNumber(String number) {
        String[] calTableIdAndName;
        if (this.allCalPerson != null && (calTableIdAndName = this.allCalPerson.get(number)) != null) {
            return Integer.valueOf(calTableIdAndName[2]);
        }
        return null;
    }

    private void initAllCalPerson(Context ctx, String calSchemeId) throws EASBizException {
        try {
            this.allCalPerson = new HashMap<String, String[]>();
            String l = LocaleUtils.getShortCode((Context)ctx);
            CalSchemeInfo calschemeInfo = CalSchemeFactory.getLocalInstance(ctx).getCalSchemeInfo("where id='" + calSchemeId + "'");
            String endDate = calschemeInfo.getEndDate().toString();
            StringBuffer sql = new StringBuffer();
            sql.append("select person.fnumber,calTable.fid,person.fname_" + l + ",calTable.fcalstate from t_hr_scmpcaltable calTable");
            sql.append(" inner join t_hr_scalscheme scheme");
            sql.append(" on calTable.fcalschemeid = scheme.fid");
            sql.append(" and calTable.fcaltime = scheme.fcaltime");
            sql.append(" and calTable.fperiodyear = scheme.fperiodyear");
            sql.append(" and calTable.fperiodmonth = scheme.fperiodmonth");
            sql.append(" inner join (select his.* from T_BD_PersonHis as his");
            sql.append(" inner join (select max(T_BD_PersonHis.FEffdt) as FEffdt,T_BD_PersonHis.FhistoryRelateID");
            sql.append(" from T_BD_PersonHis");
            sql.append(" where T_BD_PersonHis.FEffdt <= {ts '" + endDate + "' }");
            sql.append(" group by FhistoryRelateID) as maxHis");
            sql.append(" on his.FhistoryRelateID = maxHis.FhistoryRelateID");
            sql.append(" and his.FEffdt = maxHis.FEffdt) AS person");
            sql.append(" on person.FhistoryRelateID = calTable.fpersonid");
            sql.append(" where scheme.fid ='" + calSchemeId + "'");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rowSet.next()) {
                String personNumber = rowSet.getString(1);
                String calTableId = rowSet.getString(2);
                String personName = rowSet.getString(3);
                String calState = rowSet.getString(4);
                this.allCalPerson.put(personNumber, new String[]{calTableId, personName, calState});
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private String writeErrMsgToFile(Workbook wb, Map<Integer, String> errorMap, Context ctx) {
        Sheet sheet = wb.getSheetAt(0);
        Row head = sheet.getRow(1);
        int colNum = head.getPhysicalNumberOfCells();
        Map<String, CellStyle> styles = CmpExcelUtil.createStyles(wb);
        sheet.setColumnWidth(colNum, 7000);
        Cell reportCell = head.getCell(colNum - 1);
        String check = EASResource.getString((String)"com.kingdee.shr.compensation.resource.CalPersonResource", (String)"check", (Locale)ctx.getLocale());
        if (!check.equals(reportCell.getStringCellValue())) {
            reportCell = head.createCell(colNum);
            reportCell.setCellValue(check);
            reportCell.setCellStyle(styles.get("head"));
        } else {
            --colNum;
        }
        for (Map.Entry<Integer, String> entry : errorMap.entrySet()) {
            int errorRowIndex = entry.getKey();
            String errorMsg = entry.getValue();
            Row errorRow = sheet.getRow(errorRowIndex);
            Cell cell = errorRow.createCell(colNum);
            cell.setCellValue(errorMsg);
            cell.setCellStyle(styles.get("red"));
        }
        String errorPath = UUID.randomUUID().toString();
        try {
            FileOutputStream out = new FileOutputStream(SHRCheck.checkFilePath((String)(CmpConstants.TEMP_DIR + errorPath + ".xlsx")));
            wb.write((OutputStream)out);
            out.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return errorPath;
    }
}

