/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.basedata.hraux.StateEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.BaseItemException;
import com.kingdee.shr.compensation.CalSchemeVerificationRuleInfo;
import com.kingdee.shr.compensation.app.AbstractCalSchemeVerificationRuleControllerBean;
import com.kingdee.shr.compensation.exception.CalSchemeListException;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class CalSchemeVerificationRuleControllerBean
extends AbstractCalSchemeVerificationRuleControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.compensation.app.CalSchemeVerificationRuleControllerBean");

    @Override
    protected void _enable(Context ctx, String id) throws BOSException, EASBizException {
        ObjectUuidPK pk = new ObjectUuidPK(id);
        CalSchemeVerificationRuleInfo model = this.getCalSchemeVerificationRuleInfo(ctx, (IObjectPK)pk);
        this.doState(ctx, model, StateEnum.ENABLE);
    }

    @Override
    protected void _disable(Context ctx, String id) throws BOSException, EASBizException {
        ObjectUuidPK pk = new ObjectUuidPK(id);
        CalSchemeVerificationRuleInfo model = this.getCalSchemeVerificationRuleInfo(ctx, (IObjectPK)pk);
        this.doState(ctx, model, StateEnum.DISABLE);
    }

    private void doState(Context ctx, CalSchemeVerificationRuleInfo model, StateEnum state) throws BOSException, EASBizException {
        if (null == model) {
            throw new BaseItemException(BaseItemException.NO_SUCH_BASEITEM);
        }
        if (StateEnum.DISABLE.equals((Object)state) && !StateEnum.ENABLE.equals((Object)model.getState())) {
            throw new BaseItemException(BaseItemException.ONLY_ENABLED_CAN_DISABLE);
        }
        if (StateEnum.ENABLE.equals((Object)state) && StateEnum.ENABLE.equals((Object)model.getState())) {
            throw new BaseItemException(BaseItemException.ONLY_OTHER_CAN_ENABLE);
        }
        this.checkCanOperate(ctx, model.getId().toString(), false);
        CalSchemeVerificationRuleInfo updateModel = new CalSchemeVerificationRuleInfo();
        updateModel.setId(model.getId());
        updateModel.setState(state);
        updateModel.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
        updateModel.setLastUpdateUser(ContextUtil.getCurrentUserInfo((Context)ctx));
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("state");
        selector.add("lastUpdateUser");
        selector.add("lastUpdateTime");
        this.updatePartial(ctx, updateModel, selector);
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.checkCanOperate(ctx, pk.toString(), true);
        super._delete(ctx, pk);
    }

    private void checkCanOperate(Context ctx, String id, boolean isDel) throws BOSException, EASBizException {
        String checkSql = "select b.FCALSTATE,b.FISCANUPDATECOPY,d.fnumber,a.FSRCCALSCHEMEID,a.FSTATE  from T_HR_SCalSchemeVeriRule a  inner join T_HR_SCalScheme b on a.fcalschemeid = b.FID  left JOIN T_HR_SCalSchemeVeriRuleNodeRel c on c.FCALSCHEMEVERIFICATIONRULEID = a.fid inner join T_HR_SVerificationruleNode d on c.FVERIFICATIONRULENODEID = d.FID  where   a.fid = ? ";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)checkSql, (Object[])new Object[]{id});
        try {
            while (rowSet.next()) {
                int fstate = rowSet.getInt("FSTATE");
                if (2 == fstate && isDel) continue;
                int fcalstate = rowSet.getInt("FCALSTATE");
                String fnumber = rowSet.getString("fnumber");
                boolean iscanupdatecopy = rowSet.getBoolean("FISCANUPDATECOPY");
                String fsrccalschemeid = rowSet.getString("FSRCCALSCHEMEID");
                if (!iscanupdatecopy && !StringUtils.isEmpty((CharSequence)fsrccalschemeid)) {
                    throw new CalSchemeListException(CalSchemeListException.EXCEPTION28);
                }
                if (fcalstate != 6 && fcalstate != 8 || !"Compensation-Calculation".equals(fnumber)) continue;
                throw new CalSchemeListException(CalSchemeListException.EXCEPTION26);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }
}

