/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.hraux.StateEnum;
import com.kingdee.eas.basedata.org.HROrgUnitCollection;
import com.kingdee.eas.basedata.org.HROrgUnitFactory;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.compensation.CmpAgentPayBillSchemeCollection;
import com.kingdee.shr.compensation.CmpAgentPayBillSchemeFactory;
import com.kingdee.shr.compensation.CmpAgentPayBillSchemeInfo;
import com.kingdee.shr.compensation.app.AbstractCmpAgentPayBillSchemeControllerBean;
import com.kingdee.shr.compensation.util.CmpSQLUtil;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import com.kingdee.shr.compensation.util.MappingTableUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class CmpAgentPayBillSchemeControllerBean
extends AbstractCmpAgentPayBillSchemeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.compensation.app.CmpAgentPayBillSchemeControllerBean");
    private static Map<String, CmpAgentPayBillSchemeInfo> hrOrg2Scheme = new HashMap<String, CmpAgentPayBillSchemeInfo>();
    private static Map<String, HROrgUnitInfo> hrOrgMap = new HashMap<String, HROrgUnitInfo>();
    private static final String TABLE_NAME = "T_HR_SOrgAgentPaySchemeMapping";
    private static final String SCHEME_TYPE = "FSchemeID";

    @Override
    protected String _createHrPaySchemeMapping(Context ctx, Map params) throws BOSException, EASBizException {
        CmpAgentPayBillSchemeInfo scheme = (CmpAgentPayBillSchemeInfo)params.get("scheme");
        if (scheme.getCalScheme() != null) {
            return null;
        }
        try {
            String hrOrgId = scheme.getHrOrgUnit().getId().toString();
            boolean includeSub = scheme.isIncludeSub();
            Integer includeSub_int = includeSub ? 1 : 0;
            String mappingTableId = scheme.getId().toString();
            String longNumber = scheme.getHrOrgUnit().getLongNumber();
            String type = params.get("type").toString();
            String sql = null;
            String parentHrOrgId = null;
            String parentMappingTableId = null;
            String parentLongNumber = MappingTableUtils.getMaxParentNumber(ctx, TABLE_NAME, hrOrgId, 1);
            if (CmpStrUtil.isNotEmpty(parentLongNumber)) {
                sql = "select FHrOrgID, FSchemeID from T_HR_SOrgAgentPaySchemeMapping where FLongNumber = '" + parentLongNumber + "'";
                IRowSet rs = CmpSQLUtil.executeQuery(ctx, sql);
                while (rs.next()) {
                    parentHrOrgId = rs.getString("FHrOrgID");
                    parentMappingTableId = rs.getString(SCHEME_TYPE);
                }
            }
            if ("enable".equals(type)) {
                MappingTableUtils.dealOwnData(ctx, TABLE_NAME, mappingTableId, hrOrgId, longNumber, includeSub_int, SCHEME_TYPE);
                if (includeSub) {
                    sql = MappingTableUtils.getInsertSql(TABLE_NAME, mappingTableId, hrOrgId, longNumber, true, SCHEME_TYPE);
                    CmpSQLUtil.execute(ctx, sql);
                    if (!CmpStrUtil.isEmpty(parentLongNumber)) {
                        sql = MappingTableUtils.getUpdateSql(TABLE_NAME, mappingTableId, hrOrgId, parentHrOrgId, longNumber, true, SCHEME_TYPE);
                        CmpSQLUtil.execute(ctx, sql);
                    }
                }
            } else if (CmpStrUtil.isEmpty(parentLongNumber)) {
                sql = "delete from T_HR_SOrgAgentPaySchemeMapping where FUseHr = '" + hrOrgId + "'";
                CmpSQLUtil.execute(ctx, sql);
            } else {
                sql = MappingTableUtils.getUpdateSql(TABLE_NAME, parentMappingTableId, parentHrOrgId, hrOrgId, longNumber, true, SCHEME_TYPE);
                CmpSQLUtil.execute(ctx, sql);
            }
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    @Override
    protected void _initAgentPayBillSchemeMapping(Context ctx) throws BOSException, EASBizException {
        logger.info((Object)("initAgentPayBillSchemeMapping " + new Date()));
        this.initHrOrgUnit(ctx);
        hrOrg2Scheme.clear();
        String deleteSql = "delete from T_HR_SOrgAgentPaySchemeMapping";
        CmpSQLUtil.execute(ctx, deleteSql);
        this.getScheme(ctx);
        this.buildHrOrg2Scheme(ctx);
        ArrayList<Object[]> bankParams = new ArrayList<Object[]>();
        String insertSql = "insert into T_HR_SOrgAgentPaySchemeMapping (FHrorgID, FSchemeID, FUseHr, FIncludeSub, FLongNumber) values (?,?,?,?,?)";
        Iterator<String> it = hrOrg2Scheme.keySet().iterator();
        while (it.hasNext()) {
            Object[] batchParam = new Object[5];
            String orgId = it.next();
            String schemeId = hrOrg2Scheme.get(orgId).getId().toString();
            String parentOrg = hrOrg2Scheme.get(orgId).getHrOrgUnit().getId().toString();
            String longNumber = hrOrgMap.get(orgId).getLongNumber();
            boolean includeSub = orgId.equals(parentOrg) && hrOrg2Scheme.get(orgId).isIncludeSub() ? Boolean.TRUE : Boolean.FALSE;
            batchParam[0] = orgId;
            batchParam[1] = schemeId;
            batchParam[2] = parentOrg;
            batchParam[3] = includeSub;
            batchParam[4] = longNumber;
            bankParams.add(batchParam);
        }
        CmpSQLUtil.executeBatch(ctx, insertSql, bankParams);
    }

    private void initHrOrgUnit(Context ctx) throws BOSException {
        HROrgUnitCollection hrOrgUnitCollection = HROrgUnitFactory.getLocalInstance((Context)ctx).getHROrgUnitCollection("select id, number, longNumber, name, parent.*");
        for (int i = 0; i < hrOrgUnitCollection.size(); ++i) {
            HROrgUnitInfo hrOrg = hrOrgUnitCollection.get(i);
            hrOrgMap.put(hrOrg.getId().toString(), hrOrg);
        }
    }

    private void getScheme(Context ctx) throws BOSException {
        CmpAgentPayBillSchemeCollection CmpAgentPayBillSchemeCollection2 = CmpAgentPayBillSchemeFactory.getLocalInstance(ctx).getCmpAgentPayBillSchemeCollection();
        for (int i = 0; i < CmpAgentPayBillSchemeCollection2.size(); ++i) {
            CmpAgentPayBillSchemeInfo scheme = CmpAgentPayBillSchemeCollection2.get(i);
            if (scheme.getHrOrgUnit() == null || scheme.getCalScheme() != null || scheme.getState() != StateEnum.ENABLE) continue;
            hrOrg2Scheme.put(scheme.getHrOrgUnit().getId().toString(), scheme);
        }
    }

    private void buildHrOrg2Scheme(Context ctx) {
        Iterator<String> iterator = hrOrgMap.keySet().iterator();
        while (iterator.hasNext()) {
            HROrgUnitInfo hrOrg = hrOrgMap.get(iterator.next());
            CmpAgentPayBillSchemeInfo scheme = hrOrg2Scheme.get(hrOrg.getId().toString());
            if (scheme != null || (scheme = this.getSchemeByParent(hrOrg)) == null) continue;
            hrOrg2Scheme.put(hrOrg.getId().toString(), scheme);
        }
    }

    private CmpAgentPayBillSchemeInfo getSchemeByParent(HROrgUnitInfo currentHrOrg) {
        CmpAgentPayBillSchemeInfo scheme = hrOrg2Scheme.get(currentHrOrg.getId().toString());
        if (scheme != null && scheme.getBoolean("includeSub")) {
            return scheme;
        }
        if (currentHrOrg.getParent() == null) {
            return null;
        }
        return this.getSchemeByParent(hrOrgMap.get(currentHrOrg.getParent().getId().toString()));
    }
}

