/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.permission.PermissionServiceException;
import com.kingdee.eas.basedata.assistant.CurrencyException;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.compensation.app.AbstractCmpCurrencyFacadeControllerBean;
import com.kingdee.shr.shrimport.SHRImportTypeEnum;
import com.kingdee.util.UuidException;
import java.sql.SQLException;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class CmpCurrencyFacadeControllerBean
extends AbstractCmpCurrencyFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.compensation.app.CmpCurrencyFacadeControllerBean");

    @Override
    protected String _addNew(Context ctx, Map params) throws BOSException {
        CoreBaseInfo model = (CoreBaseInfo)params.get("model");
        CurrencyInfo currencyInfo = (CurrencyInfo)model;
        CtrlUnitInfo cu = currencyInfo.getCU();
        ICurrency tableInfo = CurrencyFactory.getLocalInstance((Context)ctx);
        IObjectPK pk = null;
        try {
            pk = tableInfo.addnew(model);
            currencyInfo.setCU(cu);
            tableInfo.update(pk, model);
            return pk.toString();
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
        catch (PermissionServiceException e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected String _update(Context ctx, Map params) throws BOSException {
        CoreBaseInfo model = (CoreBaseInfo)params.get("model");
        CurrencyInfo currencyInfo = (CurrencyInfo)model;
        CtrlUnitInfo ctrlUnit = (CtrlUnitInfo)params.get("currentCtrlUnit");
        StringBuilder updateCUSql = new StringBuilder();
        String tempId = ctrlUnit.getId().toString();
        String currencyId = currencyInfo.getId().toString();
        updateCUSql.append("update T_BD_Currency set fcontrolunitid=? where fid = ?");
        DbUtil.execute((Context)ctx, (String)updateCUSql.toString(), (Object[])new Object[]{tempId, currencyId});
        ObjectUuidPK pk = new ObjectUuidPK(currencyId);
        ICurrency tableInfo = CurrencyFactory.getLocalInstance((Context)ctx);
        try {
            tableInfo.update((IObjectPK)pk, model);
        }
        catch (PermissionServiceException e) {
            throw new BOSException((Throwable)e);
        }
        catch (CurrencyException e) {
            throw new BOSException(e.getMessage(ctx.getLocale()));
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
        return null;
    }

    @Override
    protected String _importSubmitData(Context ctx, Map params) throws BOSException {
        CurrencyInfo currencyInfo = (CurrencyInfo)params.get("model");
        SHRImportTypeEnum importType = (SHRImportTypeEnum)params.get("importType");
        CtrlUnitInfo ctrlUnit = currencyInfo.getCU();
        String CUId = ctrlUnit.getId().toString();
        if (20 == importType.getValue() && currencyInfo.getId() != null) {
            String editPk = currencyInfo.getId().toString();
            StringBuilder queryCUSql = new StringBuilder();
            queryCUSql.append("SELECT FID, FCONTROLUNITID FROM T_BD_CURRENCY WHERE FID = ? and FCONTROLUNITID=?");
            IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)queryCUSql.toString(), (Object[])new Object[]{editPk, CUId});
            try {
                if (!iRowSet.next()) {
                    throw new BOSException(EASResource.getString((String)"com.kingdee.shr.compensation.resource.CalPersonResource", (String)"currencyError2", (Locale)ctx.getLocale()));
                }
            }
            catch (SQLException e) {
                throw new BOSException(EASResource.getString((String)"com.kingdee.shr.compensation.resource.CalPersonResource", (String)"currencyError1", (Locale)ctx.getLocale()), (Throwable)e);
            }
            CtrlUnitInfo currentCtrlUnit = (CtrlUnitInfo)params.get("currentCtrlUnit");
            String currentCUId = currentCtrlUnit.getId().toString();
            StringBuilder updateCurrencySql = new StringBuilder();
            updateCurrencySql.append("UPDATE T_BD_CURRENCY SET FCONTROLUNITID=? WHERE FID =?");
            DbUtil.execute((Context)ctx, (String)updateCurrencySql.toString(), (Object[])new Object[]{currentCUId, editPk});
        }
        ICoreBase iCoreBase = (ICoreBase)params.get("coreBase");
        try {
            IObjectPK pk = iCoreBase.save((CoreBaseInfo)currencyInfo);
            StringBuilder updateCurrencySql = new StringBuilder();
            updateCurrencySql.append("update t_bd_currency set fcontrolunitid=? where fid =?");
            DbUtil.execute((Context)ctx, (String)updateCurrencySql.toString(), (Object[])new Object[]{CUId, pk.toString()});
            return pk.toString();
        }
        catch (CurrencyException e) {
            throw new BOSException(e.getMessage(ctx.getLocale()));
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
        catch (UuidException e) {
            throw new BOSException((Throwable)e);
        }
    }
}

