/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.shr.compensation.CmpIndexAnalysisDataFactory;
import com.kingdee.shr.compensation.CmpIndexAnalysisDataInfo;
import com.kingdee.shr.compensation.CmpRptPeriodTypeEnum;
import com.kingdee.shr.compensation.app.AbstractHRSyncIndexAnalysisDataFacadeControllerBean;
import com.kingdee.shr.compensation.util.SqlUtil;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HRSyncIndexAnalysisDataFacadeControllerBean
extends AbstractHRSyncIndexAnalysisDataFacadeControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = LoggerFactory.getLogger((String)"com.kingdee.shr.compensation.app.HRSyncIndexAnalysisDataFacadeControllerBean");
    private SimpleDateFormat syncIndexDf = new SimpleDateFormat("yyyy-MM-dd");
    private Calendar cal = Calendar.getInstance();

    @Override
    protected void _syncIndexAnalysisData(Context ctx) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        int year = this.cal.get(1);
        int period = this.cal.get(2);
        String l = LocaleUtils.getShortCode((Context)ctx);
        sql.append("select T0.FIndexTypeID indexTypeID, T1.FNUMBER indexTypeNumber, T1.FUnit_" + l + " unit, T1.Factor factor, T1.FPrecision prec, ").append("T0.FIndexAnalysisID indexAnalysisID, T2.FNumber indexAnalysisNumber, T0.FOrgID financeOrgID, T0.FOrgName financeOrgName, ").append("T0.FOrgNumber financeOrgNumber, T0.FOrgLongNumber financeOrgLongNumber, T0.FDataType dataType, T0.FDataTypeName dataTypeName, T0.FAmount amount, ").append("T0.FYear year, T0.FPeriod period, T0.FPeriodType periodType, T0.FDay day, T0.FSpecialValue specialvalue ").append("from T_CSL_IndexAnalysisData T0 ").append("inner join T_CSL_IndexType T1 on T0.FIndexTypeID = T1.FID ").append("inner join T_CSL_IndexAnalysis T2 on T0.FIndexAnalysisID = T2.FID ").append("where T0.FPeriodType = 3 ").append("and T1.FNumber = 'shr-theme' and T2.FNumber = 'shr-index'");
        IRowSet rowSet = SqlUtil.executeQuery(ctx, sql.toString());
        logger.error("~~~~~~sync finance date\uff1a" + this.syncIndexDf.format(new Date()) + " sync finance count: " + rowSet.size() + "~~~~~~");
        try {
            CoreBaseCollection collection = new CoreBaseCollection();
            StringBuffer relSql = new StringBuffer();
            relSql.append("select T2.FID adminOrgID, T2.FName_" + l + " adminOrgName, T2.FNumber adminOrgNumber, T2.FLongNumber adminOrgLongNumber ").append("from T_ORG_UnitRelation T0 ").append("inner join T_ORG_TypeRelation T1 on T0.FTypeRelationID = T1.FID ").append("inner join T_ORG_Admin T2 on T0.FFromUnitID = T2.FID ").append("where T2.FIsSealUp = 0 and T0.FToUnitID = ?  and T1.FFromType = 0 and T1.FToType = 1");
            while (rowSet.next()) {
                String financeOrgID = rowSet.getString("financeOrgID");
                Object[] params = new String[]{financeOrgID};
                IRowSet adminRowSet = SqlUtil.executeQuery(ctx, relSql.toString(), params);
                if (adminRowSet.size() == 0) break;
                while (adminRowSet.next()) {
                    CmpIndexAnalysisDataInfo info = new CmpIndexAnalysisDataInfo();
                    info.setIndexTypeID(rowSet.getString("indexTypeID"));
                    info.setIndexTypeNumber(rowSet.getString("indexTypeNumber"));
                    info.setIndexTypeUnit(rowSet.getString("unit"));
                    info.setIndexTypePrecision(rowSet.getInt("prec"));
                    info.setIndexTypeFactor(rowSet.getDouble("factor"));
                    info.setIndexAnalysisID(rowSet.getString("indexAnalysisID"));
                    info.setIndexAnalysisNumber(rowSet.getString("indexAnalysisNumber"));
                    info.setFinanceOrgID(rowSet.getString("financeOrgID"));
                    info.setFinanceOrgNumber(rowSet.getString("financeOrgName"));
                    info.setFinanceOrgName(rowSet.getString("financeOrgNumber"));
                    info.setFinanceOrgLongNumber(rowSet.getString("financeOrgLongNumber"));
                    info.setAdminOrgID(adminRowSet.getString("adminOrgID"));
                    info.setAdminOrgName(adminRowSet.getString("adminOrgName"));
                    info.setAdminOrgNumber(adminRowSet.getString("adminOrgNumber"));
                    info.setAdminOrgLongNumber(adminRowSet.getString("adminOrgLongNumber"));
                    info.setDataType(rowSet.getString("dataType"));
                    info.setDataTypeName(rowSet.getString("dataTypeName"));
                    info.setAmount(rowSet.getBigDecimal("amount"));
                    info.setYear(rowSet.getInt("year"));
                    info.setPeriod(rowSet.getInt("period"));
                    info.setPeriodType(CmpRptPeriodTypeEnum.MONTHLY);
                    info.setDay(rowSet.getTimestamp("day"));
                    info.setSpecialValue(rowSet.getString("specialvalue"));
                    collection.add((CoreBaseInfo)info);
                }
            }
            CmpIndexAnalysisDataFactory.getLocalInstance(ctx).save(collection);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

