/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app.agentIntegrate;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.emp.BankInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.compensation.CmpAgentPayBillEntryCollection;
import com.kingdee.shr.compensation.CmpAgentPayBillEntryInfo;
import com.kingdee.shr.compensation.CmpAgentPayBillException;
import com.kingdee.shr.compensation.CmpAgentPayBillFactory;
import com.kingdee.shr.compensation.CmpAgentPayBillInfo;
import com.kingdee.shr.compensation.CmpItemInfo;
import com.kingdee.shr.compensation.PaymentCompany;
import com.kingdee.shr.compensation.app.agentIntegrate.AbstractCmpAgentPayBillCreating;
import com.kingdee.shr.compensation.app.agentIntegrate.CmpAgentSource;
import com.kingdee.shr.compensation.app.agentIntegrate.CmpBillStatusXKQJEnum;
import com.kingdee.shr.compensation.app.agentIntegrate.CmpITPayEnum;
import com.kingdee.shr.compensation.app.agentIntegrate.CmpITType;
import com.kingdee.shr.compensation.app.agentIntegrate.IdWorker;
import com.kingdee.shr.compensation.app.agentIntegrate.remoteCallXKQJUtil.AdminOrgMappingDTO;
import com.kingdee.shr.compensation.app.agentIntegrate.remoteCallXKQJUtil.CmpRemoteCallXKQJService;
import com.kingdee.shr.compensation.exception.PersonCmpFacadeException;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import com.kingdee.shr.compensation.util.db.CmpInSql;
import com.kingdee.shr.compensation.util.db.CmpInSqlFactory;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CmpAgentPayBillMultiCurXKQJCreating
extends AbstractCmpAgentPayBillCreating {
    private static final Logger logger = LoggerFactory.getLogger(CmpAgentPayBillMultiCurXKQJCreating.class);
    private static final String AGENT_INNER_SPLITOR = "@@";
    protected Map<String, AdminOrgMappingDTO> mappingDTOByIdMap = Maps.newHashMap();
    private String schemePayOrgId;

    @Override
    public void create(Context ctx, Map param) throws BOSException, EASBizException {
        this.initPayBillInfo(ctx, param);
        AbstractCmpAgentPayBillCreating.EntryGroups entryGroups = this.buildPayBillEntry(ctx, param);
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)entryGroups.getErrorMsg())) {
            throw new CmpAgentPayBillException(CmpAgentPayBillException.EXCEPTION12, new Object[]{entryGroups.getErrorMsg()});
        }
        if (entryGroups.getCmpEntrysGroup().isEmpty()) {
            throw new PersonCmpFacadeException(PersonCmpFacadeException.CREATEFAIL);
        }
        logger.info("#########entryGroups:" + entryGroups);
        for (Map.Entry<String, CmpAgentPayBillEntryCollection> entry : entryGroups.getCmpEntrysGroup().entrySet()) {
            String key = entry.getKey();
            CmpAgentPayBillInfo cmpPayBillInfo = this.buildCmpPayBill(ctx, param, entryGroups.getCmpItemGroup().get(key), entryGroups.getCurrencyGroup().get(key));
            this.fillCmpBillPayOrg(cmpPayBillInfo, key);
            this.fillSplitInfo(cmpPayBillInfo, key);
            cmpPayBillInfo.setBillNumIT(null);
            this.putPayBillSumAmount(cmpPayBillInfo, entryGroups, key);
            CurrencyInfo currency = new CurrencyInfo();
            currency.setId(BOSUuid.read((String)entryGroups.getCalCurrencyGroup().get(key)));
            cmpPayBillInfo.setCalCurrency(currency);
            cmpPayBillInfo.put("entry", (Object)entry.getValue());
            logger.info("#########billId:" + cmpPayBillInfo.getId());
            logger.info("#########save bill:" + cmpPayBillInfo);
            CmpAgentPayBillFactory.getLocalInstance(ctx).save((CoreBaseInfo)cmpPayBillInfo);
        }
    }

    @Override
    public void initSplitSchemeInfo(Context ctx, Map param) throws BOSException, EASBizException {
        super.initSplitSchemeInfo(ctx, param);
        if (this.hasCmpAgentPayBillSchemeInfo() && PaymentCompany.OptionalPayOrg.equals((Object)this.getCmpAgentPayBillSchemeInfoNotNull().getPaymentCompany())) {
            throw new CmpAgentPayBillException(CmpAgentPayBillException.EXCEPTION21);
        }
    }

    @Override
    protected void assembleAndGetFinOrg(Context ctx, Map param) throws BOSException, EASBizException {
        String orgId;
        this.schemePayOrgId = orgId = (String)param.get("orgId");
        List listData = (List)param.get("listData");
        ArrayList adminList = Lists.newArrayList();
        listData.forEach(a -> adminList.add((String)a.get("cmp_ctb.adminorgunit")));
        adminList.add(orgId);
        this.genHrOrgMappingMap(ctx, adminList);
        List<AdminOrgMappingDTO> adminOrgMappingDTOList = CmpRemoteCallXKQJService.getXKQJAdminOrgMapping(ctx, Lists.newArrayList(this.adminOrgId2Number.values()));
        if (adminOrgMappingDTOList == null) {
            logger.info("\u83b7\u53d6\u4ed8\u6b3e\u7ec4\u7ec7\u3001\u7ed3\u7b97\u7ec4\u7ec7\u7ed3\u679c\u4e3a\u7a7a\uff01");
            return;
        }
        Map<String, AdminOrgMappingDTO> mappingDTOByNumberMap = adminOrgMappingDTOList.stream().collect(Collectors.toMap(AdminOrgMappingDTO::getAdminOrgNumber, a -> a));
        AdminOrgMappingDTO currentPaymentOrg = mappingDTOByNumberMap.get(this.adminOrgId2Number.get(orgId));
        if (currentPaymentOrg != null) {
            this.finOrgMap.put(1, currentPaymentOrg.getPaymentOrgId() + AGENT_INNER_SPLITOR + currentPaymentOrg.getPaymentOrgName());
        }
        HashMap otherPaymentOrg = Maps.newHashMap();
        this.adminOrgId2Number.forEach((id, num) -> {
            if (mappingDTOByNumberMap.containsKey(num)) {
                AdminOrgMappingDTO adminOrgMappingDTO = (AdminOrgMappingDTO)mappingDTOByNumberMap.get(num);
                otherPaymentOrg.put(id, adminOrgMappingDTO.getPaymentOrgId() + AGENT_INNER_SPLITOR + adminOrgMappingDTO.getPaymentOrgName());
                this.mappingDTOByIdMap.put((String)id, adminOrgMappingDTO);
            }
        });
        this.finOrgMap.put(2, otherPaymentOrg);
    }

    @Override
    protected void fillCmpBillPayOrg(CmpAgentPayBillInfo info, String splitKey) throws EASBizException {
        String payOrgId = this.getOrgIdFromSplitKey(splitKey);
        this.mappingDTOByIdMap.forEach((oldId, v) -> {
            if (payOrgId.equals(v.getPaymentOrgId())) {
                FullOrgUnitInfo orgUnitInfo = new FullOrgUnitInfo();
                orgUnitInfo.setId(BOSUuid.read((String)oldId));
                info.setPayOrg(orgUnitInfo);
                info.setPayOrgIdXKQJ(v.getPaymentOrgId());
                info.setPayOrgNameXKQJ(v.getPaymentOrgName());
            }
        });
    }

    @Override
    protected void checkPayOrgExists(Context ctx, Map param) throws EASBizException {
        if (this.adminOrgList == null || this.adminOrgList.isEmpty()) {
            return;
        }
        List<String> notExistPayOrgList = this.adminOrgList.stream().filter(admin -> !this.mappingDTOByIdMap.containsKey(admin)).collect(Collectors.toList());
        if (notExistPayOrgList.isEmpty()) {
            return;
        }
        StringBuilder adminStr = new StringBuilder();
        notExistPayOrgList.forEach(orgId -> {
            String adminOrgName = (String)this.adminOrgId2Name.get(orgId);
            String adminOrgNumber = (String)this.adminOrgId2Number.get(orgId);
            adminStr.append(adminOrgName + "\uff08" + adminOrgNumber + "\uff09\uff0c");
        });
        adminStr.deleteCharAt(adminStr.length() - 1);
        throw new CmpAgentPayBillException(CmpAgentPayBillException.EXCEPTION22, new Object[]{adminStr});
    }

    @Override
    protected CmpAgentPayBillInfo buildCmpPayBill(Context ctx, Map param, CmpItemInfo cmpItemInfo, String currencyId) throws EASBizException, BOSException {
        CmpAgentPayBillInfo info = super.buildCmpPayBill(ctx, param, cmpItemInfo, currencyId);
        info.setStateXKQJ(CmpBillStatusXKQJEnum.NOT_SUBMITED);
        return info;
    }

    @Override
    protected void buildBillMark(CmpAgentPayBillInfo info) {
        info.setITType(CmpITType.XKQJ);
        info.setAgentSource(CmpAgentSource.MultiCur);
    }

    @Override
    protected AbstractCmpAgentPayBillCreating.EntryGroups buildPayBillEntry(Context ctx, Map param) throws BOSException, EASBizException {
        AbstractCmpAgentPayBillCreating.EntryGroups entryGroups = new AbstractCmpAgentPayBillCreating.EntryGroups();
        String calTableName = (String)param.get("calTableName");
        List listData = (List)param.get("listData");
        CmpAgentPayBillEntryInfo cmpEntryInfo = null;
        for (Map data : listData) {
            List<Object> calTableList = this.getCalTableMap().get((String)data.get(calTableName + ".id"));
            BigDecimal giveAmount = new BigDecimal(data.get("gv_cmpaccres.giveamount") == null ? "0" : data.get("gv_cmpaccres.giveamount").toString());
            if (giveAmount.compareTo(BigDecimal.ZERO) <= 0) {
                entryGroups.setErrorMsg(EASResource.getString((String)"com.kingdee.shr.compensation.resource.MessageResource", (String)"label12", (Locale)ctx.getLocale()));
                return entryGroups;
            }
            PersonInfo personInfo = (PersonInfo)calTableList.get(0);
            CmpItemInfo cmpItem = this.getCalSchemeItemMap().get(data.get("gv_cmpitem.id")).getCmpItem();
            if (this.getExistPers().contains(personInfo.getId().toString() + "~" + cmpItem.getId().toString())) {
                entryGroups.setErrorMsg(EASResource.getString((String)"com.kingdee.shr.compensation.resource.MessageResource", (String)"label13", (Locale)ctx.getLocale()));
                return entryGroups;
            }
            cmpEntryInfo = new CmpAgentPayBillEntryInfo();
            BOSUuid cmpAgentPayBillEntryId = BOSUuid.create((BOSObjectType)cmpEntryInfo.getBOSType());
            cmpEntryInfo.setPerson(personInfo);
            cmpEntryInfo.setPersonNum(personInfo.getNumber());
            cmpEntryInfo.setPersonName(personInfo.getName());
            cmpEntryInfo.setAmount(giveAmount);
            cmpEntryInfo.setAdminOrg((AdminOrgUnitInfo)calTableList.get(1));
            cmpEntryInfo.setCmpCalOrg((AdminOrgUnitInfo)calTableList.get(2));
            cmpEntryInfo.setHrOrgUnit((HROrgUnitInfo)calTableList.get(3));
            cmpEntryInfo.setIsSuccess(false);
            cmpEntryInfo.setUseDefault((Boolean)data.get(calTableName + ".usedefault"));
            cmpEntryInfo.setId(cmpAgentPayBillEntryId);
            cmpEntryInfo.setCmpItemName(cmpItem.getName());
            cmpEntryInfo.setCmpItem(cmpItem);
            BigDecimal amount = new BigDecimal(data.get("gv_cmpaccres.amount") == null ? "0" : data.get("gv_cmpaccres.amount").toString());
            cmpEntryInfo.setCalAmount(amount);
            BankInfo bankInfo2 = new BankInfo();
            bankInfo2.setId(BOSUuid.read((String)((String)data.get("gv_bank.id"))));
            cmpEntryInfo.setHrBank(bankInfo2);
            cmpEntryInfo.setBankName((String)data.get("gv_bank.name"));
            cmpEntryInfo.setAccountNum((String)data.get("gv_perbkrec.accountnum"));
            cmpEntryInfo.setRecProvince((String)data.get("gv_perbkrec.province"));
            cmpEntryInfo.setRecCity((String)data.get("gv_perbkrec.city"));
            String accountName = (String)data.get("gv_perbkrec.accountname");
            accountName = CmpStrUtil.isEmpty(accountName) ? (String)data.get("cmp_person.name") : accountName;
            cmpEntryInfo.setAccountName(accountName);
            cmpEntryInfo.setITPayState(CmpITPayEnum.WAITPAY);
            cmpEntryInfo.setITCode(new BigDecimal(IdWorker.idWorker.nextId()));
            AbstractCmpAgentPayBillCreating.AmountCombie ac = new AbstractCmpAgentPayBillCreating.AmountCombie(giveAmount, amount);
            String splitField = this.getSplitFieldKey(data, param, entryGroups);
            entryGroups.putCmpEntrysGroup(splitField, cmpEntryInfo);
            entryGroups.putCmpItemGroup(splitField, cmpItem);
            entryGroups.putCurrencyGroup(splitField, (String)data.get("gv_currency.id"));
            entryGroups.putCalCurrencyGroup(splitField, (String)data.get("cal_currency.id"));
            entryGroups.putSumAmountValue(splitField, ac);
        }
        return entryGroups;
    }

    @Override
    protected String getOptionalPayOrgSplitKey(Map<String, Object> data, AbstractCmpAgentPayBillCreating.EntryGroups entryGroups) throws EASBizException {
        throw new CmpAgentPayBillException(CmpAgentPayBillException.EXCEPTION21);
    }

    @Override
    protected String getSchemePayOrgName() throws CmpAgentPayBillException {
        String finOrgName;
        String string = finOrgName = this.finOrgMap.get(1) == null ? "" : String.valueOf(this.finOrgMap.get(1));
        if (StringUtils.isEmpty((String)finOrgName)) {
            String adminOrgName = (String)this.adminOrgId2Name.get(this.schemePayOrgId);
            String adminOrgNumber = (String)this.adminOrgId2Number.get(this.schemePayOrgId);
            throw new CmpAgentPayBillException(CmpAgentPayBillException.EXCEPTION22, new Object[]{adminOrgName + "\uff08" + adminOrgNumber + "\uff09"});
        }
        return finOrgName;
    }

    @Override
    protected String getPersonOrgSplitKey(Map<String, Object> data, AbstractCmpAgentPayBillCreating.EntryGroups entryGroups) throws EASBizException {
        String finOrgName;
        Map adminOrgAndFinOrgMap = (Map)this.finOrgMap.get(2);
        String calOrgId = (String)data.get("cmp_ctb.adminorgunit");
        String string = finOrgName = adminOrgAndFinOrgMap == null ? null : (String)adminOrgAndFinOrgMap.get(calOrgId);
        if (StringUtils.isEmpty((String)finOrgName)) {
            String adminOrgName = (String)this.adminOrgId2Name.get(calOrgId);
            String adminOrgNumber = (String)this.adminOrgId2Number.get(calOrgId);
            throw new CmpAgentPayBillException(CmpAgentPayBillException.EXCEPTION22, new Object[]{adminOrgName + "\uff08" + adminOrgNumber + "\uff09"});
        }
        return finOrgName;
    }

    @Override
    protected void genHrOrgMappingMap(Context ctx, List<String> adminList) throws BOSException {
        CmpInSql<String> inSql = CmpInSqlFactory.getInstance();
        String lan = ctx.getLocale().getLanguage();
        String sql = "select distinct fid, fnumber, fname_" + lan + " name from t_org_admin where fid in " + inSql.createInSqlBaseOnFId(ctx, adminList);
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                this.adminOrgId2Number.put(rs.getString("fid"), rs.getString("fnumber"));
                this.adminOrgId2Name.put(rs.getString("fid"), rs.getString("name"));
            }
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        finally {
            inSql.release(ctx);
        }
    }
}

