/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app.budget;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.compensation.CalSchemeCollection;
import com.kingdee.shr.compensation.CalSchemeFactory;
import com.kingdee.shr.compensation.app.budget.AbstractDeductConfigFacadeControllerBean;
import com.kingdee.shr.compensation.app.budget.BudgetTemplateTypeEnum;
import com.kingdee.shr.compensation.app.integrate.CalSubmitSchemeCollection;
import com.kingdee.shr.compensation.app.integrate.CalSubmitSchemeFactory;
import com.kingdee.shr.compensation.service.budget.DeductionParam;
import com.kingdee.shr.compensation.service.budget.DeductionResult;
import com.kingdee.shr.compensation.service.budget.impl.AbstractDeductionService;
import com.kingdee.shr.compensation.service.budget.impl.CmpCalDeductionService;
import com.kingdee.shr.compensation.service.budget.impl.SubmitBillDeductionService;
import com.kingdee.shr.compensation.util.lock.CmpDistributedLockUtils;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.util.Locale;

public class DeductConfigFacadeControllerBean
extends AbstractDeductConfigFacadeControllerBean {
    public static final String BUDGET_DEDUCT_LOCK_KEY = "budget.deduct.lock.key.";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected DeductionResult _dealSchemeDeductConfig(Context ctx, DeductionParam param, BudgetTemplateTypeEnum templateType) throws BOSException, EASBizException {
        String budgetTemplateId = this.getBudgetTemplateId(ctx, param.getCalSchemeId(), templateType);
        if (StringUtils.isEmpty((String)budgetTemplateId)) {
            return null;
        }
        boolean flag = CmpDistributedLockUtils.tryLock(ctx, BUDGET_DEDUCT_LOCK_KEY, budgetTemplateId);
        if (!flag) {
            throw new EASBizException(new NumericExceptionSubItem("022", EASResource.getString((String)"com.kingdee.shr.compensation.resource.BudgetManageResource", (String)"label55", (Locale)ctx.getLocale())));
        }
        try {
            AbstractDeductionService deductionService;
            if (templateType == BudgetTemplateTypeEnum.SUBMIT_TYPE || templateType == BudgetTemplateTypeEnum.SPIRE_TYPE) {
                deductionService = new SubmitBillDeductionService();
            } else if (templateType == BudgetTemplateTypeEnum.SALARY_TYPE) {
                deductionService = new CmpCalDeductionService();
            } else {
                throw new BOSException("not supported template type for deduction: " + templateType.getAlias());
            }
            DeductionResult deductionResult = deductionService.deduct(ctx, param);
            return deductionResult;
        }
        finally {
            CmpDistributedLockUtils.unlock(ctx, BUDGET_DEDUCT_LOCK_KEY, budgetTemplateId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _dealWithRollback(Context ctx, DeductionParam param, BudgetTemplateTypeEnum templateType) throws BOSException, EASBizException {
        String budgetTemplateId = this.getBudgetTemplateId(ctx, param.getCalSchemeId(), templateType);
        if (StringUtils.isEmpty((String)budgetTemplateId)) {
            return;
        }
        boolean flag = CmpDistributedLockUtils.tryLock(ctx, BUDGET_DEDUCT_LOCK_KEY, budgetTemplateId);
        if (!flag) {
            throw new EASBizException(new NumericExceptionSubItem("022", EASResource.getString((String)"com.kingdee.shr.compensation.resource.BudgetManageResource", (String)"label55", (Locale)ctx.getLocale())));
        }
        try {
            AbstractDeductionService deductionService;
            if (templateType == BudgetTemplateTypeEnum.SUBMIT_TYPE || templateType == BudgetTemplateTypeEnum.SPIRE_TYPE) {
                deductionService = new SubmitBillDeductionService();
            } else if (templateType == BudgetTemplateTypeEnum.SALARY_TYPE) {
                deductionService = new CmpCalDeductionService();
            } else {
                throw new BOSException("not supported template type for deduction: " + templateType.getAlias());
            }
            deductionService.rollback(ctx, param);
        }
        finally {
            CmpDistributedLockUtils.unlock(ctx, BUDGET_DEDUCT_LOCK_KEY, budgetTemplateId);
        }
    }

    private String getBudgetTemplateId(Context ctx, String calSchemeId, BudgetTemplateTypeEnum templateType) throws BOSException {
        String oql = "select budgetTemplate.id where id = '" + calSchemeId + "'";
        if (templateType == BudgetTemplateTypeEnum.SALARY_TYPE) {
            CalSchemeCollection collection = CalSchemeFactory.getLocalInstance(ctx).getCalSchemeCollection(oql);
            if (collection.isEmpty()) {
                return null;
            }
            if (collection.get(0).getBudgetTemplate() == null) {
                return null;
            }
            return collection.get(0).getBudgetTemplate().getId().toString();
        }
        if (templateType == BudgetTemplateTypeEnum.SUBMIT_TYPE || templateType == BudgetTemplateTypeEnum.SPIRE_TYPE) {
            CalSubmitSchemeCollection collection = CalSubmitSchemeFactory.getLocalInstance(ctx).getCalSubmitSchemeCollection(oql);
            if (collection.isEmpty()) {
                return null;
            }
            if (collection.get(0).getBudgetTemplate() == null) {
                return null;
            }
            return collection.get(0).getBudgetTemplate().getId().toString();
        }
        throw new BOSException("not supported template type for deduction: " + templateType.getAlias());
    }
}

