/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app.formula.common;

import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.JdbcRowSet;
import com.kingdee.util.db.SQLUtils;
import com.mchange.v2.c3p0.ComboPooledDataSource;
import java.io.File;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class CmpDerbyDBUtil {
    private static final Logger logger = Logger.getLogger(CmpDerbyDBUtil.class);
    public static final String DERBY_PATH = System.getProperty("EAS_HOME") + "/server/properties/shr/cmp/calculete/db/";
    public static final String DERBY_DRIVER = "org.apache.derby.jdbc.EmbeddedDriver";
    private static ComboPooledDataSource dataSource;

    public static IRowSet executeQuery(String sql) throws SQLException {
        JdbcRowSet jdbcRowSet;
        Connection conn = null;
        Statement statement = null;
        ResultSet rs = null;
        try {
            conn = CmpDerbyDBUtil.getConnection();
            statement = conn.createStatement();
            rs = statement.executeQuery(sql);
            JdbcRowSet rowset = new JdbcRowSet();
            rowset.populate(rs);
            jdbcRowSet = rowset;
        }
        catch (SQLException e) {
            try {
                logger.error((Object)("query Sql error, sql is :" + sql), (Throwable)e);
                throw e;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)statement, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)statement, (Connection)conn);
        return jdbcRowSet;
    }

    public static IRowSet executeQuery(String sql, Object[] params) throws SQLException {
        JdbcRowSet jdbcRowSet;
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            conn = CmpDerbyDBUtil.getConnection();
            ps = conn.prepareStatement(sql);
            for (int i = 0; i < params.length; ++i) {
                ps.setObject(i + 1, params[i]);
            }
            rs = ps.executeQuery(sql);
            JdbcRowSet rowset = new JdbcRowSet();
            rowset.populate(rs);
            jdbcRowSet = rowset;
        }
        catch (SQLException e) {
            try {
                StringBuffer sb = new StringBuffer("");
                for (int i = 0; i < params.length; ++i) {
                    sb.append("param ").append(i).append(" is:").append(params[i]);
                }
                logger.error((Object)("sql is:" + sql + " param is:" + sb.toString()));
                logger.error((Object)"sql error!", (Throwable)e);
                throw e;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
        return jdbcRowSet;
    }

    public static void execute(String sql) throws SQLException {
        Connection conn = null;
        Statement statement = null;
        try {
            conn = CmpDerbyDBUtil.getConnection();
            statement = conn.createStatement();
            statement.execute(sql);
        }
        catch (SQLException e) {
            logger.error((Object)("sql 1 sql is:" + sql), (Throwable)e);
            throw e;
        }
        finally {
            SQLUtils.cleanup((Statement)statement, (Connection)conn);
        }
    }

    public static void execute(String sql, Object[] params) throws SQLException {
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = CmpDerbyDBUtil.getConnection();
            ps = conn.prepareStatement(sql);
            for (int i = 0; i < params.length; ++i) {
                ps.setObject(i + 1, params[i]);
            }
            ps.execute();
        }
        catch (SQLException e) {
            try {
                StringBuffer sb = new StringBuffer("");
                for (int i = 0; i < params.length; ++i) {
                    sb.append("param ").append(i).append(" is:").append(params[i]);
                }
                logger.error((Object)("222 sql is:" + sql + " param is:" + sb.toString()), (Throwable)e);
                throw e;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)conn);
    }

    public static int[] executeBatch(String sql, List paramsList) throws SQLException {
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = CmpDerbyDBUtil.getConnection();
            ps = conn.prepareStatement(sql);
            Object[] params = null;
            int k = 1;
            boolean flag = false;
            for (int i = 0; i < paramsList.size(); ++i) {
                params = (Object[])paramsList.get(i);
                for (int j = 0; j < params.length; ++j) {
                    ps.setObject(j + 1, params[j]);
                }
                ps.addBatch();
                if (i == k * 8000) {
                    flag = true;
                }
                if (i <= k * 8000 || !flag) continue;
                ps.executeBatch();
                ++k;
                flag = false;
                ps.clearBatch();
            }
            if (!flag) {
                int[] var18;
                int[] nArray = var18 = ps.executeBatch();
                return nArray;
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        finally {
            SQLUtils.cleanup(null, (Statement)ps, (Connection)conn);
        }
        return new int[0];
    }

    public static Connection getConnection() throws SQLException {
        return dataSource.getConnection();
    }

    public static boolean createTable(String tableName) throws Exception {
        if (!CmpDerbyDBUtil.isTableExists(tableName)) {
            CmpDerbyDBUtil.execute("Create Table " + tableName + " ( FKey VARCHAR(255),FValue BLOB)");
        }
        return true;
    }

    public static boolean dropTable(String tableName) throws Exception {
        if (CmpDerbyDBUtil.isTableExists(tableName)) {
            CmpDerbyDBUtil.execute("drop Table " + tableName);
        }
        return true;
    }

    public static boolean isTableExists(String tableN) throws Exception {
        Set<String> tables = CmpDerbyDBUtil.getTables(tableN.toUpperCase());
        return tables.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> getTables(String tableNPattern) throws SQLException {
        Connection conn = null;
        ResultSet rs = null;
        HashSet<String> set = new HashSet<String>();
        try {
            conn = CmpDerbyDBUtil.getConnection();
            DatabaseMetaData metaData = conn.getMetaData();
            rs = metaData.getTables(null, "CMPCALEXE", tableNPattern, new String[]{"TABLE"});
            while (rs.next()) {
                set.add(rs.getString("TABLE_NAME"));
            }
            SQLUtils.cleanup((ResultSet)rs, null, (Connection)conn);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            SQLUtils.cleanup(rs, null, (Connection)conn);
        }
        return set;
    }

    static {
        try {
            dataSource = new ComboPooledDataSource();
            dataSource.setDriverClass(DERBY_DRIVER);
            String derbyDBPath = DERBY_PATH.substring(0, DERBY_PATH.length() - 1);
            String dbUrl = "jdbc:derby:" + derbyDBPath;
            if (!new File(derbyDBPath).exists()) {
                dbUrl = dbUrl + ";create=true";
            }
            dbUrl = dbUrl + ";territory=zh_CN;codeset=utf8";
            dataSource.setJdbcUrl(dbUrl);
            dataSource.setUser("cmpcalexe");
            dataSource.setPassword("derby");
            dataSource.setInitialPoolSize(5);
            dataSource.setMaxPoolSize(50);
            dataSource.setMinPoolSize(5);
            dataSource.setAcquireIncrement(5);
            dataSource.setCheckoutTimeout(5000);
        }
        catch (Exception e) {
            logger.error((Object)"init s-HR Cmp Calculate Executor Derby Error!", (Throwable)e);
        }
    }
}

