/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app.incomeTax;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.shr.compensation.app.incomeTax.AbstractIncomeTaxCallbackFacadeControllerBean;
import com.kingdee.shr.compensation.app.taxCal.TaxCalTaskCatalogEnum;
import com.kingdee.shr.compensation.app.taxCal.TaxCalTaskFactory;
import com.kingdee.shr.compensation.app.taxCal.TaxCalTaskInfo;
import com.kingdee.shr.compensation.app.taxCal.TaxCalTaskStateEnum;
import com.kingdee.shr.compensation.app.taxCal.TaxServiceTaskResultInfo;
import com.kingdee.shr.compensation.tax.task.ITaxTaskService;
import com.kingdee.shr.compensation.tax.task.TaskServiceFactory;
import org.apache.log4j.Logger;

public class IncomeTaxCallbackFacadeControllerBean
extends AbstractIncomeTaxCallbackFacadeControllerBean {
    private static Logger logger = Logger.getLogger(IncomeTaxCallbackFacadeControllerBean.class);
    private ITaxTaskService taxTaskService;

    @Override
    protected void _onSuccess(Context ctx, TaxCalTaskInfo task, String response) throws BOSException {
        TaxServiceTaskResultInfo resultInfo = new TaxServiceTaskResultInfo();
        resultInfo.setResultContent(response);
        task.setRequestResult(resultInfo);
        try {
            TaxCalTaskFactory.getLocalInstance(ctx).save((CoreBaseInfo)task);
        }
        catch (EASBizException e) {
            logger.error((Object)"save TaxServiceTaskResultInfo error: ", (Throwable)e);
        }
        this.getTaxTaskService(task.getCatalog()).onSuccess(ctx, task, response);
    }

    @Override
    protected void _onFailure(Context ctx, TaxCalTaskInfo task, String content, String errMsg) throws BOSException {
        TaxCalTaskFactory.getLocalInstance(ctx).updateStateMsgById(task.getId().toString(), TaxCalTaskStateEnum.FAIDED, errMsg);
        TaxServiceTaskResultInfo resultInfo = new TaxServiceTaskResultInfo();
        resultInfo.setResultContent(content);
        task.setRequestResult(resultInfo);
        try {
            TaxCalTaskFactory.getLocalInstance(ctx).save((CoreBaseInfo)task);
        }
        catch (EASBizException e) {
            logger.error((Object)"save TaxServiceTaskResultInfo error: ", (Throwable)e);
        }
        this.getTaxTaskService(task.getCatalog()).onFailure(ctx, task, errMsg);
    }

    @Override
    protected boolean _isData4Resolving(Context ctx, TaxCalTaskCatalogEnum catalog, String code) throws BOSException {
        return this.getTaxTaskService(catalog).isData4Resolving(code);
    }

    private ITaxTaskService getTaxTaskService(TaxCalTaskCatalogEnum catalog) throws BOSException {
        if (null == this.taxTaskService) {
            this.taxTaskService = TaskServiceFactory.getInstance(catalog);
        }
        return this.taxTaskService;
    }
}

