/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app.integrate.multiinspire;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.compensation.app.integrate.BatchSubmitShemeBillFactory;
import com.kingdee.shr.compensation.app.integrate.BatchSubmitShemeBillInfo;
import com.kingdee.shr.compensation.app.integrate.CalShemeTableRelationFactory;
import com.kingdee.shr.compensation.app.integrate.CalShemeTableRelationInfo;
import com.kingdee.shr.compensation.app.integrate.SubmitSchemeType;
import com.kingdee.shr.compensation.app.integrate.multiinspire.AbstractStandingBookFacadeControllerBean;
import com.kingdee.shr.compensation.app.integrate.multiinspire.StandingBookCollection;
import com.kingdee.shr.compensation.app.integrate.multiinspire.StandingBookFactory;
import com.kingdee.shr.compensation.app.integrate.multiinspire.StandingBookInfo;
import com.kingdee.shr.compensation.util.budget.MiaBudgetUpgradeUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import shaded.com.google.common.collect.Lists;

public class StandingBookFacadeControllerBean
extends AbstractStandingBookFacadeControllerBean {
    private static final long serialVersionUID = 1L;

    @Override
    protected void _statistics(Context ctx, String billId) throws BOSException, EASBizException {
        if (MiaBudgetUpgradeUtil.isMiaBudgetUpgrade(ctx)) {
            return;
        }
        String oql = "select costBearOrg.id,budgetYear, submitScheme.submitSchemeType,submitScheme.id, costType.id where id='" + billId + "'";
        BatchSubmitShemeBillInfo batchSubmitShemeBillInfo = BatchSubmitShemeBillFactory.getLocalInstance(ctx).getBatchSubmitShemeBillInfo(oql);
        if (!SubmitSchemeType.REWARD.equals((Object)batchSubmitShemeBillInfo.getSubmitScheme().getSubmitSchemeType())) {
            return;
        }
        List<StandingBookStatisticsVO> statisticsGroup = this.getStatisticsGroup(ctx, batchSubmitShemeBillInfo);
        for (StandingBookStatisticsVO vo : statisticsGroup) {
            StandingBookInfo standingBookInfo = this.getStandingBookInfo(ctx, vo);
            this.updateStandBook(ctx, standingBookInfo, vo);
        }
    }

    protected StandingBookInfo getStandingBookInfo(Context ctx, StandingBookStatisticsVO vo) throws BOSException {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("LimitManagement.budgetYear", (Object)vo.getBudgetYear(), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("LimitManagement.adminOrgUnit.id", (Object)vo.getCostBearorgId(), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("LimitManagement.CostType.id", (Object)vo.getCostTypeId(), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("LimitManagement.virtualNode", (Object)0, CompareType.EQUALS));
        EntityViewInfo vi = new EntityViewInfo();
        SelectorItemCollection sc = new SelectorItemCollection();
        sc.add(new SelectorItemInfo("*"));
        sc.add(new SelectorItemInfo("LimitManagement.*"));
        vi.setFilter(filterInfo);
        vi.setSelector(sc);
        StandingBookCollection standingBookCollection = StandingBookFactory.getLocalInstance(ctx).getStandingBookCollection(vi);
        if (standingBookCollection.size() == 0) {
            throw new BOSException("can not get standing book!");
        }
        return standingBookCollection.get(0);
    }

    protected void updateStandBook(Context ctx, StandingBookInfo standingBookInfo, StandingBookStatisticsVO vo) throws EASBizException, BOSException {
        BigDecimal departmentLimit = standingBookInfo.getLimitManagement().getDepartmentLimit();
        BigDecimal usedAmount = standingBookInfo.getUsedAmount() != null ? standingBookInfo.getUsedAmount() : BigDecimal.ZERO;
        BigDecimal withHoleBalance = departmentLimit.subtract(new BigDecimal(vo.getDecCnvAmount())).subtract(new BigDecimal(vo.getBookkeepCnvAmount())).subtract(usedAmount).setScale(2, RoundingMode.HALF_UP);
        BigDecimal realDeductBalance = departmentLimit.subtract(new BigDecimal(vo.getBookkeepCnvAmount())).subtract(usedAmount).setScale(2, RoundingMode.HALF_UP);
        standingBookInfo.setWithHoleBalance(withHoleBalance);
        standingBookInfo.setRealDeductBalance(realDeductBalance);
        standingBookInfo.setRealDeductAmount(new BigDecimal(vo.getBookkeepCnvAmount()).setScale(2, RoundingMode.HALF_UP));
        standingBookInfo.setWithHoldAmount(new BigDecimal(vo.getDecCnvAmount()).setScale(2, RoundingMode.HALF_UP));
        StandingBookFactory.getLocalInstance(ctx).save((CoreBaseInfo)standingBookInfo);
    }

    protected List<StandingBookStatisticsVO> getStatisticsGroup(Context ctx, BatchSubmitShemeBillInfo batchSubmitShemeBillInfo) throws EASBizException, BOSException {
        ArrayList reslut = Lists.newArrayList();
        IRowSet statisticEntryGroup = DbUtil.executeQuery((Context)ctx, (String)this.getGroupSql(ctx, batchSubmitShemeBillInfo));
        try {
            while (statisticEntryGroup.next()) {
                StandingBookStatisticsVO vo = new StandingBookStatisticsVO();
                vo.setBudgetYear(statisticEntryGroup.getString("yearBudget"));
                vo.setCostBearorgId(statisticEntryGroup.getString("Fcostbearorgid"));
                vo.setCostTypeId(statisticEntryGroup.getString("FCOSTTYPEID"));
                vo.setDecCnvAmount(statisticEntryGroup.getString("FDecCnvAmount"));
                vo.setBookkeepCnvAmount(statisticEntryGroup.getString("FBookkeepCnvAmount"));
                reslut.add(vo);
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return reslut;
    }

    protected String getGroupSql(Context ctx, BatchSubmitShemeBillInfo batchSubmitShemeBillInfo) throws EASBizException, BOSException {
        String costBearOrgId = batchSubmitShemeBillInfo.getCostBearOrg().getId().toString();
        String budgetYear = batchSubmitShemeBillInfo.getBudgetYear();
        String costTypeId = batchSubmitShemeBillInfo.getCostType().getId().toString();
        CalShemeTableRelationInfo calShemeTableRelationInfo = CalShemeTableRelationFactory.getLocalInstance(ctx).getCalShemeTableRelationInfo("where submitScheme='" + batchSubmitShemeBillInfo.getSubmitScheme().getId().toString() + "'");
        String billEntryTableName = calShemeTableRelationInfo.getBillEntryTableName();
        String excuteSql = "select\nalldata.yearBudget,\nalldata.Fcostbearorgid,\nalldata.FCOSTTYPEID,\nsum(case when alldata.FBILLSTATE ='submit' then  alldata.FDecCnvAmount else 0 end) as FDecCnvAmount,\nsum(case when alldata.FBILLSTATE ='approve' then alldata.FBookkeepCnvAmount else 0 end)  as FBookkeepCnvAmount\nfrom \n(select \n(case \n  when a.FBILLSTATE =1 then  'submit'\n  when a.FBILLSTATE =2 then  'submit'\n  when a.FBILLSTATE =3 then  'approve'  \n  else 'else'\nend ) as FBILLSTATE,\nb.FBudgetYear as yearBudget,\nb.Fcostbearorgid as Fcostbearorgid,\nb.FCOSTTYPEID,\n(case when e.FDecCnvAmount is null then 0 else  e.FDecCnvAmount end) as FDecCnvAmount,\n(case when e.FBookkeepCnvAmount is null then 0 else  e.FBookkeepCnvAmount end) as FBookkeepCnvAmount\nfrom \n" + billEntryTableName + " a left join \n   T_HR_SBatchSubmitShemeBill b\non a.FBILLID =b.fid\nleft join \n   T_HR_CostType d\non b.FCOSTTYPEID =d.fid\nleft join \n   T_HR_SBatchSubmitEntryExt e\non a.fid=e.FBatchSumitEntryId\nwhere \n   b.FCostBearOrgID='" + costBearOrgId + "' and b.FCostTypeId='" + costTypeId + "') alldata\nwhere alldata.yearBudget = '" + budgetYear + "' \ngroup by \nalldata.yearBudget,\nalldata.Fcostbearorgid,\nalldata.FCOSTTYPEID";
        return excuteSql;
    }

    public static class StandingBookStatisticsVO {
        private String budgetYear;
        private String costBearorgId;
        private String costTypeId;
        private String decCnvAmount;
        private String bookkeepCnvAmount;

        public String getBudgetYear() {
            return this.budgetYear;
        }

        public void setBudgetYear(String budgetYear) {
            this.budgetYear = budgetYear;
        }

        public String getCostBearorgId() {
            return this.costBearorgId;
        }

        public void setCostBearorgId(String costBearorgId) {
            this.costBearorgId = costBearorgId;
        }

        public String getCostTypeId() {
            return this.costTypeId;
        }

        public void setCostTypeId(String costTypeId) {
            this.costTypeId = costTypeId;
        }

        public String getDecCnvAmount() {
            return this.decCnvAmount;
        }

        public void setDecCnvAmount(String decCnvAmount) {
            this.decCnvAmount = decCnvAmount;
        }

        public String getBookkeepCnvAmount() {
            return this.bookkeepCnvAmount;
        }

        public void setBookkeepCnvAmount(String bookkeepCnvAmount) {
            this.bookkeepCnvAmount = bookkeepCnvAmount;
        }

        public String getBizKey() {
            return this.costBearorgId + this.costTypeId + this.budgetYear;
        }
    }
}

