/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app.paySet;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.hraux.StateEnum;
import com.kingdee.eas.basedata.org.HROrgUnitCollection;
import com.kingdee.eas.basedata.org.HROrgUnitFactory;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import com.kingdee.shr.compensation.app.paySet.AbstractPaysetSchemeControllerBean;
import com.kingdee.shr.compensation.app.paySet.PaysetSchemeCollection;
import com.kingdee.shr.compensation.app.paySet.PaysetSchemeFactory;
import com.kingdee.shr.compensation.app.paySet.PaysetSchemeInfo;
import com.kingdee.shr.compensation.util.CmpSQLUtil;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import com.kingdee.shr.compensation.util.MappingTableUtils;
import com.kingdee.shr.compensation.util.db.CmpInSql;
import com.kingdee.shr.compensation.util.db.CmpInSqlFactory;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class PaysetSchemeControllerBean
extends AbstractPaysetSchemeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.compensation.app.paySet.PaysetSchemeControllerBean");
    private static Map<String, PaysetSchemeInfo> hrOrg2Payset = new HashMap<String, PaysetSchemeInfo>();
    private static Map<String, HROrgUnitInfo> hrOrgMap = new HashMap<String, HROrgUnitInfo>();
    private static final String TABLE_NAME = "T_HR_SOrgPaysetMapping";
    private static final String SCHEME_TYPE = "FPaysetID";

    @Override
    protected String _createHrPaysetMapping(Context ctx, Map params) throws BOSException, EASBizException {
        PaysetSchemeInfo scheme = (PaysetSchemeInfo)params.get("scheme");
        if (scheme.getCalScheme() != null) {
            return null;
        }
        try {
            String hrOrgId = scheme.getHrOrgUnit().getId().toString();
            boolean includeSub = scheme.isIncludeSub();
            Integer includeSub_int = includeSub ? 1 : 0;
            String mappingTableId = scheme.getId().toString();
            String longNumber = scheme.getHrOrgUnit().getLongNumber();
            String type = params.get("type").toString();
            String sql = null;
            String parentHrOrgId = null;
            String parentMappingTableId = null;
            String parentLongNumber = MappingTableUtils.getMaxParentNumber(ctx, TABLE_NAME, hrOrgId, 1);
            if (CmpStrUtil.isNotEmpty(parentLongNumber)) {
                sql = "select FHrOrgID, FPaysetID from T_HR_SOrgPaysetMapping where FLongNumber = '" + parentLongNumber + "'";
                IRowSet rs = CmpSQLUtil.executeQuery(ctx, sql);
                while (rs.next()) {
                    parentHrOrgId = rs.getString("FHrOrgID");
                    parentMappingTableId = rs.getString(SCHEME_TYPE);
                }
            }
            if ("enable".equals(type)) {
                MappingTableUtils.dealOwnData(ctx, TABLE_NAME, mappingTableId, hrOrgId, longNumber, includeSub_int, SCHEME_TYPE);
                if (includeSub) {
                    sql = MappingTableUtils.getInsertSql(TABLE_NAME, mappingTableId, hrOrgId, longNumber, true, SCHEME_TYPE);
                    CmpSQLUtil.execute(ctx, sql);
                    if (!CmpStrUtil.isEmpty(parentLongNumber)) {
                        sql = MappingTableUtils.getUpdateSql(TABLE_NAME, mappingTableId, hrOrgId, parentHrOrgId, longNumber, true, SCHEME_TYPE);
                        CmpSQLUtil.execute(ctx, sql);
                    }
                }
            } else if (CmpStrUtil.isEmpty(parentLongNumber)) {
                sql = "delete from T_HR_SOrgPaysetMapping where FUseHr = '" + hrOrgId + "'";
                CmpSQLUtil.execute(ctx, sql);
            } else {
                sql = MappingTableUtils.getUpdateSql(TABLE_NAME, parentMappingTableId, parentHrOrgId, hrOrgId, longNumber, true, SCHEME_TYPE);
                CmpSQLUtil.execute(ctx, sql);
            }
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    @Override
    protected void _initPaysetMapping(Context ctx) throws BOSException, EASBizException {
        this.initHrOrgUnit(ctx);
        hrOrg2Payset.clear();
        String deleteSql = "delete from T_HR_SOrgPaysetMapping";
        CmpSQLUtil.execute(ctx, deleteSql);
        this.getPayset(ctx);
        this.buildHrOrg2Payset(ctx);
        ArrayList<Object[]> bankParams = new ArrayList<Object[]>();
        String insertSql = "insert into T_HR_SOrgPaysetMapping (FHrorgID, FPaysetID, FUseHr, FIncludeSub, FLongNumber) values (?,?,?,?,?)";
        Iterator<String> it = hrOrg2Payset.keySet().iterator();
        while (it.hasNext()) {
            Object[] batchParam = new Object[5];
            String orgId = it.next();
            String paysetId = hrOrg2Payset.get(orgId).getId().toString();
            String parentOrg = hrOrg2Payset.get(orgId).getHrOrgUnit().getId().toString();
            String longNumber = hrOrgMap.get(orgId).getLongNumber();
            boolean includeSub = orgId.equals(parentOrg) && hrOrg2Payset.get(orgId).isIncludeSub() ? Boolean.TRUE : Boolean.FALSE;
            batchParam[0] = orgId;
            batchParam[1] = paysetId;
            batchParam[2] = parentOrg;
            batchParam[3] = includeSub;
            batchParam[4] = longNumber;
            bankParams.add(batchParam);
        }
        CmpSQLUtil.executeBatch(ctx, insertSql, bankParams);
    }

    private void initHrOrgUnit(Context ctx) throws BOSException {
        HROrgUnitCollection hrOrgUnitCollection = HROrgUnitFactory.getLocalInstance((Context)ctx).getHROrgUnitCollection("select id, number, longNumber, name, parent.*");
        for (int i = 0; i < hrOrgUnitCollection.size(); ++i) {
            HROrgUnitInfo hrOrg = hrOrgUnitCollection.get(i);
            hrOrgMap.put(hrOrg.getId().toString(), hrOrg);
        }
    }

    private void getPayset(Context ctx) throws BOSException {
        PaysetSchemeCollection paysetSchemeCollection = PaysetSchemeFactory.getLocalInstance(ctx).getPaysetSchemeCollection();
        for (int i = 0; i < paysetSchemeCollection.size(); ++i) {
            PaysetSchemeInfo payset = paysetSchemeCollection.get(i);
            if (payset.getHrOrgUnit() == null || payset.getCalScheme() != null || payset.getState() != StateEnum.ENABLE) continue;
            hrOrg2Payset.put(payset.getHrOrgUnit().getId().toString(), payset);
        }
    }

    private void buildHrOrg2Payset(Context ctx) {
        Iterator<String> iterator = hrOrgMap.keySet().iterator();
        while (iterator.hasNext()) {
            HROrgUnitInfo hrOrg = hrOrgMap.get(iterator.next());
            PaysetSchemeInfo payset = hrOrg2Payset.get(hrOrg.getId().toString());
            if (payset != null || (payset = this.getPaysetByParent(hrOrg)) == null) continue;
            hrOrg2Payset.put(hrOrg.getId().toString(), payset);
        }
    }

    private PaysetSchemeInfo getPaysetByParent(HROrgUnitInfo currentHrOrg) {
        PaysetSchemeInfo payset = hrOrg2Payset.get(currentHrOrg.getId().toString());
        if (payset != null && payset.getBoolean("includeSub")) {
            return payset;
        }
        if (currentHrOrg.getParent() == null) {
            return null;
        }
        return this.getPaysetByParent(hrOrgMap.get(currentHrOrg.getParent().getId().toString()));
    }

    @Override
    protected void _updatePushData(Context ctx) throws BOSException, EASBizException {
        PaysetSchemeCollection paysetSchemeColl = PaysetSchemeFactory.getLocalInstance(ctx).getPaysetSchemeCollection("select id, autoConfirm, autoConfirmDay, calScheme.id,calScheme.hrOrgUnit.id where state = '1'");
        if (paysetSchemeColl.isEmpty()) {
            return;
        }
        CmpInSql cmpInSql = CmpInSqlFactory.getInstance();
        try {
            HashSet<String> enableStatePaySetIds = new HashSet<String>();
            HashMap<String, String> schemePaySetMap = new HashMap<String, String>();
            HashMap<String, Double> autoConfirmPaySetMap = new HashMap<String, Double>();
            HashMap<String, String> calSchemeHrOrgMap = new HashMap<String, String>();
            for (int i = 0; i < paysetSchemeColl.size(); ++i) {
                PaysetSchemeInfo paySetInfo = paysetSchemeColl.get(i);
                if (paySetInfo.getId() == null) continue;
                String paySetId = paySetInfo.getId().toString();
                enableStatePaySetIds.add(paySetId);
                if (paySetInfo.getCalScheme() != null && paySetInfo.getCalScheme().getId() != null) {
                    String calSchemeId = paySetInfo.getCalScheme().getId().toString();
                    if (paySetInfo.getCalScheme().getHrOrgUnit() != null && paySetInfo.getCalScheme().getHrOrgUnit().getId() != null) {
                        String hrOrgUnitId = paySetInfo.getCalScheme().getHrOrgUnit().getId().toString();
                        calSchemeHrOrgMap.put(hrOrgUnitId, calSchemeId);
                    }
                    schemePaySetMap.put(paySetId, calSchemeId);
                }
                if (!paySetInfo.isAutoConfirm()) continue;
                autoConfirmPaySetMap.put(paySetId, paySetInfo.getAutoConfirmDay());
            }
            String paySetIdFilter = cmpInSql.createInSqlBaseOnFId(ctx, enableStatePaySetIds);
            String mappingSql = "select fhrorgid,fpaysetid from T_HR_SOrgPaysetMapping where FPaysetID in " + paySetIdFilter;
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)mappingSql);
            HashMap paySetHrOrgMap = new HashMap();
            while (rowSet.next()) {
                String paysetId = rowSet.getString("fpaysetid");
                List hrOrgIds = null;
                hrOrgIds = paySetHrOrgMap.containsKey(paysetId) ? (List)paySetHrOrgMap.get(paysetId) : new ArrayList();
                hrOrgIds.add(rowSet.getString("fhrorgid"));
                paySetHrOrgMap.put(paysetId, hrOrgIds);
            }
            String userId = HRFilterUtils.getCurrentUserId((Context)ctx);
            for (String paySetId : enableStatePaySetIds) {
                StringBuilder updatePushSql = new StringBuilder("update T_HR_SPayslipPush set fsysAutoConfirmTime = ");
                String filter = "";
                if (schemePaySetMap.containsKey(paySetId)) {
                    filter = "select fid from T_HR_SCmpCalTable where fcalSchemeId = '" + (String)schemePaySetMap.get(paySetId) + "'";
                } else {
                    if (paySetHrOrgMap.get(paySetId) == null || ((List)paySetHrOrgMap.get(paySetId)).isEmpty()) continue;
                    List hrOrgIds = (List)paySetHrOrgMap.get(paySetId);
                    StringBuilder calSchemeFilter = new StringBuilder();
                    for (String hrOrgId : hrOrgIds) {
                        if (!calSchemeHrOrgMap.containsKey(hrOrgId)) continue;
                        calSchemeFilter.append(" and fcalSchemeId !='").append((String)calSchemeHrOrgMap.get(hrOrgId)).append("'");
                    }
                    String hrOrgIdSql = cmpInSql.createInSqlBaseOnFId(ctx, (Collection)paySetHrOrgMap.get(paySetId));
                    filter = " select fid from T_HR_SCmpCalTable where fhrOrgUnitId in " + hrOrgIdSql;
                    if (!StringUtils.isEmpty((String)calSchemeFilter.toString())) {
                        filter = filter + calSchemeFilter.toString();
                    }
                }
                if (autoConfirmPaySetMap.containsKey(paySetId)) {
                    double autoConfirmDay = (Double)autoConfirmPaySetMap.get(paySetId);
                    int addSecond = (int)(autoConfirmDay * 24.0 * 60.0 * 60.0 + 0.5);
                    updatePushSql.append("DATEADD(second, " + addSecond + ", FPushTime)");
                } else {
                    updatePushSql.append("null");
                }
                updatePushSql.append(", FLastUpdateUserID='").append(userId).append("', FLastUpdateTime=now()");
                updatePushSql.append(" where FCalTableID in (" + filter + ") and FPushState = 1 and FEmpConfirmState = 0");
                DbUtil.execute((Context)ctx, (String)updatePushSql.toString());
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        finally {
            cmpInSql.release(ctx);
        }
    }
}

