/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app.tax;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import com.kingdee.shr.compensation.TaxUnitDataPermFactory;
import com.kingdee.shr.compensation.app.tax.AbstractCmpFinalSettlementFacadeControllerBean;
import com.kingdee.shr.compensation.app.tax.TaxItemPropCollection;
import com.kingdee.shr.compensation.app.tax.TaxItemPropFactory;
import com.kingdee.shr.compensation.util.CmpSQLUtil;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import org.apache.log4j.Logger;

public class CmpFinalSettlementFacadeControllerBean
extends AbstractCmpFinalSettlementFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.compensation.app.tax.CmpFinalSettlementFacadeControllerBean");
    private static ScriptEngine jse = new ScriptEngineManager().getEngineByName("JavaScript");
    private static final String FPersonID = "FPersonID";
    private static final String FTaxUnitID = "FTaxUnitID";
    private static final String FPeriodMonth = "FPeriodMonth";
    private static final String SPLIT = "_";

    @Override
    protected String _getInnerData(Context ctx, String taxYear, String speScheme) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected String _sumData(Context ctx, String taxYear) throws BOSException, EASBizException {
        Set<String> accumItemSet = this.getAccumItems(ctx);
        LinkedHashMap<String, String> expMap = new LinkedHashMap<String, String>();
        LinkedHashMap<String, Set<String>> varMap = new LinkedHashMap<String, Set<String>>();
        LinkedHashSet<String> calItemSet = new LinkedHashSet<String>();
        this.parseExpress(ctx, expMap, varMap, calItemSet, accumItemSet);
        if (expMap.size() == 0 || varMap.size() == 0) {
            throw new EASBizException(new NumericExceptionSubItem("002", EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label77", (Locale)ctx.getLocale())));
        }
        String taxUnitRange = this.getTaxUnitRange(ctx);
        StringBuilder sbf = new StringBuilder();
        sbf.append("select taxDel.FPersonID,taxDel.FTaxUnitID,taxDel.FPeriodMonth,");
        Collection values = varMap.values();
        HashSet allVars = new HashSet();
        for (Set set : values) {
            allVars.addAll(set);
        }
        for (String s : allVars) {
            sbf.append("taxDel.").append(s).append(",");
        }
        sbf.append("taxDel.FItemDefine ");
        sbf.append(" from T_HR_STaxDeclaration taxDel where taxDel.FPeriodYear=").append(taxYear);
        if (StringUtils.isEmpty((String)taxUnitRange)) {
            throw new EASBizException(new NumericExceptionSubItem("002", EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label78", (Locale)ctx.getLocale())));
        }
        sbf.append(" and taxDel.FPersonID in (select distinct FPersonID from T_HR_STaxDeclaration where FTaxUnitID in(");
        sbf.append(taxUnitRange).append(") and FPeriodYear=").append(taxYear).append(")");
        sbf.append(" and taxDel.FItemDefine in('0101','0401','0500','0600','0402','0403','0499') and taxDel.FIsPersonal=0 ");
        sbf.append(" and not exists (select 1 from T_HR_SFinalSettlementSum settlementSum ");
        sbf.append(" where settlementSum.FTaxYear=taxDel.FPeriodYear");
        sbf.append(" and taxDel.FPersonID=settlementSum.FPersonID ");
        sbf.append(" and settlementSum.FState>1)");
        sbf.append(" and not exists (select 1 from T_HR_SFinalSettlement settlement ");
        sbf.append(" where settlement.FTaxYear=taxDel.FPeriodYear and settlement.FTaxUnitID=taxDel.FTaxUnitID");
        sbf.append(" and taxDel.FPersonID=settlement.FPersonID ");
        sbf.append(" and settlement.FState>0) order by taxDel.FTaxPeriodBegin");
        IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sbf.toString());
        HashMap<String, Map<String, BigDecimal>> preMonthData = new HashMap<String, Map<String, BigDecimal>>();
        HashMap<String, Map<String, BigDecimal>> monthSumData = new HashMap<String, Map<String, BigDecimal>>();
        try {
            LinkedHashMap<String, BigDecimal> tmpData = new LinkedHashMap<String, BigDecimal>();
            while (rowset.next()) {
                Map<String, BigDecimal> preData;
                String preKey = rowset.getString(FPersonID) + SPLIT + rowset.getString(FTaxUnitID);
                String monthKey = preKey + SPLIT + rowset.getString(FPeriodMonth);
                BigDecimal month = rowset.getBigDecimal(FPeriodMonth);
                Map<String, BigDecimal> monthData = monthSumData.containsKey(monthKey) ? (Map)monthSumData.get(monthKey) : new LinkedHashMap();
                Map map = preData = preMonthData.containsKey(preKey) ? (Map)preMonthData.get(preKey) : new LinkedHashMap();
                if (monthData.size() > 0) {
                    tmpData.putAll(monthData);
                }
                String itemDefine = rowset.getString("FItemDefine");
                for (Map.Entry calItemEntry : expMap.entrySet()) {
                    String calItem = (String)calItemEntry.getKey();
                    String express = (String)calItemEntry.getValue();
                    Set varSet = (Set)varMap.get(calItem);
                    for (String string : varSet) {
                        BigDecimal curDec = rowset.getBigDecimal(string);
                        BigDecimal bigDecimal = curDec = curDec == null ? BigDecimal.ZERO : curDec;
                        if ("0101".equals(itemDefine)) {
                            BigDecimal preDec = (BigDecimal)preData.get(calItem + string);
                            if (accumItemSet.contains(string)) {
                                BigDecimal preMonth;
                                preData.put(calItem + string, curDec);
                                if (preDec != null && (preMonth = (BigDecimal)preData.get(FPeriodMonth)) != null && month.subtract(preMonth).intValue() == 1) {
                                    curDec = curDec.subtract(preDec).compareTo(BigDecimal.ZERO) < 0 ? BigDecimal.ZERO : curDec.subtract(preDec);
                                }
                            }
                        }
                        express = express.replaceAll(string, curDec.toString());
                    }
                    for (Map.Entry entry : monthData.entrySet()) {
                        if (!express.contains((CharSequence)entry.getKey())) continue;
                        express = express.replaceAll((String)entry.getKey(), ((BigDecimal)entry.getValue()).toString());
                    }
                    String str = jse.eval(express).toString();
                    BigDecimal bigDecimal = "NaN".equals(str) ? BigDecimal.ZERO : new BigDecimal(str);
                    monthData.put(calItem.split(SPLIT)[1], bigDecimal);
                }
                for (Map.Entry tmpEntry : tmpData.entrySet()) {
                    monthData.put((String)tmpEntry.getKey(), ((BigDecimal)monthData.get(tmpEntry.getKey())).add((BigDecimal)tmpEntry.getValue()));
                }
                if ("0101".equals(itemDefine)) {
                    preData.put(FPeriodMonth, rowset.getBigDecimal(FPeriodMonth));
                }
                monthSumData.put(monthKey, monthData);
                preMonthData.put(preKey, preData);
                tmpData.clear();
            }
            this.updateMonthDataBatch(ctx, monthSumData, taxYear);
            this.sumData(ctx, monthSumData, calItemSet, taxYear);
            this.sumYearData(ctx, calItemSet, taxYear, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new EASBizException(new NumericExceptionSubItem("002", EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label79", (Locale)ctx.getLocale())));
        }
        return null;
    }

    @Override
    protected String _sumYearData(Context ctx, Map personRange) throws BOSException, EASBizException {
        if (personRange == null || personRange.size() == 0) {
            return null;
        }
        LinkedHashSet<String> calItemSet = new LinkedHashSet<String>();
        calItemSet.add("FAnnualIncome");
        calItemSet.add("FAnnualSpeDeduction");
        calItemSet.add("FAnnualSpeExpense");
        calItemSet.add("FAnnualBasicDeduction");
        calItemSet.add("FAnnualOtherDeduction");
        calItemSet.add("FWithheldTax");
        try {
            for (Map.Entry yearEntry : personRange.entrySet()) {
                String taxYear = (String)yearEntry.getKey();
                String personInSql = this.convertSetToSqlString((Set)yearEntry.getValue());
                if (StringUtils.isEmpty((String)personInSql)) continue;
                this.sumYearData(ctx, calItemSet, taxYear, personInSql);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new EASBizException(new NumericExceptionSubItem("002", EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label80", (Locale)ctx.getLocale()) + e.getMessage()));
        }
        return null;
    }

    private void insertSumData(Context ctx, Map<String, Map<String, BigDecimal>> yearData, Set<String> calItemSet, String taxYear) throws BOSException {
        if (yearData == null || yearData.size() == 0) {
            return;
        }
        StringBuilder insertSql = new StringBuilder();
        insertSql.append("insert into T_HR_SFinalSettlement(FID,FPersonID,FTaxUnitID,FTaxYear,");
        for (String col : calItemSet) {
            insertSql.append(col).append(",");
        }
        insertSql.append("FState) values (").append("newbosid('59E8991A'),?,?,").append(taxYear).append(",");
        for (String col : calItemSet) {
            insertSql.append("?,");
        }
        insertSql.append(0).append(")");
        ArrayList<Object> param = null;
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        String key = null;
        Map<String, BigDecimal> data = null;
        String[] keyArr = null;
        for (Map.Entry<String, Map<String, BigDecimal>> entry : yearData.entrySet()) {
            param = new ArrayList<Object>();
            key = entry.getKey();
            keyArr = key.split(SPLIT);
            param.add(keyArr[0]);
            param.add(keyArr[1]);
            data = entry.getValue();
            for (String col : data.keySet()) {
                param.add(data.get(col));
            }
            paramsList.add(param.toArray());
        }
        CmpSQLUtil.executeBatchNoAutoCommit(ctx, insertSql.toString(), paramsList);
    }

    private void insertYearSumData(Context ctx, Map<String, Map<String, BigDecimal>> yearData, Set<String> calItemSet, String taxYear) throws BOSException {
        if (yearData == null || yearData.size() == 0) {
            return;
        }
        StringBuilder insertSql = new StringBuilder();
        insertSql.append("insert into T_HR_SFinalSettlementSum(FID,FPersonID,FTaxYear,");
        for (String col : calItemSet) {
            insertSql.append(col).append(",");
        }
        insertSql.append("FState) values (").append("newbosid('59E8991A'),?,").append(taxYear).append(",");
        for (String col : calItemSet) {
            insertSql.append("?,");
        }
        insertSql.append(0).append(")");
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        for (Map.Entry<String, Map<String, BigDecimal>> entry : yearData.entrySet()) {
            ArrayList<Object> param = new ArrayList<Object>();
            String key = entry.getKey();
            param.add(key);
            Map<String, BigDecimal> data = entry.getValue();
            for (String col : data.keySet()) {
                param.add(data.get(col));
            }
            paramsList.add(param.toArray());
        }
        CmpSQLUtil.executeBatchNoAutoCommit(ctx, insertSql.toString(), paramsList);
    }

    private void sumData(Context ctx, Map<String, Map<String, BigDecimal>> monthSumData, Set<String> calItemSet, String taxYear) throws BOSException {
        HashMap<String, Map<String, BigDecimal>> yearData = new HashMap<String, Map<String, BigDecimal>>();
        Map<String, BigDecimal> sumdata = null;
        String personUnitkey = null;
        String[] keyArr = null;
        Map<String, BigDecimal> taxUnitData = null;
        for (Map.Entry<String, Map<String, BigDecimal>> entry : monthSumData.entrySet()) {
            keyArr = entry.getKey().split(SPLIT);
            personUnitkey = keyArr[0] + SPLIT + keyArr[1];
            taxUnitData = entry.getValue();
            if (yearData.containsKey(personUnitkey)) {
                sumdata = (Map)yearData.get(personUnitkey);
                for (Map.Entry<String, BigDecimal> unitData : taxUnitData.entrySet()) {
                    sumdata.put(unitData.getKey(), ((BigDecimal)sumdata.get(unitData.getKey())).add(unitData.getValue()));
                }
            } else {
                sumdata = new LinkedHashMap();
                for (Map.Entry<String, BigDecimal> unitData : taxUnitData.entrySet()) {
                    sumdata.put(unitData.getKey(), unitData.getValue());
                }
            }
            yearData.put(personUnitkey, sumdata);
        }
        this.clearYearData(ctx, taxYear);
        this.insertSumData(ctx, yearData, calItemSet, taxYear);
    }

    private void sumYearData(Context ctx, Set<String> calItemSet, String taxYear, String filter) throws BOSException, SQLException {
        StringBuilder selSql = new StringBuilder();
        selSql.append("select settlement.* from T_HR_SFinalSettlement settlement where ");
        selSql.append("not exists (select 1 from T_HR_SFinalSettlementSum settlementSum ");
        selSql.append("where settlement.FPersonId=settlementSum.FPersonId and settlement.FTaxYear=settlementSum.FTaxYear ");
        selSql.append("and settlementSum.FState>1) and settlement.FTaxYear=").append(taxYear);
        String taxUnitRange = this.getTaxUnitRange(ctx);
        if (StringUtils.isEmpty((String)taxUnitRange)) {
            return;
        }
        if (!StringUtils.isEmpty((String)filter)) {
            selSql.append(" and settlement.FPersonID in (").append(filter).append(")");
        } else {
            selSql.append(" and settlement.FPersonID in (select FPersonID from T_HR_SFinalSettlement where FTaxUnitID in(");
            selSql.append(taxUnitRange).append("))");
        }
        IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)selSql.toString());
        HashMap<String, Map<String, BigDecimal>> yearSumData = new HashMap<String, Map<String, BigDecimal>>();
        Map<String, BigDecimal> sumdata = null;
        String personkey = null;
        boolean xx = false;
        while (rowset.next()) {
            personkey = rowset.getString(FPersonID);
            if (yearSumData.containsKey(personkey)) {
                sumdata = (Map)yearSumData.get(personkey);
                for (String calItem : calItemSet) {
                    if (rowset.getBigDecimal(calItem) == null) {
                        sumdata.put(calItem, ((BigDecimal)sumdata.get(calItem)).add(new BigDecimal(0)));
                        continue;
                    }
                    sumdata.put(calItem, ((BigDecimal)sumdata.get(calItem)).add(rowset.getBigDecimal(calItem)));
                }
            } else {
                sumdata = new LinkedHashMap();
                for (String calItem : calItemSet) {
                    if (rowset.getBigDecimal(calItem) == null) {
                        sumdata.put(calItem, new BigDecimal(0));
                        continue;
                    }
                    sumdata.put(calItem, rowset.getBigDecimal(calItem));
                }
            }
            yearSumData.put(personkey, sumdata);
        }
        this.clearYearSumData(ctx, taxYear, filter);
        this.insertYearSumData(ctx, yearSumData, calItemSet, taxYear);
    }

    private Set<String> getAccumItems(Context ctx) throws BOSException {
        HashSet<String> accumItemSet = new HashSet<String>();
        TaxItemPropCollection items = TaxItemPropFactory.getLocalInstance(ctx).getTaxItemPropCollection("select * where type=2");
        if (items != null && items.size() > 0) {
            for (int i = 0; i < items.size(); ++i) {
                accumItemSet.add(items.get(i).getNumber());
            }
        }
        return accumItemSet;
    }

    private String getTaxUnitRange(Context ctx) throws BOSException {
        String range = "";
        String personId = HRFilterUtils.getCurrentPersonId((Context)ctx);
        Set taxUnitIdSet = TaxUnitDataPermFactory.getLocalInstance(ctx).getAllPermTaxUnitByPersonId(personId);
        if (taxUnitIdSet != null && taxUnitIdSet.size() > 0) {
            range = this.convertSetToSqlString(taxUnitIdSet);
        }
        return range;
    }

    private String convertSetToSqlString(Set<String> personIdSet) {
        String result = "";
        StringBuilder sbr = new StringBuilder();
        if (personIdSet != null && personIdSet.size() > 0) {
            for (String personId : personIdSet) {
                sbr.append("'").append(personId).append("',");
            }
            result = sbr.toString();
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    private void parseExpress(Context ctx, Map<String, String> expMap, Map<String, Set<String>> varMap, Set<String> calItemSet, Set<String> accumItemSet) throws BOSException {
        String expSql = "select FID,FExpress,FCalItem,FListItem from T_HR_SFinalSettlementConfig where FIsPreset=0 order by FSortSn ASC";
        IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)expSql);
        try {
            while (rowset.next()) {
                String[] vars;
                String express = rowset.getString("FExpress").replaceAll(";", "");
                String listItem = rowset.getString("FListItem");
                String calItem = rowset.getString("FCalItem");
                calItemSet.add(calItem);
                String FID = rowset.getString("FID");
                if (!express.contains("=")) continue;
                express = express.split("=")[1];
                HashSet<String> varSet = new HashSet<String>();
                for (String var : vars = listItem.split(";")) {
                    String[] varItems = var.split("~");
                    String tbName = varItems[1] + SPLIT;
                    express = express.replaceAll(tbName, "");
                    String varItem = varItems[2];
                    if (accumItemSet.contains(varItem)) {
                        accumItemSet.add(calItem);
                    }
                    if (calItemSet.contains(varItem)) continue;
                    varSet.add(varItem);
                }
                expMap.put(FID + SPLIT + calItem, express);
                varMap.put(FID + SPLIT + calItem, varSet);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void clearYearData(Context ctx, String taxYear) throws BOSException {
        StringBuilder delSql = new StringBuilder();
        delSql.append("delete from T_HR_SFinalSettlement where FTaxYear=").append(taxYear);
        delSql.append(" and FState=0");
        String taxUnitRange = this.getTaxUnitRange(ctx);
        if (StringUtils.isEmpty((String)taxUnitRange)) {
            return;
        }
        delSql.append(" and FPersonID in (select distinct FPersonID from T_HR_STaxDeclaration where FTaxUnitID in(");
        delSql.append(taxUnitRange).append(") and FPeriodYear=").append(taxYear);
        delSql.append(" and FItemDefine in('0101','0401','0500','0600','0402','0403','0499') and FIsPersonal=0) ");
        DbUtil.execute((Context)ctx, (String)delSql.toString());
    }

    private void clearYearSumData(Context ctx, String taxYear, String filter) throws BOSException {
        StringBuilder delSql = new StringBuilder();
        delSql.append("delete from T_HR_SFinalSettlementSum where FTaxYear=").append(taxYear);
        delSql.append(" and FState<=1 ");
        String taxUnitRange = this.getTaxUnitRange(ctx);
        if (StringUtils.isEmpty((String)taxUnitRange)) {
            return;
        }
        if (!StringUtils.isEmpty((String)filter)) {
            delSql.append(" and FPersonID in (").append(filter).append(")");
        } else {
            delSql.append(" and FPersonID in (select distinct FPersonID from T_HR_STaxDeclaration where FTaxUnitID in(");
            delSql.append(taxUnitRange).append(") and FPeriodYear=").append(taxYear);
            delSql.append(" and FItemDefine in('0101','0401','0500','0600','0402','0403','0499') and FIsPersonal=0) ");
        }
        DbUtil.execute((Context)ctx, (String)delSql.toString());
    }

    private void updateMonthDataBatch(Context ctx, Map<String, Map<String, BigDecimal>> monthSumData, String taxYear) throws BOSException {
        if (monthSumData == null || monthSumData.size() == 0) {
            return;
        }
        StringBuilder updateSql = new StringBuilder();
        updateSql.append("update T_HR_STaxDeclaration set FAnnualIncome=? ,FWithheldTax=? ,FSumOperate=1 where ").append(" FPersonID=? and FTaxUnitID=? and FPeriodMonth=? and  FPeriodYear=").append(taxYear);
        updateSql.append(" and FItemDefine in('0101','0401','0500','0600','0402','0403','0499') and FIsPersonal=0");
        String key = null;
        Map<String, BigDecimal> data = null;
        String[] keyArr = null;
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = this.getConnection(ctx);
            ps = conn.prepareStatement(updateSql.toString());
            conn.setAutoCommit(false);
            for (Map.Entry<String, Map<String, BigDecimal>> entry : monthSumData.entrySet()) {
                key = entry.getKey();
                keyArr = key.split(SPLIT);
                data = entry.getValue();
                if (data.get("FAnnualIncome") != null) {
                    ps.setObject(1, data.get("FAnnualIncome"));
                } else {
                    ps.setNull(1, 12);
                }
                if (data.get("FWithheldTax") != null) {
                    ps.setObject(2, data.get("FWithheldTax"));
                } else {
                    ps.setNull(2, 12);
                }
                if (keyArr[0] != null) {
                    ps.setObject(3, keyArr[0]);
                } else {
                    ps.setNull(3, 12);
                }
                if (keyArr[1] != null) {
                    ps.setObject(4, keyArr[1]);
                } else {
                    ps.setNull(4, 12);
                }
                if (keyArr[2] != null) {
                    ps.setObject(5, keyArr[2]);
                } else {
                    ps.setNull(5, 12);
                }
                ps.addBatch();
            }
            ps.executeBatch();
            conn.commit();
        }
        catch (SQLException exc) {
            try {
                try {
                    conn.rollback();
                }
                catch (SQLException e) {
                    throw new BOSException("Sql222 execute exception : " + updateSql, (Throwable)exc);
                }
                throw new BOSException("Sql222 execute exception : " + updateSql, (Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)conn);
    }
}

