/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.baseconfig;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.data.SQLType;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.SqlParam;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.shr.baseconfig.StructureConfigInfo;
import com.kingdee.shr.baseconfig.service.api.impl.CommonSHRSqlBuilder;
import com.kingdee.shr.compensation.app.budget.CmpBudgetItemCollection;
import com.kingdee.shr.compensation.app.budget.CmpBudgetItemFactory;
import com.kingdee.shr.compensation.app.budget.CmpBudgetItemInfo;
import com.kingdee.shr.compensation.app.budget.StandingBookItemCollection;
import com.kingdee.shr.compensation.app.budget.StandingBookItemFactory;
import com.kingdee.shr.compensation.app.budget.StandingBookItemInfo;
import com.kingdee.shr.compensation.util.CmpSQLUtil;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.Locale;
import java.util.Map;

public class CmpSubBudgetAssignSHRSqlBuilder
extends CommonSHRSqlBuilder {
    protected static final String CMPBUDGETITEM_TAG = "t";
    protected static final String STANDINGBOOKITEM_TAG = "s";
    protected static final String CMPBUDGETITEM_TABLE = "T_HR_SCmpBudgetItem";
    protected static final String STANDINGBOOKITEM_TABLE = "T_HR_SStandingBookItem";

    protected OwnPropertyInfo getCmpPropertyInfo(StructureConfigInfo clientInfo, String propertyName) throws EASBizException, BOSException {
        String alias = "";
        String name = propertyName;
        DataType dataType = DataType.INTEGER;
        SQLType sqlType = SQLType.NUMERIC;
        OwnPropertyInfo propInfo = new OwnPropertyInfo();
        String tag = null;
        String itemTableName = null;
        if (propertyName.matches("(?i)t\\d+")) {
            tag = CMPBUDGETITEM_TAG;
            itemTableName = CMPBUDGETITEM_TABLE;
        } else if (propertyName.matches("(?i)s\\d+")) {
            tag = STANDINGBOOKITEM_TAG;
            itemTableName = STANDINGBOOKITEM_TABLE;
        }
        if (!CmpStrUtil.isEmpty(tag)) {
            String[] split = propertyName.toLowerCase().split(tag);
            if (split.length == 2) {
                String l = LocaleUtils.getShortCode((Context)this.ctx);
                String sql = "select fid, fname_" + l + " name, fdataType from " + itemTableName + " where fieldSn = " + split[1];
                try {
                    IRowSet rowSet = CmpSQLUtil.executeQuery(this.ctx, sql);
                    if (rowSet.next()) {
                        alias = rowSet.getString("name");
                        String type = rowSet.getString("fdataType");
                        Integer dataTypeVal = CmpStrUtil.isEmpty(type) ? 1 : Integer.parseInt(type);
                        if (0 == dataTypeVal) {
                            dataType = DataType.INTEGER;
                            sqlType = SQLType.NUMERIC;
                        }
                        dataType = DataType.STRING;
                        sqlType = SQLType.NCLOB;
                    }
                    return null;
                }
                catch (BOSException e) {
                    throw new BOSException((Throwable)e);
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
            } else {
                return null;
            }
        }
        if (StringUtils.isEmpty((String)name) || StringUtils.isEmpty((String)alias)) {
            return null;
        }
        propInfo.setAlias(alias);
        propInfo.setName(name);
        propInfo.setDataType(dataType);
        ColumnInfo mappingField = new ColumnInfo();
        mappingField.setAlias(alias);
        mappingField.setName(name);
        mappingField.setTypeName(sqlType);
        propInfo.setMappingField(mappingField);
        return propInfo;
    }

    protected void pupolateCnSnOSFHandler(SqlParam param, Map<String, Object> cnSn, Map<String, Integer> dataTypeValueMap, Map<String, String> labCostTypeNumberFieldMap) throws EASBizException, BOSException {
        StandingBookItemCollection stbItemCollection;
        CmpBudgetItemCollection itemCollection = CmpBudgetItemFactory.getLocalInstance(this.ctx).getCmpBudgetItemCollection("select fieldSn,dataType where dataType = 0");
        if (null != itemCollection && itemCollection.size() > 0) {
            int size = itemCollection.size();
            for (int i = 0; i < size; ++i) {
                CmpBudgetItemInfo itemInfo = itemCollection.get(i);
                int fieldSn = itemInfo.getFieldSn();
                dataTypeValueMap.put(CMPBUDGETITEM_TAG + fieldSn, 0);
            }
        }
        if (null != (stbItemCollection = StandingBookItemFactory.getLocalInstance(this.ctx).getStandingBookItemCollection("select fieldSn,dataType where  dataType = 0")) && stbItemCollection.size() > 0) {
            int size = stbItemCollection.size();
            for (int i = 0; i < size; ++i) {
                StandingBookItemInfo itemInfo = stbItemCollection.get(i);
                int fieldSn = itemInfo.getFieldSn();
                dataTypeValueMap.put(STANDINGBOOKITEM_TAG + fieldSn, 0);
            }
        }
        super.pupolateCnSnOSFHandler(cnSn, dataTypeValueMap, labCostTypeNumberFieldMap);
    }

    protected boolean pupolateColumnAndDateTypesFhandler0(int k, String key, String fieldStr, PropertyInfo[] props, String[] columns, int[] datetypes, Map<String, Integer> dataTypeValueMap, Map<String, String> originMap) {
        if ("subBudgetAssign".equalsIgnoreCase(this.param.getScheme()) && (fieldStr.matches("(?i)s\\d+") || fieldStr.matches("(?i)t\\d+"))) {
            OwnPropertyInfo propInfo = new OwnPropertyInfo();
            propInfo.setName(fieldStr);
            if (!dataTypeValueMap.containsKey(fieldStr)) {
                propInfo.setDataType(DataType.STRING);
            } else {
                propInfo.setDataType(DataType.DECIMAL);
            }
            props[k - 1] = propInfo;
            columns[k - 1] = originMap.get(key.toUpperCase(Locale.ENGLISH).toString());
            datetypes[k - 1] = propInfo.getDataType().getSQLType(true).getSQLType();
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }
}

