/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.util;

import com.kingdee.bos.util.EASResource;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AesUtils {
    private static final Logger LOG = LoggerFactory.getLogger(AesUtils.class);
    private static final String ENCRYPT_ALG = "AES";
    private static final int IV_LENGTH_BYTE = 16;
    private static final String CIPHER_MODE = "AES/CBC/PKCS5Padding";

    public static SecretKey strKey2SecretKey(String strKey) {
        byte[] bytes = Base64.decodeBase64((String)strKey);
        return new SecretKeySpec(bytes, ENCRYPT_ALG);
    }

    public static String encrypt(String content, String secretKeyStr) {
        try {
            String random = AesUtils.getRandomNonce(16);
            byte[] iv = random.getBytes(StandardCharsets.UTF_8);
            IvParameterSpec parameterSpec = new IvParameterSpec(iv);
            Cipher cipher = Cipher.getInstance(CIPHER_MODE);
            cipher.init(1, (Key)AesUtils.strKey2SecretKey(secretKeyStr), parameterSpec);
            return random + Base64.encodeBase64String((byte[])cipher.doFinal(content.getBytes(StandardCharsets.UTF_8)));
        }
        catch (Exception e) {
            LOG.error("decrypt error: ", (Throwable)e);
            throw new RuntimeException(EASResource.getString((String)"com.kingdee.shr.compensation.resource.CommonResource", (String)"label222"));
        }
    }

    public static String decrypt(String content, String secretKeyStr) {
        try {
            byte[] iv = content.substring(0, 16).getBytes(StandardCharsets.UTF_8);
            IvParameterSpec parameterSpec = new IvParameterSpec(iv);
            byte[] decodeBase64 = Base64.decodeBase64((String)content.substring(16));
            Cipher cipher = Cipher.getInstance(CIPHER_MODE);
            cipher.init(2, (Key)AesUtils.strKey2SecretKey(secretKeyStr), parameterSpec);
            return new String(cipher.doFinal(decodeBase64), StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            LOG.error("decrypt error: ", (Throwable)e);
            throw new RuntimeException(EASResource.getString((String)"com.kingdee.shr.compensation.resource.CommonResource", (String)"label222"));
        }
    }

    public static String getRandomNonce(int number) {
        StringBuilder uid = new StringBuilder();
        SecureRandom rd = new SecureRandom();
        block5: for (int i = 0; i < number; ++i) {
            int type = rd.nextInt(3);
            switch (type) {
                case 0: {
                    uid.append(rd.nextInt(10));
                    continue block5;
                }
                case 1: {
                    uid.append((char)(rd.nextInt(25) + 65));
                    continue block5;
                }
                case 2: {
                    uid.append((char)(rd.nextInt(25) + 97));
                    continue block5;
                }
            }
        }
        return uid.toString();
    }
}

