/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.data.domain.db.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.data.domain.db.AbstractDBSourceJDBCAdapter;
import com.kingdee.shr.data.model.designtime.AbstractSource;
import com.kingdee.shr.data.model.designtime.source.DBSource;
import com.kingdee.shr.data.model.vo.AbstractNode;
import com.kingdee.shr.data.model.vo.FolderNode;

public class DMSourceJDBCAdapter
extends AbstractDBSourceJDBCAdapter {
    public static final String URL_TEMPLATE = "jdbc:dm://%s:%s/%s?useUnicode=true&characterEncoding=utf-8&zeroDateTimeBehavior=convertToNull";
    public static final String DRIVER = "dm.jdbc.driver.DmDriver";

    private DMSourceJDBCAdapter() {
    }

    public static AbstractDBSourceJDBCAdapter newInstance() {
        return new DMSourceJDBCAdapter();
    }

    @Override
    public String getLeftDelimiter() {
        return "\"";
    }

    @Override
    public String getRightDelimiter() {
        return "\"";
    }

    @Override
    public AbstractNode getUsableEntities(Context ctx, AbstractSource source) throws BOSException, EASBizException {
        FolderNode root = new FolderNode();
        DBSource dataBase = (DBSource)source;
        String sql = "SELECT OBJECT_NAME AS TABLE_NAME  FROM ALL_OBJECTS A WHERE OBJECT_TYPE ='TABLE' AND TEMPORARY != 'Y'";
        this.queryTableLeafNodes(ctx, root, dataBase, sql, null);
        return root;
    }

    @Override
    public String getJDBCUrl(DBSource dataBase) {
        return String.format(URL_TEMPLATE, dataBase.getDbAddress(), dataBase.getDbPort(), dataBase.getDbName());
    }

    @Override
    public String getDriverClassName() {
        return DRIVER;
    }
}

