/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.data.domain.db.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.data.domain.db.AbstractDBSourceJDBCAdapter;
import com.kingdee.shr.data.model.designtime.AbstractSource;
import com.kingdee.shr.data.model.designtime.source.DBSource;
import com.kingdee.shr.data.model.vo.AbstractNode;
import com.kingdee.shr.data.model.vo.FolderNode;
import java.util.HashSet;
import java.util.Set;

public class SQLServerSourceJDBCAdapter
extends AbstractDBSourceJDBCAdapter {
    public static final String URL_TEMPLATE = "jdbc:sqlserver://%s:%s;DatabaseName=%s";
    public static final String DRIVER = "com.microsoft.sqlserver.jdbc.SQLServerDriver";
    private static Set<String> ignoreDBs = new HashSet<String>();

    private SQLServerSourceJDBCAdapter() {
    }

    public static AbstractDBSourceJDBCAdapter newInstance() {
        return new SQLServerSourceJDBCAdapter();
    }

    @Override
    public String getLeftDelimiter() {
        return "\"";
    }

    @Override
    public String getRightDelimiter() {
        return "\"";
    }

    @Override
    public AbstractNode getUsableEntities(Context ctx, AbstractSource source) throws BOSException, EASBizException {
        FolderNode root = new FolderNode();
        DBSource dataBase = (DBSource)source;
        String sql = "SELECT NAME FROM SYSOBJECTS WHERE TYPE = 'U' OR TYPE = 'V' ORDER BY NAME";
        this.queryTableLeafNodes(ctx, root, dataBase, sql, null);
        return root;
    }

    @Override
    protected String getJDBCUrl(DBSource dataBase) throws BOSException {
        String dbaddress = dataBase.getDbAddress();
        String dbport = dataBase.getDbPort();
        String dbName = dataBase.getDbName();
        return String.format(URL_TEMPLATE, dbaddress, dbport, dbName);
    }

    @Override
    protected String getDriverClassName() {
        return DRIVER;
    }

    static {
        ignoreDBs.add("master");
        ignoreDBs.add("msdb");
        ignoreDBs.add("model");
        ignoreDBs.add("tempdb");
        ignoreDBs.add("Resource");
    }
}

