/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.data.domain.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.common.util.CloseUtil;
import com.kingdee.shr.common.util.SQLVerifyUtils;
import com.kingdee.shr.common.util.SystemPropertyUtil;
import com.kingdee.shr.data.model.designtime.source.DBSource;
import com.kingdee.shr.dataset.model.RuntimeSQLInfo;
import com.kingdee.shr.dataset.model.SQLResult;
import com.kingdee.shr.dataset.service.util.SQLExcuteHelper;
import edu.emory.mathcs.backport.java.util.Arrays;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class SQLHelperUtils {
    private static Logger logger = Logger.getLogger(SQLHelperUtils.class);
    private static final int DEFAULT_MAX_PARAM_SIZE = 1000;
    private static final String MAX_PARAM_SIZE_KEY = "shr.sql.max.param.size";

    private SQLHelperUtils() {
    }

    public static int getMaxParamSize() {
        return SystemPropertyUtil.getInt(MAX_PARAM_SIZE_KEY, 1000);
    }

    public static RuntimeUserSQL processUserSQL(Context ctx, DBSource.UserSQL userSQL, String permItemId) throws BOSException, EASBizException {
        String sql = SQLVerifyUtils.doMatcher(userSQL.getContent(), ctx);
        RuntimeUserSQL runtimeUserSQL = new RuntimeUserSQL();
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("permItemId", permItemId);
        SQLHelperUtils.initParam(param, userSQL);
        SQLExcuteHelper sqlExceteHelper = new SQLExcuteHelper(ctx, param);
        RuntimeSQLInfo sqlInfo = sqlExceteHelper.convertVariableAndParam(sql);
        sql = sqlInfo.getSql();
        if (null != sqlInfo.getParams()) {
            runtimeUserSQL.setParams(Arrays.asList((Object[])sqlInfo.getParams()));
        }
        runtimeUserSQL.setSQL(sql);
        return runtimeUserSQL;
    }

    private static void initParam(Map<String, Object> param, DBSource.UserSQL userSQL) {
        SQLResult sqlResult = new SQLResult();
        sqlResult.setSourceParam(userSQL.getParams());
        sqlResult.setSetType(30);
        param.put("sqlResult", sqlResult);
        param.put("runParam", userSQL.getRunParams());
    }

    public static void setParams(PreparedStatement ps, int index, Object param) throws SQLException {
        if (param != null) {
            if (param instanceof Calendar) {
                Calendar calendar = (Calendar)param;
                Timestamp date = new Timestamp(calendar.getTimeInMillis());
                ps.setTimestamp(index, date);
            } else if (param instanceof Date) {
                Timestamp date = new Timestamp(((Date)param).getTime());
                ps.setTimestamp(index, date);
            } else if (param instanceof Boolean) {
                ps.setBoolean(index, (Boolean)param);
            } else if (param instanceof Long) {
                ps.setLong(index, (Long)param);
            } else if (param instanceof BigDecimal) {
                ps.setBigDecimal(index, (BigDecimal)param);
            } else {
                ps.setString(index, param.toString());
            }
        }
    }

    public static DBSource.DBType getDbType(Context ctx) throws BOSException {
        try {
            String dbStrType = String.valueOf(ctx.get((Object)"dbType")).toUpperCase();
            logger.info((Object)("SHR DB CENTER DB TYPE:" + dbStrType));
            if (dbStrType.contains("MS SQL SERVER")) {
                return DBSource.DBType.SQLSERVER;
            }
            return DBSource.DBType.valueOf(dbStrType);
        }
        catch (Exception e) {
            return SQLHelperUtils.getDbTypeFromDriverName(ctx);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static DBSource.DBType getDbTypeFromDriverName(Context ctx) throws BOSException {
        Connection conn = null;
        try {
            DBSource.DBType[] dbTypes;
            conn = EJBFactory.getConnection((Context)ctx);
            String dataBaseProductName = conn.getMetaData().getDatabaseProductName().toUpperCase();
            if (dataBaseProductName.contains("ORACLE")) {
                DBSource.DBType dBType = DBSource.DBType.ORACLE;
                return dBType;
            }
            if (dataBaseProductName.contains("MICROSOFT SQL SERVER")) {
                DBSource.DBType dBType = DBSource.DBType.SQLSERVER;
                return dBType;
            }
            DBSource.DBType[] dBTypeArray = dbTypes = DBSource.DBType.values();
            int n = dBTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                DBSource.DBType dbType = dBTypeArray[n2];
                if (dataBaseProductName.indexOf(dbType.name()) != -1) {
                    DBSource.DBType dBType = dbType;
                    return dBType;
                }
                ++n2;
            }
            throw new BOSException("load db driver failed");
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
        finally {
            CloseUtil.close(conn);
        }
    }

    public static class RuntimeUserSQL {
        private String sql;
        private List<Object> params = new ArrayList<Object>();

        public void setSQL(String sql) {
            this.sql = sql;
        }

        public String getSQL() {
            return this.sql;
        }

        public void addParam(Object param) {
            this.params.add(param);
        }

        public void addParams(Collection<Object> params) {
            this.params.addAll(params);
        }

        public List<Object> getParam() {
            return this.params;
        }

        public void setParams(List<Object> params) {
            this.params = params;
        }
    }
}

