/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.dataset.service.sql;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.dataplatform.AggregationEnum;
import com.kingdee.shr.dataplatform.NumberFormatEnum;
import com.kingdee.shr.dataset.model.BizObjectItem;
import com.kingdee.shr.dataset.model.DesignDataSetCommon;
import com.kingdee.shr.dataset.model.SQLFieldMappingItem;
import com.kingdee.shr.dataset.model.SQLResult;
import com.kingdee.shr.dataset.model.SelectorItem;
import com.kingdee.shr.dataset.model.SelectorObjItem;
import com.kingdee.shr.dataset.model.VariableItem;
import com.kingdee.shr.dataset.service.sql.SqlParsingService;
import com.kingdee.shr.dataset.service.util.SelectorHelper;
import com.kingdee.util.StringUtils;
import java.text.MessageFormat;
import java.util.Map;
import org.apache.log4j.Logger;

public class CustomSqlParsingService
extends SqlParsingService {
    protected static Logger logger = Logger.getLogger(CustomSqlParsingService.class);

    @Override
    public SQLResult execute(Context ctx, Map<String, Object> param) throws EASBizException, BOSException {
        DesignDataSetCommon designDataSetCommon = (DesignDataSetCommon)param.get("designDataSetCommon");
        if (null == designDataSetCommon) {
            return null;
        }
        if (designDataSetCommon.getBizObject().isSql() && designDataSetCommon.getBizObject().getCustomSQL().isUseSourceSQLQuery()) {
            this.helper = new SelectorHelper(designDataSetCommon);
            return this.getCustomSourceSQL(ctx, designDataSetCommon);
        }
        return super.execute(ctx, (Map)param);
    }

    private SQLResult getCustomSourceSQL(Context ctx, DesignDataSetCommon designDataSetCommon) {
        SQLResult result = new SQLResult();
        result.setSql(designDataSetCommon.getBizObject().getCustomSQL().getSql().getText());
        result.setSourceParam(designDataSetCommon.getParams());
        SelectorObjItem soi = designDataSetCommon.getSelector();
        result.setUseSourceSQLQuery(true);
        if (null != soi.getDimension() && !soi.getDimension().isEmpty()) {
            for (SelectorItem s : soi.getDimension()) {
                result.getSqlFieldMapping().add(this.assembleCustomSQLFieldMappingItem(s));
            }
        }
        if (null != soi.getMeasure() && !soi.getMeasure().isEmpty()) {
            for (SelectorItem s : soi.getMeasure()) {
                result.getSqlFieldMapping().add(this.assembleCustomSQLFieldMappingItem(s));
            }
        }
        return result;
    }

    private SQLFieldMappingItem assembleCustomSQLFieldMappingItem(SelectorItem selector) {
        SQLFieldMappingItem item = new SQLFieldMappingItem();
        String fieldName = selector.getName();
        if (StringUtils.isEmpty((String)fieldName)) {
            fieldName = selector.getPhysicsName();
        }
        item.setFieldName(fieldName);
        item.setAlias(selector.getAlias());
        item.setDataType(selector.getDataType());
        item.setShowDataType(selector.getDataTypeTran());
        if (!StringUtils.isEmpty((String)selector.getFormat())) {
            item.setFormat(selector.getFormat());
            if ("NUMBER".equals(selector.getDataTypeTran())) {
                item.setFormat(NumberFormatEnum.getEnum(selector.getFormat()).getValue());
            }
        }
        return item;
    }

    @Override
    protected String getTableName(Context ctx, BizObjectItem bizObjectItem) {
        if (bizObjectItem.isSql()) {
            StringBuilder sb = new StringBuilder();
            sb.append("(").append(bizObjectItem.getCustomSQL().getSql().getText()).append(")");
            return sb.toString();
        }
        return bizObjectItem.getNumber();
    }

    @Override
    protected void setSQLFieldMappingItemRefSource(SelectorItem selector, SQLFieldMappingItem item) {
    }

    @Override
    protected String getField(String fieldName, String tableAlias) {
        return MessageFormat.format("{0}.{1}", tableAlias, fieldName);
    }

    @Override
    protected String getFieldSourceRef(String fieldName, String tableAlias) {
        return "";
    }

    @Override
    protected void setMeasureDataType(SelectorItem selector, SQLFieldMappingItem item, AggregationEnum aggregationEnum) {
        if (null == aggregationEnum) {
            return;
        }
        if (AggregationEnum.count_distinct.equals((Object)aggregationEnum) || AggregationEnum.count.equals((Object)aggregationEnum)) {
            item.setDataType(DataType.INTEGER.getName());
            item.setShowDataType(DataType.INTEGER.getName());
        }
    }

    @Override
    protected void checkVariable(VariableItem vi) throws BOSException, EASBizException {
    }
}

