/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.data.domain.db.query;

import com.kingdee.bos.privacy.ParamData;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.data.domain.db.handler.ResultSetHandler;
import com.kingdee.shr.data.domain.db.query.AbstractQueryRunner;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class QueryRunner
extends AbstractQueryRunner {
    public QueryRunner(boolean pmdKnownBroken) {
        super(pmdKnownBroken);
    }

    public <T> T query(String sql, ResultSetHandler<T> rsh, ParamData param, Object ... params) throws SQLException, EASBizException {
        Connection conn = this.prepareConnection();
        return this.query(conn, true, sql, rsh, param, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T query(Connection conn, boolean closeConn, String sql, ResultSetHandler<T> rsh, ParamData paramData, Object ... params) throws SQLException, EASBizException {
        if (conn == null) {
            throw new SQLException("Null connection");
        }
        if (sql == null) {
            if (!closeConn) throw new SQLException("Null SQL statement");
            this.close(conn);
            throw new SQLException("Null SQL statement");
        }
        if (rsh == null) {
            if (!closeConn) throw new SQLException("Null ResultSetHandler");
            this.close(conn);
            throw new SQLException("Null ResultSetHandler");
        }
        PreparedStatement stmt = null;
        ResultSet rs = null;
        T result = null;
        try {
            stmt = this.prepareStatement(conn, sql);
            this.fillStatement(stmt, params);
            if (null != paramData) {
                ParamData.setParamDataToStatement((ParamData)paramData, (PreparedStatement)stmt);
            }
            rs = stmt.executeQuery();
            result = rsh.handle(rs);
            try {
                this.close(rs);
                return result;
            }
            finally {
                this.close(stmt);
                if (closeConn) {
                    this.close(conn);
                }
            }
        }
        catch (SQLException var33) {
            this.rethrow(var33, sql, params);
            return result;
        }
        finally {
            try {
                this.close(rs);
            }
            finally {
                this.close(stmt);
                if (closeConn) {
                    this.close(conn);
                }
            }
        }
    }

    protected PreparedStatement wrapPrepareStatement(String sql, PreparedStatement preparedStatement) {
        return preparedStatement;
    }

    @Override
    protected Connection prepareConnection() throws SQLException {
        return null;
    }
}

