/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.data.domain.imp;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.common.util.CloseUtil;
import com.kingdee.shr.data.domain.AbstractDataSourceDomain;
import com.kingdee.shr.data.domain.db.AbstractDBSourceJDBCAdapter;
import com.kingdee.shr.data.domain.db.AbstractDBTableCreator;
import com.kingdee.shr.data.domain.imp.CommonDBSourceDomain;
import com.kingdee.shr.data.domain.service.IConnectionFactory;
import com.kingdee.shr.data.model.designtime.AbstractSource;
import com.kingdee.shr.data.model.designtime.source.DBSource;
import com.kingdee.shr.data.model.runtime.FieldParam;
import com.kingdee.shr.data.model.runtime.Item;
import com.kingdee.shr.data.model.runtime.Table;
import com.kingdee.shr.data.model.vo.AbstractNode;
import com.kingdee.shr.data.model.vo.FolderNode;
import com.kingdee.shr.data.model.vo.LeafNode;
import com.kingdee.shr.dataplatform.CustomSQLCollection;
import com.kingdee.shr.dataplatform.CustomSQLFactory;
import com.kingdee.shr.dataplatform.CustomSQLInfo;
import com.kingdee.shr.dataplatform.ICustomSQL;
import com.kingdee.shr.dataplatform.cache.DataplatformCacheHelper;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class AbstractDBSourceDomain
extends AbstractDataSourceDomain {
    protected AbstractDBSourceJDBCAdapter jdbcAdapter;

    public static AbstractDBSourceDomain newInstance(AbstractSource source) throws BOSException {
        AbstractDBSourceJDBCAdapter jdbcAdapter = AbstractDBSourceJDBCAdapter.newInstance(source);
        return new CommonDBSourceDomain(jdbcAdapter);
    }

    public AbstractDBSourceDomain(AbstractDBSourceJDBCAdapter jdbcAdapter) {
        this.jdbcAdapter = jdbcAdapter;
    }

    public AbstractDBSourceJDBCAdapter getJdbcAdapter() {
        return this.jdbcAdapter;
    }

    public final void setConnectionFactory(IConnectionFactory connectionFactory) {
        this.jdbcAdapter.setConnectionFactory(connectionFactory);
    }

    public final IConnectionFactory getConnectionFactory() {
        return this.jdbcAdapter.getConnectionFactory();
    }

    @Override
    public AbstractNode getUsableEntities(Context ctx, AbstractSource source) throws BOSException, EASBizException {
        AbstractNode node = null;
        if (DBSource.AssociateType.CUSTOMSQL.name().equals(((DBSource)source).getName())) {
            String key = DataplatformCacheHelper.getRealKey(ctx, "DATAPLATFORM_DATASET_CUSTOMSQL_TREE");
            node = (AbstractNode)DataplatformCacheHelper.get(ctx, 5, key);
            if (null == node && ((FolderNode)(node = this.getUsableCustomSqls(ctx))).getChildCount() != 0) {
                DataplatformCacheHelper.set(ctx, 5, key, node);
            }
        } else {
            String key = DataplatformCacheHelper.getRealKey(ctx, "DATAPLATFORM_DATASET_TABLE_TREE");
            node = (AbstractNode)DataplatformCacheHelper.get(ctx, 5, key);
            if (null == node && ((FolderNode)(node = this.jdbcAdapter.getUsableEntities(ctx, source))).getChildCount() != 0) {
                DataplatformCacheHelper.set(ctx, 5, key, node);
            }
        }
        return node;
    }

    public List<Map<String, Object>> getCustomData(Context ctx, DBSource source) throws BOSException, EASBizException {
        return this.jdbcAdapter.getCustomData(ctx, source);
    }

    public Table getTablePeer(Context ctx, AbstractSource source, String associateName) throws BOSException {
        DBSource dataBase = (DBSource)source;
        AbstractDBTableCreator dbTable = this.jdbcAdapter.createDBTableCreator(dataBase, associateName);
        return dbTable.getTablePeer(ctx);
    }

    @Override
    public List<Item> getDataByField(Context ctx, AbstractSource source, FieldParam field) throws BOSException {
        ArrayList<Item> list = new ArrayList<Item>();
        DBSource dataBase = (DBSource)source;
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            conn = this.jdbcAdapter.getConnection(dataBase);
            ps = conn.prepareStatement(this.getMakeSql(field));
            rs = ps.executeQuery();
            while (rs.next()) {
                if (null == rs.getObject(1)) continue;
                Item item = new Item();
                item.setValue(rs.getObject(1));
                list.add(item);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                CloseUtil.close(conn, ps, rs);
                throw throwable;
            }
        }
        CloseUtil.close(conn, ps, rs);
        return list;
    }

    private String getMakeSql(FieldParam field) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT DISTINCT ");
        sql.append(field.getField());
        sql.append(" from ");
        sql.append(field.getTableName());
        return sql.toString();
    }

    private AbstractNode getUsableCustomSqls(Context ctx) throws BOSException {
        FolderNode fRootNode = new FolderNode();
        ICustomSQL iCustomSQL = CustomSQLFactory.getLocalInstance(ctx);
        CustomSQLCollection coll = iCustomSQL.getCustomSQLCollection();
        Iterator iter = coll.iterator();
        while (iter.hasNext()) {
            LeafNode leafNode = new LeafNode();
            CustomSQLInfo model = (CustomSQLInfo)iter.next();
            leafNode.setName(model.getId().toString());
            leafNode.setDisplayName(model.getName());
            leafNode.setCommentInfo(model.getNumber());
            leafNode.setType(model.isIsKSQL() ? DBSource.UserSQL.SQLType.KSQL.name() : DBSource.UserSQL.SQLType.SQL.name());
            fRootNode.addChild(leafNode);
        }
        return fRootNode;
    }
}

