/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.data.domain.util;

import com.kingdee.shr.data.model.designtime.type.DataType;
import java.util.HashMap;
import java.util.Map;

public class DataTypeUtil {
    private static Map<String, DataType> JAVA_DATA_TYPE_MAP = new HashMap<String, DataType>();
    private static Map<Integer, DataType> SQL_TYPES_MAP = new HashMap<Integer, DataType>();
    private static Map<DataType, DataType.DataTypeTran> TYPES_TYPETRANS_MAP = new HashMap<DataType, DataType.DataTypeTran>();
    private static Map<DataType.DataTypeEnum, DataType.DataTypeTran> ENUM_TYPETRANS_MAP = new HashMap<DataType.DataTypeEnum, DataType.DataTypeTran>();

    private DataTypeUtil() {
    }

    public static DataType parseDataType(int sqlTypes) {
        return SQL_TYPES_MAP.get(sqlTypes);
    }

    public static DataType.DataTypeTran parseDataTypeTran(DataType dataType) {
        return TYPES_TYPETRANS_MAP.get((Object)dataType);
    }

    public static DataType.DataTypeTran parseDataTypeTran(DataType.DataTypeEnum dataType) {
        return ENUM_TYPETRANS_MAP.get((Object)dataType);
    }

    public static boolean checkSqlTypes(int sqlTypes) {
        return SQL_TYPES_MAP.containsKey(sqlTypes);
    }

    public static DataType parseDataType(String columnClassName) {
        return JAVA_DATA_TYPE_MAP.get(columnClassName);
    }

    public static boolean checkClassNameTypes(String classNameTypes) {
        return JAVA_DATA_TYPE_MAP.containsKey(classNameTypes);
    }

    static {
        JAVA_DATA_TYPE_MAP.put("java.lang.Boolean", DataType.BOOLEAN);
        JAVA_DATA_TYPE_MAP.put("java.lang.Byte", DataType.INT);
        JAVA_DATA_TYPE_MAP.put("java.lang.Short", DataType.INT);
        JAVA_DATA_TYPE_MAP.put("java.lang.Integer", DataType.INT);
        JAVA_DATA_TYPE_MAP.put("java.lang.Long", DataType.INT);
        JAVA_DATA_TYPE_MAP.put("java.lang.Double", DataType.NUMBER);
        JAVA_DATA_TYPE_MAP.put("java.lang.Float", DataType.NUMBER);
        JAVA_DATA_TYPE_MAP.put("java.math.BigDecimal", DataType.NUMBER);
        JAVA_DATA_TYPE_MAP.put("java.sql.Time", DataType.TIME);
        JAVA_DATA_TYPE_MAP.put("java.sql.Timestamp", DataType.TIMESTAMP);
        JAVA_DATA_TYPE_MAP.put("oracle.sql.TIMESTAMP", DataType.TIMESTAMP);
        JAVA_DATA_TYPE_MAP.put("java.util.Date", DataType.DATE);
        JAVA_DATA_TYPE_MAP.put("java.sql.Date", DataType.DATE);
        JAVA_DATA_TYPE_MAP.put("java.lang.String", DataType.STRING);
        JAVA_DATA_TYPE_MAP.put("java.util.UUID", DataType.STRING);
        SQL_TYPES_MAP.put(2003, null);
        SQL_TYPES_MAP.put(-5, DataType.INT);
        SQL_TYPES_MAP.put(-2, null);
        SQL_TYPES_MAP.put(-7, DataType.BOOLEAN);
        SQL_TYPES_MAP.put(2004, null);
        SQL_TYPES_MAP.put(16, DataType.BOOLEAN);
        SQL_TYPES_MAP.put(1, DataType.STRING);
        SQL_TYPES_MAP.put(2005, null);
        SQL_TYPES_MAP.put(70, null);
        SQL_TYPES_MAP.put(91, DataType.DATE);
        SQL_TYPES_MAP.put(3, DataType.NUMBER);
        SQL_TYPES_MAP.put(2001, null);
        SQL_TYPES_MAP.put(8, DataType.NUMBER);
        SQL_TYPES_MAP.put(6, DataType.NUMBER);
        SQL_TYPES_MAP.put(4, DataType.INT);
        SQL_TYPES_MAP.put(2000, null);
        SQL_TYPES_MAP.put(-16, null);
        SQL_TYPES_MAP.put(-4, null);
        SQL_TYPES_MAP.put(-1, DataType.STRING);
        SQL_TYPES_MAP.put(-15, DataType.STRING);
        SQL_TYPES_MAP.put(2011, null);
        SQL_TYPES_MAP.put(0, null);
        SQL_TYPES_MAP.put(2, DataType.NUMBER);
        SQL_TYPES_MAP.put(-9, DataType.STRING);
        SQL_TYPES_MAP.put(1111, null);
        SQL_TYPES_MAP.put(7, DataType.NUMBER);
        SQL_TYPES_MAP.put(2006, null);
        SQL_TYPES_MAP.put(2012, null);
        SQL_TYPES_MAP.put(-8, null);
        SQL_TYPES_MAP.put(5, DataType.INT);
        SQL_TYPES_MAP.put(2009, null);
        SQL_TYPES_MAP.put(2002, null);
        SQL_TYPES_MAP.put(92, DataType.TIME);
        SQL_TYPES_MAP.put(2013, DataType.TIME);
        SQL_TYPES_MAP.put(93, DataType.TIMESTAMP);
        SQL_TYPES_MAP.put(2014, DataType.TIMESTAMP);
        SQL_TYPES_MAP.put(-6, DataType.INT);
        SQL_TYPES_MAP.put(-3, null);
        SQL_TYPES_MAP.put(12, DataType.STRING);
        TYPES_TYPETRANS_MAP.put(DataType.BOOLEAN, DataType.DataTypeTran.NUMBER);
        TYPES_TYPETRANS_MAP.put(DataType.INT, DataType.DataTypeTran.NUMBER);
        TYPES_TYPETRANS_MAP.put(DataType.NUMBER, DataType.DataTypeTran.NUMBER);
        TYPES_TYPETRANS_MAP.put(DataType.DATE, DataType.DataTypeTran.DATE);
        TYPES_TYPETRANS_MAP.put(DataType.TIME, DataType.DataTypeTran.DATE);
        TYPES_TYPETRANS_MAP.put(DataType.TIMESTAMP, DataType.DataTypeTran.DATE);
        TYPES_TYPETRANS_MAP.put(DataType.STRING, DataType.DataTypeTran.STRING);
        TYPES_TYPETRANS_MAP.put(DataType.F7, DataType.DataTypeTran.STRING);
        TYPES_TYPETRANS_MAP.put(DataType.ENUM, DataType.DataTypeTran.STRING);
        ENUM_TYPETRANS_MAP.put(DataType.DataTypeEnum.NUMBERENUM, DataType.DataTypeTran.NUMBER);
        ENUM_TYPETRANS_MAP.put(DataType.DataTypeEnum.STRINGENUM, DataType.DataTypeTran.STRING);
    }
}

