/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.dataset.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.shr.base.syssetting.json.JSONUtils;
import com.kingdee.shr.dataplatform.DataSetConfigInfo;
import com.kingdee.shr.dataplatform.DataSetException;
import com.kingdee.shr.dataplatform.ISQLResult;
import com.kingdee.shr.dataplatform.SQLResultFactory;
import com.kingdee.shr.dataplatform.SQLResultInfo;
import com.kingdee.shr.dataplatform.SQLTypeEnum;
import com.kingdee.shr.dataplatform.SetTypeEnum;
import com.kingdee.shr.dataplatform.cache.DataplatformCacheHelper;
import com.kingdee.shr.dataset.model.DataSourceItem;
import com.kingdee.shr.dataset.model.DesignDataSetCommon;
import com.kingdee.shr.dataset.model.DesignDataSetEntity;
import com.kingdee.shr.dataset.model.DesignDataSetJava;
import com.kingdee.shr.dataset.model.DesignDataSetSql;
import com.kingdee.shr.dataset.model.DesignDataSetTable;
import com.kingdee.shr.dataset.model.SQLResult;
import com.kingdee.shr.dataset.service.DataPlatformServiceFactory;
import com.kingdee.shr.dataset.service.IDataPlatformService;
import com.kingdee.shr.ml.util.SHRServerResource;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class DataSetUtils {
    private static Logger logger = Logger.getLogger(DataSetUtils.class);
    private static final List<String> SUPPORT_LANGUE = new ArrayList<String>();
    private static final String PATTERN = "^[\\w@\\$\\^!~,.\\*\\- ]+$";

    private DataSetUtils() {
    }

    public static DesignDataSetCommon getDataSetModel(Context ctx, DataSetConfigInfo model) throws EASBizException {
        boolean isProductionMode;
        if (null == model) {
            throw new DataSetException(DataSetException.PARAMS_EXCEPTION, new Object[]{"model"});
        }
        String content = model.getContent();
        Object value = model.get("isProductionMode");
        boolean bl = isProductionMode = null != value ? (Boolean)value : true;
        if (isProductionMode && !StringUtils.isEmpty((String)model.getExtend())) {
            content = model.getExtend();
        }
        if (StringUtils.isEmpty((String)content)) {
            throw new DataSetException(DataSetException.PARAMS_EXCEPTION, new Object[]{"dataSet content is null !"});
        }
        return DataSetUtils.getDataSetModel(ctx, content, model.getSetType());
    }

    public static DesignDataSetCommon getDataSetModel(Context ctx, String content, SetTypeEnum datasetType) throws EASBizException {
        if (StringUtils.isEmpty((String)content)) {
            throw new DataSetException(DataSetException.PARAMS_EXCEPTION, new Object[]{"content is null"});
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)content);
        }
        DesignDataSetCommon designDataSetCommon = null;
        if (SetTypeEnum.META_ENTITY.equals((Object)datasetType)) {
            designDataSetCommon = (DesignDataSetEntity)JSONUtils.convertJsonToObject((Context)ctx, (String)content, DesignDataSetEntity.class);
        } else if (SetTypeEnum.DB_TABLE.equals((Object)datasetType)) {
            designDataSetCommon = (DesignDataSetTable)JSONUtils.convertJsonToObject((Context)ctx, (String)content, DesignDataSetTable.class);
        } else if (SetTypeEnum.CUSTOM_SQL.equals((Object)datasetType)) {
            designDataSetCommon = (DesignDataSetSql)JSONUtils.convertJsonToObject((Context)ctx, (String)content, DesignDataSetSql.class);
        } else if (SetTypeEnum.JAVA_INTERFACE.equals((Object)datasetType)) {
            designDataSetCommon = (DesignDataSetJava)JSONUtils.convertJsonToObject((Context)ctx, (String)content, DesignDataSetJava.class);
        }
        return designDataSetCommon;
    }

    public static void checkNumberRule(String number) throws EASBizException {
        if (!Pattern.matches(PATTERN, number)) {
            throw new DataSetException(DataSetException.NUMBER_RULE_EXCEPTION);
        }
    }

    public static Map<String, String> getBooleanData(Context ctx) {
        HashMap<String, String> booleanConvert = new HashMap<String, String>();
        booleanConvert.put("0", SHRServerResource.getString((String)"com.kingdee.shr.report.ReportResource", (String)"no", (Context)ctx));
        booleanConvert.put("1", SHRServerResource.getString((String)"com.kingdee.shr.report.ReportResource", (String)"yes", (Context)ctx));
        return booleanConvert;
    }

    public static List<String> getSupportLangue() {
        return SUPPORT_LANGUE;
    }

    public static String getUserDataSetSelectSql(String value) {
        StringBuffer subSb = new StringBuffer(200);
        subSb.append(" select u.fid from T_SHR_DataSetConfigUser eu join  T_PM_User u on eu.FUserID = u.fid where eu.fdatasetid = '" + value + "'");
        subSb.append(" UNION ");
        subSb.append(" select u.fid from T_SHR_DataSetConfigRole er join T_PM_UserRoleOrg ur on er.FRoleID = ur.FRoleID join T_PM_User u on ur.FUserID = u.fid where er.fdatasetid = '" + value + "'");
        return subSb.toString();
    }

    public static String getDataSetSelectSql(String value) {
        StringBuffer subSb = new StringBuffer(200);
        subSb.append(" select eu.fdatasetid from T_SHR_DataSetConfigUser eu join  T_PM_User u on eu.FUserID = u.fid where u.fid = '" + value + "'");
        subSb.append(" UNION ");
        subSb.append(" select er.fdatasetid from T_SHR_DataSetConfigRole er join T_PM_UserRoleOrg ur on er.FRoleID = ur.FRoleID join T_PM_User u on ur.FUserID = u.fid where u.fid = '" + value + "'");
        return subSb.toString();
    }

    public static void saveSQLResultInfo(Context ctx, IObjectPK pk, String content, String dsId, SetTypeEnum datasetType) throws EASBizException, BOSException {
        SQLResult result = DataSetUtils.getSQLResult(ctx, content, datasetType, dsId);
        DataSetUtils.saveSQLResultInfo(ctx, pk.toString(), result);
    }

    private static void saveSQLResultInfo(Context ctx, String datasetID, SQLResult result) throws EASBizException, BOSException {
        ISQLResult iSQLResult = SQLResultFactory.getLocalInstance(ctx);
        SQLResultInfo resultInfo = null;
        String oql = " where boid='" + datasetID + "'";
        if (iSQLResult.exists(oql)) {
            resultInfo = iSQLResult.getSQLResultInfo(oql);
        } else {
            resultInfo = new SQLResultInfo();
            resultInfo.setBoid(datasetID);
            resultInfo.setType(SQLTypeEnum.DataSetSQL);
        }
        resultInfo.setContent(JSONUtils.convertObjectToJson((Context)ctx, (Object)result));
        iSQLResult.save((CoreBaseInfo)resultInfo);
        DataplatformCacheHelper.remove(ctx, 2, datasetID);
    }

    public static SQLResult getSQLResultAndSaveSQLResult(Context ctx, String datasetID) throws EASBizException, BOSException {
        if (StringUtils.isEmpty((String)datasetID)) {
            return null;
        }
        IDataPlatformService service = DataPlatformServiceFactory.getPlateformService("/dataplateform/datasetSQL.do");
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("datasetID", datasetID);
        SQLResult result = (SQLResult)service.execute(ctx, param);
        DataSetUtils.saveSQLResultInfo(ctx, datasetID, result);
        return result;
    }

    public static SQLResult getSQLResult(Context ctx, String content, SetTypeEnum datasetType, String datasourceID) throws EASBizException, BOSException {
        if (StringUtils.isEmpty((String)content) || null == datasetType) {
            return null;
        }
        IDataPlatformService service = DataPlatformServiceFactory.getPlateformService("/dataplateform/datasetSQL.do");
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("datasetContent", content);
        param.put("datasetType", (Object)datasetType);
        SQLResult result = (SQLResult)service.execute(ctx, param);
        DataSourceItem ds = new DataSourceItem();
        ds.setId(datasourceID);
        result.setDataSourceItem(ds);
        return result;
    }

    static {
        SUPPORT_LANGUE.add("l1");
        SUPPORT_LANGUE.add("l2");
        SUPPORT_LANGUE.add("l3");
    }
}

