/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.econtractservice.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.person.Person;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.HRBillBaseCollection;
import com.kingdee.eas.hr.base.HRBillBaseEntryInfo;
import com.kingdee.eas.hr.base.HRBillBaseInfo;
import com.kingdee.eas.hr.base.IHRBillBase;
import com.kingdee.eas.hr.contract.ContractChangeBizBillEntryFactory;
import com.kingdee.eas.hr.contract.ContractChangeBizBillEntryInfo;
import com.kingdee.eas.hr.contract.ContractChangeBizBillInfo;
import com.kingdee.eas.hr.contract.ContractEndBizBillEntryInfo;
import com.kingdee.eas.hr.contract.ContractEndBizBillInfo;
import com.kingdee.eas.hr.contract.ContractFreeBizBillEntryInfo;
import com.kingdee.eas.hr.contract.ContractFreeBizBillInfo;
import com.kingdee.eas.hr.contract.ContractPreSignBizBillEntryInfo;
import com.kingdee.eas.hr.contract.ContractPreSignBizBillInfo;
import com.kingdee.eas.hr.contract.ContractRenewBizBillEntryFactory;
import com.kingdee.eas.hr.contract.ContractRenewBizBillEntryInfo;
import com.kingdee.eas.hr.contract.ContractRenewBizBillInfo;
import com.kingdee.eas.hr.contract.ContractSignBizBillEntryInfo;
import com.kingdee.eas.hr.contract.ContractSignBizBillInfo;
import com.kingdee.eas.hr.contract.OtherContractChangeBizBillEntryInfo;
import com.kingdee.eas.hr.contract.OtherContractRenewBizBillEntryInfo;
import com.kingdee.eas.hr.contract.OtherContractSignBizBillEntryInfo;
import com.kingdee.eas.hr.contract.OtherContractSignBizBillInfo;
import com.kingdee.eas.hr.contract.OtherFollowLaborConEntryInfo;
import com.kingdee.eas.hr.contract.OtherFollowPreConEntryInfo;
import com.kingdee.eas.hr.emp.ContractTempletInfo;
import com.kingdee.eas.hr.emp.LabContractFirstPartyInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.shr.base.syssetting.BaseItemStateEnum;
import com.kingdee.shr.econtractservice.EContractCompanyTaskCollection;
import com.kingdee.shr.econtractservice.EContractCompanyTaskFactory;
import com.kingdee.shr.econtractservice.EContractCompanyTaskInfo;
import com.kingdee.shr.econtractservice.SSCEContractRecordCollection;
import com.kingdee.shr.econtractservice.SSCEContractRecordFactory;
import com.kingdee.shr.econtractservice.SSCEContractRecordInfo;
import com.kingdee.shr.econtractservice.SSCEContractTaskCollection;
import com.kingdee.shr.econtractservice.SSCEContractTaskFactory;
import com.kingdee.shr.econtractservice.SSCEContractTaskInfo;
import com.kingdee.shr.elecontract.EContractSignCallBackRecordCollection;
import com.kingdee.shr.elecontract.EContractSignCallBackRecordFactory;
import com.kingdee.shr.elecontract.IKDContractConfigRecord;
import com.kingdee.shr.elecontract.KDContractConfigInfo;
import com.kingdee.shr.elecontract.KDContractConfigRecordCollection;
import com.kingdee.shr.elecontract.KDContractConfigRecordFactory;
import com.kingdee.shr.elecontract.KDContractConfigRecordInfo;
import com.kingdee.shr.elecontract.util.ElectronicContractUtils;
import com.kingdee.shr.elecontract.vo.PersonThreeEleInfo;
import com.kingdee.shr.preentry.PreEntryCollection;
import com.kingdee.shr.preentry.PreEntryFactory;
import com.kingdee.shr.preentry.PreEntryInfo;
import com.kingdee.shr.preentry.PreEntryPerson;
import com.kingdee.shr.shareservice.util.SSCTaskAppUtil;
import com.kingdee.util.StringUtils;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EContractService {
    private static final Logger logger = LoggerFactory.getLogger(EContractService.class);
    public static final String CONTRACT_PRE_SIGN_BIZ_BILL_BOSTYPE = "9F4ECBD6";
    public static final String CONTRACT_SIGN_BIZ_BILL_BOSTYPE = "502B7D81";
    public static final String CONTRACT_RENEW_BIZ_BILL_BOSTYPE = "2A2632A9";
    public static final String CONTRACT_CHANGE_BIZ_BILL_BOSTYPE = "056FBF2E";
    public static final String CONTRACT_END_BIZ_BILL_BOSTYPE = "8015FF9B";
    public static final String CONTRACT_FREE_BIZ_BILL_BOTTYPE = "87AFF1F2";
    public static final String OTHER_CONTRACT_SIGN_BIZ_BILL_BOSTYPE = "CB88E0A5";
    public static final String OTHER_FOLLOW_LABOR_CONTRACT_ENTRY_BOSTYPE = "9394E209";
    public static final String OTHER_FOLLOW_LABOR_PRE_CONTRACT_ENTRY_BOSTYPE = "F5C647BC";
    public static final String OTHER_FOLLOW_LABOR_RENEW_CONTRACT_ENTRY_BOSTYPE = "EF339F6D";
    public static final String OTHER_FOLLOW_LABOR_CHANGE_CONTRACT_ENTRY_BOSTYPE = "6A163240";
    public static final String CONTRACT_COMPANY_SIGN_ATTR = "FM7eJ3c6TxG3i2xUKhSla7xcg58=";
    public static final String CONTRACT_PERSON_SIGN_ATTR = "Lm+d5jKTTzyEh9JsyZhcX7xcg58=";
    public static final String CONTRACT_COMPANY_PRE_SIGN_ATTR = "YCRhEi3iT3W8pPo7JITzw7xcg58=";
    public static final String CONTRACT_PERSON_PRE_SIGN_ATTR = "9sUzY4P2QBqjzbi0fdHPxLxcg58=";
    public static final String CONTRACT_COMPANY_RENEW_SIGN_ATTR = "6IXTBav3Rcanok3WJyvqjbxcg58=";
    public static final String CONTRACT_PERSON_RENEW_SIGN_ATTR = "nRcxVbzPQnyU+/gOq0UW3Lxcg58=";
    public static final String OTHER_CONTRACT_PERSON_SIGN_ATTR = "ahYlKVCPRT2PRvCLZWrtqrxcg58=";
    public static final String OTHER_CONTRACT_COMPANY_SIGN_ATTR = "IuJzzWdLTuCB3zCAt4QnuLxcg58=";
    public static final String OTHER_CONTRACT_ACOMPANY_SIGN_ATTR = "OPJkiZl7QTGMbdsafsvGhbxcg58=";
    public static final String OTHER_CONTRACT_BCOMPANY_SIGN_ATTR = "rcR4cz6lQvCoXog30A8Qhrxcg58=";
    public static final String OTHER_CONTRACT_PERSON_SINGLE_SIGN_ATTR = "13pLLpQfRhe2GgRskSG5R7xcg58=";
    public static final String CONTRACT_PERSON_CHANGE_SIGN_ATTR = "/94HJqZsREWbrc5DDTXa37xcg58=";
    public static final String CONTRACT_COMPANY_CHANGE_SIGN_ATTR = "9LpcSzs7QyOsI6/t4Hlj3bxcg58=";
    public static final String[] packageContract = new String[]{"9F4ECBD6", "502B7D81", "2A2632A9", "056FBF2E"};

    public static boolean isContractBusinessBill(BOSUuid billId) {
        String curBosType = billId.getType().toString();
        return CONTRACT_PRE_SIGN_BIZ_BILL_BOSTYPE.equals(curBosType) || CONTRACT_SIGN_BIZ_BILL_BOSTYPE.equals(curBosType) || CONTRACT_RENEW_BIZ_BILL_BOSTYPE.equals(curBosType) || CONTRACT_END_BIZ_BILL_BOSTYPE.equals(curBosType) || CONTRACT_CHANGE_BIZ_BILL_BOSTYPE.equals(curBosType) || CONTRACT_FREE_BIZ_BILL_BOTTYPE.equals(curBosType);
    }

    public static boolean isContractBusinessBill(String billId) {
        String curBosType = BOSUuid.read((String)billId).getType().toString();
        return CONTRACT_PRE_SIGN_BIZ_BILL_BOSTYPE.equals(curBosType) || CONTRACT_RENEW_BIZ_BILL_BOSTYPE.equals(curBosType) || CONTRACT_SIGN_BIZ_BILL_BOSTYPE.equals(curBosType) || CONTRACT_END_BIZ_BILL_BOSTYPE.equals(curBosType) || CONTRACT_CHANGE_BIZ_BILL_BOSTYPE.equals(curBosType) || CONTRACT_FREE_BIZ_BILL_BOTTYPE.equals(curBosType) || OTHER_CONTRACT_SIGN_BIZ_BILL_BOSTYPE.equals(curBosType);
    }

    public static boolean isOtherContractBusinessBill(BOSUuid billId) {
        String curBosType = billId.getType().toString();
        return OTHER_CONTRACT_SIGN_BIZ_BILL_BOSTYPE.equals(curBosType);
    }

    public static boolean isSupportOtherFollowContractEntryInfo(BOSUuid billId) {
        String curBosType = billId.getType().toString();
        return CONTRACT_PRE_SIGN_BIZ_BILL_BOSTYPE.equals(curBosType) || CONTRACT_SIGN_BIZ_BILL_BOSTYPE.equals(curBosType) || CONTRACT_RENEW_BIZ_BILL_BOSTYPE.equals(curBosType) || CONTRACT_CHANGE_BIZ_BILL_BOSTYPE.equals(curBosType);
    }

    public static boolean isCertificationBillBuss(BOSUuid billID) {
        String curBosType = billID.getType().toString();
        return "C84F6BC0".equalsIgnoreCase(curBosType);
    }

    public static SSCEContractRecordInfo getSSCEContractRecord(Context ctx, String billId, String entryId) throws BOSException {
        SSCEContractRecordInfo info = null;
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("billId", (Object)billId));
        if (!StringUtils.isEmpty((String)entryId)) {
            filter.getFilterItems().add(new FilterItemInfo("entryId", (Object)entryId));
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SSCEContractRecordCollection collection = SSCEContractRecordFactory.getLocalInstance(ctx).getSSCEContractRecordCollection(view);
        if (collection.size() > 0) {
            info = collection.get(0);
        }
        return info;
    }

    public static JSONArray getTaskInfoByBillId(Context ctx, String billId, String type, SelectorItemCollection selectorColl) throws BOSException, EASBizException {
        HashMap<String, String> serviceParam = new HashMap<String, String>();
        if (StringUtils.isEmpty((String)type)) {
            type = "3";
        }
        String selector = null;
        if (selectorColl != null && selectorColl.size() > 0) {
            selector = selectorColl.toString();
        }
        serviceParam.put("billId", billId);
        serviceParam.put("type", type);
        serviceParam.put("selector", selector);
        JSONObject result = JSONObject.parseObject((String)SSCTaskAppUtil.operateTaskAll((Context)ctx, (String)"GETJOBINFOBYBILLID", serviceParam).toString());
        return result.getJSONArray("data");
    }

    public static SSCEContractRecordInfo getSSCEContractRecordByEContractNo(Context ctx, String contractNO, String billId) throws BOSException, EASBizException {
        SSCEContractRecordInfo recordInfo = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("eContractNO", (Object)contractNO));
        filterInfo.getFilterItems().add(new FilterItemInfo("billId", (Object)billId));
        view.setFilter(filterInfo);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        view.setSelector(selector);
        SSCEContractRecordCollection recordCollection = SSCEContractRecordFactory.getLocalInstance(ctx).getSSCEContractRecordCollection(view);
        if (recordCollection.size() > 0) {
            recordInfo = recordCollection.get(0);
        }
        return recordInfo;
    }

    public static SSCEContractRecordInfo getSSCEContractRecordByContractNo(Context ctx, String contractNO, String billId) throws BOSException, EASBizException {
        return EContractService.getSSCEContractRecordByContractNo(ctx, contractNO, billId, null);
    }

    public static SSCEContractRecordInfo getSSCEContractRecordByContractNo(Context ctx, String contractNO, String billId, String entryId) throws BOSException, EASBizException {
        SSCEContractRecordInfo recordInfo = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("contractNO", (Object)contractNO));
        if (!StringUtils.isEmpty((String)billId)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("billId", (Object)billId));
        }
        if (!StringUtils.isEmpty((String)entryId)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("entryId", (Object)entryId));
        }
        view.setFilter(filterInfo);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        view.setSelector(selector);
        SSCEContractRecordCollection recordCollection = SSCEContractRecordFactory.getLocalInstance(ctx).getSSCEContractRecordCollection(view);
        if (recordCollection.size() > 0) {
            recordInfo = recordCollection.get(0);
        }
        return recordInfo;
    }

    public static SSCEContractTaskInfo getEContractTaskInfoByBussAttrId(Context ctx, String jobId, String billId, String bussAttrID) throws BOSException {
        SSCEContractTaskInfo taskInfo = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("billId", (Object)billId));
        if (!StringUtils.isEmpty((String)jobId)) {
            filter.getFilterItems().add(new FilterItemInfo("jobId", (Object)jobId));
        }
        if (!StringUtils.isEmpty((String)bussAttrID)) {
            filter.getFilterItems().add(new FilterItemInfo("taskType", (Object)bussAttrID));
        }
        view.setFilter(filter);
        SSCEContractTaskCollection collection = SSCEContractTaskFactory.getLocalInstance(ctx).getSSCEContractTaskCollection(view);
        if (collection.size() > 0) {
            taskInfo = collection.get(0);
        }
        return taskInfo;
    }

    public static SSCEContractTaskInfo getEContractTaskInfo(Context ctx, String jobId, String billId, String type) throws BOSException {
        SSCEContractTaskInfo taskInfo = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("billId", (Object)billId));
        if (!StringUtils.isEmpty((String)jobId)) {
            filter.getFilterItems().add(new FilterItemInfo("jobId", (Object)jobId));
        }
        if (!StringUtils.isEmpty((String)type)) {
            filter.getFilterItems().add(new FilterItemInfo("type", (Object)type));
        }
        view.setFilter(filter);
        SSCEContractTaskCollection collection = SSCEContractTaskFactory.getLocalInstance(ctx).getSSCEContractTaskCollection(view);
        if (collection.size() > 0) {
            taskInfo = collection.get(0);
        }
        return taskInfo;
    }

    public static EContractCompanyTaskInfo getEContractCompanyTaskInfo(Context ctx, String billId, String jobId, String contractNo) throws BOSException {
        EContractCompanyTaskInfo taskInfo = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("billId", (Object)billId));
        filter.getFilterItems().add(new FilterItemInfo("jobId", (Object)jobId));
        if (!StringUtils.isEmpty((String)contractNo)) {
            filter.getFilterItems().add(new FilterItemInfo("contractNo", (Object)contractNo));
        }
        view.setFilter(filter);
        EContractCompanyTaskCollection collection = EContractCompanyTaskFactory.getLocalInstance(ctx).getEContractCompanyTaskCollection(view);
        if (collection.size() > 0) {
            taskInfo = collection.get(0);
        }
        return taskInfo;
    }

    public static EContractCompanyTaskInfo getEContractCompanyTaskInfoByContractNOAndUserId(Context ctx, String userId, String contractNo, boolean isCallback) throws BOSException {
        EContractCompanyTaskInfo taskInfo = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("userId", (Object)userId));
        filter.getFilterItems().add(new FilterItemInfo("contractNo", (Object)contractNo));
        filter.getFilterItems().add(new FilterItemInfo("isCallback", (Object)isCallback));
        view.setFilter(filter);
        EContractCompanyTaskCollection collection = EContractCompanyTaskFactory.getLocalInstance(ctx).getEContractCompanyTaskCollection(view);
        if (collection.size() > 0) {
            taskInfo = collection.get(0);
        }
        return taskInfo;
    }

    public static EContractCompanyTaskInfo getEContractCompanyTaskInfoByContractNOAndUserId(Context ctx, String userId, String contractNo) throws BOSException {
        return EContractService.getEContractCompanyTaskInfoByContractNOAndUserId(ctx, userId, contractNo, false);
    }

    public static EContractCompanyTaskInfo getEContractCompanyTaskInfoNew(Context ctx, String billId, String jobId, String entryId, String contractNo) throws BOSException {
        EContractCompanyTaskInfo taskInfo = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("billId", (Object)billId));
        filter.getFilterItems().add(new FilterItemInfo("jobId", (Object)jobId));
        if (!StringUtils.isEmpty((String)contractNo)) {
            filter.getFilterItems().add(new FilterItemInfo("contractNo", (Object)contractNo));
        }
        view.setFilter(filter);
        EContractCompanyTaskCollection collection = EContractCompanyTaskFactory.getLocalInstance(ctx).getEContractCompanyTaskCollection(view);
        if (collection.size() > 0) {
            SSCEContractRecordCollection ssceContractRecordCollection = SSCEContractRecordFactory.getLocalInstance(ctx).getSSCEContractRecordCollection("where billId = '" + billId + "'");
            if (ssceContractRecordCollection != null && ssceContractRecordCollection.size() > 1) {
                for (int i = 0; !(i >= collection.size() || (taskInfo = collection.get(i)).getEntryId() != null && entryId.equals(taskInfo.getEntryId().toString())); ++i) {
                    taskInfo = null;
                }
            } else {
                taskInfo = collection.get(0);
            }
        }
        if (taskInfo != null) {
            logger.info("taskInfo_ is " + taskInfo);
        }
        return taskInfo;
    }

    public static void updateEContractCompanyTaskInfo(Context ctx, EContractCompanyTaskInfo companyTaskInfo, boolean isSuccess) throws EASBizException, BOSException {
        SelectorItemCollection selector = new SelectorItemCollection();
        if (isSuccess) {
            Timestamp curTimestamp = EContractService.getCurTimestamp();
            companyTaskInfo.setIsCallback(true);
            companyTaskInfo.setCallbackTime(curTimestamp);
            companyTaskInfo.setResultCode("1");
            companyTaskInfo.setResultDesc("");
            companyTaskInfo.setIsFinish(true);
            selector.add(new SelectorItemInfo("isCallback"));
            selector.add(new SelectorItemInfo("callbackTime"));
            selector.add(new SelectorItemInfo("resultCode"));
            selector.add(new SelectorItemInfo("resultDesc"));
            selector.add(new SelectorItemInfo("isFinish"));
            EContractCompanyTaskFactory.getLocalInstance(ctx).updatePartial(companyTaskInfo, selector);
        } else {
            companyTaskInfo.setIsRequest(false);
            companyTaskInfo.setRequestTime(null);
            companyTaskInfo.setIsCallback(false);
            companyTaskInfo.setCallbackTime(null);
            companyTaskInfo.setResultCode("0");
            companyTaskInfo.setResultDesc("");
            companyTaskInfo.setIsFinish(false);
            selector.add(new SelectorItemInfo("isRequest"));
            selector.add(new SelectorItemInfo("requestTime"));
            selector.add(new SelectorItemInfo("isCallback"));
            selector.add(new SelectorItemInfo("callbackTime"));
            selector.add(new SelectorItemInfo("resultCode"));
            selector.add(new SelectorItemInfo("resultDesc"));
            selector.add(new SelectorItemInfo("isFinish"));
            EContractCompanyTaskFactory.getLocalInstance(ctx).updatePartial(companyTaskInfo, selector);
        }
    }

    public static EContractSignCallBackRecordCollection getSignCallBackRecord(Context ctx, String contractNO) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("contractNO", (Object)contractNO));
        filter.getFilterItems().add(new FilterItemInfo("resultCode", (Object)"1"));
        view.setFilter(filter);
        EContractSignCallBackRecordCollection recordCollection = EContractSignCallBackRecordFactory.getLocalInstance((Context)ctx).getEContractSignCallBackRecordCollection(view);
        return recordCollection;
    }

    public static LabContractFirstPartyInfo getLabContractFirstPartyByBillID(Context ctx, String billId) throws EASBizException, BOSException {
        BOSUuid bosBillId = BOSUuid.read((String)billId);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("entrys.*"));
        HRBillBaseInfo billBaseInfo = ((IHRBillBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)bosBillId.getType())).getHRBillBaseInfo((IObjectPK)new ObjectUuidPK(billId), selector);
        IObjectCollection entryColls = (IObjectCollection)billBaseInfo.get("entrys");
        HRBillBaseEntryInfo billBaseEntryInfo = null;
        if (entryColls.size() > 0) {
            billBaseEntryInfo = (HRBillBaseEntryInfo)entryColls.getObject(0);
        }
        return EContractService.getLabContractFirstParty(ctx, billBaseInfo, billBaseEntryInfo);
    }

    public static SSCEContractTaskInfo saveSSCEContractTaskInfo(Context ctx, String jobId, String billId, Map dataMap, Map otherParamMap, boolean isOnlyRecord, String type) throws EASBizException, BOSException {
        SSCEContractTaskInfo taskInfo = new SSCEContractTaskInfo();
        taskInfo.setJobId(jobId);
        BOSUuid read = BOSUuid.read((String)billId);
        taskInfo.setBillId(read);
        String taskType = "";
        if (dataMap != null && StringUtils.isEmpty((String)(taskType = (String)dataMap.get("bussAttrID")))) {
            taskType = (String)dataMap.get("bussAttrID.id");
        }
        if (StringUtils.isEmpty((String)taskType)) {
            taskType = read.getType().toString();
        }
        taskInfo.setTaskType(taskType);
        taskInfo.setType(type);
        taskInfo.setBusinessParam(billId);
        taskInfo.setParam(JSONObject.toJSONString((Object)otherParamMap));
        taskInfo.setAction("PASS");
        UserInfo currentUserInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        taskInfo.setUser(currentUserInfo);
        taskInfo.setPerson(currentUserInfo.getPerson());
        if (isOnlyRecord) {
            taskInfo.setIsAutoClose(false);
            taskInfo.setIsDelete(true);
            taskInfo.setIsNeedProcess(false);
            taskInfo.setIsProcess(true);
        } else {
            taskInfo.setIsAutoClose(true);
            taskInfo.setIsDelete(false);
            taskInfo.setIsNeedProcess(true);
            taskInfo.setIsProcess(false);
        }
        IObjectPK pk = SSCEContractTaskFactory.getLocalInstance(ctx).addnew(taskInfo);
        taskInfo.setId(BOSUuid.read((String)pk.toString()));
        return taskInfo;
    }

    public static SSCEContractTaskInfo saveSSCEContractTaskInfo(Context ctx, String jobId, String billId, Map otherParamMap, boolean isOnlyRecord, String type) throws EASBizException, BOSException {
        return EContractService.saveSSCEContractTaskInfo(ctx, jobId, billId, null, otherParamMap, isOnlyRecord, type);
    }

    public static LabContractFirstPartyInfo getLabContractFirstParty(Context ctx, HRBillBaseInfo billInfo, HRBillBaseEntryInfo entryInfo) throws EASBizException, BOSException {
        if (billInfo instanceof ContractRenewBizBillInfo) {
            ContractRenewBizBillEntryInfo contract = ContractRenewBizBillEntryFactory.getLocalInstance((Context)ctx).getContractRenewBizBillEntryInfo("where bill = '" + billInfo.getId() + "'");
            return contract.getLabContractFirstParty();
        }
        if (billInfo instanceof ContractPreSignBizBillInfo) {
            return ((ContractPreSignBizBillInfo)billInfo).getLabContractFirstParty();
        }
        if (billInfo instanceof ContractSignBizBillInfo) {
            return ((ContractSignBizBillInfo)billInfo).getLabContractFirstParty();
        }
        if (billInfo instanceof OtherContractSignBizBillInfo) {
            return ((OtherContractSignBizBillInfo)billInfo).getLabContractFirstParty();
        }
        if (billInfo instanceof ContractChangeBizBillInfo) {
            ContractChangeBizBillEntryInfo contract = ContractChangeBizBillEntryFactory.getLocalInstance((Context)ctx).getContractChangeBizBillEntryInfo("where bill = '" + billInfo.getId() + "'");
            return contract.getLabContractFirstParty();
        }
        if (billInfo instanceof ContractFreeBizBillInfo) {
            ContractFreeBizBillEntryInfo contract = ((ContractFreeBizBillInfo)billInfo).getEntrys().get(0);
            return contract.getLabContractFirstParty();
        }
        if (billInfo instanceof ContractEndBizBillInfo) {
            ContractEndBizBillEntryInfo contract = ((ContractEndBizBillInfo)billInfo).getEntrys().get(0);
            return contract.getLabContractFirstParty();
        }
        return null;
    }

    public static LabContractFirstPartyInfo getLabContractPartyB(Context ctx, HRBillBaseInfo billInfo, HRBillBaseEntryInfo entryInfo) {
        if (billInfo instanceof OtherContractSignBizBillInfo) {
            return ((OtherContractSignBizBillInfo)billInfo).getLabContractCParty();
        }
        return null;
    }

    public static String getLCFPNameByBillId(Context ctx, String billId) throws EASBizException, BOSException {
        HRBillBaseInfo info = EContractService.getHRBillBaseInfo(ctx, billId);
        return EContractService.getLCFPNameByBillId(info);
    }

    public static String getLCFPNameByBillId(HRBillBaseInfo info) throws EASBizException, BOSException {
        ContractRenewBizBillEntryInfo contract;
        if (info == null) {
            return null;
        }
        String lcfpName = null;
        if (info instanceof ContractRenewBizBillInfo) {
            contract = ((ContractRenewBizBillInfo)info).getEntrys().get(0);
            lcfpName = contract.getLCFPName();
        }
        if (info instanceof ContractPreSignBizBillInfo) {
            lcfpName = ((ContractPreSignBizBillInfo)info).getLCFPName();
        }
        if (info instanceof ContractSignBizBillInfo) {
            lcfpName = ((ContractSignBizBillInfo)info).getLCFPName();
        }
        if (info instanceof OtherContractSignBizBillInfo) {
            lcfpName = ((OtherContractSignBizBillInfo)info).getLCFPName();
        }
        if (info instanceof ContractChangeBizBillInfo) {
            contract = ((ContractChangeBizBillInfo)info).getEntrys().get(0);
            lcfpName = contract.getLCFPName();
        }
        return lcfpName;
    }

    public static ContractTempletInfo getContractTempletInfo(Context ctx, HRBillBaseInfo billInfo, HRBillBaseEntryInfo entryInfo) {
        if (entryInfo instanceof ContractPreSignBizBillEntryInfo) {
            return ((ContractPreSignBizBillEntryInfo)entryInfo).getContractTemplet();
        }
        if (entryInfo instanceof ContractRenewBizBillEntryInfo) {
            return ((ContractRenewBizBillEntryInfo)entryInfo).getContractTemplet();
        }
        if (entryInfo instanceof ContractSignBizBillEntryInfo) {
            return ((ContractSignBizBillEntryInfo)entryInfo).getContractTemplet();
        }
        if (entryInfo instanceof ContractChangeBizBillEntryInfo) {
            return ((ContractChangeBizBillEntryInfo)entryInfo).getContractTemplet();
        }
        if (billInfo instanceof OtherContractSignBizBillInfo) {
            return ((OtherContractSignBizBillEntryInfo)entryInfo).getContractTemplet();
        }
        if (entryInfo instanceof OtherFollowLaborConEntryInfo) {
            return ((OtherFollowLaborConEntryInfo)entryInfo).getContractTemplet();
        }
        if (entryInfo instanceof OtherFollowPreConEntryInfo) {
            return ((OtherFollowPreConEntryInfo)entryInfo).getContractTemplet();
        }
        if (entryInfo instanceof OtherContractRenewBizBillEntryInfo) {
            return ((OtherContractRenewBizBillEntryInfo)entryInfo).getContractTemplet();
        }
        if (entryInfo instanceof OtherContractChangeBizBillEntryInfo) {
            return ((OtherContractChangeBizBillEntryInfo)entryInfo).getContractTemplet();
        }
        return null;
    }

    public static HRBillBaseInfo getHRBillBaseInfo(Context ctx, String billId) throws EASBizException, BOSException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("entrys.*"));
        return EContractService.getHRBillBaseInfo(ctx, billId, selector);
    }

    public static HRBillBaseInfo getHRBillBaseInfoNew(Context ctx, String billId) throws EASBizException, BOSException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("entrys.*"));
        selector.add(new SelectorItemInfo("entrys.contractType.name"));
        selector.add(new SelectorItemInfo("otherEntrys.*"));
        selector.add(new SelectorItemInfo("otherEntrys.contractType.name"));
        selector.add(new SelectorItemInfo("otherEntrys.contractTemplet.signType"));
        return EContractService.getHRBillBaseInfo(ctx, billId, selector);
    }

    public static HRBillBaseInfo getHRBillBaseInfo(Context ctx, String billId, SelectorItemCollection selector) throws EASBizException, BOSException {
        HRBillBaseInfo info = null;
        BOSUuid bosUuid = BOSUuid.read((String)billId);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)billId));
        view.setFilter(filter);
        view.setSelector(selector);
        HRBillBaseCollection colls = ((IHRBillBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)bosUuid.getType())).getHRBillBaseCollection(view);
        if (colls.size() > 0) {
            info = colls.get(0);
        }
        return info;
    }

    public static PersonThreeEleInfo getPersonThreeInfo(Context ctx, String personId) throws BOSException {
        EntityViewInfo view;
        FilterInfo filter;
        SelectorItemCollection sic;
        PersonThreeEleInfo info = null;
        BOSUuid bosUuid = BOSUuid.read((String)personId);
        String bosType = bosUuid.getType().toString();
        if ("80EF7DED".equals(bosType)) {
            sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("cell"));
            sic.add(new SelectorItemInfo("idCardNO"));
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)personId));
            view = new EntityViewInfo();
            view.setSelector(sic);
            view.setFilter(filter);
            PersonCollection personColls = PersonFactory.getLocalInstance((Context)ctx).getPersonCollection(view);
            if (personColls.size() > 0) {
                info = new PersonThreeEleInfo(bosUuid);
                PersonInfo personInfo = personColls.get(0);
                info.setName(personInfo.getName());
                info.setMobile(personInfo.getCell());
                info.setIdCardNO(personInfo.getIdCardNO());
                return info;
            }
        }
        if ("33E8F2DB".equals(bosType)) {
            sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("cellPhone"));
            sic.add(new SelectorItemInfo("talent.id"));
            sic.add(new SelectorItemInfo("talent.name"));
            sic.add(new SelectorItemInfo("talent.idCardNO"));
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("talent.id", (Object)personId));
            view = new EntityViewInfo();
            view.setSelector(sic);
            view.setFilter(filter);
            PreEntryCollection preEntryColls = PreEntryFactory.getLocalInstance((Context)ctx).getPreEntryCollection(view);
            if (preEntryColls.size() > 0) {
                info = new PersonThreeEleInfo(bosUuid);
                PreEntryInfo preEntryInfo = preEntryColls.get(0);
                info.setName(preEntryInfo.getTalent().getName());
                info.setMobile(preEntryInfo.getCellPhone());
                info.setIdCardNO(preEntryInfo.getTalent().getIdCardNO());
                return info;
            }
        }
        return null;
    }

    public static PersonThreeEleInfo getBillPersonInfo(Context ctx, HRBillBaseEntryInfo entryInfo) throws BOSException {
        if (entryInfo != null) {
            IObjectValue objectValue = entryInfo.getObjectValue("person");
            if (objectValue != null && (objectValue instanceof Person || objectValue instanceof PreEntryPerson)) {
                return EContractService.getPersonThreeInfo(ctx, objectValue.getBOSUuid("id").toString());
            }
            objectValue = entryInfo.getObjectValue("preEntryPerson");
            if (objectValue != null && (objectValue instanceof Person || objectValue instanceof PreEntryPerson)) {
                return EContractService.getPersonThreeInfo(ctx, objectValue.getBOSUuid("id").toString());
            }
        }
        return null;
    }

    public static Map<String, String> getProcessInfo(Context ctx, HRBillBaseInfo info) {
        ContractSignBizBillInfo signBizBillInfo;
        ContractRenewBizBillEntryInfo entryInfo;
        HashMap<String, String> dataMap = new HashMap<String, String>();
        if (info instanceof ContractRenewBizBillInfo) {
            ContractRenewBizBillInfo renewBizBillInfo = (ContractRenewBizBillInfo)info;
            entryInfo = renewBizBillInfo.getEntrys().get(0);
            dataMap.put("personId", entryInfo.getPerson().getId().toString());
            dataMap.put("contractNo", entryInfo.getContractNo());
            dataMap.put("entryId", entryInfo.getId().toString());
            dataMap.put("templateId", entryInfo.getContractTemplet().getId().toString());
        }
        if (info instanceof ContractPreSignBizBillInfo) {
            ContractPreSignBizBillInfo preSignBizBillInfo = (ContractPreSignBizBillInfo)info;
            entryInfo = preSignBizBillInfo.getEntrys().get(0);
            dataMap.put("personId", entryInfo.getPerson().getId().toString());
            dataMap.put("contractNo", entryInfo.getContractNo());
            dataMap.put("entryId", entryInfo.getId().toString());
            dataMap.put("templateId", entryInfo.getContractTemplet().getId().toString());
        }
        if (info instanceof ContractSignBizBillInfo) {
            signBizBillInfo = (ContractSignBizBillInfo)info;
            entryInfo = signBizBillInfo.getEntrys().get(0);
            dataMap.put("personId", entryInfo.getPerson().getId().toString());
            dataMap.put("contractNo", entryInfo.getContractNo());
            dataMap.put("entryId", entryInfo.getId().toString());
            dataMap.put("templateId", entryInfo.getContractTemplet().getId().toString());
        }
        if (info instanceof OtherContractSignBizBillInfo) {
            signBizBillInfo = (OtherContractSignBizBillInfo)info;
            entryInfo = signBizBillInfo.getEntrys().get(0);
            if (((OtherContractSignBizBillInfo)info).isIsPreEntry()) {
                dataMap.put("personId", entryInfo.getPreEntryPerson().getId().toString());
            } else {
                dataMap.put("personId", entryInfo.getPerson().getId().toString());
            }
            dataMap.put("contractNo", entryInfo.getContractNo());
            dataMap.put("entryId", entryInfo.getId().toString());
            dataMap.put("templateId", entryInfo.getContractTemplet().getId().toString());
        }
        if (info instanceof ContractChangeBizBillInfo) {
            ContractChangeBizBillInfo changeBizBillInfo = (ContractChangeBizBillInfo)info;
            entryInfo = changeBizBillInfo.getEntrys().get(0);
            dataMap.put("personId", entryInfo.getPerson().getId().toString());
            dataMap.put("contractNo", entryInfo.getContractNo());
            dataMap.put("entryId", entryInfo.getId().toString());
            dataMap.put("templateId", entryInfo.getContractTemplet().getId().toString());
        }
        return dataMap;
    }

    public static Map<String, String> getProcessInfoNew(Context ctx, HRBillBaseInfo info, HRBillBaseEntryInfo billEntryInfo) {
        ContractSignBizBillInfo signBizBillInfo;
        ContractRenewBizBillEntryInfo entryInfo;
        HashMap<String, String> dataMap = new HashMap<String, String>();
        if (info instanceof ContractRenewBizBillInfo) {
            if (billEntryInfo instanceof OtherContractRenewBizBillEntryInfo) {
                OtherContractRenewBizBillEntryInfo otherContractRenewBizBillEntryInfo = (OtherContractRenewBizBillEntryInfo)billEntryInfo;
                dataMap.put("personId", otherContractRenewBizBillEntryInfo.getPerson().getId().toString());
                dataMap.put("contractNo", otherContractRenewBizBillEntryInfo.getContractNo());
                dataMap.put("entryId", otherContractRenewBizBillEntryInfo.getId().toString());
                dataMap.put("templateId", otherContractRenewBizBillEntryInfo.getContractTemplet().getId().toString());
            } else {
                ContractRenewBizBillInfo renewBizBillInfo = (ContractRenewBizBillInfo)info;
                entryInfo = renewBizBillInfo.getEntrys().get(0);
                dataMap.put("personId", entryInfo.getPerson().getId().toString());
                dataMap.put("contractNo", entryInfo.getContractNo());
                dataMap.put("entryId", entryInfo.getId().toString());
                dataMap.put("templateId", entryInfo.getContractTemplet().getId().toString());
            }
        }
        if (info instanceof ContractPreSignBizBillInfo) {
            if (billEntryInfo instanceof OtherFollowPreConEntryInfo) {
                OtherFollowPreConEntryInfo otherFollowPreConEntryInfo = (OtherFollowPreConEntryInfo)billEntryInfo;
                dataMap.put("personId", otherFollowPreConEntryInfo.getPerson().getId().toString());
                dataMap.put("contractNo", otherFollowPreConEntryInfo.getContractNo());
                dataMap.put("entryId", otherFollowPreConEntryInfo.getId().toString());
                dataMap.put("templateId", otherFollowPreConEntryInfo.getContractTemplet().getId().toString());
            } else {
                ContractPreSignBizBillInfo preSignBizBillInfo = (ContractPreSignBizBillInfo)info;
                entryInfo = preSignBizBillInfo.getEntrys().get(0);
                dataMap.put("personId", entryInfo.getPerson().getId().toString());
                dataMap.put("contractNo", entryInfo.getContractNo());
                dataMap.put("entryId", entryInfo.getId().toString());
                dataMap.put("templateId", entryInfo.getContractTemplet().getId().toString());
            }
        }
        if (info instanceof ContractSignBizBillInfo) {
            if (billEntryInfo instanceof OtherFollowLaborConEntryInfo) {
                OtherFollowLaborConEntryInfo otherFollowLaborConEntryInfo = (OtherFollowLaborConEntryInfo)billEntryInfo;
                dataMap.put("personId", otherFollowLaborConEntryInfo.getPerson().getId().toString());
                dataMap.put("contractNo", otherFollowLaborConEntryInfo.getContractNo());
                dataMap.put("entryId", otherFollowLaborConEntryInfo.getId().toString());
                dataMap.put("templateId", otherFollowLaborConEntryInfo.getContractTemplet().getId().toString());
            } else {
                signBizBillInfo = (ContractSignBizBillInfo)info;
                entryInfo = signBizBillInfo.getEntrys().get(0);
                dataMap.put("personId", entryInfo.getPerson().getId().toString());
                dataMap.put("contractNo", entryInfo.getContractNo());
                dataMap.put("entryId", entryInfo.getId().toString());
                dataMap.put("templateId", entryInfo.getContractTemplet().getId().toString());
            }
        }
        if (info instanceof OtherContractSignBizBillInfo) {
            signBizBillInfo = (OtherContractSignBizBillInfo)info;
            entryInfo = signBizBillInfo.getEntrys().get(0);
            if (((OtherContractSignBizBillInfo)info).isIsPreEntry()) {
                dataMap.put("personId", entryInfo.getPreEntryPerson().getId().toString());
            } else {
                dataMap.put("personId", entryInfo.getPerson().getId().toString());
            }
            dataMap.put("contractNo", entryInfo.getContractNo());
            dataMap.put("entryId", entryInfo.getId().toString());
            dataMap.put("templateId", entryInfo.getContractTemplet().getId().toString());
        }
        if (info instanceof ContractChangeBizBillInfo) {
            if (billEntryInfo instanceof OtherContractChangeBizBillEntryInfo) {
                OtherContractChangeBizBillEntryInfo otherContractChangeBizBillEntryInfo = (OtherContractChangeBizBillEntryInfo)billEntryInfo;
                dataMap.put("personId", otherContractChangeBizBillEntryInfo.getPerson().getId().toString());
                dataMap.put("contractNo", otherContractChangeBizBillEntryInfo.getContractNo());
                dataMap.put("entryId", otherContractChangeBizBillEntryInfo.getId().toString());
                dataMap.put("templateId", otherContractChangeBizBillEntryInfo.getContractTemplet().getId().toString());
            } else {
                ContractChangeBizBillInfo changeBizBillInfo = (ContractChangeBizBillInfo)info;
                entryInfo = changeBizBillInfo.getEntrys().get(0);
                dataMap.put("personId", entryInfo.getPerson().getId().toString());
                dataMap.put("contractNo", entryInfo.getContractNo());
                dataMap.put("entryId", entryInfo.getId().toString());
                dataMap.put("templateId", entryInfo.getContractTemplet().getId().toString());
            }
        }
        return dataMap;
    }

    public static void updateKDContractConfigRecordState(Context ctx, HRBillBaseInfo billBaseInfo, HRBillBaseEntryInfo billEntryInfo, String contractNo) throws BOSException, EASBizException {
        EContractService.updateKDContractConfigRecordState(ctx, billBaseInfo, billEntryInfo, contractNo, null);
    }

    public static void updateKDContractConfigRecordState(Context ctx, HRBillBaseInfo billBaseInfo, HRBillBaseEntryInfo billEntryInfo, String contractNo, String userId) throws BOSException, EASBizException {
        KDContractConfigInfo configInfo;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("fileNo"));
        selector.add(new SelectorItemInfo("state"));
        selector.add(new SelectorItemInfo("result"));
        filterInfo.getFilterItems().add(new FilterItemInfo("fileNo", (Object)contractNo));
        filterInfo.getFilterItems().add(new FilterItemInfo("result", (Object)false));
        filterInfo.getFilterItems().add(new FilterItemInfo("state", (Object)2));
        if (!StringUtils.isEmpty((String)userId) && (configInfo = ElectronicContractUtils.getKDContractConfigByEnterpriseId((Context)ctx, (String)userId)) != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("config.id", (Object)configInfo.getId().toString()));
        }
        view.setFilter(filterInfo);
        view.setSelector(selector);
        IKDContractConfigRecord ikdContractConfigRecord = KDContractConfigRecordFactory.getLocalInstance((Context)ctx);
        KDContractConfigRecordCollection recordCollection = ikdContractConfigRecord.getKDContractConfigRecordCollection(view);
        if (recordCollection != null && recordCollection.size() > 0) {
            logger.error("EContractService updateKDContractConfigRecordState contractNo " + contractNo);
            selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("state"));
            selector.add(new SelectorItemInfo("result"));
            selector.add(new SelectorItemInfo("lastUpdateTime"));
            KDContractConfigRecordInfo recordInfo = recordCollection.get(0);
            recordInfo.setResult(true);
            recordInfo.setState(BaseItemStateEnum.ENABLE);
            recordInfo.setLastUpdateTime(EContractService.getCurTimestamp());
            ikdContractConfigRecord.updatePartial(recordInfo, selector);
        }
    }

    public static EContractCompanyTaskInfo getEContractCompanyTaskInfoNew(Context ctx, String billId, String entryId, String contractNo) throws BOSException {
        EContractCompanyTaskInfo taskInfo = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("billId", (Object)billId));
        if (!StringUtils.isEmpty((String)contractNo)) {
            filter.getFilterItems().add(new FilterItemInfo("contractNo", (Object)contractNo));
        }
        if (!StringUtils.isEmpty((String)entryId)) {
            filter.getFilterItems().add(new FilterItemInfo("entryId", (Object)entryId));
        }
        view.setFilter(filter);
        EContractCompanyTaskCollection collection = EContractCompanyTaskFactory.getLocalInstance(ctx).getEContractCompanyTaskCollection(view);
        if (collection.size() > 0) {
            taskInfo = collection.get(0);
        }
        return taskInfo;
    }

    public static boolean isPackage(String billId) {
        for (String bosType : packageContract) {
            if (!BOSUuid.read((String)billId).getType().toString().equals(bosType)) continue;
            return true;
        }
        return false;
    }

    public static Timestamp getCurTimestamp() {
        return new Timestamp(System.currentTimeMillis());
    }

    public static final class TASK_TYPE {
        public static final String COMPANY_SIGNED = "COMPANY";
        public static final String COMPANY_PARTY_B_SIGNED = "COMPANY_B";
        public static final String PERSON_SIGNED = "PERSON";
    }

    public static final class Cons {
        public static final String IS_PERSON_TASK = "isPersonTask";
        public static final String IS_COMPANY_TASK = "isCompanyTask";
        public static final String IS_PERSON_SIGNED = "isPersonSigned";
        public static final String IS_COMPANY_SIGNED = "isCompanySigned";
    }
}

