/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.elecontract.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.attachment.AttachmentFactory;
import com.kingdee.eas.base.attachment.AttachmentInfo;
import com.kingdee.eas.base.attachment.BoAttchAssoFactory;
import com.kingdee.eas.base.attachment.BoAttchAssoInfo;
import com.kingdee.eas.base.attachment.IAttachment;
import com.kingdee.eas.base.attachment.IBoAttchAsso;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.contract.util.BoAttchAssoBillUtils;
import com.kingdee.shr.attachment.AttachmentState;
import com.kingdee.shr.attachment.AttachmentTypeEnum;
import com.kingdee.shr.attachment.ISHRAttachmentExt;
import com.kingdee.shr.attachment.SHRAttachmentExtFactory;
import com.kingdee.shr.attachment.SHRAttachmentExtInfo;
import com.kingdee.shr.ml.util.SHRServerResource;
import com.kingdee.util.LocaleUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.BASE64Decoder;

public class SaveAttachmentThread
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(SaveAttachmentThread.class);
    private Context ctx;
    private String boId;
    private String fullname;
    private String fileString;
    private String entryId;

    public SaveAttachmentThread(Context ctx, String boId, String fullname, String fileString) {
        this.ctx = ctx;
        this.boId = boId;
        this.fullname = fullname;
        this.fileString = fileString;
    }

    public SaveAttachmentThread(Context ctx, String boId, String fullname, String fileString, String entryId) {
        this.ctx = ctx;
        this.boId = boId;
        this.fullname = fullname;
        this.fileString = fileString;
        this.entryId = entryId;
    }

    @Override
    public void run() {
        try {
            BASE64Decoder decoder = new BASE64Decoder();
            byte[] byteData = decoder.decodeBuffer(this.fileString);
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("boId", this.boId);
            paramMap.put("boEntryId", this.entryId);
            paramMap.put("type", "0");
            paramMap.put("signState", "0");
            paramMap.put("contractNo", this.fullname);
            paramMap.put("fileByte", byteData);
            paramMap.put("fileName", this.fullname + ".pdf");
            BoAttchAssoBillUtils.saveBoAttchAssoBill((Context)this.ctx, paramMap);
        }
        catch (UnsupportedEncodingException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (EASBizException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            logger.error("SaveAttachmentThread Exception : " + e.getMessage(), (Throwable)e);
        }
        catch (Throwable e) {
            logger.error("SaveAttachmentThread Throwable : " + e.getMessage(), e);
        }
    }

    public SHRAttachmentExtInfo saveAttachment(Context ctx, String boID, String fullname, byte[] filedata) throws BOSException, EASBizException {
        if (fullname.lastIndexOf("-") != -1) {
            fullname = fullname.substring(0, fullname.lastIndexOf(45));
        }
        String mainname = fullname + "_preview";
        String extname = "pdf";
        extname = extname.toLowerCase();
        SHRAttachmentExtInfo attchExt = new SHRAttachmentExtInfo();
        AttachmentInfo ai = new AttachmentInfo();
        BoAttchAssoInfo boAttchAssoInfo = new BoAttchAssoInfo();
        Locale locale_en_US = LocaleUtils.locale_en_US;
        Locale locale_zh_CN = LocaleUtils.locale_zh_CN;
        Locale locale_zh_TW = LocaleUtils.locale_zh_TW;
        ai.setName(mainname, locale_en_US);
        ai.setName(mainname, locale_zh_CN);
        ai.setName(mainname, locale_zh_TW);
        ai.setSimpleName(extname);
        ai.setDescription("");
        ai.setFile(filedata);
        ai.setIsShared(false);
        String label26 = SHRServerResource.getString((String)"com.kingdee.shr.econtractservice.EcontractserviceServerResource", (String)"label26", (Context)ctx);
        ai.setSharedDesc(label26);
        int size = filedata.length;
        if (size < 1024) {
            String label27 = SHRServerResource.getString((String)"com.kingdee.shr.econtractservice.EcontractserviceServerResource", (String)"label27", (Context)ctx);
            String realObj = MessageFormat.format(label27, size);
            ai.setSize(realObj);
        } else {
            ai.setSize(size / 1024 + "KB");
        }
        ai.setSizeInByte(size);
        ai.setAttachID("" + System.currentTimeMillis());
        String label28 = SHRServerResource.getString((String)"com.kingdee.shr.econtractservice.EcontractserviceServerResource", (String)"label28", (Context)ctx);
        ai.setType(label28);
        attchExt.setAttachment(ai);
        attchExt.setName(fullname, locale_en_US);
        attchExt.setName(fullname, locale_zh_CN);
        attchExt.setName(fullname, locale_zh_TW);
        attchExt.setPropertyName("null0");
        attchExt.setType(AttachmentTypeEnum.PROPERTY);
        attchExt.setState(AttachmentState.SAVE);
        attchExt.setBoID(boID);
        boAttchAssoInfo.setBoID(boID);
        boAttchAssoInfo.setAssoBusObjType(String.valueOf(BOSUuid.getBOSObjectType((String)boID, (boolean)true)));
        boAttchAssoInfo.setAssoType("Added Accessories");
        boAttchAssoInfo.setAttachment(ai);
        try {
            IAttachment attachment = AttachmentFactory.getLocalInstance((Context)ctx);
            IBoAttchAsso attchAsso = BoAttchAssoFactory.getLocalInstance((Context)ctx);
            ISHRAttachmentExt shrAttchExt = SHRAttachmentExtFactory.getLocalInstance((Context)ctx);
            attachment.addnew(ai);
            attchAsso.addnew(boAttchAssoInfo);
            shrAttchExt.addnew((CoreBaseInfo)attchExt);
            return attchExt;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            String label29 = SHRServerResource.getString((String)"com.kingdee.shr.econtractservice.EcontractserviceServerResource", (String)"label29", (Context)ctx);
            String label30 = SHRServerResource.getString((String)"com.kingdee.shr.econtractservice.EcontractserviceServerResource", (String)"label30", (Context)ctx);
            String label31 = SHRServerResource.getString((String)"com.kingdee.shr.econtractservice.EcontractserviceServerResource", (String)"label31", (Context)ctx);
            String label32 = SHRServerResource.getString((String)"com.kingdee.shr.econtractservice.EcontractserviceServerResource", (String)"label32", (Context)ctx);
            throw new BOSException(label29 + "\uff1a\n1\u3001" + label30 + "\uff1b\n2\u3001" + label31 + "\uff1b\n3\u3001" + label32 + "\u3002");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readInputStream(InputStream inputStream) throws BOSException, EASBizException {
        byte[] buffer = new byte[1024];
        byte[] bufferReturn = null;
        int len = 0;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            while ((len = inputStream.read(buffer)) != -1) {
                bos.write(buffer, 0, len);
            }
            bufferReturn = bos.toByteArray();
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return bufferReturn;
    }
}

