/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.elecontract.service;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.contract.ElectronicContractRelationCollection;
import com.kingdee.eas.hr.contract.ElectronicContractRelationFactory;
import com.kingdee.eas.hr.contract.ElectronicContractRelationInfo;
import com.kingdee.eas.hr.contract.IElectronicContractRelation;
import com.kingdee.shr.elecontract.KDContractConfigInfo;
import com.kingdee.util.StringUtils;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncSaveEContractInfoRunnable
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(SyncSaveEContractInfoRunnable.class);
    private Context ctx;
    private String billId;
    private String entryId;
    private Map<String, Object> dataMap;
    private JSONObject jsonObject;
    private KDContractConfigInfo config;
    private int pageCount = 1;

    public SyncSaveEContractInfoRunnable(Context ctx, String billId, Map<String, Object> dataMap, JSONObject jsonObject, KDContractConfigInfo config) {
        this.ctx = ctx;
        this.billId = billId;
        this.dataMap = dataMap;
        this.jsonObject = jsonObject;
        this.config = config;
    }

    public SyncSaveEContractInfoRunnable(Context ctx, String billId, Map<String, Object> dataMap, JSONObject jsonObject, KDContractConfigInfo config, int pageCount) {
        this.ctx = ctx;
        this.billId = billId;
        this.dataMap = dataMap;
        this.jsonObject = jsonObject;
        this.config = config;
        this.pageCount = pageCount;
    }

    public SyncSaveEContractInfoRunnable(Context ctx, String billId, String entryId, Map<String, Object> dataMap, JSONObject jsonObject, KDContractConfigInfo config) {
        this.ctx = ctx;
        this.billId = billId;
        this.dataMap = dataMap;
        this.jsonObject = jsonObject;
        this.config = config;
        this.entryId = entryId;
    }

    public SyncSaveEContractInfoRunnable(Context ctx, String billId, String entryId, Map<String, Object> dataMap, JSONObject jsonObject, KDContractConfigInfo config, int pageCount) {
        this.ctx = ctx;
        this.billId = billId;
        this.entryId = entryId;
        this.dataMap = dataMap;
        this.jsonObject = jsonObject;
        this.config = config;
        this.pageCount = pageCount;
    }

    @Override
    public void run() {
        try {
            logger.error("SyncSaveEContractInfoRunnable run: ");
            logger.error("SyncSaveEContractInfoRunnable dataMap: " + this.dataMap);
            if (this.jsonObject.getIntValue("code") == 0 && !StringUtils.isEmpty((String)this.billId)) {
                ElectronicContractRelationCollection coll;
                String contractNo = (String)this.dataMap.get("contractNo");
                logger.error("SyncSaveEContractInfoRunnable contractNo : " + contractNo);
                IElectronicContractRelation electronicContractRelation = ElectronicContractRelationFactory.getLocalInstance((Context)this.ctx);
                String oql = "where billID = '" + this.billId + "'";
                if (!StringUtils.isEmpty((String)this.entryId)) {
                    oql = oql + " AND entryId = '" + this.entryId + "'";
                }
                ElectronicContractRelationInfo relation = (coll = electronicContractRelation.getElectronicContractRelationCollection(oql)).size() > 0 ? coll.get(0) : new ElectronicContractRelationInfo();
                relation.setBillID(BOSUuid.read((String)this.billId));
                if (!StringUtils.isEmpty((String)this.entryId)) {
                    relation.setEntryId(BOSUuid.read((String)this.entryId));
                }
                relation.setContractId(contractNo);
                if (this.config != null && this.config.getId() != null) {
                    relation.setSimpleName(this.config.getId().toString());
                }
                relation.setPageCount(this.pageCount);
                logger.error("SyncSaveEContractInfoRunnable relation.getSimpleName() : " + relation.getSimpleName());
                relation.setContractState(Short.parseShort("0"));
                electronicContractRelation.save((CoreBaseInfo)relation);
            }
        }
        catch (EASBizException e) {
            logger.error("SyncSaveEContractInfoRunnable EASBizException : " + e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error("SyncSaveEContractInfoRunnable BOSException : " + e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            logger.error("SyncSaveEContractInfoRunnable Exception : " + e.getMessage(), (Throwable)e);
        }
        catch (Throwable e) {
            logger.error("SyncSaveEContractInfoRunnable Throwable : " + e.getMessage(), e);
        }
    }
}

