/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.elecontract.util;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.elecontract.util.CloudServiceUtil;
import com.kingdee.shr.elecontract.util.HttpMethodUtils;
import com.kingdee.shr.elecontract.util.TSPServerInstance;
import com.kingdee.shr.elecontract.util.URLUtils;
import com.kingdee.shr.shareservice.CloudServiceException;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.AbstractHttpMessage;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckHRCloudLicenseUtils {
    private static final Logger logger = LoggerFactory.getLogger(CheckHRCloudLicenseUtils.class);
    private static String HRCLOUD_SERVER_ADDRESS = "";
    public static final String COUNT_PATH = "/ctrl/site";
    public static final String REDUCE_PATH = "/ctrl/tenantobtain/deduct";
    public static final String ROLLBACK_PATH = "/ctrl/tenantobtain/deductback";
    public static final int SUCCESS_CODE = 0;
    public static final boolean SUCCESS_STATUS = true;
    public static final boolean FAIL_STATUS = false;
    public static final String DEFAULT_POINT = "1";
    private static Map<String, String> headerMap = new HashMap<String, String>();
    public static final String KDCONTRACT = "8";
    public static final String AVAILABLESITE_KEY = "availableSite";

    public static void checkLicenseCount(Context ctx, String cloudServiceId, String nonce) throws BOSException, EASBizException {
        Map<String, String> serverMap = null;
        try {
            serverMap = TSPServerInstance.getServerInfo(ctx);
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        if (serverMap != null) {
            String serviceId = serverMap.get("service_id");
            CheckHRCloudLicenseUtils.checkLicenseCount(ctx, serviceId, cloudServiceId, nonce);
        }
    }

    public static void checkLicenseCount(Context ctx, String tenantId, String cloudServiceId, String nonce) throws EASBizException {
        String baseAddress = CheckHRCloudLicenseUtils.getHRCloudBaseAddress(ctx) + COUNT_PATH;
        HashMap<String, String> pathMap = new HashMap<String, String>();
        HashMap<String, String> queryMap = new HashMap<String, String>();
        pathMap.put("0", tenantId);
        pathMap.put(DEFAULT_POINT, cloudServiceId);
        queryMap.put("nonce", nonce);
        String sendRequestToHRCloud = CheckHRCloudLicenseUtils.sendRequestToHRCloud(ctx, baseAddress, headerMap, pathMap, queryMap, null);
        JSONObject reqResult = JSONObject.parseObject((String)sendRequestToHRCloud);
        if (!reqResult.getBoolean("success").booleanValue() || 0 != reqResult.getIntValue("code")) {
            throw new CloudServiceException(CloudServiceException.CEIFAIL_EXCEPTION);
        }
        JSONObject dataRes = reqResult.getJSONObject("data");
        Object info = null;
        if (StringUtils.isEmpty((String)dataRes.getString("strategyType")) || StringUtils.isEmpty((String)dataRes.getString(AVAILABLESITE_KEY))) {
            throw new CloudServiceException(CloudServiceException.CEIFAILP_EXCEPTION);
        }
        if ("2".equals(dataRes.getString("strategyType")) && dataRes.getIntValue(AVAILABLESITE_KEY) <= 0) {
            throw new CloudServiceException(CloudServiceException.ENHI_EXCEPTION);
        }
    }

    public static void reduceLicenseCount(Context ctx, String tenantId, String cloudServiceId, String reducePoint, String nonce) throws EASBizException, BOSException {
        String baseAddress = CheckHRCloudLicenseUtils.getHRCloudBaseAddress(ctx) + REDUCE_PATH;
        HashMap<String, String> bodyMap = new HashMap<String, String>();
        bodyMap.put("tenantId", tenantId);
        bodyMap.put("cloudServiceId", cloudServiceId);
        bodyMap.put("totalSite", reducePoint);
        HashMap<String, String> queryMap = new HashMap<String, String>();
        queryMap.put("nonce", nonce);
        String sendRequestToHRCloud = CheckHRCloudLicenseUtils.sendRequestToHRCloud(ctx, baseAddress, headerMap, null, queryMap, bodyMap);
        JSONObject reqResult = JSONObject.parseObject((String)sendRequestToHRCloud);
        if (!reqResult.getBoolean("success").booleanValue() || 0 != reqResult.getIntValue("code")) {
            throw new CloudServiceException(CloudServiceException.CEIFAIL_EXCEPTION);
        }
        JSONObject dataRes = reqResult.getJSONObject("data");
        Object info = null;
        if (!dataRes.getBoolean("result").booleanValue()) {
            throw new CloudServiceException(CloudServiceException.EIDFAIL_EXCEPTION, new Object[]{reqResult.getString("errorMessage")});
        }
    }

    public static boolean rollbackLicenseCount(Context ctx, String tenantId, String cloudServiceId, String backPoint, String nonce) throws EASBizException, BOSException {
        String baseAddress = CheckHRCloudLicenseUtils.getHRCloudBaseAddress(ctx) + ROLLBACK_PATH;
        HashMap<String, String> bodyMap = new HashMap<String, String>();
        bodyMap.put("tenantId", tenantId);
        bodyMap.put("cloudServiceId", cloudServiceId);
        bodyMap.put("totalSite", backPoint);
        HashMap<String, String> queryMap = new HashMap<String, String>();
        queryMap.put("nonce", nonce);
        String sendRequestToHRCloud = CheckHRCloudLicenseUtils.sendRequestToHRCloud(ctx, baseAddress, headerMap, null, queryMap, bodyMap);
        JSONObject reqResult = JSONObject.parseObject((String)sendRequestToHRCloud);
        if (!reqResult.getBoolean("success").booleanValue() || 0 != reqResult.getIntValue("code")) {
            return false;
        }
        JSONObject dataRes = reqResult.getJSONObject("data");
        return dataRes.getBoolean("result");
    }

    public static String sendRequestToHRCloud(Context ctx, String url, Map<String, String> headerMap, Map<String, String> pathMap, Map<String, String> queryMap, Map<String, String> bodyMap) throws EASBizException {
        HttpPost method = null;
        try {
            url = CheckHRCloudLicenseUtils.setPath(url, pathMap);
            url = CheckHRCloudLicenseUtils.setQuery(url, queryMap);
            CloseableHttpClient httpClient = HttpClients.createDefault();
            method = new HttpPost(url);
            method = (HttpPost)HttpMethodUtils.addHeader(ctx, (AbstractHttpMessage)method);
            CheckHRCloudLicenseUtils.setHeader(method, headerMap);
            CheckHRCloudLicenseUtils.setBody(method, bodyMap);
            logger.error("post form to url : " + url + ", params: " + null);
            HttpResponse response = httpClient.execute((HttpUriRequest)method);
            int statusCode = response.getStatusLine().getStatusCode();
            String responseString = "";
            if (statusCode == 200) {
                responseString = EntityUtils.toString((HttpEntity)response.getEntity());
                logger.error("post form to url res : statusCode " + statusCode + " , responseString" + responseString);
                String string = responseString;
                return string;
            }
            try {
                throw new Exception("Http Request Error, statusCode " + statusCode + " , responseString" + responseString);
            }
            catch (Exception e) {
                logger.error("post Exception : \n", (Throwable)e);
                NumericExceptionSubItem info = new NumericExceptionSubItem("00", e.getMessage());
                throw new EASBizException(info, (Throwable)e);
            }
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
    }

    private static void setHeader(HttpPost method, Map<String, String> headerMap) {
        if (headerMap != null && headerMap.size() > 0) {
            Set<String> keySet = headerMap.keySet();
            for (String key : keySet) {
                method.setHeader(key, headerMap.get(key));
            }
        }
    }

    private static String setPath(String url, Map<String, String> pathMap) {
        if (pathMap != null && pathMap.size() > 0) {
            String basePath = URLUtils.getBasePath(url);
            StringBuilder redirectUrl = new StringBuilder(basePath);
            Map<String, String> queryParams = URLUtils.getQueryParams(url);
            int size = pathMap.size();
            for (int dex = 0; dex < size; ++dex) {
                redirectUrl.append("/").append(pathMap.get("" + dex));
            }
            return URLUtils.assembleUrl(redirectUrl.toString(), queryParams);
        }
        return url;
    }

    private static String setQuery(String url, Map<String, String> queryMap) {
        if (queryMap != null && queryMap.size() > 0) {
            StringBuilder redirectUrl = new StringBuilder(url);
            if (redirectUrl.indexOf("?") == -1) {
                redirectUrl.append("?");
            } else {
                redirectUrl.append("&");
            }
            String key2 = null;
            String value = null;
            int index = 0;
            for (String key2 : queryMap.keySet()) {
                if (index != 0) {
                    redirectUrl.append("&");
                }
                redirectUrl.append(key2);
                redirectUrl.append("=");
                value = queryMap.get(key2);
                try {
                    redirectUrl.append(URLEncoder.encode(value, "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    redirectUrl.append(URLEncoder.encode(value));
                }
                ++index;
            }
            return redirectUrl.toString();
        }
        return url;
    }

    private static void setBody(HttpPost method, Map<String, String> bodyMap) throws UnsupportedEncodingException {
        if (bodyMap != null && bodyMap.size() > 0) {
            StringEntity entity = new StringEntity(JSONObject.toJSONString(bodyMap), "UTF-8");
            entity.setContentEncoding("UTF-8");
            entity.setContentType(ContentType.APPLICATION_JSON.getMimeType());
            method.setEntity((HttpEntity)entity);
        }
    }

    public static String getHRCloudBaseAddress(Context ctx) throws EASBizException {
        if (StringUtils.isEmpty((String)HRCLOUD_SERVER_ADDRESS)) {
            String serviceUrl = CloudServiceUtil.getServiceUrl(ctx, "BASE");
            if (StringUtils.isEmpty((String)serviceUrl)) {
                throw new CloudServiceException(CloudServiceException.RSYANS_EXCEPTION);
            }
            HRCLOUD_SERVER_ADDRESS = serviceUrl;
        }
        return HRCLOUD_SERVER_ADDRESS;
    }

    static {
        if (headerMap == null) {
            headerMap = new HashMap<String, String>();
        }
        headerMap.put("Content-type", ContentType.APPLICATION_JSON.getMimeType() + "; charset=utf-8");
    }
}

