/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.elecontract.util;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.base.syssetting.IMSFServiceFacade;
import com.kingdee.shr.base.syssetting.MSFServiceFacadeFactory;
import com.kingdee.shr.elecontract.IKDContractConfigAuthRecord;
import com.kingdee.shr.elecontract.KDContractConfigAuthRecordFactory;
import com.kingdee.shr.elecontract.KDContractConfigAuthRecordHISInfo;
import com.kingdee.shr.elecontract.KDContractConfigAuthRecordInfo;
import com.kingdee.shr.elecontract.app.KDContractConfigAuthRecordState;
import com.kingdee.util.StringUtils;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KdContractConfigAuthRecordUtils {
    private static final Logger logger = LoggerFactory.getLogger(KdContractConfigAuthRecordUtils.class);

    public static KDContractConfigAuthRecordHISInfo copyAuthRecordToHis(KDContractConfigAuthRecordInfo authRecordInfo) {
        KDContractConfigAuthRecordHISInfo kdContractConfigAuthRecordHisInfo = new KDContractConfigAuthRecordHISInfo();
        kdContractConfigAuthRecordHisInfo.setAuthFileNo(authRecordInfo.getAuthFileNo());
        kdContractConfigAuthRecordHisInfo.setAuthTime(authRecordInfo.getAuthTime());
        kdContractConfigAuthRecordHisInfo.setAuthUrl(authRecordInfo.getAuthUrl());
        kdContractConfigAuthRecordHisInfo.setState(authRecordInfo.getState());
        kdContractConfigAuthRecordHisInfo.setAuthPersonName(authRecordInfo.getAuthPersonName());
        kdContractConfigAuthRecordHisInfo.setAuthPersonCell(authRecordInfo.getAuthPersonCell());
        kdContractConfigAuthRecordHisInfo.setAuthPersonNo(authRecordInfo.getAuthPersonNo());
        kdContractConfigAuthRecordHisInfo.setConfig(authRecordInfo.getConfig());
        kdContractConfigAuthRecordHisInfo.setEnterpId(authRecordInfo.getEnterpId());
        kdContractConfigAuthRecordHisInfo.setSendAuthTime(authRecordInfo.getSendAuthTime());
        kdContractConfigAuthRecordHisInfo.setSendCancelAuthTime(authRecordInfo.getSendCancelAuthTime());
        kdContractConfigAuthRecordHisInfo.setCancelAuthUrl(authRecordInfo.getCancelAuthUrl());
        kdContractConfigAuthRecordHisInfo.setCancelAuthTime(authRecordInfo.getCancelAuthTime());
        kdContractConfigAuthRecordHisInfo.setErrorMsg(authRecordInfo.getErrorMsg());
        kdContractConfigAuthRecordHisInfo.setHistoryId(authRecordInfo.getId().toString());
        return kdContractConfigAuthRecordHisInfo;
    }

    public static void cleanAuthDataForCancel(Context ctx, KDContractConfigAuthRecordInfo authRecordInfo, Timestamp cancelTime) throws EASBizException, BOSException {
        authRecordInfo.setCancelAuthTime(cancelTime == null ? new Timestamp(System.currentTimeMillis()) : cancelTime);
        authRecordInfo.setState(KDContractConfigAuthRecordState.Unauthorized);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("cancelAuthTime"));
        selector.add(new SelectorItemInfo("state"));
        KdContractConfigAuthRecordUtils.updateAuthRecordAndHis(ctx, authRecordInfo, selector);
        authRecordInfo.setAuthFileNo(null);
        authRecordInfo.setAuthTime(null);
        authRecordInfo.setAuthUrl(null);
        authRecordInfo.setSendAuthTime(null);
        authRecordInfo.setCancelAuthUrl(null);
        authRecordInfo.setErrorMsg(null);
        authRecordInfo.setSendCancelAuthTime(null);
        authRecordInfo.setCancelAuthTime(null);
        selector.clear();
        selector.add(new SelectorItemInfo("authFileNo"));
        selector.add(new SelectorItemInfo("authTime"));
        selector.add(new SelectorItemInfo("authUrl"));
        selector.add(new SelectorItemInfo("sendAuthTime"));
        selector.add(new SelectorItemInfo("cancelAuthUrl"));
        selector.add(new SelectorItemInfo("errorMsg"));
        selector.add(new SelectorItemInfo("sendCancelAuthTime"));
        selector.add(new SelectorItemInfo("cancelAuthTime"));
        KdContractConfigAuthRecordUtils.updateAuthRecordAndHis(ctx, authRecordInfo, selector);
    }

    public static void setAuthSuccess(Context ctx, KDContractConfigAuthRecordInfo authRecordInfo, String createTime) throws EASBizException, BOSException {
        Timestamp authTime = null;
        if (!StringUtils.isEmpty((String)createTime)) {
            try {
                Long times = Long.valueOf(createTime);
                authTime = new Timestamp(times);
            }
            catch (Exception e) {
                new Timestamp(System.currentTimeMillis());
                logger.error(e.getMessage(), (Throwable)e);
            }
        } else {
            authTime = new Timestamp(System.currentTimeMillis());
        }
        authRecordInfo.setState(KDContractConfigAuthRecordState.Authorized);
        authRecordInfo.setAuthTime(authTime);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("state"));
        selector.add(new SelectorItemInfo("authTime"));
        KdContractConfigAuthRecordUtils.updateAuthRecordAndHis(ctx, authRecordInfo, selector);
    }

    public static void setCancelAuthSuccess(Context ctx, KDContractConfigAuthRecordInfo authRecordInfo, String createTime) throws EASBizException, BOSException {
        Timestamp cancelAuthTime = null;
        if (!StringUtils.isEmpty((String)createTime)) {
            try {
                Long times = Long.valueOf(createTime);
                cancelAuthTime = new Timestamp(times);
            }
            catch (Exception e) {
                new Timestamp(System.currentTimeMillis());
                logger.error(e.getMessage(), (Throwable)e);
            }
        } else {
            cancelAuthTime = new Timestamp(System.currentTimeMillis());
        }
        KdContractConfigAuthRecordUtils.cleanAuthDataForCancel(ctx, authRecordInfo, cancelAuthTime);
    }

    public static void setAuthOrCancelAuthFailed(Context ctx, KDContractConfigAuthRecordInfo authRecordInfo, String errorMsg, String createTime) throws EASBizException, BOSException {
        authRecordInfo.setState(KDContractConfigAuthRecordState.AuthFailed);
        authRecordInfo.setErrorMsg(errorMsg);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("state"));
        selector.add(new SelectorItemInfo("errorMsg"));
        KdContractConfigAuthRecordUtils.updateAuthRecordAndHis(ctx, authRecordInfo, selector);
    }

    public static void refreshAuthRecordState(Context ctx, KDContractConfigAuthRecordInfo authRecordInfo, Map dataMap) throws EASBizException, BOSException {
        String authFileNo = authRecordInfo.getAuthFileNo();
        HashMap<String, String> osfDataMap = new HashMap<String, String>();
        osfDataMap.put("kDContractConfigId", authRecordInfo.getConfig().getId().toString());
        osfDataMap.put("authFileNo", authFileNo);
        IMSFServiceFacade osfServiceFacade = MSFServiceFacadeFactory.getLocalInstance((Context)ctx);
        JSONObject result = (JSONObject)osfServiceFacade.processService("getAuthSignResultService", osfDataMap);
        int code = result.getIntValue("code");
        if (code == 0) {
            JSONObject data = result.getJSONObject("data");
            String authType = data.getString("authType");
            String authResult = data.getString("authResult");
            String authTime = data.getString("authTime");
            if ("1".equals(authResult) && "1".equals(authType)) {
                KdContractConfigAuthRecordUtils.setAuthSuccess(ctx, authRecordInfo, authTime);
                dataMap.put("authState", KDContractConfigAuthRecordState.Authorized);
            } else if ("1".equals(authResult) && "2".equals(authType)) {
                KdContractConfigAuthRecordUtils.setCancelAuthSuccess(ctx, authRecordInfo, authTime);
                dataMap.put("authState", KDContractConfigAuthRecordState.Unauthorized);
            } else if ("2".equals(authResult) && "1".equals(authType) || "2".equals(authResult) && "2".equals(authType)) {
                String errorMsg = data.getString("resultDesc");
                KdContractConfigAuthRecordUtils.setAuthOrCancelAuthFailed(ctx, authRecordInfo, errorMsg, authTime);
                dataMap.put("authState", KDContractConfigAuthRecordState.AuthFailed);
            }
        }
    }

    public static void updateAuthRecordAndHis(Context ctx, KDContractConfigAuthRecordInfo authRecordInfo, SelectorItemCollection selector) throws BOSException, EASBizException {
        IKDContractConfigAuthRecord ikdContractConfigAuthRecord = KDContractConfigAuthRecordFactory.getLocalInstance(ctx);
        ikdContractConfigAuthRecord.updatePartial(authRecordInfo, selector);
    }
}

