/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.ml.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.bs.ml.MetaDataTypeEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.shr.ml.ResourceType;
import com.kingdee.shr.ml.SHRResourceInfo;
import com.kingdee.shr.ml.ShrMlBizException;
import com.kingdee.shr.ml.app.AbstractSHRResourceControllerBean;
import com.kingdee.util.StringUtils;
import java.sql.Timestamp;
import java.util.List;
import org.apache.log4j.Logger;

public class SHRResourceControllerBean
extends AbstractSHRResourceControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.ml.app.SHRResourceControllerBean");

    public IObjectPK save(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        SHRResourceInfo info = (SHRResourceInfo)model;
        Timestamp t = new Timestamp(System.currentTimeMillis());
        info.setLastUpdateTime(t);
        info.setLastUpdateUser(ContextUtil.getCurrentUserInfo((Context)ctx));
        if (StringUtils.isEmpty((String)info.getRes())) {
            info.setRes(info.getRes2());
        }
        if (null == info.getId()) {
            info.setMetaType(MetaDataTypeEnum.ui);
            if (StringUtils.isEmpty((String)info.getPackageName())) {
                List rs = ResourceType.getEnumList();
                String upperType = info.getFileName().substring(info.getFileName().lastIndexOf(".") + 1).toUpperCase();
                for (ResourceType r : rs) {
                    if (!r.getName().equals(upperType)) continue;
                    info.setPackageName(r.getValue());
                    break;
                }
            }
            info.setCreateTime(t);
            info.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
            this.checkExists(ctx, info);
            return super.save(ctx, (CoreBaseInfo)info);
        }
        SHRResourceInfo oldInfo = this.getSHRResourceInfo(ctx, (IObjectPK)new ObjectUuidPK(info.getId()));
        oldInfo.setRes2(info.getRes2());
        return super.save(ctx, (CoreBaseInfo)oldInfo);
    }

    private void checkExists(Context ctx, SHRResourceInfo info) throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("packageName", (Object)info.getPackageName()));
        filter.getFilterItems().add(new FilterItemInfo("fileName", (Object)info.getFileName()));
        filter.getFilterItems().add(new FilterItemInfo("key", (Object)info.getKey()));
        if (this.exists(ctx, filter)) {
            throw new ShrMlBizException(ShrMlBizException.KEYEXISTS, new Object[]{info.getPackageName(), info.getFileName(), info.getKey()});
        }
    }
}

