/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.base.serviceImpl;

import com.google.gson.Gson;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.basedata.org.IPosition;
import com.kingdee.eas.basedata.org.PositionFactory;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.org.IJobGrade;
import com.kingdee.eas.hr.org.JobGradeFactory;
import com.kingdee.eas.hr.org.JobGradeInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjectInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfPeriodInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfPlanInfo;
import com.kingdee.shr.perfweb.app.base.evalrule.EvaFormFieldConfCollection;
import com.kingdee.shr.perfweb.app.base.evalrule.EvaFormFieldConfInfo;
import com.kingdee.shr.perfweb.app.base.evalrule.EvaluFormAreaBaseCollection;
import com.kingdee.shr.perfweb.app.base.evalrule.EvaluFormAreaBaseFactory;
import com.kingdee.shr.perfweb.app.base.evalrule.EvaluFormAreaBaseInfo;
import com.kingdee.shr.perfweb.app.base.evalrule.IEvaluFormAreaBase;
import com.kingdee.shr.perfweb.app.base.evalrule.PerformanceRuleInfo;
import com.kingdee.shr.perfweb.app.base.evalrule.RecordFieldConfCollection;
import com.kingdee.shr.perfweb.app.base.evalrule.RecordFieldConfInfo;
import com.kingdee.shr.perfweb.app.base.indecator.IndecatorTypeInfo;
import com.kingdee.shr.perfweb.app.resource.SHRPerfWebResource;
import com.kingdee.shr.perfweb.app.workflow.GradeTargetInstCollection;
import com.kingdee.shr.perfweb.app.workflow.GradeTargetInstFactory;
import com.kingdee.shr.perfweb.app.workflow.GradeTargetInstInfo;
import com.kingdee.shr.perfweb.app.workflow.GradeTaskNodeInstCollection;
import com.kingdee.shr.perfweb.app.workflow.GradeTaskNodeInstFactory;
import com.kingdee.shr.perfweb.app.workflow.GradeTaskNodeInstInfo;
import com.kingdee.shr.perfweb.osf.model.FieldType;
import com.kingdee.shr.perfweb.portal.bean.AreaFieldBean;
import com.kingdee.shr.perfweb.portal.bean.EvaAreaListBean;
import com.kingdee.shr.perfweb.portal.bean.PerfRecordScoreBean;
import com.kingdee.shr.perfweb.portal.bean.PersonalEvaBaseBean;
import com.kingdee.shr.perfweb.util.EvaFormUtil;
import com.kingdee.shr.perfweb.util.GetEntityInfoUtils;
import com.kingdee.shr.perfweb.util.SHRPerfWebResourceUtil;
import com.kingdee.shr.perfweb.utils.IndicatorUtils;
import com.kingdee.shr.perfweb.utils.PersonBaseUtils;
import com.kingdee.shr.perfweb.utils.PhotoUtils;
import java.io.IOException;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetPerfScoreResultImpl {
    private static Logger logger = LoggerFactory.getLogger((String)"com.kingdee.shr.perfweb.base.serviceImpl.GetPerfScoreResultImpl");
    private static final String AREASUMSCORE = "AREASUMSCORE";

    public Map<String, Object> getPerfScoreResult(Context ctx, String evaObjId, String periodId, String planId, String personId, String type) {
        Map<String, Object> map = new HashMap<String, Object>();
        try {
            map = this.getAreaConfAndTarget(ctx, evaObjId, periodId, planId, personId, type);
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
        }
        return map;
    }

    public static ArrayList<HashMap<String, Object>> getPersonBaseData(Context ctx, HttpServletRequest request, HttpServletResponse response) throws BOSException, SQLException, EASBizException, IOException {
        String json = "";
        String evaObj = request.getParameter("evaObj");
        String periodId = request.getParameter("periodId");
        ArrayList<HashMap<String, Object>> fieldConfList = PersonBaseUtils.getPersonBaseFileds(ctx, periodId);
        StringBuffer sqlBuffer = new StringBuffer("select ");
        for (HashMap<String, Object> map : fieldConfList) {
            sqlBuffer.append(",").append(map.get("colName"));
        }
        sqlBuffer.append(" from T_EVA_PersonBaseOfGoals where FEvaObjID=?");
        String selectSQL = sqlBuffer.toString().replaceFirst(",", "");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSQL, (Object[])new Object[]{evaObj});
        if (rs != null && rs.next()) {
            for (HashMap<String, Object> map : fieldConfList) {
                String colName = (String)map.get("colName");
                if (colName.equals("FBELONGORG")) {
                    String orgId = rs.getString(colName);
                    if (StringUtils.isEmpty((String)orgId)) continue;
                    IAdminOrgUnit iadminOrg = AdminOrgUnitFactory.getLocalInstance((Context)ctx);
                    AdminOrgUnitInfo adminOrgInfo = iadminOrg.getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgId));
                    map.put("colNameVal", adminOrgInfo.getName());
                    continue;
                }
                if (colName.equals("FPHOTOID")) {
                    request.setAttribute("personId", (Object)request.getParameter("personId"));
                    IPerson iPerson = PersonFactory.getLocalInstance((Context)ctx);
                    PersonCollection personColl = iPerson.getPersonCollection(" where id='" + request.getParameter("personId") + "'");
                    if (personColl == null || personColl.size() <= 0) continue;
                    PersonInfo personInfo = personColl.get(0);
                    request.setAttribute("personNumber", (Object)personInfo.getNumber());
                    String imgPath = PhotoUtils.showCutImage(request, response);
                    map.put("colNameVal", imgPath);
                    continue;
                }
                if (colName.equals("FPOSITIONID")) {
                    String positonId = rs.getString(colName);
                    if (StringUtils.isEmpty((String)positonId)) continue;
                    IPosition ipos = PositionFactory.getLocalInstance((Context)ctx);
                    PositionInfo posInfo = ipos.getPositionInfo((IObjectPK)new ObjectUuidPK(positonId));
                    map.put("colNameVal", posInfo.getName());
                    continue;
                }
                if (colName.equals("FJOBGRADEID")) {
                    String jobGradeId = rs.getString(colName);
                    if (StringUtils.isEmpty((String)jobGradeId)) continue;
                    IJobGrade ijobGrade = JobGradeFactory.getLocalInstance((Context)ctx);
                    JobGradeInfo jobGradeInfo = ijobGrade.getJobGradeInfo(" where id='" + jobGradeId + "'");
                    map.put("colNameVal", jobGradeInfo.getName());
                    continue;
                }
                map.put("colNameVal", StringUtils.isEmpty((String)rs.getString(colName)) ? "" : rs.getString(colName));
            }
        }
        Gson gson = new Gson();
        json = gson.toJson(fieldConfList);
        return fieldConfList;
    }

    private Map<String, Object> getAreaConfAndTarget(Context ctx, String evaObj, String periodId, String planId, String handlerId, String type) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Float sum = Float.valueOf(0.0f);
        try {
            PerfEvaObjectInfo evaObjInfo = PersonBaseUtils.getPerfEvaObjInfo(ctx, evaObj);
            PerfPeriodInfo periodInfo = PersonBaseUtils.getPerfPeriodInfo(ctx, evaObjInfo.getPeriod().getId().toString());
            PerfPlanInfo planInfo = PersonBaseUtils.getPerfPlanInfo(ctx, periodInfo.getPerfPlan().getId().toString());
            String planName = planInfo.getName();
            String perfRuleName = periodInfo.getPerfRule().getName();
            String perfModelName = planInfo.getPerfModel().getName();
            String perfRuleId = periodInfo.getPerfRule().getId().toString();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy.MM.dd");
            String pStartDate = sdf.format(periodInfo.getPStartDate());
            String pEndDate = sdf.format(periodInfo.getPEndDate());
            PersonalEvaBaseBean personEvaBaseBean = new PersonalEvaBaseBean();
            personEvaBaseBean.setPlanName(planName);
            personEvaBaseBean.setRuleName(perfRuleName);
            personEvaBaseBean.setPerfModelName(perfModelName);
            personEvaBaseBean.setpStartDate(pStartDate);
            personEvaBaseBean.setpEndDate(pEndDate);
            PerformanceRuleInfo ruleInfo = GetEntityInfoUtils.getPerformanceRuleInfo(ctx, perfRuleId);
            if (ruleInfo != null) {
                personEvaBaseBean.setScoreRuleContent(ruleInfo.getScoreRuleContent());
            }
            IEvaluFormAreaBase iEvaFABase = EvaluFormAreaBaseFactory.getLocalInstance((Context)ctx);
            EvaluFormAreaBaseCollection evaFormABColl = iEvaFABase.getEvaluFormAreaBaseCollection(" where performanceRule='" + perfRuleId + "' order by Seq ASC");
            ArrayList<EvaAreaListBean> evaAreaList = new ArrayList<EvaAreaListBean>();
            if (evaFormABColl != null && evaFormABColl.size() > 0) {
                for (int i = 0; i < evaFormABColl.size(); ++i) {
                    List<PerfRecordScoreBean> list;
                    String targetId;
                    String weightStr;
                    FieldType fieldType;
                    String colName;
                    HashMap<String, Object> fieldValueMap;
                    IRowSet rs;
                    StringBuffer sqlBuffer;
                    String selectSQL;
                    AreaFieldBean areaFieldBean;
                    AreaFieldBean areaFieldBean2;
                    EvaAreaListBean evaAreaBean = new EvaAreaListBean();
                    EvaluFormAreaBaseInfo evaFABaseInfo = evaFormABColl.get(i);
                    String areaBaseId = evaFABaseInfo.getId().toString();
                    String areaType = evaFABaseInfo.getAreaType().getValue();
                    evaAreaBean.setAreaType(areaType);
                    evaAreaBean.setWeightControl(String.valueOf(evaFABaseInfo.getWeightControl().getValue()));
                    ArrayList<AreaFieldBean> fieldList = new ArrayList<AreaFieldBean>();
                    if (areaType.equals("200")) {
                        evaAreaBean.setAreaId(areaBaseId);
                        evaAreaBean.setAreaName(evaFABaseInfo.getName());
                        EvaFormFieldConfCollection evaFormFieldColl = PersonBaseUtils.getEvaFormFieldColl(ctx, areaBaseId);
                        if (evaFormFieldColl != null && evaFormFieldColl.size() > 0) {
                            for (int j = 0; j < evaFormFieldColl.size(); ++j) {
                                EvaFormFieldConfInfo evaFormFieldInfo = evaFormFieldColl.get(j);
                                areaFieldBean2 = new AreaFieldBean();
                                areaFieldBean2.setId(evaFormFieldInfo.getId().toString());
                                areaFieldBean2.setColName(evaFormFieldInfo.getColName());
                                areaFieldBean2.setShowName(evaFormFieldInfo.getShowName());
                                areaFieldBean2.setSeqNo(evaFormFieldInfo.getSeqNo());
                                areaFieldBean2.setTemplateId(evaFormFieldInfo.getFieldTemplate());
                                fieldList.add(areaFieldBean2);
                            }
                            areaFieldBean = new AreaFieldBean();
                            areaFieldBean.setColName("FISUNITED");
                            areaFieldBean.setShowName(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.UNIFIEDTRANSMITORNOT, ctx));
                            fieldList.add(areaFieldBean);
                            evaAreaBean.setFieldList(fieldList);
                        }
                        selectSQL = "";
                        sqlBuffer = new StringBuffer("select FID,FWEIGHT ");
                        for (int k = 0; k < fieldList.size(); ++k) {
                            if (((AreaFieldBean)fieldList.get(k)).getColName().equalsIgnoreCase("FWEIGHT")) continue;
                            sqlBuffer.append(",").append(((AreaFieldBean)fieldList.get(k)).getColName());
                        }
                        sqlBuffer.append(" from T_EVA_IndicatorTarget where FEvaObjID=? and FAreaBaseID=?");
                        selectSQL = sqlBuffer.toString();
                        rs = DbUtil.executeQuery((Context)ctx, (String)selectSQL, (Object[])new Object[]{evaObj, areaBaseId});
                        ArrayList<HashMap<String, Object>> evaIndicatorList = new ArrayList<HashMap<String, Object>>();
                        int areaWeight = 0;
                        if (rs != null) {
                            while (rs.next()) {
                                fieldValueMap = new HashMap<String, Object>();
                                for (int m = 0; m < fieldList.size(); ++m) {
                                    colName = fieldList.get(m).getColName();
                                    String colVal = rs.getString(colName);
                                    colVal = colVal == null ? "" : colVal;
                                    fieldType = fieldList.get(m).getFieldType();
                                    colVal = EvaFormUtil.setBooleanMulitLan(ctx, fieldType, colVal, colName, fieldValueMap);
                                    if (colName.equalsIgnoreCase("FINDECATORTYPE")) {
                                        IndecatorTypeInfo indecatorTypeInfo = new IndecatorTypeInfo();
                                        if (!StringUtils.isEmpty((String)colVal)) {
                                            indecatorTypeInfo = IndicatorUtils.getIndecatorType(ctx, colVal);
                                        }
                                        fieldValueMap.put(colName, indecatorTypeInfo);
                                        continue;
                                    }
                                    fieldValueMap.put(colName, colVal);
                                }
                                weightStr = rs.getString("FWEIGHT");
                                if (StringUtils.isEmpty((String)weightStr)) {
                                    weightStr = "0";
                                }
                                areaWeight += Integer.parseInt(weightStr);
                                targetId = rs.getString("FID");
                                fieldValueMap.put("FID", targetId);
                                list = this.getGradeTargetInstCollection(ctx, evaObj, areaBaseId, targetId, handlerId, type);
                                fieldValueMap.put("scoreList", list);
                                evaIndicatorList.add(fieldValueMap);
                            }
                        }
                        evaAreaBean.setAreaWeight(String.valueOf(areaWeight));
                        evaAreaBean.setEvaIndicatorList(evaIndicatorList);
                        evaAreaList.add(evaAreaBean);
                        continue;
                    }
                    if (!areaType.equals("300")) continue;
                    evaAreaBean.setAreaId(areaBaseId);
                    evaAreaBean.setAreaName(evaFABaseInfo.getName());
                    RecordFieldConfCollection recordFieldColl = PersonBaseUtils.getRecordFieldColl(ctx, areaBaseId);
                    if (recordFieldColl != null && recordFieldColl.size() > 0) {
                        for (int j = 0; j < recordFieldColl.size(); ++j) {
                            RecordFieldConfInfo recordFieldInfo = recordFieldColl.get(j);
                            areaFieldBean2 = new AreaFieldBean();
                            areaFieldBean2.setId(recordFieldInfo.getId().toString());
                            areaFieldBean2.setColName(recordFieldInfo.getColName());
                            areaFieldBean2.setShowName(recordFieldInfo.getShowName());
                            areaFieldBean2.setSeqNo(recordFieldInfo.getSeqNo());
                            areaFieldBean2.setTemplateId(recordFieldInfo.getFieldTemplate());
                            fieldList.add(areaFieldBean2);
                        }
                        areaFieldBean = new AreaFieldBean();
                        areaFieldBean.setColName("FISUNITED");
                        areaFieldBean.setShowName(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.UNIFIEDTRANSMITORNOT, ctx));
                        fieldList.add(areaFieldBean);
                        evaAreaBean.setFieldList(fieldList);
                    }
                    selectSQL = "";
                    sqlBuffer = new StringBuffer("select FID,FWEIGHT");
                    for (int k = 0; k < fieldList.size(); ++k) {
                        if (((AreaFieldBean)fieldList.get(k)).getColName().equalsIgnoreCase("FWEIGHT")) continue;
                        sqlBuffer.append(",").append(fieldList.get(k).getColName());
                    }
                    sqlBuffer.append(" from T_EVA_RecordTarget where FEvaObjID=? and FAreaBaseID=?");
                    selectSQL = sqlBuffer.toString();
                    rs = DbUtil.executeQuery((Context)ctx, (String)selectSQL, (Object[])new Object[]{evaObj, areaBaseId});
                    int areaWeight = 0;
                    ArrayList<HashMap<String, Object>> evaRecordList = new ArrayList<HashMap<String, Object>>();
                    if (rs != null) {
                        while (rs.next()) {
                            fieldValueMap = new HashMap();
                            for (int m = 0; m < fieldList.size(); ++m) {
                                colName = fieldList.get(m).getColName();
                                String colValue = rs.getString(colName);
                                colValue = colValue == null ? "" : colValue;
                                fieldType = fieldList.get(m).getFieldType();
                                colValue = EvaFormUtil.setBooleanMulitLan(ctx, fieldType, colValue, colName, fieldValueMap);
                                fieldValueMap.put(colName, colValue);
                            }
                            weightStr = rs.getString("FWEIGHT");
                            if (StringUtils.isEmpty((String)weightStr)) {
                                weightStr = "0";
                            }
                            areaWeight += Integer.parseInt(weightStr);
                            targetId = rs.getString("FID");
                            fieldValueMap.put("FID", targetId);
                            list = this.getGradeTargetInstCollection(ctx, evaObj, areaBaseId, targetId, handlerId, type);
                            fieldValueMap.put("scoreList", list);
                            evaRecordList.add(fieldValueMap);
                        }
                    }
                    evaAreaBean.setAreaWeight(String.valueOf(areaWeight));
                    evaAreaBean.setEvaRecordList(evaRecordList);
                    evaAreaList.add(evaAreaBean);
                }
            }
            personEvaBaseBean.setEvaAreaList(evaAreaList);
            map.put("rows", personEvaBaseBean);
        }
        catch (Exception e) {
            logger.error("load area and indicator err:" + e.getMessage());
            map.put("result", SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.LOADEVALUAREAANDINDICATORERR, ctx));
        }
        return map;
    }

    private List<PerfRecordScoreBean> getGradeTargetInstCollection(Context ctx, String evaObjId, String areaBaseId, String targetId, String handlerId, String type) {
        ArrayList<PerfRecordScoreBean> list = new ArrayList<PerfRecordScoreBean>();
        if (type.equals("101")) {
            Object coll = null;
            try {
                GradeTaskNodeInstCollection gradeTaskNodeInstCollection = GradeTaskNodeInstFactory.getLocalInstance((Context)ctx).getGradeTaskNodeInstCollection("where evaObj.id='" + evaObjId + "' order by nodeSeq");
                if (gradeTaskNodeInstCollection == null || gradeTaskNodeInstCollection.size() == 0) {
                    return list;
                }
                for (int m = 0; m < gradeTaskNodeInstCollection.size(); ++m) {
                    PerfRecordScoreBean bean = new PerfRecordScoreBean();
                    GradeTaskNodeInstInfo info = gradeTaskNodeInstCollection.get(m);
                    GradeTargetInstCollection gradeTargetInstCollection = GradeTargetInstFactory.getLocalInstance((Context)ctx).getGradeTargetInstCollection("where gradeTaskNode.id='" + info.getId().toString() + "' and areaBase.id='" + areaBaseId + "' and target='" + targetId + "' ");
                    if (gradeTargetInstCollection == null || gradeTargetInstCollection.size() == 0) continue;
                    GradeTargetInstInfo gradeTargetInstInfo = gradeTargetInstCollection.get(0);
                    bean.setScoreGrade(gradeTargetInstInfo.getGradeRank());
                    bean.setScoreNumber(String.valueOf(gradeTargetInstInfo.getTargetScore()));
                    bean.setComment(gradeTargetInstInfo.getComment());
                    bean.setNodeWeight(info.getNodeWeight());
                    bean.setScorePersonName(info.getNodeHandlerName());
                    bean.setScorePersonRel(info.getPositionName());
                    list.add(bean);
                }
            }
            catch (BOSException e) {
                logger.error("BOSException: ", (Throwable)e);
            }
        } else if (type.equals("201")) {
            try {
                GradeTaskNodeInstCollection gradeTaskNodeInstCollection = GradeTaskNodeInstFactory.getLocalInstance((Context)ctx).getGradeTaskNodeInstCollection("where evaObj.id='" + evaObjId + "' order by nodeSeq");
                if (gradeTaskNodeInstCollection == null || gradeTaskNodeInstCollection.size() == 0) {
                    return list;
                }
                for (int m = 0; m < gradeTaskNodeInstCollection.size(); ++m) {
                    PerfRecordScoreBean bean = new PerfRecordScoreBean();
                    GradeTaskNodeInstInfo info = gradeTaskNodeInstCollection.get(m);
                    GradeTargetInstCollection gradeTargetInstCollection = GradeTargetInstFactory.getLocalInstance((Context)ctx).getGradeTargetInstCollection("where gradeTaskNode.id='" + info.getId().toString() + "' and areaBase.id='" + areaBaseId + "' and target='" + targetId + "' ");
                    if (gradeTargetInstCollection == null || gradeTargetInstCollection.size() == 0) continue;
                    GradeTargetInstInfo gradeTargetInstInfo = gradeTargetInstCollection.get(0);
                    bean.setScoreGrade(gradeTargetInstInfo.getGradeRank());
                    bean.setScoreNumber(String.valueOf(gradeTargetInstInfo.getTargetScore()));
                    bean.setComment(gradeTargetInstInfo.getComment());
                    bean.setScorePersonName(info.getNodeHandlerName());
                    bean.setScorePersonRel(info.getPositionName());
                    list.add(bean);
                    if (!info.getNodeHandler().getId().toString().equals(handlerId)) {
                        continue;
                    }
                    break;
                }
            }
            catch (BOSException e) {
                logger.error("BOSException: ", (Throwable)e);
            }
        }
        return list;
    }

    private void getNodeInstInfo() {
    }
}

