/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.base.serviceImpl;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.HROrgUnitFactory;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.shr.perfweb.app.base.evalplan.IPerfEvaObjectMatrixWorkFlow;
import com.kingdee.shr.perfweb.app.base.evalplan.IPerfPeriod;
import com.kingdee.shr.perfweb.app.base.evalplan.IPerfPlan;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjectMatrixWorkFlowCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjectMatrixWorkFlowFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjectMatrixWorkFlowInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfPeriodCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfPeriodFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfPeriodInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfPlanCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfPlanFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfPlanInfo;
import com.kingdee.shr.perfweb.app.base.evalrule.IPerformanceRule;
import com.kingdee.shr.perfweb.app.base.evalrule.PerformanceRuleFactory;
import com.kingdee.shr.perfweb.app.base.evalrule.PerformanceRuleInfo;
import com.kingdee.shr.perfweb.app.base.evalrule.WFNodeDefCollection;
import com.kingdee.shr.perfweb.app.base.evalrule.WFNodeDefFactory;
import com.kingdee.shr.perfweb.app.base.evalrule.WFNodeDefInfo;
import com.kingdee.shr.perfweb.app.common.YesOrNoEnum;
import com.kingdee.shr.perfweb.app.common.YesOrNotEnum;
import com.kingdee.shr.perfweb.app.exception.SHRPerfWebBizException;
import com.kingdee.shr.perfweb.app.resource.SHRPerfWebResource;
import com.kingdee.shr.perfweb.base.bean.AreaBaseWorkFlowBean;
import com.kingdee.shr.perfweb.base.bean.WorkFlowBean;
import com.kingdee.shr.perfweb.base.service.IPerformancePlan;
import com.kingdee.shr.perfweb.exception.SHRPerfWebException;
import com.kingdee.shr.perfweb.util.SHRPerfWebResourceUtil;
import com.kingdee.shr.perfweb.utils.PerfPlanUtils;
import com.kingdee.shr.perfweb.utils.RequestUtils;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class PerformancePlanImpl
implements IPerformancePlan {
    private static Logger logger = LoggerFactory.getLogger(PerformancePlanImpl.class);

    @Override
    public Map<String, String> savePlan(Context ctx, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        String result = "ERROR";
        String planId = RequestUtils.getParameter(request, "planId");
        String number = RequestUtils.getParameter(request, "number");
        String name = RequestUtils.getParameter(request, "name");
        String orgName = RequestUtils.getParameter(request, "orgName");
        String orgId = RequestUtils.getParameter(request, "orgId");
        String hrOrg = RequestUtils.getParameter(request, "hrOrg");
        String isOrg = RequestUtils.getParameter(request, "isOrg");
        String orgLongNumber = "";
        PerfPlanInfo planInfo = new PerfPlanInfo();
        if (!StringUtils.isEmpty((String)isOrg)) {
            planInfo.setIsOrg(YesOrNotEnum.getEnum((String)isOrg));
        } else {
            isOrg = "0";
            planInfo.setIsOrg(YesOrNotEnum.getEnum((String)isOrg));
        }
        String perfmanceRuleId = RequestUtils.getParameter(request, "perfmanceRuleId");
        String perfmanceRuleName = RequestUtils.getParameter(request, "perfmanceRuleName");
        String perfModelId = RequestUtils.getParameter(request, "evaluMode");
        String perfModelName = RequestUtils.getParameter(request, "evaluModeName");
        String periodFrequency = RequestUtils.getParameter(request, "periodFrequency");
        String evaluationWay = RequestUtils.getParameter(request, "evaluationWay");
        String perfPlanStartSE = RequestUtils.getParameter(request, "perfPlanStartSE");
        String defaultWorkFlow = RequestUtils.getParameter(request, "defaultWorkFlow");
        String defaultWorkFlowName = RequestUtils.getParameter(request, "defaultWorkFlowName");
        String rema = RequestUtils.getParameter(request, "rema");
        String appealDays = RequestUtils.getParameter(request, "appealDays");
        String confirmDays = RequestUtils.getParameter(request, "confirmDays");
        String isShowQuantity = RequestUtils.getParameter(request, "isShowQuantity");
        boolean needConfirm = !StringUtils.isEmpty((String)request.getParameter("needConfirm"));
        boolean allowAppeal = !StringUtils.isEmpty((String)request.getParameter("allowAppeal"));
        String targetTransmitWay = RequestUtils.getParameter(request, "targetTransmitWay");
        targetTransmitWay = StringUtils.isEmpty((String)targetTransmitWay) ? "0" : targetTransmitWay;
        String targetNodeWeight = RequestUtils.getParameter(request, "targetNodeWeight");
        String evaResultShowControllStr = RequestUtils.getParameter(request, "evaResultShowControll");
        int evaResultShowControll = StringUtils.isEmpty((String)evaResultShowControllStr) ? 0 : Integer.valueOf(evaResultShowControllStr);
        String targetMakeSure = RequestUtils.getParameter(request, "targetMakeSure");
        String targetCanEdit = RequestUtils.getParameter(request, "targetCanEdit");
        String onlyFillerReceiver = RequestUtils.getParameter(request, "receiverOnlyFiller");
        String weightForce100 = RequestUtils.getParameter(request, "weightForce100");
        if (StringUtils.isEmpty((String)weightForce100)) {
            planInfo.setWeightForce100(true);
        } else {
            planInfo.setWeightForce100("1".equalsIgnoreCase(weightForce100));
        }
        ArrayList<AreaBaseWorkFlowBean> list = new ArrayList();
        if (evaluationWay.equals("1")) {
            String tabledata = RequestUtils.getParameter(request, "tabledata");
            Gson gson = new Gson();
            list = (List)gson.fromJson(tabledata, new TypeToken<List<AreaBaseWorkFlowBean>>(){}.getType());
        }
        try {
            IAdminOrgUnit iadminOrg = AdminOrgUnitFactory.getRemoteInstance();
            AdminOrgUnitCollection adminOrgColl = iadminOrg.getAdminOrgUnitCollection("where id='" + orgId + "'");
            if (adminOrgColl != null && adminOrgColl.size() > 0) {
                orgLongNumber = adminOrgColl.get(0).getLongNumber();
            }
            boolean isAddOrNewStatus = true;
            String l1Flag = SHRPerfWebResourceUtil.getMlFlag(LocaleUtils.locale_L1);
            String l2Flag = SHRPerfWebResourceUtil.getMlFlag(LocaleUtils.locale_L2);
            String l3Flag = SHRPerfWebResourceUtil.getMlFlag(LocaleUtils.locale_L3);
            String name_l1 = RequestUtils.getParameter(request, "name" + l1Flag);
            String name_l2 = RequestUtils.getParameter(request, "name" + l2Flag);
            String name_l3 = RequestUtils.getParameter(request, "name" + l3Flag);
            String rema_l1 = RequestUtils.getParameter(request, "rema" + l1Flag);
            String rema_l2 = RequestUtils.getParameter(request, "rema" + l2Flag);
            String rema_l3 = RequestUtils.getParameter(request, "rema" + l3Flag);
            if (!StringUtils.isEmpty((String)planId)) {
                IPerfPlan iperfPlan = PerfPlanFactory.getLocalInstance((Context)ctx);
                PerfPlanInfo originPerfPlanInfo = iperfPlan.getPerfPlanInfo((IObjectPK)new ObjectUuidPK(planId));
                if (null == originPerfPlanInfo) {
                    throw new SHRPerfWebBizException(SHRPerfWebBizException.PERFPLANNOTEXIST);
                }
                planInfo.put("id", (Object)planId);
                if (originPerfPlanInfo.getPStatus().getValue() != 0) {
                    planInfo.put("number", (Object)number);
                    planInfo.setName(name);
                    planInfo.setName(StringUtils.isEmpty((String)name_l1) ? name : name_l1, LocaleUtils.locale_l1);
                    planInfo.setName(StringUtils.isEmpty((String)name_l2) ? name : name_l2, LocaleUtils.locale_l2);
                    planInfo.setName(StringUtils.isEmpty((String)name_l3) ? name : name_l3, LocaleUtils.locale_l3);
                    planInfo.setRema(StringUtils.isEmpty((String)rema_l1) ? rema : rema_l1, LocaleUtils.locale_l1);
                    planInfo.setRema(StringUtils.isEmpty((String)rema_l2) ? rema : rema_l2, LocaleUtils.locale_l2);
                    planInfo.setRema(StringUtils.isEmpty((String)rema_l3) ? rema : rema_l3, LocaleUtils.locale_l3);
                    if (!StringUtils.isEmpty((String)appealDays)) {
                        planInfo.setAppealDays(Integer.valueOf(appealDays).intValue());
                    } else {
                        planInfo.setAppealDays(0);
                    }
                    if (!StringUtils.isEmpty((String)confirmDays)) {
                        planInfo.setConfirmDays(Integer.valueOf(confirmDays).intValue());
                    } else {
                        planInfo.setConfirmDays(0);
                    }
                    planInfo.setNeedConfirm(needConfirm);
                    planInfo.setAllowAppeal(allowAppeal);
                    isAddOrNewStatus = false;
                    planInfo.put("targetTransmitWay", (Object)targetTransmitWay);
                    planInfo.put("evaResultShowControll", (Object)evaResultShowControll);
                }
            }
            if (isAddOrNewStatus) {
                planInfo.put("number", (Object)number);
                planInfo.setName(name);
                planInfo.setName(StringUtils.isEmpty((String)name_l1) ? name : name_l1, LocaleUtils.locale_l1);
                planInfo.setName(StringUtils.isEmpty((String)name_l2) ? name : name_l2, LocaleUtils.locale_l2);
                planInfo.setName(StringUtils.isEmpty((String)name_l3) ? name : name_l3, LocaleUtils.locale_l3);
                planInfo.put("belongOrgName", (Object)orgName);
                planInfo.put("belongOrg", (Object)orgId);
                planInfo.put("orgLongNumber", (Object)orgLongNumber);
                planInfo.put("canAdjustEvaluer", (Object)evaluationWay);
                planInfo.put("isShowQuantity", (Object)isShowQuantity);
                planInfo.put("perfRule", (Object)perfmanceRuleId);
                planInfo.put("perfRuleName", (Object)perfmanceRuleName);
                planInfo.put("perfModel", (Object)perfModelId);
                planInfo.put("perfModelName", (Object)perfModelName);
                planInfo.put("periodFrequency", (Object)periodFrequency);
                planInfo.put("perfPlanStartSE", (Object)perfPlanStartSE);
                planInfo.put("defaultWorkFlow", (Object)defaultWorkFlow);
                planInfo.put("defaultWFName", (Object)defaultWorkFlowName);
                planInfo.put("hrUnitOrg", (Object)hrOrg);
                planInfo.setRema(rema);
                planInfo.setRema(StringUtils.isEmpty((String)rema_l1) ? rema : rema_l1, LocaleUtils.locale_l1);
                planInfo.setRema(StringUtils.isEmpty((String)rema_l2) ? rema : rema_l2, LocaleUtils.locale_l2);
                planInfo.setRema(StringUtils.isEmpty((String)rema_l3) ? rema : rema_l3, LocaleUtils.locale_l3);
                if (!StringUtils.isEmpty((String)appealDays)) {
                    planInfo.setAppealDays(Integer.valueOf(appealDays).intValue());
                } else {
                    planInfo.setAppealDays(0);
                }
                if (!StringUtils.isEmpty((String)confirmDays)) {
                    planInfo.setConfirmDays(Integer.valueOf(confirmDays).intValue());
                } else {
                    planInfo.setConfirmDays(0);
                }
                planInfo.setNeedConfirm(needConfirm);
                planInfo.setAllowAppeal(allowAppeal);
                planInfo.put("targetTransmitWay", (Object)targetTransmitWay);
                planInfo.put("evaResultShowControll", (Object)evaResultShowControll);
                planInfo.put("targetNodeWeight", (Object)targetNodeWeight);
                planInfo.put("targetMakeSure", (Object)targetMakeSure);
                planInfo.put("targetCanEdit", (Object)targetCanEdit);
                planInfo.put("onlyFillerReceiver", (Object)onlyFillerReceiver);
            } else {
                planInfo.put("defaultWorkFlow", (Object)defaultWorkFlow);
                planInfo.put("defaultWFName", (Object)defaultWorkFlowName);
            }
        }
        catch (Exception e1) {
            logger.error("", (Throwable)e1);
            throw new Exception(e1.getMessage());
        }
        String msg = "";
        if (this.checkIsDuplicateNumber(number, planId, isOrg)) {
            result = "500";
            msg = SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.NUMBERREPEATERR, ctx);
        } else {
            String id = null;
            String currentRuleId = this.getCurrentPerfRuleId(planId);
            if (!StringUtils.isEmpty((String)currentRuleId) && this.checkIsOnlyOneRuleIdReferred(currentRuleId) && !currentRuleId.equals(perfmanceRuleId)) {
                PerfPlanUtils.writeRefStateForPerformanceRule(ctx, currentRuleId, YesOrNoEnum.NO);
            }
            try {
                PerfPlanUtils.writeRefStateForPerformanceRule(ctx, perfmanceRuleId);
                id = PerfPlanFactory.getRemoteInstance().save((CoreBaseInfo)planInfo).toString();
                IPerfPeriod localInstance = PerfPeriodFactory.getLocalInstance((Context)ctx);
                PerfPeriodCollection perfPeriodCollection = localInstance.getPerfPeriodCollection(" where perfPlan='" + id + "'");
                if (perfPeriodCollection != null && perfPeriodCollection.size() > 0) {
                    CoreBaseCollection period = new CoreBaseCollection();
                    for (int i = 0; i < perfPeriodCollection.size(); ++i) {
                        PerfPeriodInfo perfPeriodInfo = perfPeriodCollection.get(i);
                        perfPeriodInfo.put("targetTransmitWay", (Object)targetTransmitWay);
                        period.add((CoreBaseInfo)perfPeriodInfo);
                    }
                    if (period.size() > 0) {
                        localInstance.save(period);
                    }
                }
                this.initMatrixWorkFlow(ctx, id, list);
                result = "200";
                map.put("ruleId", id);
                msg = SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.SAVESUCCESS, ctx);
            }
            catch (Exception e) {
                logger.error("Exception: ", (Throwable)e);
                result = "ERROR";
                msg = SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.SAVEFAILED, ctx);
            }
        }
        map.put("result", result);
        map.put("msg", msg);
        return map;
    }

    private void initMatrixWorkFlow(Context ctx, String planId, List<AreaBaseWorkFlowBean> list) throws BOSException, EASBizException {
        IPerfEvaObjectMatrixWorkFlow iMatrixWorkFlow = PerfEvaObjectMatrixWorkFlowFactory.getLocalInstance((Context)ctx);
        CoreBaseCollection coll = new CoreBaseCollection();
        for (int i = 0; i < list.size(); ++i) {
            AreaBaseWorkFlowBean bean = list.get(i);
            PerfEvaObjectMatrixWorkFlowInfo info = new PerfEvaObjectMatrixWorkFlowInfo();
            info.put("perfPlan", (Object)planId);
            info.put("workflow", (Object)bean.getDefaultProcess().getId());
            info.put("areaBase", (Object)bean.getId());
            coll.add((CoreBaseInfo)info);
        }
        if (coll.size() > 0) {
            DbUtil.execute((Context)ctx, (String)"delete from T_EVA_PerfEvaObjectMatrixWork where FPerfPlanId = ? and FPerfRuleId is null", (Object[])new Object[]{planId});
            iMatrixWorkFlow.addnew(coll);
        }
    }

    private boolean checkIsDuplicateNumber(String number, String planId, String isOrg) {
        try {
            IPerfPlan iperfRule = PerfPlanFactory.getRemoteInstance();
            if (planId == null || planId == "") {
                return iperfRule.exists(" where number='" + number + "' and isOrg ='" + isOrg + "'");
            }
            return iperfRule.exists(" where number='" + number + "' and id != '" + planId + "'and isOrg ='" + isOrg + "'");
        }
        catch (Exception e) {
            logger.error("BOSException: ", (Throwable)e);
            return false;
        }
    }

    private String getCurrentPerfRuleId(String planId) {
        try {
            if (StringUtils.isEmpty((String)planId)) {
                return null;
            }
            IPerfPlan iperfRule = PerfPlanFactory.getRemoteInstance();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)planId, CompareType.EQUALS));
            EntityViewInfo evi = new EntityViewInfo();
            evi.setFilter(filter);
            PerfPlanCollection collection = iperfRule.getPerfPlanCollection(evi);
            if (collection != null && collection.size() > 0) {
                return collection.get(0).getPerfRule().getId().toString();
            }
            return null;
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
            return null;
        }
    }

    private boolean checkIsOnlyOneRuleIdReferred(String ruleId) {
        try {
            IPerfPlan iperfRule = PerfPlanFactory.getRemoteInstance();
            if (!StringUtils.isEmpty((String)ruleId)) {
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("perfRule", (Object)ruleId, CompareType.EQUALS));
                EntityViewInfo evi = new EntityViewInfo();
                evi.setFilter(filter);
                return iperfRule.getCount(evi) == 1;
            }
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
        }
        return false;
    }

    @Override
    @Deprecated
    public boolean deletePlan(HttpServletRequest request, HttpServletResponse response) {
        String planId = RequestUtils.getParameter(request, "planId").trim();
        boolean flag = false;
        try {
            String oql = "where perfplan = '" + planId + "'";
            PerfPeriodCollection coll = PerfPeriodFactory.getRemoteInstance().getPerfPeriodCollection(oql);
            if (coll.size() > 0) {
                return false;
            }
            PerfPlanFactory.getRemoteInstance().delete((IObjectPK)new ObjectUuidPK(planId));
            flag = true;
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
        }
        return flag;
    }

    public boolean deletePlan(Context ctx, HttpServletRequest request, HttpServletResponse response) {
        String planId = RequestUtils.getParameter(request, "planId").trim();
        boolean flag = false;
        try {
            String oql = "where perfplan = '" + planId + "'";
            PerfPeriodCollection coll = PerfPeriodFactory.getLocalInstance((Context)ctx).getPerfPeriodCollection(oql);
            if (coll.size() > 0) {
                return false;
            }
            IPerfPlan iPerfPlan = PerfPlanFactory.getLocalInstance((Context)ctx);
            PerfPlanInfo perfPlanInfo = iPerfPlan.getPerfPlanInfo("select perfRule where id = '" + planId + "'");
            iPerfPlan.delete((IObjectPK)new ObjectUuidPK(planId));
            if (!iPerfPlan.exists("where perfRule = '" + perfPlanInfo.getPerfRule().getId().toString() + "'")) {
                IPerformanceRule iPerformanceRule = PerformanceRuleFactory.getLocalInstance((Context)ctx);
                ObjectUuidPK ruleId = new ObjectUuidPK(perfPlanInfo.getPerfRule().getId());
                PerformanceRuleInfo performanceRuleInfo = iPerformanceRule.getPerformanceRuleInfo((IObjectPK)ruleId);
                performanceRuleInfo.setRefState(YesOrNoEnum.NO);
                iPerformanceRule.update((IObjectPK)ruleId, performanceRuleInfo);
            }
            flag = true;
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
        }
        return flag;
    }

    public Map<String, Object> getPerfRuleById(Context ctx, HttpServletRequest request, HttpServletResponse response) throws SHRPerfWebException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList<AreaBaseWorkFlowBean> resultList = new ArrayList<AreaBaseWorkFlowBean>();
        try {
            PerfPlanInfo perfPlanInfo = null;
            String planId = request.getParameter("planId").trim();
            IPerfPlan iperfPlan = PerfPlanFactory.getLocalInstance((Context)ctx);
            IPerfEvaObjectMatrixWorkFlow pWorkFlow = PerfEvaObjectMatrixWorkFlowFactory.getLocalInstance((Context)ctx);
            ObjectUuidPK pk = new ObjectUuidPK(planId);
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("perfPlan", (Object)pk, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("perfRule", null, CompareType.EQUALS));
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("perfPlan.*"));
            sic.add(new SelectorItemInfo("perfPlan.perfRule.id"));
            sic.add(new SelectorItemInfo("perfPlan.perfRule.name"));
            sic.add(new SelectorItemInfo("perfPlan.perfModel.name"));
            sic.add(new SelectorItemInfo("perfPlan.belongOrg.name"));
            sic.add(new SelectorItemInfo("areaBase.id"));
            sic.add(new SelectorItemInfo("areaBase.name"));
            sic.add(new SelectorItemInfo("areaBase.seq"));
            sic.add(new SelectorItemInfo("workflow.name"));
            sic.add(new SelectorItemInfo("workflow.id"));
            sic.add(new SelectorItemInfo("workflow.number"));
            evi.setFilter(filter);
            evi.setSelector(sic);
            SorterItemCollection sorterColl = new SorterItemCollection();
            sorterColl.getSorter().add(new SorterItemInfo("areaBase.seq"));
            evi.setSorter(sorterColl);
            PerfEvaObjectMatrixWorkFlowCollection coll = pWorkFlow.getPerfEvaObjectMatrixWorkFlowCollection(evi);
            perfPlanInfo = coll.size() > 0 ? coll.get(0).getPerfPlan() : iperfPlan.getPerfPlanInfo("select *,belongOrg.name,belongOrg.id,perfrule.name,defaultWorkFlow.*,perfModel.name where id = '" + planId + "'");
            HROrgUnitInfo hROrgUnitInfo = HROrgUnitFactory.getLocalInstance((Context)ctx).getHROrgUnitInfo("where id = '" + perfPlanInfo.getHrUnitOrg().getId().toString() + "'");
            SHRPerfWebResourceUtil.setMultiLanValue(ctx, (CoreBaseInfo)perfPlanInfo, "name");
            SHRPerfWebResourceUtil.setMultiLanValue(ctx, (CoreBaseInfo)perfPlanInfo, "rema");
            map.put("name", perfPlanInfo.getName());
            map.put("number", perfPlanInfo.getNumber());
            map.put("evaluModeName", perfPlanInfo.getPerfModel().getName());
            map.put("evaluMode", perfPlanInfo.getPerfModel().getId().toString());
            map.put("orgId", perfPlanInfo.getBelongOrg().getId().toString());
            map.put("orgIdName", perfPlanInfo.getBelongOrg().getName());
            map.put("hrOrgUnitId", hROrgUnitInfo.getId().toString());
            map.put("hrOrgUnitName", hROrgUnitInfo.getName(ctx.getLocale()));
            map.put("perfRule", perfPlanInfo.getPerfRule().getId().toString());
            map.put("perfRuleName", perfPlanInfo.getPerfRule().getName());
            map.put("periodFrequency", perfPlanInfo.getPeriodFrequency().toString());
            map.put("perfPlanStartSE", perfPlanInfo.getPerfPlanStartSE());
            map.put("defaultWorkFlow", perfPlanInfo.getDefaultWorkFlow() == null ? "" : perfPlanInfo.getDefaultWorkFlow().getId().toString());
            if (perfPlanInfo.getDefaultWorkFlow() != null) {
                map.put("defaultWorkFlowName", perfPlanInfo.getDefaultWorkFlow().getName());
            }
            map.put("canAdjustEvaluer", perfPlanInfo.getCanAdjustEvaluer().getValue());
            map.put("rema", perfPlanInfo.getRema());
            map.put("pStatus", perfPlanInfo.getPStatus().getValue());
            map.put("appealDays", perfPlanInfo.getAppealDays());
            map.put("confirmDays", perfPlanInfo.getConfirmDays());
            map.put("appealDealType", perfPlanInfo.getAppealDealType());
            map.put("allowAppeal", perfPlanInfo.isAllowAppeal());
            map.put("needConfirm", perfPlanInfo.isNeedConfirm());
            map.put("isShowQuantity", perfPlanInfo.getIsShowQuantity().getValue());
            map.put("targetTransmitWay", perfPlanInfo.get("targetTransmitWay"));
            map.put("targetNodeWeight", perfPlanInfo.get("targetNodeWeight"));
            map.put("targetMakeSure", perfPlanInfo.get("targetMakeSure"));
            map.put("targetCanEdit", perfPlanInfo.get("targetCanEdit"));
            map.put("onlyFillerReceiver", perfPlanInfo.get("onlyFillerReceiver"));
            map.put("weightForce100", perfPlanInfo.get("weightForce100"));
            map.put("evaResultShowControll", perfPlanInfo.get("evaResultShowControll"));
            for (int i = 0; i < coll.size(); ++i) {
                PerfEvaObjectMatrixWorkFlowInfo info = coll.get(i);
                AreaBaseWorkFlowBean bean = new AreaBaseWorkFlowBean();
                bean.setId(info.getAreaBase().getId().toString());
                bean.setArea(info.getAreaBase().getName());
                WorkFlowBean workBean = new WorkFlowBean();
                workBean.setId(info.getWorkflow().getId().toString());
                workBean.setName(info.getWorkflow().getName());
                workBean.setNumber(info.getWorkflow().getNumber());
                bean.setDefaultProcess(workBean);
                HashSet<String> workFlowIds = new HashSet<String>();
                workFlowIds.add(info.getWorkflow().getId().toString());
                Map<String, List<WFNodeDefInfo>> workFlowMsgMap = PerformancePlanImpl.getWorkFlowInFO(workFlowIds);
                List<WFNodeDefInfo> wfNodeDefInfos = workFlowMsgMap.get(info.getWorkflow().getId().toString());
                String workFlowDesc = null;
                if (!CollectionUtils.isEmpty(wfNodeDefInfos)) {
                    int preLevel = 0;
                    int curLevel = 1;
                    StringBuffer workFlowMsg = new StringBuffer("");
                    for (WFNodeDefInfo nodeDefInfo : wfNodeDefInfos) {
                        curLevel = nodeDefInfo.getLevel();
                        if (preLevel == curLevel) {
                            workFlowMsg.append("&").append(nodeDefInfo.getNodeName()).append("(").append(nodeDefInfo.getNodeWeight()).append("%)");
                        } else {
                            workFlowMsg.append("->").append(nodeDefInfo.getNodeName()).append("(").append(nodeDefInfo.getNodeWeight()).append("%)");
                        }
                        preLevel = curLevel;
                    }
                    workFlowDesc = workFlowMsg.toString().replaceFirst("->", "");
                }
                bean.setProcessInfo(workFlowDesc);
                resultList.add(bean);
            }
            map.put("areaBaseWorkFlow", resultList);
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
            throw new SHRPerfWebException(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.DATADEALERR, ctx));
        }
        return map;
    }

    public static Map<String, List<WFNodeDefInfo>> getWorkFlowInFO(Set<String> workFlowIds) throws Exception {
        HashMap<String, List<WFNodeDefInfo>> workFlowMsgMap = new HashMap<String, List<WFNodeDefInfo>>();
        if (!CollectionUtils.isEmpty(workFlowIds)) {
            WFNodeDefCollection wfNodeDefCollection;
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("workflow", workFlowIds, CompareType.INCLUDE));
            EntityViewInfo evi = new EntityViewInfo();
            evi.setFilter(filterInfo);
            SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
            selectorItemCollection.add(new SelectorItemInfo("id"));
            selectorItemCollection.add(new SelectorItemInfo("workflow"));
            selectorItemCollection.add(new SelectorItemInfo("level"));
            selectorItemCollection.add(new SelectorItemInfo("nodeSeq"));
            selectorItemCollection.add(new SelectorItemInfo("nodeName"));
            selectorItemCollection.add(new SelectorItemInfo("nodeWeight"));
            evi.setSelector(selectorItemCollection);
            try {
                SorterItemCollection sorterItemCollection = new SorterItemCollection();
                evi.setSorter(sorterItemCollection);
                sorterItemCollection.getSorter().decode("order by level asc,nodeSeq asc");
                wfNodeDefCollection = WFNodeDefFactory.getRemoteInstance().getWFNodeDefCollection(evi);
            }
            catch (Exception e) {
                logger.error("Exception: ", (Throwable)e);
                throw new SHRPerfWebBizException(SHRPerfWebBizException.GETWORKFLOWINFOERR);
            }
            if (wfNodeDefCollection != null && wfNodeDefCollection.size() > 0) {
                int size = wfNodeDefCollection.size();
                for (int i = 0; i < size; ++i) {
                    WFNodeDefInfo nodeDefInfo = wfNodeDefCollection.get(i);
                    String workFlowId = nodeDefInfo.getWorkflow().getId().toString();
                    ArrayList<WFNodeDefInfo> wfNodeDefInfos = (ArrayList<WFNodeDefInfo>)workFlowMsgMap.get(workFlowId);
                    if (CollectionUtils.isEmpty((Collection)wfNodeDefInfos)) {
                        wfNodeDefInfos = new ArrayList<WFNodeDefInfo>();
                    }
                    wfNodeDefInfos.add(nodeDefInfo);
                    workFlowMsgMap.put(workFlowId, wfNodeDefInfos);
                }
            }
        }
        return workFlowMsgMap;
    }
}

