/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.base.serviceImpl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.shr.perfweb.app.base.talentReview.ITalentReviewSolution;
import com.kingdee.shr.perfweb.app.base.talentReview.TalentReviewSolutionFactory;
import com.kingdee.shr.perfweb.app.base.talentReview.TalentReviewSolutionInfo;
import com.kingdee.shr.perfweb.app.exception.SHRPerfWebBizException;
import com.kingdee.shr.perfweb.app.resource.SHRPerfWebResource;
import com.kingdee.shr.perfweb.exception.SHRPerfWebException;
import com.kingdee.shr.perfweb.util.SHRPerfWebResourceUtil;
import com.kingdee.shr.perfweb.utils.RequestUtils;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TalentReviewSolutionService {
    private static Logger logger = LoggerFactory.getLogger(TalentReviewSolutionService.class);

    public Map<String, String> savePlan(Context ctx, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        String result = "ERROR";
        String planId = RequestUtils.getParameter(request, "planId");
        String number = RequestUtils.getParameter(request, "number");
        String name = RequestUtils.getParameter(request, "name");
        String orgId = RequestUtils.getParameter(request, "orgId");
        String hrOrg = RequestUtils.getParameter(request, "hrOrg");
        TalentReviewSolutionInfo planInfo = new TalentReviewSolutionInfo();
        String rema = RequestUtils.getParameter(request, "rema");
        try {
            boolean isAddOrNewStatus = true;
            String l1Flag = SHRPerfWebResourceUtil.getMlFlag(LocaleUtils.locale_L1);
            String l2Flag = SHRPerfWebResourceUtil.getMlFlag(LocaleUtils.locale_L2);
            String l3Flag = SHRPerfWebResourceUtil.getMlFlag(LocaleUtils.locale_L3);
            if (!StringUtils.isEmpty((String)planId)) {
                ITalentReviewSolution iperfPlan = TalentReviewSolutionFactory.getLocalInstance((Context)ctx);
                TalentReviewSolutionInfo originPerfPlanInfo = iperfPlan.getTalentReviewSolutionInfo((IObjectPK)new ObjectUuidPK(planId));
                if (null == originPerfPlanInfo) {
                    throw new EASBizException(SHRPerfWebBizException.PERFPLANNOTEXIST);
                }
                planInfo.put("id", (Object)planId);
                if (originPerfPlanInfo.getState().getValue() != 0) {
                    planInfo.put("number", (Object)number);
                    planInfo.setName(name);
                    planInfo.setName(StringUtils.isEmpty((String)RequestUtils.getParameter(request, "name" + l1Flag)) ? name : RequestUtils.getParameter(request, "name" + l1Flag), LocaleUtils.locale_l1);
                    planInfo.setName(StringUtils.isEmpty((String)RequestUtils.getParameter(request, "name" + l2Flag)) ? name : RequestUtils.getParameter(request, "name" + l2Flag), LocaleUtils.locale_l2);
                    planInfo.setName(StringUtils.isEmpty((String)RequestUtils.getParameter(request, "name" + l3Flag)) ? name : RequestUtils.getParameter(request, "name" + l3Flag), LocaleUtils.locale_l3);
                }
            }
            if (isAddOrNewStatus) {
                planInfo.put("number", (Object)number);
                planInfo.setName(name);
                planInfo.put("adminOrgUnit", (Object)orgId);
                planInfo.put("hrOrgUnit", (Object)hrOrg);
                planInfo.setRemark(rema);
                planInfo.setName(StringUtils.isEmpty((String)RequestUtils.getParameter(request, "name" + l1Flag)) ? name : RequestUtils.getParameter(request, "name" + l1Flag), LocaleUtils.locale_l1);
                planInfo.setName(StringUtils.isEmpty((String)RequestUtils.getParameter(request, "name" + l2Flag)) ? name : RequestUtils.getParameter(request, "name" + l2Flag), LocaleUtils.locale_l2);
                planInfo.setName(StringUtils.isEmpty((String)RequestUtils.getParameter(request, "name" + l3Flag)) ? name : RequestUtils.getParameter(request, "name" + l3Flag), LocaleUtils.locale_l3);
                planInfo.setRemark(StringUtils.isEmpty((String)RequestUtils.getParameter(request, "rema" + l1Flag)) ? rema : RequestUtils.getParameter(request, "rema" + l1Flag), LocaleUtils.locale_l1);
                planInfo.setRemark(StringUtils.isEmpty((String)RequestUtils.getParameter(request, "rema" + l2Flag)) ? rema : RequestUtils.getParameter(request, "rema" + l2Flag), LocaleUtils.locale_l2);
                planInfo.setRemark(StringUtils.isEmpty((String)RequestUtils.getParameter(request, "rema" + l3Flag)) ? rema : RequestUtils.getParameter(request, "rema" + l3Flag), LocaleUtils.locale_l3);
            }
        }
        catch (Exception e1) {
            logger.error("", (Throwable)e1);
            throw new Exception(e1.getMessage());
        }
        String msg = "";
        if (this.checkIsDuplicateNumber(number, planId)) {
            result = "500";
            msg = SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.PERFRULENUMBERREPEATED, ctx);
        } else {
            String id = null;
            try {
                id = TalentReviewSolutionFactory.getRemoteInstance().save((CoreBaseInfo)planInfo).toString();
                result = "200";
                map.put("ruleId", id);
                msg = SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.SAVESUCCESS, ctx);
            }
            catch (Exception e) {
                logger.error("Exception: ", (Throwable)e);
                result = "ERROR";
                msg = SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.SAVEFAILED, ctx);
            }
        }
        map.put("result", result);
        map.put("msg", msg);
        return map;
    }

    private boolean checkIsDuplicateNumber(String number, String planId) {
        try {
            ITalentReviewSolution iperfRule = TalentReviewSolutionFactory.getRemoteInstance();
            if (planId == null || planId == "") {
                return iperfRule.exists(" where number='" + number + "'");
            }
            return iperfRule.exists(" where number='" + number + "' and id != '" + planId + "'");
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
            return false;
        }
    }

    public boolean deletePlan(HttpServletRequest request, HttpServletResponse response) {
        String planId = RequestUtils.getParameter(request, "planId").trim();
        boolean flag = false;
        try {
            TalentReviewSolutionFactory.getRemoteInstance().delete((IObjectPK)new ObjectUuidPK(planId));
            flag = true;
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
        }
        return flag;
    }

    public Map<String, Object> getPerfRuleById(Context ctx, HttpServletRequest request, HttpServletResponse response) throws SHRPerfWebException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            TalentReviewSolutionInfo perfPlanInfo = null;
            String planId = request.getParameter("planId").trim();
            ITalentReviewSolution iperfPlan = TalentReviewSolutionFactory.getLocalInstance((Context)ctx);
            perfPlanInfo = iperfPlan.getTalentReviewSolutionInfo("select *, adminOrgUnit.name, HrOrgUnit.id,HrOrgUnit.name where id = '" + planId + "'");
            SHRPerfWebResourceUtil.setMultiLanValue(ctx, (CoreBaseInfo)perfPlanInfo, "name");
            SHRPerfWebResourceUtil.setMultiLanValue(ctx, (CoreBaseInfo)perfPlanInfo, "remark");
            map.put("name", perfPlanInfo.getName());
            map.put("number", perfPlanInfo.getNumber());
            map.put("orgId", perfPlanInfo.getAdminOrgUnit().getId().toString());
            map.put("orgIdName", perfPlanInfo.getAdminOrgUnit().getName(ctx.getLocale()).toString());
            map.put("hrOrgUnitId", perfPlanInfo.getHrOrgUnit().getId().toString());
            map.put("hrOrgUnitName", perfPlanInfo.getHrOrgUnit().getName(ctx.getLocale()).toString());
            map.put("rema", perfPlanInfo.getRemark());
            map.put("state", perfPlanInfo.getState().getValue());
        }
        catch (BOSException e) {
            logger.error("BOSException: ", (Throwable)e);
            throw new SHRPerfWebException(new SHRPerfWebBizException(SHRPerfWebBizException.SYSTEMERROCCURED).getMessage());
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
            throw new SHRPerfWebException(new SHRPerfWebBizException(SHRPerfWebBizException.SYSTEMERROCCURED).getMessage());
        }
        return map;
    }
}

