/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.bean;

import com.google.common.collect.Sets;
import com.kingdee.bos.util.MD5Util;
import com.kingdee.shr.base.syssetting.util.SHRCheck;
import com.kingdee.shr.perfweb.bean.FileCheckStatement;
import com.kingdee.shr.perfweb.util.FileSecUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.archivers.zip.UnsupportedZipFeatureException;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompressedFileBoomStatement
extends FileCheckStatement {
    private static Logger logger = LoggerFactory.getLogger(CompressedFileBoomStatement.class);
    private static final int MAX_COUNT = 1000;
    private static final long MAX_SIZE = 524288000L;
    private static final int PATH_LENGTH = 512;
    private static final String TMP_DIR = System.getProperty("EAS_HOME") + File.separator + "server" + File.separator + "deploy" + File.separator + "easweb.ear" + File.separator + "shr_web.war" + File.separator + "tmp" + File.separator + "compressedFile" + File.separator;
    String fileDir = "tmp" + File.separator + "compressedFile" + File.separator;

    public CompressedFileBoomStatement() {
        this.checks = Sets.newHashSet((Object[])new String[]{"zip"});
    }

    @Override
    public String ifFail(String part) throws IOException {
        throw new IllegalArgumentException("PERFWEB_F_0025");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkFile(File file) throws IOException {
        block15: {
            FileInputStream fileInputStream = null;
            BufferedInputStream bufferedInputStream = null;
            ZipArchiveInputStream inputStream = null;
            OutputStream os = null;
            String TMP_PATH = TMP_DIR;
            TMP_PATH = TMP_PATH + System.currentTimeMillis() + MD5Util.getFileMD5String((File)file) + File.separator;
            File tmpDir = new File(SHRCheck.checkFilePath((String)TMP_PATH));
            try {
                if (!tmpDir.exists()) {
                    tmpDir.mkdirs();
                }
                String fileName = file.getName().trim();
                String suffix = "";
                if (StringUtils.isNotBlank((CharSequence)fileName) && fileName.contains(".")) {
                    suffix = FileSecUtil.getSuffixByName(fileName);
                }
                if ("zip".equals(suffix)) {
                    fileInputStream = new FileInputStream(file);
                    bufferedInputStream = new BufferedInputStream(fileInputStream);
                    inputStream = new ZipArchiveInputStream((InputStream)bufferedInputStream);
                    int count = 0;
                    long size = 0L;
                    ZipArchiveEntry entry = null;
                    while ((entry = inputStream.getNextZipEntry()) != null) {
                        if (++count > 1000) {
                            this.ifFail(null);
                        }
                        if ((size += entry.getSize()) <= 524288000L) continue;
                        this.ifFail(null);
                    }
                } else if ("rar".equals(suffix)) {
                    this.ifFail(null);
                } else {
                    this.ifFail(null);
                }
                IOUtils.closeQuietly(os);
            }
            catch (UnsupportedZipFeatureException e) {
                logger.error("", (Throwable)e);
                break block15;
            }
            finally {
                IOUtils.closeQuietly(os);
                IOUtils.closeQuietly(inputStream);
                IOUtils.closeQuietly(bufferedInputStream);
                IOUtils.closeQuietly(fileInputStream);
                if (tmpDir.exists()) {
                    CompressedFileBoomStatement.deleteDir(tmpDir);
                }
            }
            IOUtils.closeQuietly(inputStream);
            IOUtils.closeQuietly((InputStream)bufferedInputStream);
            IOUtils.closeQuietly((InputStream)fileInputStream);
            if (tmpDir.exists()) {
                CompressedFileBoomStatement.deleteDir(tmpDir);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkFile(String fileName, byte[] content) throws IOException {
        String TMP_PATH = TMP_DIR;
        TMP_PATH = TMP_PATH + System.currentTimeMillis() + MD5Util.getMD5String((String)fileName) + File.separator;
        File tmpDir = new File(SHRCheck.checkFilePath((String)TMP_PATH));
        FileOutputStream fos = null;
        try {
            if (!tmpDir.exists()) {
                tmpDir.mkdirs();
            }
            if (content != null) {
                File tmpFile = new File(tmpDir, SHRCheck.checkFilePath((String)fileName));
                if (tmpFile.exists()) {
                    tmpFile.delete();
                }
                fos = new FileOutputStream(tmpFile);
                fos.write(content, 0, content.length);
                fos.flush();
                this.checkFile(tmpFile);
            }
        }
        catch (UnsupportedZipFeatureException e) {
            logger.error("", (Throwable)e);
        }
        finally {
            if (fos != null) {
                fos.close();
            }
            if (tmpDir.exists()) {
                CompressedFileBoomStatement.deleteDir(tmpDir);
            }
        }
        return false;
    }

    public static void deleteDir(File file) {
        if (file.getAbsolutePath().contains("compressedFile")) {
            if (file.isDirectory()) {
                File[] files = file.listFiles();
                for (int i = 0; i < files.length; ++i) {
                    CompressedFileBoomStatement.deleteDir(files[i]);
                }
            }
            file.delete();
        }
    }
}

