/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.comprehensive.baseformula;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.SqlParam;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.baseconfig.StructureConfigInfo;
import com.kingdee.shr.perfweb.app.base.formulaplatform.CalcuItemCollection;
import com.kingdee.shr.perfweb.app.base.formulaplatform.CalcuItemInfo;
import com.kingdee.shr.perfweb.comprehensive.baseformula.SumCalSHRSqlBuilder;
import com.kingdee.shr.perfweb.util.SumCalUtil;
import com.kingdee.shr.validaterule.BaseFormulaCollection;
import com.kingdee.shr.validaterule.BaseFormulaInfo;
import com.kingdee.shr.validaterule.CmpItemDataDot;
import com.kingdee.shr.validaterule.exception.SalaryException;
import com.kingdee.shr.validaterule.formula.SalaryCalFunMgr2;
import com.kingdee.shr.validaterule.formula.SalaryCalFunction2;
import com.kingdee.shr.validaterule.formula.base.data.DataAccess;
import com.kingdee.shr.validaterule.formula.base.data.DataSet;
import com.kingdee.shr.validaterule.formula.base.data.DataTable;
import com.kingdee.shr.validaterule.formula.base.impl.CalculatorBusinessDataCommon;
import com.kingdee.shr.validaterule.formula.base.vo.InitCalData;
import com.kingdee.shr.validaterule.util.FunUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class SumAssessmentBusinessData
extends CalculatorBusinessDataCommon {
    private static Logger logger = Logger.getLogger(SumAssessmentBusinessData.class);

    public Map<String, String> combineTableItems(Context ctx, BaseFormulaCollection formulaInfos) throws SalaryException {
        HashMap<String, String> assTable = new HashMap<String, String>();
        String[] item = null;
        String[] items = null;
        String clm = null;
        String listItems = null;
        int size = formulaInfos.size();
        for (int i = 0; i < size; ++i) {
            BaseFormulaInfo formulaInfo = formulaInfos.get(i);
            listItems = formulaInfo.getListItem();
            if (listItems == null || "".equals(listItems)) continue;
            items = listItems.split(";");
            for (int loop = 0; loop < items.length; ++loop) {
                item = items[loop].split("~");
                if (item[1].startsWith("TEMP")) continue;
                String columns = "";
                String tableKey = "";
                if (item.length > 3) {
                    tableKey = item[1] + "~" + item[3];
                    if (assTable.containsKey(tableKey)) {
                        columns = (String)assTable.get(tableKey) + ",";
                        if (columns.indexOf(clm = item[1] + "." + item[2] + ",") != -1) continue;
                        columns = columns.substring(0, columns.length() - 1) + ", " + clm.substring(0, clm.length() - 1);
                        assTable.put(tableKey, columns);
                        continue;
                    }
                    columns = item[1] + "." + item[2];
                    assTable.put(tableKey, columns);
                    continue;
                }
                if (assTable.containsKey(item[1])) {
                    columns = (String)assTable.get(item[1]) + ",";
                    if (columns.indexOf(clm = item[1] + "." + item[2] + ",") != -1) continue;
                    columns = columns.substring(0, columns.length() - 1) + ", " + clm.substring(0, clm.length() - 1);
                    assTable.put(item[1], columns);
                    continue;
                }
                columns = item[1] + "." + item[2];
                assTable.put(item[1], columns);
            }
        }
        if (assTable.keySet().isEmpty()) {
            throw new SalaryException(SalaryException.NOCAL);
        }
        return assTable;
    }

    public SalaryCalFunction2 initCalInstance(InitCalData initCalData) throws SalaryException {
        SalaryCalFunction2 calObj = null;
        try {
            calObj = SalaryCalFunMgr2.getInstance((InitCalData)initCalData);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        if (calObj == null) {
            throw new SalaryException(SalaryException.FORMULAERROR);
        }
        return calObj;
    }

    public DataSet initCalData(InitCalData initCalData) throws EASBizException {
        DataSet dataSet = new DataSet();
        Map assTable = initCalData.getAssTable();
        Iterator iter = assTable.keySet().iterator();
        DataAccess DAC = new DataAccess();
        Object sq = null;
        DataTable dt = null;
        try {
            String tempSql = this.buildDataSetSql(initCalData);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("---initCalData: SQL " + tempSql));
            }
            DataTable baseDt = DAC.getDataForDataTable(initCalData.getCtx(), tempSql);
            while (iter.hasNext()) {
                String tableName = (String)iter.next();
                dt = new DataTable();
                dt.tablename = tableName.toUpperCase(Locale.ENGLISH);
                dt.columns = baseDt.columns;
                dt.datas = baseDt.datas;
                dt.datasIndexMap = baseDt.datasIndexMap;
                dt.emptyrow = baseDt.emptyrow;
                dataSet.addTable(dt);
            }
        }
        catch (Exception e) {
            throw new SalaryException(SalaryException.QUERYFAIL, (Throwable)e, new Object[]{sq});
        }
        if (dataSet.tableCount() == 0) {
            throw new SalaryException(SalaryException.NOCALDATA);
        }
        return dataSet;
    }

    protected String buildDataSetSql(InitCalData initCalData) throws Exception {
        FilterInfo filter = new FilterInfo("evaResult.id in (" + initCalData.getCondition() + ")");
        SqlParam sqlParam = new SqlParam();
        Map<String, String> selectMapping = this.buildSelector(initCalData);
        sqlParam.setSelectMapping(selectMapping);
        sqlParam.setFilterInfo(filter);
        sqlParam.setScheme(initCalData.getConfigNum());
        sqlParam.setFilterDate(initCalData.getEndDate());
        sqlParam.setHistoryMode(true);
        sqlParam.setIgnoreNowDateFilter(true);
        String sql = SumCalSHRSqlBuilder.getInstance().getSql(initCalData.getCtx(), sqlParam);
        return sql;
    }

    protected Map<String, String> buildSelector(InitCalData initCalData) throws BOSException {
        HashMap<String, String> selectMapping = new HashMap<String, String>();
        String mainTableAlias = initCalData.getMainTableAlias();
        selectMapping.put(mainTableAlias + ".id", "fid");
        selectMapping.put("evaObj.id", "evaObjId");
        selectMapping.put(mainTableAlias + ".caluid", initCalData.getUid() + ".caluid");
        selectMapping.put(mainTableAlias + ".simulate", (initCalData.isSimulation() ? "1" : "0") + ".simulate");
        Map outerData = (Map)initCalData.getOuterData();
        if (outerData != null) {
            selectMapping.put(mainTableAlias + ".parimutualmax", (String)outerData.get("parimutualmax"));
            selectMapping.put(mainTableAlias + ".parimutualmin", (String)outerData.get("parimutualmin"));
        }
        Map assTable = initCalData.getAssTable();
        Set entrySet = assTable.entrySet();
        Iterator it = entrySet.iterator();
        String tableName = "";
        String field = "";
        String strucNum = "";
        String entityName = "";
        String tableField = "";
        String columns = "";
        String column = "";
        String[] tableArr = null;
        String[] columnArr = null;
        StructureConfigInfo structureInfo = null;
        Context ctx = initCalData.getCtx();
        Map<String, StructureConfigInfo> structMap = SumCalUtil.getStructureMap(ctx, initCalData.getConfigNum());
        Map properties = null;
        Map.Entry next = null;
        String mainTableName = initCalData.getMainTableName();
        while (it.hasNext()) {
            next = it.next();
            tableArr = ((String)next.getKey()).split("~");
            tableName = tableArr[0];
            if (mainTableName.equals(tableName)) {
                columns = (String)assTable.get(tableName);
                columnArr = columns.split(",");
                for (int i = 0; i < columnArr.length; ++i) {
                    String columnStr = columnArr[i].split("\\.")[1];
                    String fieldName = columnStr.startsWith("F") ? columnStr.replaceFirst("F", "") : columnStr;
                    selectMapping.put(mainTableAlias + "." + fieldName, mainTableAlias + "." + columnStr);
                }
                continue;
            }
            if ("SUMCALITEM_TABLE".equalsIgnoreCase(tableName)) {
                columns = (String)assTable.get(tableName);
                columnArr = columns.split(",");
                for (int i = 0; i < columnArr.length; ++i) {
                    String columnStr = columnArr[i].split("\\.")[1];
                    selectMapping.put(mainTableAlias + "." + columnStr, mainTableAlias + "." + columnStr);
                }
                continue;
            }
            strucNum = tableArr.length > 1 ? tableArr[1] : mainTableAlias;
            structureInfo = structMap.get(strucNum);
            if (structureInfo == null) continue;
            entityName = structureInfo.getEntityName();
            properties = FunUtils.getProperties((Context)ctx, (String)entityName);
            field = (String)next.getValue();
            String[] singleField = field.split(",");
            for (int i = 0; i < singleField.length; ++i) {
                field = singleField[i];
                tableField = field.split("\\.")[1];
                field = ((PropertyInfo)properties.get(tableField)).getName();
                if (selectMapping.containsKey(strucNum + "." + field)) continue;
                selectMapping.put(strucNum + "." + field, strucNum + "." + tableField);
            }
        }
        return selectMapping;
    }

    public Map<String, Object> getAllCnSnMap(Context ctx, String schemeID) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT ");
        sql.append(" ITEM.FID ITEMID,ITEM.FNAME_L2 ITEMNAME,ITEM.FNUMBER ITEMNUMBER, ");
        sql.append(" ITEM.FIELDSN,ITEM.FDATADOT,ITEM.FDATATYPE,ITEM.FDATALENGTH,ITEM.FIELDNAME FIELDNAME");
        sql.append(" FROM ");
        sql.append(" T_EVA_CalcuItem ITEM where ITEM.FCALITEMCATORY in('5','6')");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        ArrayList<String> sn = new ArrayList<String>();
        ArrayList<String> cn = new ArrayList<String>();
        HashMap<String, CmpItemDataDot> dataDotMap = new HashMap<String, CmpItemDataDot>();
        HashMap<String, Integer> dataTypeMap = new HashMap<String, Integer>();
        HashMap<String, String> idItemMap = new HashMap<String, String>();
        HashMap<String, Integer> strItemLenMap = new HashMap<String, Integer>();
        try {
            while (rs.next()) {
                CmpItemDataDot dataDot = CmpItemDataDot.getEnum((int)rs.getInt("FDATADOT"));
                Integer dataType = rs.getInt("FDATATYPE");
                String name = rs.getString("ITEMNAME");
                String fieldName = rs.getString("FIELDNAME").toLowerCase(Locale.ENGLISH);
                sn.add(fieldName);
                cn.add(name);
                dataDotMap.put(fieldName, dataDot);
                dataTypeMap.put(fieldName, dataType);
                if (dataType == 1) {
                    strItemLenMap.put(fieldName, rs.getInt("FDATALENGTH"));
                }
                idItemMap.put(fieldName.toUpperCase(Locale.ENGLISH), rs.getString("ITEMID"));
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        CalcuItemCollection sumCalItem = SumCalUtil.getSumCalItem(ctx, schemeID);
        if (sumCalItem != null && sumCalItem.size() > 0) {
            for (int i = 0; i < sumCalItem.size(); ++i) {
                CalcuItemInfo calcuItemInfo = sumCalItem.get(i);
                dataTypeMap.put(calcuItemInfo.getFieldName().toLowerCase(Locale.ENGLISH), Integer.valueOf(calcuItemInfo.getDataType().getValue()));
            }
        }
        HashMap<String, Object> res = new HashMap<String, Object>();
        sn.add("forwarncontent");
        cn.add(EASResource.getString((String)"com.kingdee.shr.validaterule.resource.BaseStrResource", (String)"warnContent", (Locale)ctx.getLocale()));
        dataTypeMap.put("forwarncontent", 1);
        res.put("sn", sn);
        res.put("cn", cn);
        res.put("dataDotMap", dataDotMap);
        res.put("dataTypeMap", dataTypeMap);
        res.put("fieldSnAndId", idItemMap);
        res.put("strLengthMap", strItemLenMap);
        return res;
    }
}

