/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.comprehensive.baseformula;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.ormapping.impl.HistoryGeneratorParam;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.data.SQLType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.HistoryConstant;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.ShrSqlEnum;
import com.kingdee.eas.hr.base.app.filter.SqlGenerateUtils;
import com.kingdee.eas.hr.base.app.filter.StructureConfigConvertHelper;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.shr.baseconfig.BaseConfigException;
import com.kingdee.shr.baseconfig.LinkType;
import com.kingdee.shr.baseconfig.StructureConfigCollection;
import com.kingdee.shr.baseconfig.StructureConfigInfo;
import com.kingdee.shr.baseconfig.service.api.impl.CommonSHRSqlBuilder;
import com.kingdee.util.StringUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class SumCalSHRSqlBuilder
extends CommonSHRSqlBuilder {
    private static final Logger logger = LoggerFactory.getLogger(SumCalSHRSqlBuilder.class);
    protected String cmpSchemeNumber = "002";
    protected String perSumCalSchemeNumber = "PERFWEB010";
    protected Map<String, String> cmpSelectingMap = new HashMap<String, String>();

    public static SumCalSHRSqlBuilder getInstance() {
        return new SumCalSHRSqlBuilder();
    }

    protected String generateOneColumn(String column, String alias) throws EASBizException, BOSException {
        String scheme = this.param.getScheme();
        String[] keys = column.split("\\.");
        boolean isBigDataType = false;
        StringBuffer selectColumnString = new StringBuffer();
        if (keys[1].indexOf("SUMCALITEM") > -1) {
            return " NULL AS \"" + alias + "\"";
        }
        if (keys[1].indexOf("caluid") > -1) {
            String[] split = alias.split("\\.");
            return "'" + split[0] + "'  AS \"" + split[1] + "\"";
        }
        if (keys[1].indexOf("simulate") > -1) {
            String[] split = alias.split("\\.");
            return "'" + split[0] + "'  AS \"" + split[1] + "\"";
        }
        if (keys[1].indexOf("parimutual") > -1) {
            return "'" + alias + "'  AS \"" + keys[1] + "\"";
        }
        StructureConfigInfo configInfo = StructureConfigConvertHelper.getStructureConfigByNumber((Context)this.ctx, (String)keys[0], (String)scheme);
        if (configInfo == null && (this.perSumCalSchemeNumber.equalsIgnoreCase(scheme) || this.cmpSchemeNumber.equalsIgnoreCase(scheme))) {
            configInfo = StructureConfigConvertHelper.getStructureConfigByNumber((Context)this.ctx, (String)keys[0], (String)this.cmpSchemeNumber);
        }
        if (configInfo == null) {
            return "";
        }
        if (StringUtils.isEmpty((String)keys[1]) && StringUtils.isEmpty((String)configInfo.getEntityName())) {
            throw new BaseConfigException(BaseConfigException.TABLENAMEANDCOLUMNNAMENULL);
        }
        PropertyInfo prop = this.getPropertyInfo(configInfo, keys[1]);
        if (this.param.isNeedDistinct()) {
            isBigDataType = this.isBigDataType(configInfo, column);
        }
        ArrayList<String> allLocales = new ArrayList<String>();
        allLocales.add(LocaleUtils.locale_l1.getDisplayName());
        allLocales.add(LocaleUtils.locale_l2.getDisplayName());
        allLocales.add(LocaleUtils.locale_l3.getDisplayName());
        if (this.param.isHistoryMode() && column.toUpperCase().contains("LONGNUMBER") && "com.kingdee.eas.basedata.org.app.AdminOrgUnit".equalsIgnoreCase(configInfo.getEntityName())) {
            this.appendQueAdminHis(selectColumnString, configInfo, "T", "FLongNumber", alias);
        } else if (this.param.isHistoryMode() && column.toUpperCase().contains("DISPLAYNAME") && "com.kingdee.eas.basedata.org.app.AdminOrgUnit".equalsIgnoreCase(configInfo.getEntityName())) {
            if (ShrSqlEnum.REPORT.equals((Object)this.param.getShrSqlEnum())) {
                this.appendQueAdminHis(selectColumnString, configInfo, "T", MessageFormat.format("FDisplayName_{0} ", "@customLocaleLan"), alias);
            } else if (!StringUtils.isEmpty((String)this.param.getMultiLanLocale()) && !this.ctx.getLocale().getDisplayName().equalsIgnoreCase(this.param.getMultiLanLocale())) {
                if ("all".equalsIgnoreCase(this.param.getMultiLanLocale())) {
                    this.appendQueAdminHis(selectColumnString, configInfo, "T", MessageFormat.format("FDisplayName_{0} ", this.ctx.getLocale().getDisplayName()), alias);
                    for (String locale : allLocales) {
                        selectColumnString.append(",").append("\n");
                        this.appendQueAdminHis(selectColumnString, configInfo, "T", MessageFormat.format("FDisplayName_{0} ", locale), MessageFormat.format("{0}_{1}", alias, locale));
                    }
                } else {
                    this.appendQueAdminHis(selectColumnString, configInfo, "T", MessageFormat.format("FDisplayName_{0} ", this.param.getMultiLanLocale()), alias);
                }
            } else {
                this.appendQueAdminHis(selectColumnString, configInfo, "T", MessageFormat.format("FDisplayName_{0} ", this.ctx.getLocale().getDisplayName()), alias);
            }
        } else if (prop instanceof OwnPropertyInfo && ((OwnPropertyInfo)prop).isMultilingual()) {
            if (!StringUtils.isEmpty((String)this.param.getMultiLanLocale()) && !this.ctx.getLocale().getDisplayName().equalsIgnoreCase(this.param.getMultiLanLocale())) {
                if ("all".equalsIgnoreCase(this.param.getMultiLanLocale())) {
                    this.appendColumnString(selectColumnString, isBigDataType, configInfo, keys, alias);
                    for (String locale : allLocales) {
                        selectColumnString.append(",").append("\n");
                        this.appendColumnStringForMultiLan(selectColumnString, isBigDataType, configInfo, MessageFormat.format("{0}_{1}", prop.getMappingField().getName(), locale), MessageFormat.format("{0}_{1}", alias, locale));
                    }
                } else {
                    this.appendColumnStringForMultiLan(selectColumnString, isBigDataType, configInfo, MessageFormat.format("{0}_{1}", prop.getMappingField().getName(), this.param.getMultiLanLocale()), alias);
                }
            } else {
                this.appendColumnString(selectColumnString, isBigDataType, configInfo, keys, alias);
            }
        } else {
            this.appendColumnString(selectColumnString, isBigDataType, configInfo, keys, alias);
        }
        return selectColumnString.toString();
    }

    protected String generateOneColumn2(String column, String alias) throws EASBizException, BOSException {
        String scheme = this.param.getScheme();
        String[] keys = column.split("\\.");
        StringBuffer selectColumnString = new StringBuffer();
        String customStr = this.generateCustomColumnStr(column, alias);
        StructureConfigInfo configInfo = StructureConfigConvertHelper.getStructureConfigByNumber((Context)this.ctx, (String)keys[0], (String)scheme);
        if (configInfo == null && (this.perSumCalSchemeNumber.equalsIgnoreCase(scheme) || this.cmpSchemeNumber.equalsIgnoreCase(scheme))) {
            configInfo = StructureConfigConvertHelper.getStructureConfigByNumber((Context)this.ctx, (String)keys[0], (String)this.cmpSchemeNumber);
        }
        if (configInfo == null) {
            if (customStr != null && !"".equals(customStr)) {
                alias = SqlGenerateUtils.getLabCostColumnAlias((Context)this.ctx, (String)column, (String)alias);
                selectColumnString.append(" ").append(customStr).append(" AS ").append(this.appendQuo(alias)).append(" ");
            } else {
                alias = SqlGenerateUtils.getLabCostColumnAlias((Context)this.ctx, (String)column, (String)alias);
                selectColumnString.append(" ").append(column).append(" AS ").append(this.appendQuo(alias)).append(" ");
            }
        } else if (this.param.isHistoryMode() && column.toUpperCase().contains("LONGNUMBER") && "com.kingdee.eas.basedata.org.app.AdminOrgUnit".equalsIgnoreCase(configInfo.getEntityName())) {
            this.appendQueAdminHis(selectColumnString, configInfo, "T", "FLongNumber", alias);
        } else if (this.param.isHistoryMode() && column.toUpperCase().contains("DISPLAYNAME") && "com.kingdee.eas.basedata.org.app.AdminOrgUnit".equalsIgnoreCase(configInfo.getEntityName())) {
            if (ShrSqlEnum.REPORT.equals((Object)this.param.getShrSqlEnum())) {
                this.appendQueAdminHis(selectColumnString, configInfo, "T", MessageFormat.format("FDisplayName_{0} ", "@customLocaleLan"), alias);
            } else {
                this.appendQueAdminHis(selectColumnString, configInfo, "T", MessageFormat.format("FDisplayName_{0} ", this.ctx.getLocale().getDisplayName()), alias);
            }
        } else {
            String relaceStr = this.getColumnHisotryName(this.historyReplayColumn, this.getColumnName(configInfo, keys[1]));
            if (this.param.getColumns().get(column) != null && ((Map)this.param.getColumns().get(column)).get("columnsql") != null && !"".equals(((Map)this.param.getColumns().get(column)).get("columnsql")) && !"null".equals(((Map)this.param.getColumns().get(column)).get("columnsql"))) {
                String columnSql = (String)((Map)this.param.getColumns().get(column)).get("columnsql");
                selectColumnString.append(" ").append(columnSql.replace(column, relaceStr)).append(" AS ").append(this.appendQuo(alias)).append(" ");
            } else if (customStr != null && !"".equals(customStr)) {
                alias = SqlGenerateUtils.getLabCostColumnAlias((Context)this.ctx, (String)column, (String)alias);
                selectColumnString.append(" ").append(customStr).append(" AS ").append(this.appendQuo(alias)).append(" ");
            } else {
                selectColumnString.append(" ").append(relaceStr).append(" AS ").append(this.appendQuo(alias)).append(" ");
            }
        }
        return selectColumnString.toString();
    }

    protected String assembleSQLFrom() throws EASBizException, BOSException {
        int i;
        long begin = System.currentTimeMillis();
        HashMap<String, HistoryGeneratorParam> hisParamMap = new HashMap<String, HistoryGeneratorParam>();
        String scheme = this.param.getScheme();
        StructureConfigInfo main = StructureConfigConvertHelper.getMain((Context)this.ctx, (String)scheme);
        StringBuffer sql = new StringBuffer();
        ArrayList<String> tempLeft = new ArrayList<String>();
        StructureConfigCollection relateConfigColl = this.getRelateStructureConfig(main);
        StructureConfigCollection structureConfigColl = (StructureConfigCollection)relateConfigColl.clone();
        HashMap<String, StructureConfigInfo> alreadyProcessMap = new HashMap<String, StructureConfigInfo>();
        this.processFirstTable(hisParamMap, main, alreadyProcessMap, sql);
        StructureConfigInfo info = null;
        for (i = 0; i < structureConfigColl.size(); ++i) {
            info = structureConfigColl.get(i);
            if (alreadyProcessMap.containsKey(info.getId().toString())) continue;
            this.processEachNode(tempLeft, info, alreadyProcessMap, hisParamMap);
        }
        int size = tempLeft.size();
        for (i = 0; i < size; ++i) {
            this.assembleSQLFromReal(((String)tempLeft.get(i)).toString(), sql);
        }
        long end = System.currentTimeMillis();
        if (logger.isDebugEnabled()) {
            logger.debug("assembleSQLFrom cost:" + (end - begin));
        }
        if (this.perSumCalSchemeNumber.equalsIgnoreCase(scheme) || this.cmpSchemeNumber.equalsIgnoreCase(scheme)) {
            String cmpsqlFrom = this.assembleCMPSQLFrom();
            if (cmpsqlFrom.contains("CMP_PERSON") && !sql.toString().contains("CMP_PERSON")) {
                sql.append(" ").append("LEFT JOIN  T_BD_PERSONHIS AS \"CMP_PERSON\" ON \"CMP_PERSON\".FhistoryRelateID=\"EVARESULT\".FPERSONID");
            }
            if (!StringUtils.isEmpty((String)cmpsqlFrom)) {
                int leftIndex = cmpsqlFrom.indexOf("LEFT");
                sql.append(" ").append(cmpsqlFrom.substring(leftIndex));
            }
        }
        return sql.toString();
    }

    protected String assembleCMPSQLFrom() throws EASBizException, BOSException {
        int i;
        if (CollectionUtils.isEmpty(this.cmpSelectingMap)) {
            return "";
        }
        long begin = System.currentTimeMillis();
        HashMap<String, HistoryGeneratorParam> hisParamMap = new HashMap<String, HistoryGeneratorParam>();
        StructureConfigInfo main = StructureConfigConvertHelper.getMain((Context)this.ctx, (String)this.cmpSchemeNumber);
        StringBuffer sql = new StringBuffer();
        ArrayList<String> tempLeft = new ArrayList<String>();
        StructureConfigCollection relateConfigColl = this.getCMPRelateStructureConfig(main);
        StructureConfigCollection structureConfigColl = (StructureConfigCollection)relateConfigColl.clone();
        HashMap<String, StructureConfigInfo> alreadyProcessMap = new HashMap<String, StructureConfigInfo>();
        this.processFirstTable(hisParamMap, main, alreadyProcessMap, sql);
        StructureConfigInfo info = null;
        for (i = 0; i < structureConfigColl.size(); ++i) {
            info = structureConfigColl.get(i);
            if (alreadyProcessMap.containsKey(info.getId().toString())) continue;
            this.processCMPEachNode(tempLeft, info, alreadyProcessMap, hisParamMap, this.cmpSchemeNumber);
        }
        int size = tempLeft.size();
        for (i = 0; i < size; ++i) {
            this.assembleSQLFromReal(((String)tempLeft.get(i)).toString(), sql);
        }
        long end = System.currentTimeMillis();
        if (logger.isDebugEnabled()) {
            logger.debug("assembleSQLFrom cost:" + (end - begin));
        }
        return sql.toString();
    }

    protected void processEachNode(List<String> tempLeft, StructureConfigInfo structureConfigInfo, Map<String, StructureConfigInfo> alreadyProcessMap, Map<String, HistoryGeneratorParam> hisParamMap) throws EASBizException, BOSException {
        this.processEachNode(tempLeft, structureConfigInfo, alreadyProcessMap, hisParamMap, this.param.getScheme());
    }

    protected void processEachNode(List<String> tempLeft, StructureConfigInfo structureConfigInfo, Map<String, StructureConfigInfo> alreadyProcessMap, Map<String, HistoryGeneratorParam> hisParamMap, String schemeNumber) throws EASBizException, BOSException {
        StructureConfigInfo parentInfo = null;
        if (null != structureConfigInfo.getParent()) {
            parentInfo = StructureConfigConvertHelper.getStructureConfigByID((Context)this.ctx, (String)structureConfigInfo.getParent().getId().toString(), (String)schemeNumber);
        }
        if (parentInfo == null) {
            throw new BOSException(structureConfigInfo.getAlias() + " parentnode is null,please set");
        }
        if (!alreadyProcessMap.containsKey(parentInfo.getId().toString())) {
            this.processEachNode(tempLeft, parentInfo, alreadyProcessMap, hisParamMap);
        }
        this.processNode(tempLeft, alreadyProcessMap, structureConfigInfo, parentInfo, hisParamMap);
    }

    protected void processCMPEachNode(List<String> tempLeft, StructureConfigInfo structureConfigInfo, Map<String, StructureConfigInfo> alreadyProcessMap, Map<String, HistoryGeneratorParam> hisParamMap, String schemeNumber) throws EASBizException, BOSException {
        StructureConfigInfo parentInfo = null;
        if (null != structureConfigInfo.getParent()) {
            parentInfo = StructureConfigConvertHelper.getStructureConfigByID((Context)this.ctx, (String)structureConfigInfo.getParent().getId().toString(), (String)schemeNumber);
        }
        if (parentInfo != null) {
            if (!alreadyProcessMap.containsKey(parentInfo.getId().toString())) {
                this.processCMPEachNode(tempLeft, parentInfo, alreadyProcessMap, hisParamMap, schemeNumber);
            }
            this.processNode(tempLeft, alreadyProcessMap, structureConfigInfo, parentInfo, hisParamMap);
        }
    }

    protected void processNode(List<String> tempLeft, Map<String, StructureConfigInfo> alreadyProcessMap, StructureConfigInfo clientInfo, StructureConfigInfo parentInfo, Map<String, HistoryGeneratorParam> hisParamMap) throws EASBizException, BOSException {
        long begin = System.currentTimeMillis();
        this.handleSingleViewValue(clientInfo);
        alreadyProcessMap.put(clientInfo.getId().toString(), clientInfo);
        this.prepareHisparam(hisParamMap, clientInfo, parentInfo);
        String tempStr = this.generateFromSql(clientInfo, parentInfo, hisParamMap).toString();
        int size = tempLeft.size();
        for (int i = 0; i < size; ++i) {
            if (!tempLeft.get(i).toString().contains("\"" + clientInfo.getClientNumber().toUpperCase() + "\"")) continue;
            tempLeft.add(i, tempStr);
            break;
        }
        if (!tempLeft.contains(tempStr)) {
            tempLeft.add(tempStr);
        }
        long end = System.currentTimeMillis();
        if (logger.isDebugEnabled()) {
            logger.debug("processNode cost:" + (end - begin) + ", tempStr:" + tempStr);
        }
    }

    protected void prepareHisparam(Map<String, HistoryGeneratorParam> hisParamMap, StructureConfigInfo currentInfo, StructureConfigInfo parentInfo) {
        HistoryGeneratorParam parentParam = hisParamMap.get(parentInfo.getId().toString());
        HistoryGeneratorParam clientParam = null;
        if (parentParam.isNeedHisFilter()) {
            clientParam = new HistoryGeneratorParam();
            clientParam.setRelateColumn(parentParam.getRelateColumn());
            clientParam.setRelateColumnFieldName(parentParam.getRelateColumnFieldName());
            clientParam.setRelateTalbe(parentParam.getRelateTalbe());
        } else {
            clientParam = this.getHisParam(currentInfo);
        }
        hisParamMap.put(currentInfo.getId().toString(), clientParam);
    }

    protected StructureConfigCollection getRelateStructureConfig(StructureConfigInfo main) throws EASBizException, BOSException {
        int i;
        StructureConfigCollection relateColl = this.getAllTableInfo();
        relateColl.add(main);
        Map<String, StructureConfigInfo> allParentMap = this.initParentMap(relateColl, main);
        ArrayList<StructureConfigInfo> addList = new ArrayList<StructureConfigInfo>();
        for (i = 0; i < relateColl.size(); ++i) {
            for (StructureConfigInfo parentInfo = relateColl.get(i).getParent(); parentInfo != null && !allParentMap.containsKey(parentInfo.getId().toString()); parentInfo = parentInfo.getParent()) {
                parentInfo = StructureConfigConvertHelper.getStructureConfigByID((Context)this.ctx, (String)parentInfo.getId().toString(), (String)this.param.getScheme());
                addList.add(parentInfo);
                allParentMap.put(parentInfo.getId().toString(), parentInfo);
            }
        }
        for (i = 0; i < addList.size(); ++i) {
            relateColl.add((StructureConfigInfo)addList.get(i));
        }
        return relateColl;
    }

    protected StructureConfigCollection getCMPRelateStructureConfig(StructureConfigInfo main) throws EASBizException, BOSException {
        int i;
        StructureConfigCollection relateColl = this.getCMPAllTableInfo();
        relateColl.add(main);
        Map<String, StructureConfigInfo> allParentMap = this.initParentMap(relateColl, main);
        ArrayList<StructureConfigInfo> addList = new ArrayList<StructureConfigInfo>();
        for (i = 0; i < relateColl.size(); ++i) {
            for (StructureConfigInfo parentInfo = relateColl.get(i).getParent(); parentInfo != null && !allParentMap.containsKey(parentInfo.getId().toString()); parentInfo = parentInfo.getParent()) {
                parentInfo = StructureConfigConvertHelper.getStructureConfigByID((Context)this.ctx, (String)parentInfo.getId().toString(), (String)this.cmpSchemeNumber);
                addList.add(parentInfo);
                allParentMap.put(parentInfo.getId().toString(), parentInfo);
            }
        }
        for (i = 0; i < addList.size(); ++i) {
            relateColl.add((StructureConfigInfo)addList.get(i));
        }
        return relateColl;
    }

    protected StructureConfigCollection getAllTableInfo() throws EASBizException, BOSException {
        StructureConfigInfo structureConfigByKey;
        StructureConfigCollection tableCollection = new StructureConfigCollection();
        for (Map.Entry entry : this.param.getSelectMapping().entrySet()) {
            structureConfigByKey = StructureConfigConvertHelper.getStructureConfigByKey((Context)this.ctx, (String)((String)entry.getKey()), (String)this.param.getScheme());
            if (structureConfigByKey != null) {
                tableCollection.add(structureConfigByKey);
                continue;
            }
            this.cmpSelectingMap.put((String)entry.getKey(), (String)entry.getValue());
        }
        for (int i = 0; i < this.param.getFilterInfo().getFilterItems().size(); ++i) {
            structureConfigByKey = StructureConfigConvertHelper.getStructureConfigByKey((Context)this.ctx, (String)this.param.getFilterInfo().getFilterItems().get(i).getPropertyName(), (String)this.param.getScheme());
            if (structureConfigByKey == null) continue;
            tableCollection.add(structureConfigByKey);
        }
        if (ShrSqlEnum.REPORT.equals((Object)this.param.getShrSqlEnum())) {
            this.afterGetAllTableInfoForReport(tableCollection);
        }
        return tableCollection;
    }

    protected StructureConfigCollection getCMPAllTableInfo() throws EASBizException, BOSException {
        StructureConfigCollection tableCollection = new StructureConfigCollection();
        if (CollectionUtils.isEmpty(this.cmpSelectingMap)) {
            return tableCollection;
        }
        for (Map.Entry<String, String> entry : this.cmpSelectingMap.entrySet()) {
            StructureConfigInfo structureConfigByKey = StructureConfigConvertHelper.getStructureConfigByKey((Context)this.ctx, (String)entry.getKey(), (String)this.cmpSchemeNumber);
            if (structureConfigByKey == null) continue;
            tableCollection.add(structureConfigByKey);
        }
        return tableCollection;
    }

    protected Map<String, StructureConfigInfo> initParentMap(StructureConfigCollection relateColl, StructureConfigInfo main) throws EASBizException, BOSException {
        HashMap<String, StructureConfigInfo> allParentMap = new HashMap<String, StructureConfigInfo>();
        StructureConfigInfo tempParentInfo = null;
        StructureConfigInfo parentInfo = StructureConfigConvertHelper.getMain((Context)this.ctx, (String)this.param.getScheme());
        int total = relateColl.size();
        for (int i = 0; i < total; ++i) {
            allParentMap.put(relateColl.get(i).getId().toString(), relateColl.get(i));
        }
        boolean flag = true;
        do {
            if (parentInfo.getParent() != null) {
                if (allParentMap.containsKey((parentInfo = parentInfo.getParent()).getId().toString())) {
                    flag = false;
                    break;
                }
                if (this.getInfoFromCollByKey((IObjectCollection)relateColl, parentInfo.getId().toString()) != null) {
                    tempParentInfo = StructureConfigConvertHelper.getStructureConfigByID((Context)this.ctx, (String)main.getParent().getId().toString(), (String)this.param.getScheme());
                    while (!tempParentInfo.getId().equals((Object)parentInfo.getId())) {
                        relateColl.add(tempParentInfo);
                        tempParentInfo = StructureConfigConvertHelper.getStructureConfigByID((Context)this.ctx, (String)tempParentInfo.getParent().getId().toString(), (String)this.param.getScheme());
                    }
                }
                allParentMap.put(parentInfo.getId().toString(), StructureConfigConvertHelper.getStructureConfigByID((Context)this.ctx, (String)parentInfo.getId().toString(), (String)this.param.getScheme()));
                continue;
            }
            flag = false;
        } while (flag);
        return allParentMap;
    }

    protected void processFirstTable(Map<String, HistoryGeneratorParam> hisParamMap, StructureConfigInfo mainConfig, Map<String, StructureConfigInfo> alreadyProcessMap, StringBuffer sql) throws EASBizException, BOSException {
        sql.append(this.generateFromSql(mainConfig, null, hisParamMap));
        alreadyProcessMap.put(mainConfig.getId().toString(), mainConfig);
        hisParamMap.put(mainConfig.getId().toString(), this.getHisParam(mainConfig));
    }

    protected StringBuffer generateFromSql(StructureConfigInfo configInfo, StructureConfigInfo relateInfo, Map<String, HistoryGeneratorParam> hisParamMap) throws EASBizException, BOSException {
        String tableName = this.getTableName(configInfo, this.param.isHistoryMode());
        StringBuffer sql = new StringBuffer();
        if (relateInfo == null) {
            sql.append(this.getTableNameAndAlias(configInfo, tableName));
        } else if (LinkType.INNER.equals((Object)relateInfo.getLinkType())) {
            this.appendInnerJoin(sql, this.getTableNameAndAlias(configInfo, tableName), this.getFromOnSql(configInfo, relateInfo, hisParamMap));
        } else {
            this.appendLeftJoin(sql, this.getTableNameAndAlias(configInfo, tableName), this.getFromOnSql(configInfo, relateInfo, hisParamMap));
        }
        if ("T_ORG_ADMINHIS".equalsIgnoreCase(tableName)) {
            String adminAlias = this.getQuoTableAlias(configInfo);
            String adminTAlias = this.appendQuo(this.getTableAlias(configInfo) + "T");
            this.appendLeftJoin(sql, new StringBuffer("T_ORG_ADMINORGTREEHIS").append(" AS ").append(adminTAlias), this.generateAdminHis(configInfo, adminAlias, adminTAlias));
        }
        return sql;
    }

    protected StringBuffer getTableNameAndAlias(StructureConfigInfo configInfo, String tableName) {
        StringBuffer sql = new StringBuffer();
        String tableAlias = this.getQuoTableAlias(configInfo);
        tableAlias = tableAlias.toUpperCase();
        if (this.isNeedHistory(configInfo) && this.param.isHistoryMode()) {
            this.historyReplayColumn.put(tableAlias + ".FID", tableAlias + ".F" + HistoryConstant.historyRelateID);
        }
        sql.append(" ").append(tableName).append(" AS ").append(tableAlias);
        return sql;
    }

    protected boolean isNeedHistory(StructureConfigInfo configInfo) {
        EntityObjectInfo objectInfo = this.getEntityObject(configInfo.getEntityName());
        return this.isHistoryEntity(objectInfo);
    }

    protected boolean isBigDataType(StructureConfigInfo configInfo, String column) {
        EntityObjectInfo entityObjectInfo = this.getEntityObject(configInfo.getEntityName());
        String propertyName = "";
        propertyName = column.indexOf(".") > 0 ? column.split("\\.")[1] : column;
        PropertyInfo propertyInfo = entityObjectInfo.getPropertyByNameRuntime(propertyName);
        ColumnInfo ColumnInfo2 = propertyInfo.getMappingField();
        int sqlType = ColumnInfo2.getSQLType();
        return sqlType == SQLType.CLOB.getSQLType() || sqlType == SQLType.BLOB.getSQLType() || sqlType == SQLType.NCLOB.getSQLType();
    }
}

