/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.osf;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.service.app.IHRMsfService;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.perfweb.app.multiEvalution.multiPerfPlan.IMultiPerfPeriod;
import com.kingdee.shr.perfweb.app.multiEvalution.multiPerfPlan.MultiPerfPeriodFactory;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetMultiPerfPeriodService
implements IHRMsfService {
    private static Logger logger = LoggerFactory.getLogger((String)GetMultiPerfPeriodService.class.getName());

    public Object process(Context ctx, Map param) throws EASBizException, BOSException {
        int rows = (Integer)param.get("rows");
        int page = (Integer)param.get("page");
        EntityViewInfo evi = GetMultiPerfPeriodService.getEntityView(ctx, param);
        IMultiPerfPeriod iMultiPerfPeriod = MultiPerfPeriodFactory.getLocalInstance((Context)ctx);
        int totalCount = iMultiPerfPeriod.getCount(evi);
        int length = rows;
        if (page * rows > totalCount) {
            length = totalCount - (page - 1) * rows;
        }
        List list = iMultiPerfPeriod.getPagingList(evi, (page - 1) * rows, length);
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("page", page);
        resultMap.put("records", totalCount);
        resultMap.put("rows", list);
        return resultMap;
    }

    private static EntityViewInfo getEntityView(Context ctx, Map param) throws BOSException {
        String perfPlanId = (String)param.get("perfPlanId");
        String periodName = (String)param.get("periodName");
        FilterInfo filter = new FilterInfo();
        if (!StringUtils.isEmpty((CharSequence)perfPlanId)) {
            filter.getFilterItems().add(new FilterItemInfo("multiPerfplan.id", (Object)perfPlanId, CompareType.EQUALS));
        }
        if (!StringUtils.isEmpty((CharSequence)periodName)) {
            filter.getFilterItems().add(new FilterItemInfo("name", (Object)("%" + periodName + "%"), CompareType.LIKE));
        }
        if (!GetMultiPerfPeriodService.isOrg(param)) {
            filter.getFilterItems().add(new FilterItemInfo("isOrg", (Object)0, CompareType.EQUALS));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("isOrg", (Object)1, CompareType.EQUALS));
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        SorterItemCollection sorterItemCollection = new SorterItemCollection();
        SorterItemInfo sorterItemInfo = new SorterItemInfo("name");
        sorterItemInfo.setSortType(SortType.DESCEND);
        sorterItemCollection.add(sorterItemInfo);
        evi.setSelector(sic);
        evi.setSorter(sorterItemCollection);
        evi.setFilter(filter);
        return evi;
    }

    private static boolean isOrg(Map map) {
        return map.get("isOrg") != null && map.get("isOrg").toString().equals("1");
    }
}

