/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.osf;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.service.app.IHRMsfService;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.AdminOrgRangeFilterUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.perfweb.app.multiEvalution.multiPerfPlan.IMultiPerfPlan;
import com.kingdee.shr.perfweb.app.multiEvalution.multiPerfPlan.MultiPerfPlanFactory;
import com.kingdee.shr.perfweb.util.AdminOrgFilterUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetMultiPerfPlanService
implements IHRMsfService {
    private static Logger logger = LoggerFactory.getLogger((String)GetMultiPerfPlanService.class.getName());

    public Object process(Context ctx, Map param) throws EASBizException, BOSException {
        int rows = (Integer)param.get("rows");
        int page = (Integer)param.get("page");
        EntityViewInfo evi = GetMultiPerfPlanService.getEntityView(ctx, param);
        IMultiPerfPlan iMultiPerfPlan = MultiPerfPlanFactory.getLocalInstance((Context)ctx);
        int totalCount = iMultiPerfPlan.getCount(evi);
        int length = rows;
        if (page * rows > totalCount) {
            length = totalCount - (page - 1) * rows;
        }
        List list = iMultiPerfPlan.getPagingList(evi, (page - 1) * rows, length);
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("page", page);
        resultMap.put("records", totalCount);
        resultMap.put("rows", list);
        return resultMap;
    }

    private static EntityViewInfo getEntityView(Context ctx, Map param) throws BOSException {
        String belongOrgId = (String)param.get("belongOrgId");
        String planName = (String)param.get("planName");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("pStatus", (Object)1, CompareType.EQUALS));
        if (!GetMultiPerfPlanService.isOrg(param)) {
            filter.getFilterItems().add(new FilterItemInfo("isOrg", (Object)0, CompareType.EQUALS));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("isOrg", (Object)1, CompareType.EQUALS));
        }
        if (!StringUtils.isEmpty((CharSequence)planName)) {
            filter.getFilterItems().add(new FilterItemInfo("name", (Object)("%" + planName + "%"), CompareType.LIKE));
        }
        FilterInfo adminOrgFilter = new FilterInfo();
        adminOrgFilter.getFilterItems().add(new FilterItemInfo("belongOrg.id", (Object)AdminOrgRangeFilterUtil.getUserAdminOrgSql((Context)ctx), CompareType.INNER));
        filter.mergeFilter(adminOrgFilter, "and");
        if (!StringUtils.isEmpty((CharSequence)belongOrgId)) {
            FilterInfo adminSubOrgFilter = new FilterInfo();
            adminSubOrgFilter.getFilterItems().add(new FilterItemInfo("belongOrg.id", (Object)AdminOrgFilterUtil.getUserIncludeSubAdminOrgRangeSql(ctx, belongOrgId), CompareType.INNER));
            filter.mergeFilter(adminSubOrgFilter, "and");
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        SorterItemCollection sorterItemCollection = new SorterItemCollection();
        SorterItemInfo sorterItemInfo = new SorterItemInfo("name");
        sorterItemInfo.setSortType(SortType.DESCEND);
        sorterItemCollection.add(sorterItemInfo);
        evi.setSelector(sic);
        evi.setSorter(sorterItemCollection);
        evi.setFilter(filter);
        return evi;
    }

    private static boolean isOrg(Map map) {
        return map.get("isOrg") != null && map.get("isOrg").toString().equals("1");
    }
}

