/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.osf;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.service.app.IHRMsfService;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.perfweb.app.resource.SHRPerfWebResource;
import com.kingdee.shr.perfweb.app.workflow.PerfWorkFlowFacadeControllerBean;
import com.kingdee.shr.perfweb.bean.PerfScoreList;
import com.kingdee.shr.perfweb.exception.SHRPerfWebException;
import com.kingdee.shr.perfweb.util.EvaFormUtil;
import com.kingdee.shr.perfweb.util.PerfConfigUtils;
import com.kingdee.shr.perfweb.util.SHRPerfWebResourceUtil;
import com.kingdee.shr.perfweb.utils.OrgAssessmentUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.axis.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class GradingSingleService
implements IHRMsfService {
    private static final String SAVE_VALUE = "0";
    private static final String BACK_VALUE = "2";
    private static final String SUBMIT_VALUE = "1";
    private static final String CALCULTE_SCORE = "3";
    private static final Logger logger = LoggerFactory.getLogger((String)"com.kingdee.shr.perfweb.osf.GradingSingleService");

    public Object process(Context ctx, Map param) throws EASBizException, BOSException {
        String result = "";
        ArrayList<Map<String, Object>> resList = new ArrayList<Map<String, Object>>();
        PerfWorkFlowFacadeControllerBean bean = new PerfWorkFlowFacadeControllerBean();
        String type = (String)param.get("type");
        if (BACK_VALUE.equals(type)) {
            String[] gradeTaskNode = ((String)param.get("nodeTaskId")).split(",");
            String[] evaObj = ((String)param.get("evaObjId")).split(",");
            String backReason = (String)param.get("backReason");
            return bean.backToUpLevel(ctx, gradeTaskNode, evaObj, backReason);
        }
        Gson gson = new Gson();
        String scoreList = (String)param.get("scoreList");
        List perfScoreListList = (List)gson.fromJson(scoreList, new TypeToken<List<PerfScoreList>>(){}.getType());
        if (!CollectionUtils.isEmpty((Collection)perfScoreListList)) {
            for (PerfScoreList perfScoreList : perfScoreListList) {
                HashMap<String, String> res = new HashMap<String, String>();
                if (SAVE_VALUE.equals(type)) {
                    result = bean.saveScore(ctx, perfScoreList);
                    res.put("result", result);
                    res.put("gradeTaskNode", perfScoreList.getGradeTaskNode());
                } else if (SUBMIT_VALUE.equals(type)) {
                    bean.saveScore(ctx, perfScoreList);
                    result = bean.submitScore(ctx, perfScoreList);
                    res.put("result", result);
                    res.put("gradeTaskNode", perfScoreList.getGradeTaskNode());
                } else if (CALCULTE_SCORE.equals(type)) {
                    boolean isOrg = OrgAssessmentUtils.isOrgAssessment(ctx, perfScoreList.getEvaObj());
                    String isManualJudgeGrade = PerfConfigUtils.getConfigByName(ctx, "isManualJudgeGrade", isOrg);
                    result = bean.saveScore(ctx, perfScoreList);
                    HashMap<String, String> parames = new HashMap<String, String>();
                    String gradeTaskNodeid = perfScoreList.getGradeTaskNode();
                    parames.put("evaObj", perfScoreList.getEvaObj());
                    parames.put("gradeTaskNode", gradeTaskNodeid);
                    parames.put("myType", "INIT");
                    parames.put("isModifyScore", SUBMIT_VALUE);
                    parames.put("isManualJudgeGrade", isManualJudgeGrade);
                    parames.put("isShowAuditedWholeForm", "false");
                    List<Map<String, Object>> wholeComments = null;
                    String wholeGrade = "";
                    String wholeScore = "";
                    try {
                        wholeComments = EvaFormUtil.getCurrentAndPrevWholeCommentAction(ctx, parames);
                        if (!CollectionUtils.isEmpty(wholeComments)) {
                            for (Map<String, Object> wholeComment : wholeComments) {
                                if (StringUtils.isEmpty((String)gradeTaskNodeid) || !gradeTaskNodeid.equals(wholeComment.get("gradeTaskNode"))) continue;
                                wholeGrade = String.valueOf(wholeComment.get("scoreToLevel"));
                                wholeScore = String.valueOf(wholeComment.get("wholeScore"));
                            }
                        }
                    }
                    catch (SHRPerfWebException e) {
                        logger.error("[perfweb]GradingSingleService auto calculate grade error!", (Throwable)e);
                    }
                    res.put("wholeGrade", wholeGrade);
                    res.put("wholeScore", wholeScore);
                    res.put("gradeTaskNode", gradeTaskNodeid);
                    res.put("result", result);
                }
                resList.add(res);
            }
        }
        return this.packageResultMap(resList, type, ctx);
    }

    private Map<String, Object> packageResultMap(List<Map<String, Object>> resList, String type, Context ctx) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (CollectionUtils.isEmpty(resList)) {
            return resultMap;
        }
        String msg = SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.OPERATESUCCESS, ctx);
        ArrayList<String> gradeTaskNodeList = new ArrayList<String>();
        String resultStr = "200";
        for (Map<String, Object> resMap : resList) {
            gradeTaskNodeList.add((String)resMap.get("gradeTaskNode"));
            if ("200".equals(resMap.get("result"))) continue;
            msg = SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.OPERATEFAILED, ctx);
            resultStr = "500";
        }
        resultMap.put("wholeResultList", resList);
        resultMap.put("gradeTaskNode", gradeTaskNodeList);
        resultMap.put("msg", msg);
        resultMap.put("result", resultStr);
        return resultMap;
    }
}

