/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.osf;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.service.app.IHRMsfService;
import com.kingdee.bos.bsf.service.classloader.MsfClassLoaderFactory;
import com.kingdee.bos.workflow.exception.MissMatchParticipantException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.perfweb.app.exception.SHRPerfWebBizException2;
import com.kingdee.shr.perfweb.app.resource.SHRPerfWebResource;
import com.kingdee.shr.perfweb.osf.invoke.InvokerDigestHelper;
import com.kingdee.shr.perfweb.util.OsfUtils;
import com.kingdee.shr.perfweb.util.SHRPerfWebResourceUtil;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.util.ReflectUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerfGoCommonService
implements IHRMsfService {
    private static Logger logger = LoggerFactory.getLogger(PerfGoCommonService.class);

    public Object process(Context context, Map map) throws EASBizException, BOSException {
        String showException = null;
        try {
            OsfUtils.notEmpty(context, map, "className", "methodName", "digest");
            showException = (String)map.get("showException");
            String className = (String)map.get("className");
            String methodName = (String)map.get("methodName");
            String digest = (String)map.get("digest");
            String md5String = InvokerDigestHelper.getDigest(context, className, methodName);
            if (!md5String.equals(digest)) {
                throw new SHRPerfWebBizException2(SHRPerfWebBizException2.ILLEGALREQUEST);
            }
            Map args = (Map)map.get("args");
            Class targetClass = this.getTargetClass(className.toString());
            Object result = ReflectUtil.invoke(targetClass.newInstance(), (String)methodName, Context.class, (Object)context, Map.class, (Object)args);
            if (result instanceof Map) {
                ((Map)result).put("resultFlag", "success");
            }
            return result;
        }
        catch (Exception e) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            if (showException != null && Boolean.valueOf(showException.toString()).booleanValue()) {
                result.put("exception", e.getStackTrace());
            }
            result.put("resultFlag", "failure");
            if (e instanceof EASBizException || e instanceof BuildException) {
                result.put("errorDes", this.filterMsg(context, e));
            } else if (e instanceof InvocationTargetException) {
                Throwable targetException = ((InvocationTargetException)e).getTargetException();
                if (targetException instanceof EASBizException || targetException instanceof MissMatchParticipantException) {
                    result.put("errorDes", this.filterMsg(context, targetException));
                }
            } else {
                result.put("errorDes", SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.SYSTEMERR, context));
            }
            logger.error("Exception: ", (Throwable)e);
            return result;
        }
    }

    private String filterMsg(Context context, Throwable e) {
        logger.error("", e);
        String message = e.getMessage();
        String[] split = new String[2];
        if (message.contains("SHRPerfWebBizException2:")) {
            split = message.split("SHRPerfWebBizException2:");
        } else if (message.contains("SHRPerfWebBizException:")) {
            split = message.split("SHRPerfWebBizException:");
        } else if (message.contains("ShrWebBizException:")) {
            split = message.split("ShrWebBizException:");
        } else if (message.contains("EASBizException:")) {
            split = message.split("EASBizException:");
        } else {
            message = SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.SYSTEMERR, context);
        }
        if (split.length == 2 && !"".equals(split[1])) {
            message = split[1];
        }
        return message;
    }

    private Class getTargetClass(String className) throws EASBizException, BOSException {
        Class<?> serviceClass;
        try {
            serviceClass = MsfClassLoaderFactory.forName((String)className);
        }
        catch (ClassNotFoundException e) {
            try {
                serviceClass = Class.forName(className);
            }
            catch (ClassNotFoundException e1) {
                logger.error("", (Throwable)e1);
                throw new BOSException((Throwable)e1);
            }
        }
        if (null == serviceClass) {
            throw new BOSException((Throwable)new ClassNotFoundException());
        }
        return serviceClass;
    }
}

