/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.osf.targetrelation;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.perfweb.app.base.evalfile.PerfFileCollection;
import com.kingdee.shr.perfweb.app.base.evalfile.PerfFileFactory;
import com.kingdee.shr.perfweb.app.base.evalfile.PerfFileInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjectFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjectInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaluAdminResponsorCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaluAdminResponsorInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfPeriodInfo;
import com.kingdee.shr.perfweb.app.resource.SHRPerfWebResource;
import com.kingdee.shr.perfweb.osf.CommonListHandlerService;
import com.kingdee.shr.perfweb.osf.model.SimpleFieldInfo;
import com.kingdee.shr.perfweb.util.SHRPerfWebResourceUtil;
import com.kingdee.util.StringUtils;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class GetTargetRelationEvaObjService
extends CommonListHandlerService {
    private static Logger logger = LoggerFactory.getLogger((String)GetTargetRelationEvaObjService.class.getName());
    private static final String ONLYSHOWSUBORDINATE = "1";

    @Override
    public FilterInfo getDefoFilter(Context ctx, Map map) throws BOSException, EASBizException {
        String periodId = (String)map.get("period");
        String evaObjId = (String)map.get("evaObj");
        String subordinate = (String)map.get("subordinate");
        String searchKey = (String)map.get("searchText");
        logger.error("GetTargetRelationEvaObjService evaObjId = " + evaObjId);
        PerfEvaObjectInfo perfEvaObjectInfo = PerfEvaObjectFactory.getLocalInstance((Context)ctx).getPerfEvaObjectInfo("select *,adminHis.longnumber,perfFile.position.id where id='" + evaObjId + "'");
        FilterInfo filter = new FilterInfo();
        Boolean isOrg = perfEvaObjectInfo.getIsOrg().getValue() == 1;
        map.put("isOrg", isOrg);
        if (ONLYSHOWSUBORDINATE.equals(subordinate)) {
            if (!isOrg.booleanValue()) {
                String positionId = perfEvaObjectInfo.getPerfFile().getPosition().getId().toString();
                filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)this.getPrimarySubordinateSQL(positionId), CompareType.INNER));
            } else {
                filter.getFilterItems().add(new FilterItemInfo("adminhis.parent.longnumber", (Object)perfEvaObjectInfo.getAdminHis().getLongNumber(), CompareType.EQUALS));
            }
        }
        HashSet<Integer> set = new HashSet<Integer>();
        set.add(1);
        set.add(0);
        filter.getFilterItems().add(new FilterItemInfo("period.evaPeriodStatus", (Object)100, CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("unitGoalsStatus", (Object)1, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("personalGoalStatus", set, CompareType.INCLUDE));
        if (!StringUtils.isEmpty((String)periodId)) {
            filter.getFilterItems().add(new FilterItemInfo("period", (Object)periodId, CompareType.EQUALS));
        }
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)evaObjId, CompareType.NOTEQUALS));
        if (!StringUtils.isEmpty((String)searchKey)) {
            FilterInfo searchFilter = new FilterInfo();
            if (!isOrg.booleanValue()) {
                searchFilter.getFilterItems().add(new FilterItemInfo("person.name", (Object)("%" + searchKey + "%"), CompareType.LIKE));
                searchFilter.getFilterItems().add(new FilterItemInfo("perfFile.position.name", (Object)("%" + searchKey + "%"), CompareType.LIKE));
                searchFilter.getFilterItems().add(new FilterItemInfo("adminOrgUnit.name", (Object)("%" + searchKey + "%"), CompareType.LIKE));
                searchFilter.setMaskString("#0 or #1 or #2");
                filter.mergeFilter(searchFilter, "and");
            } else {
                searchFilter.getFilterItems().add(new FilterItemInfo("name", (Object)("%" + searchKey + "%"), CompareType.LIKE));
                searchFilter.getFilterItems().add(new FilterItemInfo("number", (Object)("%" + searchKey + "%"), CompareType.LIKE));
                searchFilter.setMaskString("#0 or #1 ");
                filter.mergeFilter(searchFilter, "and");
            }
        }
        return filter;
    }

    @Override
    public void afterGetListData(Context ctx, List list) {
        if (!CollectionUtils.isEmpty((Collection)list)) {
            HashSet<String> responserIds = new HashSet<String>();
            HashSet<String> perfFileIds = new HashSet<String>();
            for (PerfEvaObjectInfo item : list) {
                PerfEvaluAdminResponsorCollection colls = item.getResponsor();
                if (colls != null && !colls.isEmpty()) {
                    for (PerfEvaluAdminResponsorInfo responsorInfo : colls) {
                        responserIds.add(responsorInfo.getPerson().getId().toString());
                    }
                }
                if (item.getPerfFile() == null) continue;
                perfFileIds.add(item.getPerfFile().getId().toString());
            }
            HashMap<String, PerfFileInfo> perfFileMap = new HashMap<String, PerfFileInfo>();
            if (!CollectionUtils.isEmpty(perfFileIds)) {
                EntityViewInfo evi = new EntityViewInfo();
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("id", perfFileIds, CompareType.INCLUDE));
                evi.setFilter(filterInfo);
                SelectorItemCollection selectors = new SelectorItemCollection();
                selectors.add(new SelectorItemInfo("position.name"));
                selectors.add(new SelectorItemInfo("adminOrgUnit.name"));
                evi.setSelector(selectors);
                try {
                    PerfFileCollection perfFileColls = PerfFileFactory.getLocalInstance((Context)ctx).getPerfFileCollection(evi);
                    if (perfFileColls != null && !perfFileColls.isEmpty()) {
                        for (PerfFileInfo perfFileInfo : perfFileColls) {
                            perfFileMap.put(perfFileInfo.getId().toString(), perfFileInfo);
                        }
                    }
                }
                catch (BOSException e) {
                    logger.error("get perfFiles err", (Throwable)e);
                }
            }
            HashMap<String, String> personMap = new HashMap<String, String>();
            if (!CollectionUtils.isEmpty(responserIds)) {
                EntityViewInfo evi = new EntityViewInfo();
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("id", responserIds, CompareType.INCLUDE));
                evi.setFilter(filterInfo);
                SelectorItemCollection selectors = new SelectorItemCollection();
                selectors.add(new SelectorItemInfo("id"));
                selectors.add(new SelectorItemInfo("name"));
                evi.setSelector(selectors);
                try {
                    PersonCollection persons = PersonFactory.getLocalInstance((Context)ctx).getPersonCollection(evi);
                    if (persons != null && !persons.isEmpty()) {
                        for (PersonInfo personInfo : persons) {
                            personMap.put(personInfo.getId().toString(), personInfo.getName());
                        }
                    }
                }
                catch (BOSException e) {
                    logger.error("get responsers err", (Throwable)e);
                }
            }
            for (PerfEvaObjectInfo item : list) {
                PerfPeriodInfo periodInfo;
                PerfFileInfo perfFileInfo;
                StringBuffer responses = new StringBuffer();
                PerfEvaluAdminResponsorCollection colls = item.getResponsor();
                if (colls != null && !colls.isEmpty()) {
                    for (PerfEvaluAdminResponsorInfo responsorInfo : colls) {
                        String personId = responsorInfo.getPerson().getId().toString();
                        responses.append((String)personMap.get(personId)).append(",");
                    }
                    responses.setLength(responses.length() - 1);
                }
                item.put("responsor.person.name", (Object)responses.toString());
                perfFileInfo = item.getPerfFile();
                if (perfFileInfo != null && perfFileInfo.getId() != null) {
                    String perfFileId = perfFileInfo.getId().toString();
                    item.put("perffile.position.name", (Object)((PerfFileInfo)perfFileMap.get(perfFileId)).getPosition().getName());
                    item.put("adminorgunit.department.name", (Object)((PerfFileInfo)perfFileMap.get(perfFileId)).getAdminOrgUnit().getName());
                }
                if ((periodInfo = item.getPeriod()) == null) continue;
                item.put("period.name", (Object)periodInfo.getName());
            }
        }
    }

    @Override
    public void afterResultData(Context ctx, Map<String, Object> reMap) {
        reMap.put("selectId", "id");
        reMap.put("selectName", "name");
    }

    @Override
    public void afterGetFieldList(Context ctx, Map map, List<SimpleFieldInfo> fieldList) {
        Boolean isOrg = (Boolean)map.get("isOrg");
        HashSet<String> displayFields = new HashSet<String>();
        displayFields.addAll(Arrays.asList("name", "perffile.position.name", "adminorgunit.department.name"));
        HashSet<String> orgDisplayFields = new HashSet<String>();
        orgDisplayFields.addAll(Arrays.asList("number", "name", "responsor.person.name"));
        HashMap<String, String> orgFieldsName = new HashMap<String, String>();
        orgFieldsName.put("number", SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.ORG_NUMBER, ctx));
        orgFieldsName.put("name", SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.ORG_NAME, ctx));
        for (SimpleFieldInfo fieldInfo : fieldList) {
            if (isOrg.booleanValue() && orgDisplayFields.contains(fieldInfo.getFieldName()) || !isOrg.booleanValue() && displayFields.contains(fieldInfo.getFieldName())) {
                fieldInfo.setDefaultDisplay(true);
                if (fieldInfo.isHidden()) {
                    fieldInfo.setHidden(false);
                }
            }
            String fieldName = fieldInfo.getFieldName();
            if (!isOrg.booleanValue() || !orgFieldsName.containsKey(fieldName)) continue;
            fieldInfo.setShowName((String)orgFieldsName.get(fieldName));
        }
    }

    public String getPrimarySubordinateSQL(String position) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Date now = new Date(System.currentTimeMillis());
        String dt2 = sdf.format(now);
        String selectSuperiorPerson = "select t.FPersonID from T_HR_EmpOrgRelation t  left outer join T_HR_EmpLaborRelation t1     on t.FlaborRelationID = t1.fid   left outer join T_HR_BDEmployeeType t2     on t1.FLaborRelationStateID = t2.fid  inner join T_BD_Person t3     on t.FPersonID = t3.fid where t.FPositionID in ( select fid from t_org_position where FPARENTID ='" + position + "') and t.FLEFFDT>={ts'" + dt2 + "'} and t.FEFFDT<={ts'" + dt2 + "'}   and t2.FinService = 1 ";
        return selectSuperiorPerson;
    }
}

