/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.osf.teamPersonalTarget;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.service.app.IHRMsfService;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.perfweb.app.base.evalplan.GoalsTransmitFacadeFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjectFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjectInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjectUnitGoalsStatusEnum;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjectWFStatusEnum;
import com.kingdee.shr.perfweb.app.base.evalrule.EvaluFormAreaBaseCollection;
import com.kingdee.shr.perfweb.app.base.evalrule.EvaluFormAreaBaseFactory;
import com.kingdee.shr.perfweb.app.base.targetprocess.TargetTransmitBillFacadeFactory;
import com.kingdee.shr.perfweb.app.exception.SHRPerfWebBizException;
import com.kingdee.shr.perfweb.app.resource.SHRPerfWebResource;
import com.kingdee.shr.perfweb.base.serviceImpl.TargetFillService;
import com.kingdee.shr.perfweb.portal.serviceImpl.PerfGoasFillService;
import com.kingdee.shr.perfweb.util.ExceptionUtil;
import com.kingdee.shr.perfweb.util.GetEntityInfoUtils;
import com.kingdee.shr.perfweb.util.PerfPlanExecuteUtils;
import com.kingdee.shr.perfweb.util.SHRPerfWebResourceUtil;
import com.kingdee.shr.perfweb.utils.IndicatorUtils;
import com.kingdee.shr.perfweb.utils.MapUtils;
import com.kingdee.shr.perfweb.utils.OrgAssessmentUtils;
import com.kingdee.shr.perfweb.utils.PerfPlanUtils;
import com.kingdee.shr.perfweb.utils.PermissionUtils;
import com.kingdee.shr.perfweb.utils.PersonBaseUtils;
import com.kingdee.shr.perfweb.utils.RuleHistoryUtils;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.tools.ant.util.ReflectUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoalsfillService
implements IHRMsfService {
    TargetFillService targetFillService = new TargetFillService();
    private static Logger logger = LoggerFactory.getLogger(GoalsfillService.class);
    private static final String ADDTARGET = "addTarget";
    private static final String REFTARGET = "refTarget";
    private static final String SETTARGETWORKFLOW = "setTargetWorkflow";

    public Object process(Context context, Map map) throws EASBizException, BOSException {
        Object showException = map.get("showException");
        String methodName = MapUtils.getParam(map, "methodName");
        if (!StringUtils.isEmpty((CharSequence)methodName)) {
            methodName = methodName + "Action";
        } else {
            HashMap<String, String> result = new HashMap<String, String>();
            result.put("resultFlag", "failure");
            result.put("errorDes", SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.METHODNAMEISNULL, context));
        }
        Map args = (Map)map.get("args");
        Class<?> targetClass = this.getClass();
        Object m1 = null;
        try {
            Object result = ReflectUtil.invoke(targetClass.newInstance(), (String)methodName, Context.class, (Object)context, Map.class, (Object)args);
            if (result instanceof Map) {
                ((Map)result).put("resultFlag", "success");
            }
            return result;
        }
        catch (Exception e) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            if (showException != null && Boolean.valueOf(showException.toString()).booleanValue()) {
                result.put("exception", e.getStackTrace());
            }
            result.put("resultFlag", "failure");
            if (e instanceof EASBizException) {
                result.put("errorDes", e.getMessage());
            } else if (e instanceof InvocationTargetException) {
                Throwable targetException = ((InvocationTargetException)e).getTargetException();
                if (targetException instanceof EASBizException) {
                    result.put("errorDes", targetException.getMessage());
                }
            } else {
                result.put("errorDes", SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.SYSTEMERR, context));
            }
            logger.error("Exception: ", (Throwable)e);
            return result;
        }
    }

    public Object getEareAction(Context ctx, Map map) throws EASBizException, BOSException {
        String evaObj = MapUtils.getParam(map, "evaObj");
        PerfEvaObjectInfo evaInfo = PerfEvaObjectFactory.getLocalInstance((Context)ctx).getPerfEvaObjectInfo("select period.perfRule.id where id = '" + evaObj + "'");
        EvaluFormAreaBaseCollection evaAreaColl = EvaluFormAreaBaseFactory.getLocalInstance((Context)ctx).getEvaluFormAreaBaseCollection("select id,name where performanceRule = '" + evaInfo.getPeriod().getPerfRule().getId().toString() + "'");
        return evaAreaColl;
    }

    public Object getPersonBaseOfGoalsAction(Context ctx, Map map) throws EASBizException, BOSException {
        try {
            Object json = null;
            String evaObj = MapUtils.getParam(map, "evaObj");
            PerfEvaObjectInfo evaObjectInfo = GetEntityInfoUtils.getPerfEvaObjectInfo(ctx, evaObj);
            if (OrgAssessmentUtils.isOrgAssessment(evaObjectInfo)) {
                // empty if block
            }
            return json;
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
            throw new SHRPerfWebBizException(SHRPerfWebBizException.GOALSSUBMITERR);
        }
    }

    public Object addIndicatorForAreaAction(Context ctx, Map map) throws EASBizException, BOSException {
        Map<Object, Object> reMap = new HashMap();
        try {
            reMap = new PerfGoasFillService().addIndicatorForArea(ctx, map);
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
            throw ExceptionUtil.EASBizException(e.getMessage());
        }
        return reMap;
    }

    public Object getEvaTargetAction(Context ctx, Map map) throws EASBizException, BOSException {
        HashMap<String, Object> reMap = new HashMap();
        String getTargetType = "0";
        map.put("getTargetType", getTargetType);
        try {
            reMap = PerfGoasFillService.getInstance().compositeEvaObjectDataAction(ctx, map);
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
            throw ExceptionUtil.EASBizException(e.getMessage());
        }
        RuleHistoryUtils.filterFormArea(ctx, MapUtils.getParam(map, "periodId"), reMap);
        return reMap;
    }

    public Object getPlanFilterAction(Context ctx, Map map) throws EASBizException, BOSException {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        this.targetFillService.getPlanFilter(ctx, resultMap, map);
        return resultMap;
    }

    public Object getEvaObjTargetStatusAction(Context ctx, Map map) throws EASBizException, BOSException {
        String evaObj = MapUtils.getParam(map, "evaObj");
        HashMap<String, Integer> resultMap = new HashMap<String, Integer>();
        PerfEvaObjectInfo evaObjectInfo = GetEntityInfoUtils.getPerfEvaObjectInfo(ctx, evaObj);
        resultMap.put("targetStatus", evaObjectInfo.getPersonalGoalStatus().getValue());
        return resultMap;
    }

    public Object getAreaIndicatorListAction(Context ctx, Map map) throws EASBizException, BOSException, SQLException {
        Map<Object, Object> resultMap = new HashMap();
        resultMap = new PerfGoasFillService().getAreaIndicatorList(ctx, map);
        return resultMap;
    }

    public Object checkCanReviseAction(Context ctx, Map map) throws EASBizException, BOSException {
        String evaObj = MapUtils.getParam(map, "evaObj");
        HashMap<String, Boolean> resultMap = new HashMap<String, Boolean>();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)evaObj, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("personalGoalStatus", (Object)3, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("workFlowStatus", (Object)0, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("workFlowStatus IS NULL"));
        filter.setMaskString("#0 and #1 and (#2 or #3)");
        if (PerfEvaObjectFactory.getLocalInstance((Context)ctx).exists(filter)) {
            resultMap.put("flag", true);
        } else {
            resultMap.put("flag", false);
        }
        return resultMap;
    }

    public Object submitPersonalTargetAction(Context ctx, Map map) throws EASBizException, BOSException {
        String evaObj = MapUtils.getParam(map, "evaObj");
        String periodId = MapUtils.getParam(map, "periodId");
        String submitType = MapUtils.getParam(map, "submitType");
        Map<String, Object> resultMap = null;
        try {
            resultMap = new PerfGoasFillService().submitPersonalTarget(ctx, evaObj, periodId, submitType);
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
            throw new SHRPerfWebBizException(SHRPerfWebBizException.GOALSSUBMITERR);
        }
        return resultMap;
    }

    public Object addIndicatorByReferenceAction(Context ctx, Map map) throws EASBizException, BOSException {
        HashMap<String, Object> res = new HashMap<String, Object>();
        try {
            List<String> successIds = IndicatorUtils.fiiIndicatorByReference(ctx, map);
            res.put("successIds", successIds);
            res.put("result", "OK");
        }
        catch (BOSException e) {
            res.put("result", "FAILED");
            logger.error("BOSException: ", (Throwable)e);
            throw new SHRPerfWebBizException(SHRPerfWebBizException.REFERINDECTORLIBERR);
        }
        return res;
    }

    public Object isOperatePermittedAction(Context ctx, Map map) throws EASBizException, BOSException {
        String evaObj = MapUtils.getParam(map, "evaObj");
        HashMap res = new HashMap();
        PerfEvaObjectInfo evaObjInfo = PersonBaseUtils.getPerfEvaObjInfo(ctx, evaObj);
        if (evaObjInfo == null) {
            logger.error("\u3010PERFWEB\u3011evaObj doesn't exist, evaObjId:" + evaObj);
            throw new SHRPerfWebBizException(SHRPerfWebBizException.EVALUINVALID);
        }
        if (PerfEvaObjectUnitGoalsStatusEnum.UNASSIGN.equals((Object)evaObjInfo.getUnitGoalsStatus())) {
            logger.error("\u3010PERFWEB\u3011evaObj has been revoked united target, evaObjId:" + evaObj);
            throw new SHRPerfWebBizException(SHRPerfWebBizException.UNIFIEGOALSTRANSMITCANCELED);
        }
        if (PerfEvaObjectWFStatusEnum.STOPED.equals((Object)evaObjInfo.getWorkFlowStatus()) || PerfEvaObjectWFStatusEnum.COMPLETED.equals((Object)evaObjInfo.getWorkFlowStatus())) {
            logger.error("\u3010PERFWEB\u3011workflow is over, evaObjId:" + evaObj);
            throw new SHRPerfWebBizException(SHRPerfWebBizException.WORKFLOWENDEDORSTOPPED);
        }
        return res;
    }

    public Object getPerfEvaObjMsgAction(Context ctx, Map map) throws EASBizException, BOSException {
        HashMap<String, Integer> res = new HashMap<String, Integer>(8);
        String evaObj = MapUtils.getParam(map, "evaObj");
        try {
            PerfEvaObjectInfo evaObjInfo = GetEntityInfoUtils.getPerfEvaObjectInfo(ctx, evaObj);
            res.put("canAdjustEvaluer", evaObjInfo.getCanAdjustEvaluer().getValue());
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
            throw new SHRPerfWebBizException(SHRPerfWebBizException.GETEVAOBJMATRIXATTRERR);
        }
        return null;
    }

    public Object detectAreaIndicatorWeightAction(Context ctx, Map map) throws EASBizException, BOSException {
        HashMap<String, String> result = new HashMap<String, String>();
        String periodId = MapUtils.getParam(map, "periodId");
        String evaObj = MapUtils.getParam(map, "evaObj");
        result.put("resultFlag", "failed");
        String detectedResult = IndicatorUtils.detectAreaIndicatorWeight(ctx, periodId, evaObj);
        if ("200".equalsIgnoreCase(detectedResult)) {
            result.put("resultFlag", "success");
        }
        return result;
    }

    public Object compositeOtherPeriodEvaObjectDataAction(Context ctx, Map map) throws EASBizException, BOSException {
        String sql;
        Map<String, Object> reMap = null;
        String isOrg = (String)map.get("isOrg");
        Object[] params = null;
        if ("1".equals(isOrg)) {
            sql = "select top 1 obj.FID fid from T_EVA_PerfEvaObject obj left join T_EVA_PerfEvaObject fileObj on obj.FEvaluOrgAdminID = fileObj.FEvaluOrgAdminID where fileObj.FID =? and obj.FPeriodID =?";
            params = new Object[]{map.get("evaObj"), map.get("period")};
        } else {
            sql = "select top 1 obj.FID fid from T_EVA_PerfEvaObject obj left join T_EVA_PerfEvaObject fileObj on obj.FPersonID = fileObj.FPersonID where fileObj.FPersonID =? and obj.FPeriodID =?";
            params = new Object[]{map.get("personId"), map.get("period")};
        }
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params);
            String evaObjId = "";
            while (rs.next()) {
                evaObjId = rs.getString("fid");
            }
            map.put("evaObj", evaObjId);
            map.put("getTargetType", "0");
            reMap = PerfGoasFillService.getInstance().compositeEvaObjectDataAction(ctx, map);
            RuleHistoryUtils.filterFormArea(ctx, MapUtils.getParam(map, "thisPeriod"), reMap);
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
            throw new SHRPerfWebBizException(SHRPerfWebBizException.LOADEVAOBJEVARESULTERR);
        }
        return reMap;
    }

    public Object judgeIsRefTargetAction(Context ctx, Map param) throws EASBizException, BOSException {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            String indicatorId = MapUtils.getParam(param, "indicatorId");
            String isUnited = MapUtils.getParam(param, "isUnited");
            if (StringUtils.isEmpty((CharSequence)isUnited)) {
                isUnited = "0";
            }
            map.put("result", "200");
            map.put("isRefTarget", "0");
            if (!StringUtils.isEmpty((CharSequence)indicatorId)) {
                if ("0".equals(isUnited)) {
                    IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)"select frefTarget from T_EVA_IndicatorTarget where fid = ? union select frefTarget from T_EVA_RecordTarget where fid = ?", (Object[])new Object[]{indicatorId, indicatorId});
                    if (iRowSet != null && iRowSet.next() && !StringUtils.isEmpty((CharSequence)iRowSet.getString("frefTarget"))) {
                        map.put("isRefTarget", "1");
                    }
                } else {
                    IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)"select frefTarget from T_EVA_UniteIndicator where fid = ? union select frefTarget from T_EVA_UniteRecord where fid = ?", (Object[])new Object[]{indicatorId, indicatorId});
                    if (iRowSet != null && iRowSet.next() && !StringUtils.isEmpty((CharSequence)iRowSet.getString("frefTarget"))) {
                        map.put("isRefTarget", "1");
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
            throw new SHRPerfWebBizException(SHRPerfWebBizException.GETINDICATORREFERROR);
        }
        return map;
    }

    public Object initDataAction(Context ctx, Map map) throws EASBizException, BOSException {
        HashMap<String, Boolean> reMap = new HashMap<String, Boolean>();
        boolean addTarget = PermissionUtils.hasFunctionPermission(ctx, ADDTARGET);
        reMap.put(ADDTARGET, addTarget);
        boolean refTarget = PermissionUtils.hasFunctionPermission(ctx, REFTARGET);
        reMap.put(REFTARGET, refTarget);
        boolean setTargetWorkflow = PermissionUtils.hasFunctionPermission(ctx, SETTARGETWORKFLOW);
        reMap.put(SETTARGETWORKFLOW, setTargetWorkflow);
        return reMap;
    }

    public Object deleteIndicatorOrRecordAction(Context ctx, Map param) throws EASBizException, BOSException {
        String todeleteId = MapUtils.getParam(param, "todeleteId");
        String evaObj = MapUtils.getParam(param, "evaObj");
        HashMap<String, String> res = new HashMap<String, String>();
        String filter = "('" + todeleteId + "')";
        if (PerfPlanUtils.deleteIndicatorTarget(ctx, filter, evaObj)) {
            try {
                float weight = PerfPlanExecuteUtils.calculateEvaObjTargetWeight(ctx, evaObj);
                GoalsTransmitFacadeFactory.getLocalInstance((Context)ctx).writeBackEvaObjGoalsPercent(evaObj, String.valueOf(weight));
                res.put("result", "200");
                res.put("msg", "delete indicator success\uff01");
            }
            catch (BOSException e) {
                res.put("result", "500");
                res.put("msg", "delete indicator fail\uff01");
                logger.error("BOSException: ", (Throwable)e);
            }
        } else {
            res.put("result", "500");
            res.put("msg", "delete indicator fail\uff01");
        }
        return res;
    }

    public Object saveTargetAction(Context ctx, Map param) throws EASBizException, BOSException {
        int scoringWay = 0;
        if (param != null) {
            if (param.get("scoringWay") != null) {
                scoringWay = Integer.valueOf((String)param.get("scoringWay"));
            }
            param.put("scoringWay", scoringWay);
        } else if (logger.isDebugEnabled()) {
            logger.error("[PERFWEB]it is faild to get param");
        }
        return PerfGoasFillService.getInstance().saveTarget(ctx, param);
    }

    public Object saveRefExistIndicatorAction(Context ctx, Map param) throws EASBizException, BOSException {
        Map<String, Object> resultMap;
        try {
            resultMap = PerfGoasFillService.getInstance().saveRefExistIndicator(ctx, param, "1");
            float weight = PerfPlanExecuteUtils.calculateEvaObjTargetWeight(ctx, String.valueOf(param.get("evaObj")));
            GoalsTransmitFacadeFactory.getLocalInstance((Context)ctx).writeBackEvaObjGoalsPercent(String.valueOf(param.get("evaObj")), String.valueOf(weight));
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
            throw ExceptionUtil.EASBizException(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.INDICATORREFERENCEERROR, ctx));
        }
        return resultMap;
    }

    public Object getTargetTransmitBillAction(Context ctx, Map param) throws EASBizException, BOSException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("result", "200");
        result.put("billId", "");
        result.put("state", 0);
        String evaObj = (String)param.get("evaObj");
        Map billByEvaObj = TargetTransmitBillFacadeFactory.getLocalInstance((Context)ctx).getBillByEvaObj(evaObj);
        if (billByEvaObj != null) {
            result.put("billId", billByEvaObj.get("billId"));
            result.put("billState", billByEvaObj.get("billState"));
            result.put("state", billByEvaObj.get("state"));
        }
        return result;
    }
}

