/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.util;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.message.BMCMessageFactory;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.weibo.util.HttpClientTool;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.bireport.bimanager.ws.paramCtx.util.Strings;
import com.kingdee.shr.base.syssetting.CloudHubMessageFacadeFactory;
import com.kingdee.shr.base.syssetting.cloud.http.HttpResultVo;
import com.kingdee.shr.perfweb.app.base.evalplan.IPerfSMSRecord;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEmailConfigInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfSMSFailureTypeEnum;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfSMSRecordFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfSMSRecordInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfSMSResendEnum;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfSMSStatusEnum;
import com.kingdee.shr.perfweb.app.resource.SHRPerfWebResource;
import com.kingdee.shr.perfweb.base.serviceImpl.SendUrgeMessageService;
import com.kingdee.shr.perfweb.bean.MsgConfigBean;
import com.kingdee.shr.perfweb.bean.ReMsgBean;
import com.kingdee.shr.perfweb.util.GetEntityInfoUtils;
import com.kingdee.shr.perfweb.util.NoticeUtils;
import com.kingdee.shr.perfweb.util.SHRPerfWebResourceUtil;
import com.kingdee.shr.perfweb.utils.CurrentUserUtil;
import com.kingdee.shr.perfweb.utils.EmailUtils;
import com.kingdee.shr.perfweb.utils.PerfPropertiesUtils;
import com.kingdee.shr.perfweb.utils.SmsUtils;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendMessageService {
    public static BlockingDeque<ReMsgBean> msgQueue = new LinkedBlockingDeque<ReMsgBean>();
    private static Logger logger = LoggerFactory.getLogger(SendMessageService.class);
    private static String phoneToken = null;
    private static String phoneSignature = null;
    private static String apiUrl = null;

    public static void consumeMsg(Context ctx) {
        block23: {
            if (logger.isDebugEnabled()) {
                logger.debug("[perfweb]:SendMessageService:msg consume start!");
            }
            PerfEmailConfigInfo perfEmailConfInfo = GetEntityInfoUtils.getAndUpdateCurrentUsePerfEmailConfigInfo(ctx);
            boolean isEmailNetwork = false;
            if (null != perfEmailConfInfo && !Strings.isEmpty((String)perfEmailConfInfo.getEmailServer()) && !Strings.isEmpty((String)perfEmailConfInfo.getPort())) {
                isEmailNetwork = EmailUtils.judgeUrlIsReachable(perfEmailConfInfo.getEmailServer(), Integer.parseInt(perfEmailConfInfo.getPort()));
            }
            CoreBaseCollection coreColl = new CoreBaseCollection();
            while (!msgQueue.isEmpty()) {
                ReMsgBean msgBean = null;
                try {
                    MsgConfigBean config;
                    block22: {
                        block21: {
                            block20: {
                                msgBean = msgQueue.take();
                                if (msgBean == null || (config = msgBean.getConfig()) == null) continue;
                                if (config.isYzjType()) {
                                    try {
                                        String personId = msgBean.getReceiver().getId().toString();
                                        UserCollection userColl = CurrentUserUtil.getUserCollByPersonId(ctx, personId);
                                        HttpResultVo httpResultVo = (HttpResultVo)CloudHubMessageFacadeFactory.getLocalInstance((Context)ctx).sendTextMessageToUser(msgBean.getYzjContent(), userColl, "perfwebNotice", false);
                                    }
                                    catch (Exception e) {
                                        if (!logger.isDebugEnabled()) break block20;
                                        logger.error("[perfweb]:SendMessageService:send yzjMessage err!", (Throwable)e);
                                    }
                                }
                            }
                            if (config.isEmailType() && isEmailNetwork) {
                                boolean emailFlag = false;
                                try {
                                    emailFlag = SendUrgeMessageService.sendEmailService(ctx, msgBean.getReceiver().getEmail(), msgBean.getEmailTitle(), msgBean.getEmailContent(), perfEmailConfInfo);
                                    if (logger.isDebugEnabled()) {
                                        logger.info("[perfweb]:SendMessageService:send emailMessage " + emailFlag + "!");
                                    }
                                }
                                catch (Exception e) {
                                    if (!logger.isDebugEnabled()) break block21;
                                    logger.error("[perfweb]:SendMessageService:send emailMessage " + emailFlag, (Throwable)e);
                                }
                            }
                        }
                        if (config.isSmsType()) {
                            boolean smsFlag = false;
                            try {
                                HashMap<String, Object> otherParams = new HashMap<String, Object>();
                                otherParams.put("evaObjId", msgBean.get("evaObjId"));
                                otherParams.put("hrOrgUnitId", msgBean.get("hrOrgUnitId"));
                                smsFlag = SendUrgeMessageService.sendSMSService(ctx, msgBean.getReceiver().getCell(), config.getPhoneContent(), config.getSmsTemplateCode(), otherParams);
                                if (logger.isDebugEnabled()) {
                                    logger.info("[perfweb]:SendMessageService:send smsMessage " + smsFlag + "!");
                                }
                            }
                            catch (Exception e) {
                                if (!logger.isDebugEnabled()) break block22;
                                logger.error("[perfweb]:SendMessageService:send smsMessage " + smsFlag, (Throwable)e);
                            }
                        }
                    }
                    if (!config.isSysType()) continue;
                    NoticeUtils.sendNoticesToPortal(ctx, msgBean, "100", coreColl);
                }
                catch (Exception e) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.error("[perfweb]:SendMessageService:msg consume err!", (Throwable)e);
                }
            }
            try {
                if (!coreColl.isEmpty()) {
                    BMCMessageFactory.getLocalInstance((Context)ctx).saveBatchData(coreColl);
                    NoticeUtils.expireMessage(ctx, coreColl);
                }
            }
            catch (Exception e) {
                if (!logger.isDebugEnabled()) break block23;
                logger.error("[perfweb]:SendMessageService:save sysMessage err!", (Throwable)e);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.info("[perfweb]:SendMessageService:msg consume end!");
        }
    }

    public boolean SendSMS(Context ctx, String token, String signature, String phone, String content, String perfSmsCode, Map otherParams) {
        return this.callSendSafeSMSService(ctx, phone, content, perfSmsCode, otherParams);
    }

    public boolean SendSMS(Context ctx, String phone, String content, String perfSmsCode, Map otherParams) {
        String token = "";
        String signature = "";
        return this.SendSMS(ctx, token, signature, phone, content, perfSmsCode, otherParams);
    }

    @Deprecated
    private boolean callSendSMSService(Context ctx, String token, String signature, String phone, String content, String perfSmsCode) {
        PerfSMSRecordInfo perfSMSRecordInfo = new PerfSMSRecordInfo();
        perfSMSRecordInfo.setSendPerson("");
        perfSMSRecordInfo.setRecipientPhone(phone);
        perfSMSRecordInfo.setMessageInfo(content);
        perfSMSRecordInfo.setServiceId(perfSmsCode);
        perfSMSRecordInfo.setResend(PerfSMSResendEnum.NORESEND);
        perfSMSRecordInfo.setSendTimes(1);
        IPerfSMSRecord iPerfSMSRecord = null;
        try {
            iPerfSMSRecord = PerfSMSRecordFactory.getLocalInstance((Context)ctx);
        }
        catch (BOSException e2) {
            logger.error("", (Throwable)e2);
        }
        HashMap resultMap = new HashMap();
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap<String, String> map1 = new HashMap<String, String>();
        HashMap<String, String> map2 = new HashMap<String, String>();
        if (phoneToken == null) {
            Map<String, String> properties = PerfPropertiesUtils.getPropertiesByKey(ctx, "SendMessageService");
            phoneToken = properties.get("SendMessageService.phoneToken");
            phoneSignature = properties.get("SendMessageService.phoneSignature");
            apiUrl = properties.get("SendMessageService.apiUrl");
        }
        map1.put("token", phoneToken);
        map1.put("signature", phoneSignature);
        map2.put("phone", phone);
        map2.put("content", content);
        map2.put("perfSmsCode", perfSmsCode);
        String map1str = JSONObject.toJSONString(map1);
        String map2str = JSONObject.toJSONString(map2);
        map.put("checkinfo", map1str);
        map.put("sms", map2str);
        Map response = HttpClientTool.httpPost((String)apiUrl, map);
        Object result = response.get("HTTP_CLIENT_USER_RESULT");
        if (result == null || result.equals("") || result.toString().length() == 0) {
            perfSMSRecordInfo.setFailureType(PerfSMSFailureTypeEnum.SYSFAILURE);
            perfSMSRecordInfo.setSendFailureInfo("HttpClient request failed\uff01");
            perfSMSRecordInfo.setSendFailureCode("40401");
            perfSMSRecordInfo.setStatus(PerfSMSStatusEnum.FAILURE);
            try {
                iPerfSMSRecord.addnew(perfSMSRecordInfo);
            }
            catch (Exception e) {
                return false;
            }
        }
        if (result != null && result.toString() != null) {
            try {
                JSONObject objResult = JSONObject.parseObject((String)result.toString());
                String is_success = objResult.get((Object)"is_success").toString();
                if (is_success.equals("no_success")) {
                    if (objResult.get((Object)"message") != null && objResult.get((Object)"message").toString().length() > 0) {
                        perfSMSRecordInfo.setSendFailureInfo(objResult.get((Object)"message").toString());
                        perfSMSRecordInfo.setSendFailureCode(objResult.get((Object)"code").toString());
                    } else {
                        perfSMSRecordInfo.setSendFailureInfo(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.SENDSMSERR, ctx));
                        perfSMSRecordInfo.setSendFailureCode("50501");
                    }
                    perfSMSRecordInfo.setFailureType(PerfSMSFailureTypeEnum.SMSFAILURE);
                    perfSMSRecordInfo.setStatus(PerfSMSStatusEnum.FAILURE);
                }
                if (is_success.equals("success")) {
                    if (objResult.get((Object)"uuid") != null && objResult.get((Object)"uuid").toString().length() > 0) {
                        perfSMSRecordInfo.setSendRecordId(objResult.get((Object)"uuid").toString());
                    }
                    perfSMSRecordInfo.setStatus(PerfSMSStatusEnum.SUCCESS);
                }
            }
            catch (Exception e) {
                perfSMSRecordInfo.setFailureType(PerfSMSFailureTypeEnum.OTHERFAILUER);
                perfSMSRecordInfo.setSendFailureInfo(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.JSONPARSERETUNINFOERR, ctx));
                perfSMSRecordInfo.setSendFailureCode("70701");
                perfSMSRecordInfo.setStatus(PerfSMSStatusEnum.FAILURE);
                try {
                    iPerfSMSRecord.addnew(perfSMSRecordInfo);
                    return false;
                }
                catch (Exception e1) {
                    logger.error("", (Throwable)e1);
                    return false;
                }
            }
            try {
                iPerfSMSRecord.addnew(perfSMSRecordInfo);
            }
            catch (Exception e) {
                logger.error("Exception: ", (Throwable)e);
                return false;
            }
        }
        return true;
    }

    private boolean callSendSafeSMSService(Context ctx, String phone, String content, String perfSmsCode, Map<String, String> otherParams) {
        PerfSMSRecordInfo perfSMSRecordInfo = new PerfSMSRecordInfo();
        perfSMSRecordInfo.setSendPerson("");
        perfSMSRecordInfo.setRecipientPhone(phone);
        perfSMSRecordInfo.setMessageInfo(content);
        perfSMSRecordInfo.setServiceId(perfSmsCode);
        perfSMSRecordInfo.setResend(PerfSMSResendEnum.NORESEND);
        perfSMSRecordInfo.setSendTimes(1);
        IPerfSMSRecord iPerfSMSRecord = null;
        try {
            iPerfSMSRecord = PerfSMSRecordFactory.getLocalInstance((Context)ctx);
        }
        catch (BOSException e2) {
            logger.error("", (Throwable)e2);
        }
        HashMap resultMap = new HashMap();
        HashMap<String, String> param = new HashMap<String, String>();
        Map<String, String> properties = PerfPropertiesUtils.getPropertiesByKey(ctx, "SendMessageService");
        String apiUrl = properties.get("SendMessageService.apiUrl");
        String sendMode = properties.get("SendMessageService.sendMode");
        param.put("phone", phone);
        param.put("content", content);
        param.put("perfSmsCode", perfSmsCode);
        param.put("apiUrl", apiUrl);
        param.put("sendMode", sendMode);
        if (otherParams != null) {
            param.put("hrOrgUnitId", otherParams.get("hrOrgUnitId"));
            param.put("evaObjId", otherParams.get("evaObjId"));
        }
        Map response = SmsUtils.smsHttpPost(ctx, param);
        boolean sendFlag = true;
        String result = (String)response.get("HTTP_CLIENT_USER_RESULT");
        if (StringUtils.isEmpty((String)result)) {
            perfSMSRecordInfo.setFailureType(PerfSMSFailureTypeEnum.SYSFAILURE);
            perfSMSRecordInfo.setSendFailureInfo((String)response.get("errormsg"));
            perfSMSRecordInfo.setSendFailureCode("40401");
            perfSMSRecordInfo.setStatus(PerfSMSStatusEnum.FAILURE);
            sendFlag = false;
        } else {
            try {
                logger.error("[perfweb]SendMessageService#callSendSafeSMSService result:" + result);
                JSONObject objResult = JSONObject.parseObject((String)result);
                Object errorcode = objResult.get((Object)"errorcode");
                if (errorcode == null || !"0".equals(String.valueOf(errorcode))) {
                    String errormsg = objResult.getString("errormsg");
                    if (!StringUtils.isEmpty((String)errormsg)) {
                        perfSMSRecordInfo.setSendFailureInfo(errormsg.toString());
                        perfSMSRecordInfo.setSendFailureCode(String.valueOf(errorcode));
                    } else {
                        perfSMSRecordInfo.setSendFailureInfo(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.SENDSMSERR, ctx));
                        perfSMSRecordInfo.setSendFailureCode("50501");
                    }
                    perfSMSRecordInfo.setFailureType(PerfSMSFailureTypeEnum.SMSFAILURE);
                    perfSMSRecordInfo.setStatus(PerfSMSStatusEnum.FAILURE);
                    sendFlag = false;
                } else {
                    Object uuid = objResult.get((Object)"data");
                    perfSMSRecordInfo.setSendRecordId(String.valueOf(uuid));
                    perfSMSRecordInfo.setStatus(PerfSMSStatusEnum.SUCCESS);
                }
            }
            catch (Exception e) {
                if (logger.isDebugEnabled()) {
                    logger.error("[perfweb] it is failed to SendMessageService#callSendSafeSMSService", (Throwable)e);
                }
                perfSMSRecordInfo.setFailureType(PerfSMSFailureTypeEnum.OTHERFAILUER);
                perfSMSRecordInfo.setSendFailureInfo(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.JSONPARSERETUNINFOERR, ctx));
                perfSMSRecordInfo.setSendFailureCode("70701");
                perfSMSRecordInfo.setStatus(PerfSMSStatusEnum.FAILURE);
                sendFlag = false;
            }
            try {
                iPerfSMSRecord.addnew(perfSMSRecordInfo);
            }
            catch (Exception e) {
                logger.error("[perfweb] it is failed to add perfSmsRecord after do SendMessageService#callSendSafeSMSService!", (Throwable)e);
            }
        }
        return sendFlag;
    }
}

