/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.AchivementDataEntriorCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.AchivementDataEntriorFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.AchivementDataEntryStateEnum;
import com.kingdee.shr.perfweb.app.base.evalplan.EvaPeriodStatusEnum;
import com.kingdee.shr.perfweb.app.base.evalplan.EvaResultSummaryFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.EvaResultSummaryInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.IAchivementDataEntrior;
import com.kingdee.shr.perfweb.app.base.evalplan.IIndicatorTarget;
import com.kingdee.shr.perfweb.app.base.evalplan.IPerfEvaObject;
import com.kingdee.shr.perfweb.app.base.evalplan.IndicatorTargetCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.IndicatorTargetFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.IndicatorTargetInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.OrgEvaResultSummaryFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.OrgEvaResultSummaryInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjectFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjectInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjectWFStatusEnum;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfPeriodInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.ScoreTaskStatusEnum;
import com.kingdee.shr.perfweb.app.base.evalrule.WFNodeDefCollection;
import com.kingdee.shr.perfweb.app.base.evalrule.WFNodeDefInfo;
import com.kingdee.shr.perfweb.app.common.YesOrNoEnum;
import com.kingdee.shr.perfweb.app.resource.SHRPerfWebResource;
import com.kingdee.shr.perfweb.app.workflow.CanEditEnum;
import com.kingdee.shr.perfweb.app.workflow.ConcurrentNodeStatusEnum;
import com.kingdee.shr.perfweb.app.workflow.GradeTaskNodeInstCollection;
import com.kingdee.shr.perfweb.app.workflow.GradeTaskNodeInstFactory;
import com.kingdee.shr.perfweb.app.workflow.GradeTaskNodeInstInfo;
import com.kingdee.shr.perfweb.app.workflow.IGradeTaskNodeInst;
import com.kingdee.shr.perfweb.app.workflow.IWorkFlowJumpRecord;
import com.kingdee.shr.perfweb.app.workflow.IsEffectiveEnum;
import com.kingdee.shr.perfweb.app.workflow.IsVisibleEnum;
import com.kingdee.shr.perfweb.app.workflow.ScoreStatusEnum;
import com.kingdee.shr.perfweb.app.workflow.TaskStatusEnum;
import com.kingdee.shr.perfweb.app.workflow.WeightAccuTypeEnum;
import com.kingdee.shr.perfweb.app.workflow.WorkFlowJumpRecordFactory;
import com.kingdee.shr.perfweb.app.workflow.WorkFlowJumpRecordInfo;
import com.kingdee.shr.perfweb.util.GetEntityInfoUtils;
import com.kingdee.shr.perfweb.util.SHRPerfWebResourceUtil;
import com.kingdee.shr.perfweb.util.WorkFlowUtils;
import com.kingdee.shr.perfweb.utils.PerfwebStrUtils;
import com.kingdee.shr.perfweb.workflow.serviceImpl.WorkFlowEngine;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowJumpUtils {
    private static Logger logger = LoggerFactory.getLogger((String)"com.kingdee.shr.perfweb.util.WorkflowJumpUtils");

    public static Map<String, String> dealWorkflowJump(Context ctx, int jumpargs, String evaObj, String jumreason) {
        return WorkflowJumpUtils.dealWorkflowJump(ctx, jumpargs, evaObj, jumreason, false);
    }

    public static Map<String, String> dealWorkflowJump(Context ctx, int jumpargs, String evaObj, String jumreason, boolean showInEvaReport) {
        HashMap<String, String> res = new HashMap<String, String>();
        GradeTaskNodeInstCollection gradeTaskNodeInstColl = null;
        try {
            IGradeTaskNodeInst iGradeTaskNodeInst = GradeTaskNodeInstFactory.getLocalInstance((Context)ctx);
            gradeTaskNodeInstColl = iGradeTaskNodeInst.getGradeTaskNodeInstCollection(" where evaObj='" + evaObj + "' and isEffective='" + "1" + "' and scoreStatus='" + "1" + "' and taskStatus='" + "1" + "' order by wfLevel asc");
        }
        catch (BOSException e1) {
            logger.error("", (Throwable)e1);
        }
        WFNodeDefInfo wfNodeDefInfo = GetEntityInfoUtils.getWFNodeDefInfo(ctx, gradeTaskNodeInstColl.get(0).getWfNode().getId().toString());
        if (null == gradeTaskNodeInstColl || gradeTaskNodeInstColl.size() < 1) {
            res.put("result", "500");
            res.put("message", SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.JUMPERRASJUMPABLEWORKFLOWNOTFOUND, ctx));
            return res;
        }
        int wfLevel = gradeTaskNodeInstColl.get(0).getWfLevel();
        GradeTaskNodeInstCollection currentGradeTaskNodeInstColl = GetEntityInfoUtils.getGradeTaskNodeInstCollByEvaObjAndNodeLevel(ctx, evaObj, wfLevel, wfNodeDefInfo.getWorkflow().getId().toString());
        int currentSubmitSize = 0;
        int currentGradeTaskNodeSize = currentGradeTaskNodeInstColl.size();
        for (int i = 0; i < currentGradeTaskNodeSize; ++i) {
            String scoreStatus = currentGradeTaskNodeInstColl.get(i).getScoreStatus().getValue();
            if (!scoreStatus.equals("2")) continue;
            ++currentSubmitSize;
        }
        if (currentSubmitSize == currentGradeTaskNodeSize) {
            res.put("result", "500");
            res.put("message", SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.ALLNODEHANDLERSUBMITTEDINCURRENTWORKFLOW, ctx));
            return res;
        }
        GradeTaskNodeInstCollection nextGradeTaskNodeInstColl = GetEntityInfoUtils.getGradeTaskNodeInstCollByEvaObjAndNodeLevel(ctx, evaObj, wfLevel + 1, wfNodeDefInfo.getWorkflow().getId().toString());
        if (null == nextGradeTaskNodeInstColl || nextGradeTaskNodeInstColl.size() < 1) {
            res.put("result", "500");
            res.put("message", SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.JUMPINVLIDASFINALWORKFLOW, ctx));
            return res;
        }
        WFNodeDefCollection wfNodeDefColl = GetEntityInfoUtils.getWfNodeDefColl(ctx, wfNodeDefInfo.getWorkflow().getId().toString(), wfLevel);
        if (null != wfNodeDefColl && wfNodeDefColl.size() > 0) {
            int wfNodeSize = wfNodeDefColl.size();
            BigDecimal sumNodeWeight = new BigDecimal("0");
            for (int i = 0; i < wfNodeSize; ++i) {
                sumNodeWeight = sumNodeWeight.add(new BigDecimal(wfNodeDefColl.get(i).getNodeWeight()));
            }
            WorkflowJumpUtils.dealJumpGradNode(ctx, currentGradeTaskNodeInstColl, nextGradeTaskNodeInstColl, wfNodeDefInfo, evaObj, jumpargs, sumNodeWeight);
        }
        try {
            IWorkFlowJumpRecord iWorkFlowJumpRecord = WorkFlowJumpRecordFactory.getLocalInstance((Context)ctx);
            WorkFlowJumpRecordInfo wfJumpRecordInfo = new WorkFlowJumpRecordInfo();
            wfJumpRecordInfo.put("evaObj", (Object)evaObj);
            wfJumpRecordInfo.setWfLevelDef(gradeTaskNodeInstColl.get(0).getWfLevelDef());
            wfJumpRecordInfo.setWfLevel(wfLevel);
            wfJumpRecordInfo.setWeightAccuType(WeightAccuTypeEnum.getEnum((int)jumpargs));
            wfJumpRecordInfo.setJumpReason(jumreason);
            wfJumpRecordInfo.setShowInEvaReport(showInEvaReport);
            iWorkFlowJumpRecord.addnew(wfJumpRecordInfo);
        }
        catch (Exception e) {
            logger.error("\u3010PERFWEB\u3011-SAVEJUMPLOGERR\uff01", (Throwable)e);
        }
        res.put("result", "200");
        res.put("message", SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.WORKFLOWJUMPSUCCESS, ctx));
        return res;
    }

    protected static void dealJumpGradNode(Context ctx, GradeTaskNodeInstCollection currentGradeTaskNodeInstColl, GradeTaskNodeInstCollection nextGradeTaskNodeInstColl, WFNodeDefInfo wfNodeDefInfo, String evaObj, int jumpargs, BigDecimal sumNodeWeight) {
        try {
            String workflow = wfNodeDefInfo.getWorkflow().getId().toString();
            int level = wfNodeDefInfo.getLevel() + 1;
            WFNodeDefCollection wfNodeDefColl = GetEntityInfoUtils.getWfNodeDefColl(ctx, workflow, level);
            if (jumpargs == 0) {
                WorkflowJumpUtils.setCurrentGadeTaskNodeInvalid(ctx, currentGradeTaskNodeInstColl, WeightAccuTypeEnum.AVERAGETONEXT);
                sumNodeWeight = WorkflowJumpUtils.getCurrentNodeOutWeight(ctx, wfNodeDefInfo, evaObj);
                WorkflowJumpUtils.asignWeightToNextGadeTaskNodeOfAverage(ctx, evaObj, wfNodeDefInfo, sumNodeWeight);
            } else if (jumpargs == 1) {
                WorkflowJumpUtils.setCurrentGadeTaskNodeInvalid(ctx, currentGradeTaskNodeInstColl, WeightAccuTypeEnum.PROPORTIONTONEXT);
                sumNodeWeight = WorkflowJumpUtils.getCurrentNodeOutWeight(ctx, wfNodeDefInfo, evaObj);
                WorkflowJumpUtils.asignWeightToNextGadeTaskNodeOfProportion(ctx, evaObj, wfNodeDefColl, sumNodeWeight);
            } else if (jumpargs == 2) {
                WorkflowJumpUtils.setCurrentGadeTaskNodeInvalid(ctx, currentGradeTaskNodeInstColl, WeightAccuTypeEnum.UNCUMUTONEXT_CURISEFFECT);
                WorkflowJumpUtils.asignWeightAverageToCurrentLevelOtherNode(ctx, evaObj, wfNodeDefInfo);
            }
            WorkFlowEngine.getInstance().activeNodeInst(ctx, evaObj, level, workflow);
            PerfEvaObjectInfo perfEvaObjectInfo = GetEntityInfoUtils.getPerfEvaObjectInfo(ctx, evaObj);
            if (WorkFlowEngine.getInstance().isNodeHandUp(ctx, evaObj, level)) {
                WorkFlowUtils.writeBackWorkFlowStatusForEvaObj(ctx, perfEvaObjectInfo, PerfEvaObjectWFStatusEnum.HANGUP);
            } else {
                WorkFlowUtils.writeBackWorkFlowStatusForEvaObj(ctx, perfEvaObjectInfo, PerfEvaObjectWFStatusEnum.UNDERWAY);
            }
            IPerfEvaObject iPerfEvaObject = PerfEvaObjectFactory.getLocalInstance((Context)ctx);
            iPerfEvaObject.urgedGradeSendSuccess(evaObj);
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
        }
    }

    protected static void setCurrentGadeTaskNodeInvalid(Context ctx, GradeTaskNodeInstCollection currentGradeTaskNodeInstColl, WeightAccuTypeEnum weightAccuTypeEnum) {
        try {
            IGradeTaskNodeInst iGradeTaskNodeInst = GradeTaskNodeInstFactory.getLocalInstance((Context)ctx);
            CoreBaseCollection currentCoreBaseColl = new CoreBaseCollection();
            int size = currentGradeTaskNodeInstColl.size();
            for (int i = 0; i < size; ++i) {
                BigDecimal outWeight = new BigDecimal("0");
                GradeTaskNodeInstInfo gradeTaskNodeInfo = currentGradeTaskNodeInstColl.get(i);
                outWeight = outWeight.add(new BigDecimal(gradeTaskNodeInfo.getNodeWeight()));
                gradeTaskNodeInfo.setCanEdit(CanEditEnum.DISABLED);
                gradeTaskNodeInfo.setIsVisible(IsVisibleEnum.HIDDEN);
                gradeTaskNodeInfo.setTaskStatus(TaskStatusEnum.COMPLETED);
                if (!gradeTaskNodeInfo.getScoreStatus().getValue().equals("2")) {
                    gradeTaskNodeInfo.setIsEffective(IsEffectiveEnum.INVALID);
                    gradeTaskNodeInfo.setConcurrentNodeStatus(ConcurrentNodeStatusEnum.OTHERSUBMIT);
                } else {
                    gradeTaskNodeInfo.setIsVisible(IsVisibleEnum.VISIBLE);
                }
                if (!StringUtils.isEmpty((CharSequence)gradeTaskNodeInfo.getInweight())) {
                    outWeight = outWeight.add(new BigDecimal(gradeTaskNodeInfo.getInweight()));
                }
                if (weightAccuTypeEnum.getValue() == 0) {
                    gradeTaskNodeInfo.setOutWeight(String.valueOf(outWeight));
                    gradeTaskNodeInfo.setWeightAccuType(WeightAccuTypeEnum.AVERAGETONEXT);
                    gradeTaskNodeInfo.setIsSkipNode(true);
                } else if (weightAccuTypeEnum.getValue() == 1) {
                    gradeTaskNodeInfo.setOutWeight(String.valueOf(outWeight));
                    gradeTaskNodeInfo.setWeightAccuType(WeightAccuTypeEnum.PROPORTIONTONEXT);
                    gradeTaskNodeInfo.setIsSkipNode(true);
                } else if (weightAccuTypeEnum.getValue() == 2) {
                    gradeTaskNodeInfo.setWeightAccuType(WeightAccuTypeEnum.UNCUMUTONEXT_CURISEFFECT);
                    if (gradeTaskNodeInfo.getScoreStatus().getValue() != "2") {
                        gradeTaskNodeInfo.setIsSkipNode(true);
                        gradeTaskNodeInfo.setOutWeight(String.valueOf(outWeight));
                    } else {
                        gradeTaskNodeInfo.setIsSkipNode(false);
                    }
                }
                gradeTaskNodeInfo.setScoreStatus(ScoreStatusEnum.SUBMIT);
                currentCoreBaseColl.add((CoreBaseInfo)gradeTaskNodeInfo);
            }
            iGradeTaskNodeInst.updateBatchData(currentCoreBaseColl);
            currentCoreBaseColl.clear();
        }
        catch (Exception e) {
            logger.error("\u3010PERFWEB\u3011-SETCURRENTNODEINVALIDERR\uff01", (Throwable)e);
        }
    }

    protected static BigDecimal getCurrentNodeOutWeight(Context ctx, WFNodeDefInfo wfNodeDefInfo, String evaObj) {
        String workflow = wfNodeDefInfo.getWorkflow().getId().toString();
        int level = wfNodeDefInfo.getLevel();
        BigDecimal sumNodeWeight = new BigDecimal("0");
        try {
            IGradeTaskNodeInst iGradeTaskNodeInst = GradeTaskNodeInstFactory.getLocalInstance((Context)ctx);
            WFNodeDefCollection wfNodeDefColl = GetEntityInfoUtils.getWfNodeDefColl(ctx, workflow, level);
            if (null != wfNodeDefColl && wfNodeDefColl.size() > 0) {
                int nodeSize = wfNodeDefColl.size();
                for (int i = 0; i < nodeSize; ++i) {
                    StringBuffer conditionSb = new StringBuffer(" where wfLevel=").append(level).append(" and evaObj='").append(evaObj).append("' and isSkipNode=1 and wfNode='").append(wfNodeDefColl.get(i).getId().toString()).append("'");
                    GradeTaskNodeInstCollection gradeTaskNodeColl = iGradeTaskNodeInst.getGradeTaskNodeInstCollection(conditionSb.toString());
                    if (null == gradeTaskNodeColl) continue;
                    sumNodeWeight = sumNodeWeight.add(new BigDecimal(gradeTaskNodeColl.get(0).getOutWeight()));
                }
            }
        }
        catch (BOSException e) {
            logger.error("\u3010PERFWEB\u3011-GETCURRENTJUMPNODEERR", (Throwable)e);
        }
        return sumNodeWeight;
    }

    protected static void asignWeightToNextGadeTaskNodeOfAverage(Context ctx, String evaObj, WFNodeDefInfo wfNodeDefInfo, BigDecimal sumNodeWeight) {
        try {
            IGradeTaskNodeInst iGradeTaskNodeInst = GradeTaskNodeInstFactory.getLocalInstance((Context)ctx);
            CoreBaseCollection nextCoreBaseColl = new CoreBaseCollection();
            String workflow = wfNodeDefInfo.getWorkflow().getId().toString();
            int level = wfNodeDefInfo.getLevel() + 1;
            WFNodeDefCollection nextWFNodeColl = GetEntityInfoUtils.getWfNodeDefColl(ctx, workflow, level);
            int nextWFNodeSize = nextWFNodeColl.size();
            Map<String, BigDecimal> meanMap = WorkflowJumpUtils.calcuMean(sumNodeWeight, new BigDecimal(nextWFNodeSize));
            BigDecimal average = meanMap.get("average");
            BigDecimal remainder = meanMap.get("remainder");
            for (int i = 0; i < nextWFNodeSize; ++i) {
                WFNodeDefInfo nodeInfo = nextWFNodeColl.get(i);
                GradeTaskNodeInstCollection gradeTaskNodeInstColl = GetEntityInfoUtils.getGradeTaskNodeInstCollection(ctx, evaObj, nodeInfo.getId().toString(), null);
                for (int j = 0; j < gradeTaskNodeInstColl.size(); ++j) {
                    GradeTaskNodeInstInfo gradeTaskNodeInfo = gradeTaskNodeInstColl.get(j);
                    gradeTaskNodeInfo.setInweight(String.valueOf(average));
                    gradeTaskNodeInfo.setWeightAccuType(null);
                    if (i == nextWFNodeSize - 1) {
                        gradeTaskNodeInfo.setInweight(String.valueOf(average.add(remainder)));
                    }
                    nextCoreBaseColl.add((CoreBaseInfo)gradeTaskNodeInfo);
                }
            }
            iGradeTaskNodeInst.save(nextCoreBaseColl);
            nextCoreBaseColl.clear();
        }
        catch (Exception e) {
            logger.error("\u3010PERFWEB\u3011-AVGDISTRIBUTEWEIGHTTONEXTNODEERR\uff01", (Throwable)e);
        }
    }

    protected static void asignWeightToNextGadeTaskNodeOfProportion(Context ctx, String evaObj, WFNodeDefCollection wfNodeDefColl, BigDecimal sumNodeWeight) {
        try {
            int nodeSize = wfNodeDefColl.size();
            HashMap<String, BigDecimal> nodeWeightMap = new HashMap<String, BigDecimal>();
            BigDecimal sumWeight = new BigDecimal("0.00");
            for (int i = 0; i < nodeSize; ++i) {
                WFNodeDefInfo nodeDefInfo = wfNodeDefColl.get(i);
                sumWeight = sumWeight.add(new BigDecimal(nodeDefInfo.getNodeWeight()));
                nodeWeightMap.put(nodeDefInfo.getId().toString(), new BigDecimal(nodeDefInfo.getNodeWeight()));
            }
            Map<String, BigDecimal> meanMap = WorkflowJumpUtils.calcuMean(sumNodeWeight, sumWeight);
            BigDecimal average = meanMap.get("average");
            BigDecimal remainder = meanMap.get("remainder");
            int size = 0;
            CoreBaseCollection nextCoreBaseColl = new CoreBaseCollection();
            for (Map.Entry entry : nodeWeightMap.entrySet()) {
                BigDecimal inWeight = new BigDecimal("0.00");
                inWeight = ((BigDecimal)entry.getValue()).compareTo(new BigDecimal("0")) == 0 ? average : ((BigDecimal)entry.getValue()).multiply(average);
                if (++size == nodeSize) {
                    inWeight = ((BigDecimal)entry.getValue()).multiply(average).add(remainder);
                }
                GradeTaskNodeInstCollection gradeTaskNodeInstColl = GetEntityInfoUtils.getGradeTaskNodeInstCollection(ctx, evaObj, (String)entry.getKey(), null);
                for (int j = 0; j < gradeTaskNodeInstColl.size(); ++j) {
                    GradeTaskNodeInstInfo gradeTaskNodeInfo = gradeTaskNodeInstColl.get(j);
                    gradeTaskNodeInfo.setInweight(String.valueOf(inWeight));
                    gradeTaskNodeInfo.setWeightAccuType(null);
                    nextCoreBaseColl.add((CoreBaseInfo)gradeTaskNodeInfo);
                }
            }
            IGradeTaskNodeInst iGradeTaskNodeInst = GradeTaskNodeInstFactory.getLocalInstance((Context)ctx);
            iGradeTaskNodeInst.save(nextCoreBaseColl);
            nextCoreBaseColl.clear();
        }
        catch (Exception e) {
            logger.error("\u3010PERFWEB\u3011-DISTRIBUTEWEIGHTTONEXTNODEERR\uff01", (Throwable)e);
        }
    }

    protected static void asignWeightAverageToCurrentLevelOtherNode(Context ctx, String evaObj, WFNodeDefInfo wfNodeDefInfo) {
        try {
            int currentLevel = wfNodeDefInfo.getLevel();
            WFNodeDefCollection nodeDefColl = GetEntityInfoUtils.getWfNodeDefColl(ctx, wfNodeDefInfo.getWorkflow().getId().toString(), currentLevel);
            BigDecimal sumNodeWeight = new BigDecimal("0");
            ArrayList<WFNodeDefInfo> effectedNodeList = new ArrayList<WFNodeDefInfo>();
            HashMap<String, GradeTaskNodeInstCollection> toAsignWeightGradeTaskNodeMap = new HashMap<String, GradeTaskNodeInstCollection>();
            if (null != nodeDefColl && nodeDefColl.size() > 0) {
                int nodeSize = nodeDefColl.size();
                block2: for (int i = 0; i < nodeSize; ++i) {
                    GradeTaskNodeInstCollection gradeTaskNodeInstColl = GetEntityInfoUtils.getGradeTaskNodeInstCollection(ctx, evaObj, nodeDefColl.get(i).getId().toString(), null);
                    if (null == gradeTaskNodeInstColl || gradeTaskNodeInstColl.size() <= 0) continue;
                    int gradeTaskNodeInstSize = gradeTaskNodeInstColl.size();
                    int unSubmitTaskNodeSize = 0;
                    for (int j = 0; j < gradeTaskNodeInstSize; ++j) {
                        GradeTaskNodeInstInfo gradeTaskNodeInfo = gradeTaskNodeInstColl.get(j);
                        if (gradeTaskNodeInfo.getScoreStatus().getValue().equals("2") && gradeTaskNodeInfo.getIsEffective().getValue().equals("1")) {
                            effectedNodeList.add(nodeDefColl.get(i));
                            toAsignWeightGradeTaskNodeMap.put(nodeDefColl.get(i).getId().toString(), gradeTaskNodeInstColl);
                            continue block2;
                        }
                        if (++unSubmitTaskNodeSize != gradeTaskNodeInstSize) continue;
                        sumNodeWeight = sumNodeWeight.add(new BigDecimal(nodeDefColl.get(i).getNodeWeight()));
                        if (!StringUtils.isNotEmpty((CharSequence)gradeTaskNodeInfo.getInweight())) continue;
                        sumNodeWeight.add(new BigDecimal(gradeTaskNodeInfo.getInweight()));
                    }
                }
                BigDecimal sumWeight = new BigDecimal("0.00");
                HashMap<String, BigDecimal> nodeWeightMap = new HashMap<String, BigDecimal>();
                for (WFNodeDefInfo nodeDefInfo : effectedNodeList) {
                    sumWeight = sumWeight.add(new BigDecimal(nodeDefInfo.getNodeWeight()));
                    nodeWeightMap.put(nodeDefInfo.getId().toString(), new BigDecimal(nodeDefInfo.getNodeWeight()));
                }
                Map<String, BigDecimal> meanMap = WorkflowJumpUtils.calcuMean(sumNodeWeight, sumWeight);
                BigDecimal average = meanMap.get("average");
                BigDecimal remainder = meanMap.get("remainder");
                int size = 1;
                int effectedNodeSize = effectedNodeList.size();
                CoreBaseCollection otherCoreBaseColl = new CoreBaseCollection();
                for (Map.Entry entry : nodeWeightMap.entrySet()) {
                    BigDecimal inWeight = new BigDecimal("0.00");
                    inWeight = ((BigDecimal)entry.getValue()).compareTo(new BigDecimal("0")) == 0 ? average : ((BigDecimal)entry.getValue()).multiply(average);
                    if (size == effectedNodeSize) {
                        inWeight = inWeight.add(remainder);
                    }
                    ++size;
                    GradeTaskNodeInstCollection gradeTaskNodeInstColl = (GradeTaskNodeInstCollection)toAsignWeightGradeTaskNodeMap.get(entry.getKey());
                    for (int j = 0; j < gradeTaskNodeInstColl.size(); ++j) {
                        GradeTaskNodeInstInfo gradeTaskNodeInfo = gradeTaskNodeInstColl.get(j);
                        if (!StringUtils.isEmpty((CharSequence)gradeTaskNodeInfo.getInweight())) {
                            inWeight = inWeight.add(new BigDecimal(gradeTaskNodeInfo.getInweight()));
                        }
                        gradeTaskNodeInfo.setInweight(String.valueOf(inWeight));
                        gradeTaskNodeInfo.setWeightAccuType(null);
                        otherCoreBaseColl.add((CoreBaseInfo)gradeTaskNodeInfo);
                    }
                }
                IGradeTaskNodeInst iGradeTaskNodeInst = GradeTaskNodeInstFactory.getLocalInstance((Context)ctx);
                iGradeTaskNodeInst.save(otherCoreBaseColl);
                otherCoreBaseColl.clear();
            }
        }
        catch (Exception e) {
            logger.error("\u3010PERFWEB\u3011-AVGDISTRIBUTEWEIGHTTOOTHERNODEERR\uff01", (Throwable)e);
        }
    }

    public static Map<String, BigDecimal> calcuMean(BigDecimal dividend, BigDecimal divisor) {
        HashMap<String, BigDecimal> resultMap = new HashMap<String, BigDecimal>();
        if (divisor.compareTo(new BigDecimal("0")) == 0) {
            resultMap.put("average", dividend);
            resultMap.put("remainder", divisor);
            return resultMap;
        }
        BigDecimal average = dividend.divide(divisor, 2, 5);
        BigDecimal remainder = dividend.subtract(average.multiply(divisor));
        resultMap.put("average", average);
        resultMap.put("remainder", remainder);
        return resultMap;
    }

    public static boolean regrade(Context ctx, String[] gradeNodeInstArr) {
        try {
            String evaObj = "";
            IGradeTaskNodeInst iGradeTaskNodeInst = GradeTaskNodeInstFactory.getLocalInstance((Context)ctx);
            CoreBaseCollection coreBaseColl = null;
            String idCondition = "(" + PerfwebStrUtils.convertListToString(gradeNodeInstArr) + ")";
            GradeTaskNodeInstCollection gradeTaskNodeInstColl = iGradeTaskNodeInst.getGradeTaskNodeInstCollection(" where id in " + idCondition);
            if (null != gradeTaskNodeInstColl && gradeTaskNodeInstColl.size() > 0) {
                int size = gradeTaskNodeInstColl.size();
                evaObj = gradeTaskNodeInstColl.get(0).getEvaObj().getId().toString();
                coreBaseColl = new CoreBaseCollection();
                for (int i = 0; i < size; ++i) {
                    GradeTaskNodeInstInfo gradeTaskNodeInstInfo = gradeTaskNodeInstColl.get(i);
                    gradeTaskNodeInstInfo.setIsEffective(IsEffectiveEnum.EFFECTIVE);
                    gradeTaskNodeInstInfo.setScoreStatus(ScoreStatusEnum.UNSUBMIT);
                    gradeTaskNodeInstInfo.setIsVisible(IsVisibleEnum.VISIBLE);
                    gradeTaskNodeInstInfo.setCanEdit(CanEditEnum.CANEDIT);
                    gradeTaskNodeInstInfo.setTaskStatus(TaskStatusEnum.DEALING);
                    gradeTaskNodeInstInfo.setIsEndProcess(YesOrNoEnum.NO);
                    gradeTaskNodeInstInfo.setIsRegrade(YesOrNoEnum.YES);
                    WorkflowJumpUtils.disposeIndicatorTarget(ctx, gradeTaskNodeInstInfo.getEvaObj().getId().toString(), gradeTaskNodeInstInfo.getNodeHandler().getId().toString());
                    coreBaseColl.add((CoreBaseInfo)gradeTaskNodeInstInfo);
                }
                iGradeTaskNodeInst.update(coreBaseColl);
                coreBaseColl.clear();
            }
            PerfEvaObjectInfo evaObjInfo = GetEntityInfoUtils.getPerfEvaObjectInfo(ctx, evaObj);
            WorkFlowUtils.writeBackWorkFlowStatusForEvaObj(ctx, evaObjInfo, PerfEvaObjectWFStatusEnum.UNDERWAY);
            WorkFlowUtils.updatePerfEvaobjScoreTaskStatus(ctx, new String[]{evaObj}, ScoreTaskStatusEnum.HADSENT);
            IPerfEvaObject iPerfEvaObject = PerfEvaObjectFactory.getLocalInstance((Context)ctx);
            iPerfEvaObject.urgedGradeSendSuccess(evaObj);
            int isOrg = evaObjInfo.getIsOrg().getValue();
            if (isOrg == 1) {
                OrgEvaResultSummaryInfo evaResultSummaryInfo = GetEntityInfoUtils.getEvaResultSummaryInfo4Org(ctx, evaObj);
                iPerfEvaObject.deleteEvaresultAuditBill(evaResultSummaryInfo.getId().toString(), "11");
                evaResultSummaryInfo.put("reviseSumScore", null);
                evaResultSummaryInfo.put("reviseGradeLevel", null);
                OrgEvaResultSummaryFactory.getLocalInstance((Context)ctx).save((CoreBaseInfo)evaResultSummaryInfo);
            } else {
                EvaResultSummaryInfo evaResultSummaryInfo = GetEntityInfoUtils.getEvaResultSummaryInfoByEvaObj(ctx, evaObj);
                iPerfEvaObject.deleteEvaresultAuditBill(evaResultSummaryInfo.getId().toString(), "10");
                evaResultSummaryInfo.put("reviseSumScore", null);
                evaResultSummaryInfo.put("reviseGradeLevel", null);
                EvaResultSummaryFactory.getLocalInstance((Context)ctx).save((CoreBaseInfo)evaResultSummaryInfo);
            }
            return true;
        }
        catch (BOSException e) {
            logger.error("Exception: ", (Throwable)e);
            return false;
        }
        catch (EASBizException e) {
            logger.error("Exception: ", (Throwable)e);
            return false;
        }
    }

    public static void disposeIndicatorTarget(Context ctx, String evaObj, String person) {
        try {
            IAchivementDataEntrior iAchivementDataEntrior = AchivementDataEntriorFactory.getLocalInstance((Context)ctx);
            IIndicatorTarget iIndicatorTarget = IndicatorTargetFactory.getLocalInstance((Context)ctx);
            IndicatorTargetCollection indicatorTargetCollection = iIndicatorTarget.getIndicatorTargetCollection("where actCompValState='0' and  qualiOrRation=1 and evaObj='" + evaObj + "'");
            if (indicatorTargetCollection != null && indicatorTargetCollection.size() > 0) {
                CoreBaseCollection coreBaseCollection = new CoreBaseCollection();
                for (int i = 0; i < indicatorTargetCollection.size(); ++i) {
                    IndicatorTargetInfo indicatorTargetInfo = indicatorTargetCollection.get(i);
                    AchivementDataEntriorCollection achivementDataEntriorCollection = iAchivementDataEntrior.getAchivementDataEntriorCollection("where person ='" + person + "' and target='" + indicatorTargetInfo.getId().toString() + "'");
                    if (achivementDataEntriorCollection == null || achivementDataEntriorCollection.size() <= 0) continue;
                    indicatorTargetInfo.setAchivementEntryState(AchivementDataEntryStateEnum.SAVED);
                    coreBaseCollection.add((CoreBaseInfo)indicatorTargetInfo);
                }
                iIndicatorTarget.save(coreBaseCollection);
            }
        }
        catch (BOSException e) {
            logger.error("perfweb : method disposeIndicatorTarget error :" + e.getMessage());
        }
        catch (EASBizException e) {
            logger.error("perfweb : method disposeIndicatorTarget error :" + e.getMessage());
        }
    }

    public static Map<String, String> isCanJump(Context ctx, String evaObj) {
        String wfNode;
        WFNodeDefInfo wfNodeInfo;
        HashMap<String, String> res = new HashMap<String, String>();
        res.put("result", "200");
        GradeTaskNodeInstCollection gradeTaskNodeInstColl = null;
        try {
            PerfEvaObjectInfo perfEvaObjectInfo = GetEntityInfoUtils.getPerfEvaObjectInfo(ctx, evaObj);
            PerfPeriodInfo periodInfo = GetEntityInfoUtils.getPerfPeriodInfo(ctx, perfEvaObjectInfo.getPeriod().getId().toString());
            if (periodInfo.getEvaPeriodStatus().getValue() == EvaPeriodStatusEnum.EVALUATED.getValue()) {
                res.put("result", "500");
                res.put("message", SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.JUMPNOTALLOWEDASPERIODENDED, ctx));
                return res;
            }
            IGradeTaskNodeInst iGradeTaskNodeInst = GradeTaskNodeInstFactory.getLocalInstance((Context)ctx);
            gradeTaskNodeInstColl = iGradeTaskNodeInst.getGradeTaskNodeInstCollection(" where evaObj='" + evaObj + "' and isEffective='" + "1" + "' and scoreStatus='" + "1" + "' and taskStatus='" + "1" + "' and isRegrade=" + 0 + " order by wfLevel asc");
        }
        catch (BOSException e1) {
            logger.error("", (Throwable)e1);
        }
        if (null == gradeTaskNodeInstColl || gradeTaskNodeInstColl.size() < 1) {
            res.put("result", "500");
            res.put("message", SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.JUMPERRASJUMPABLEWORKFLOWNOTFOUND, ctx));
            return res;
        }
        int wfLevel = gradeTaskNodeInstColl.get(0).getWfLevel();
        GradeTaskNodeInstCollection nextGradeTaskNodeInstColl = GetEntityInfoUtils.getGradeTaskNodeInstCollByEvaObjAndNodeLevel(ctx, evaObj, wfLevel + 1, (wfNodeInfo = GetEntityInfoUtils.getWFNodeDefInfo(ctx, wfNode = gradeTaskNodeInstColl.get(0).getWfNode().getId().toString())).getWorkflow().getId().toString());
        if (null == nextGradeTaskNodeInstColl || nextGradeTaskNodeInstColl.size() < 1) {
            res.put("result", "500");
            res.put("message", SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.JUMPINVLIDASFINALWORKFLOW, ctx));
            return res;
        }
        return res;
    }
}

