/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.server.PagingHelper;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.sql.KSqlUtil;
import com.kingdee.bos.workflow.exception.biz.WfBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.perfweb.utils.CommonSQLUtil;
import com.kingdee.shr.perfweb.utils.ICustomDataProcessor;
import com.kingdee.shr.perfweb.utils.MapUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomPageHelper {
    private static Logger logger = LoggerFactory.getLogger(CustomPageHelper.class);

    private CustomPageHelper() {
    }

    public static Map<String, Object> getPageCallbackData(Context ctx, HttpServletRequest request, String sql, String orderFld, ICustomDataProcessor process, String type) throws BOSException, SQLException {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (StringUtils.isEmpty((String)sql)) {
            return resultMap;
        }
        int rows = 0;
        if (request.getAttribute("rows") != null && !StringUtils.isEmpty((String)request.getAttribute("rows").toString())) {
            rows = Integer.parseInt(request.getAttribute("rows").toString());
        } else if (!StringUtils.isEmpty((String)request.getParameter("rows"))) {
            rows = Integer.parseInt(request.getParameter("rows"));
        }
        int page = 0;
        if (request.getAttribute("page") != null && !StringUtils.isEmpty((String)request.getAttribute("page").toString())) {
            page = Integer.parseInt(request.getAttribute("page").toString());
        } else if (!StringUtils.isEmpty((String)request.getParameter("page")) && !"null".equals(request.getParameter("page"))) {
            page = Integer.parseInt(request.getParameter("page"));
        }
        String sidx = request.getParameter("sidx");
        if (request.getAttribute("sidx") != null && !StringUtils.isEmpty((String)request.getAttribute("sidx").toString())) {
            sidx = request.getAttribute("sidx").toString();
        } else if (!StringUtils.isEmpty((String)request.getParameter("sidx"))) {
            sidx = request.getParameter("sidx");
        }
        String sord = request.getParameter("sord");
        if (request.getAttribute("sord") != null && !StringUtils.isEmpty((String)request.getAttribute("sord").toString())) {
            sord = request.getAttribute("sord").toString();
        } else if (!StringUtils.isEmpty((String)request.getParameter("sord"))) {
            sord = request.getParameter("sord");
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("rows", rows);
        params.put("page", page);
        params.put("sidx", sidx);
        params.put("sord", sord);
        return CustomPageHelper.getPageCallbackData(ctx, params, sql, orderFld, process, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Object> getPageCallbackData(Context ctx, Map<String, Object> requestMap, String sql, String orderFld, ICustomDataProcessor process, String type) throws BOSException, SQLException {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (StringUtils.isEmpty((String)sql)) {
            return resultMap;
        }
        Integer rows = MapUtils.toInt(requestMap, "rows");
        Integer page = MapUtils.toInt(requestMap, "page");
        String sidx = (String)requestMap.get("sidx");
        String sord = (String)requestMap.get("sord");
        int totalCount = process.getTotalCount(ctx, sql);
        int length = rows;
        if (page * rows > totalCount) {
            length = totalCount - (page - 1) * rows;
        }
        int start = (page - 1) * rows;
        if (!StringUtils.isEmpty((String)sidx) && !"null".equals(sidx)) {
            sql = sql + " order by " + sidx;
            if (!StringUtils.isEmpty((String)sord)) {
                sql = sql + " " + sord;
            }
            if (!StringUtils.isEmpty((String)orderFld)) {
                String[] orderCondtions;
                for (String orderCondition : orderCondtions = orderFld.split(",")) {
                    if (orderCondition.contains(sidx)) continue;
                    sql = sql + "," + orderCondition;
                }
            }
        } else if (!StringUtils.isEmpty((String)orderFld)) {
            sql = sql + " order by " + orderFld;
        }
        long top = page * rows;
        sql = sql.trim().replaceFirst("SELECT", "SELECT TOP " + top);
        Connection conn = null;
        IRowSet rowset = null;
        List<?> cols = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            sql = new PagingHelper().getPagingSqlNoOptmize(KSqlUtil.getDbType((Connection)conn), sql, start, rows.intValue());
            rowset = DbUtil.executeQuery((Context)ctx, (String)sql);
            cols = process.formatResultData(ctx, rowset, type);
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rowset, null, (Connection)conn);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rowset, null, (Connection)conn);
        if (totalCount % rows == 0) {
            resultMap.put("total", totalCount / rows);
        } else {
            resultMap.put("total", totalCount / rows + 1);
        }
        resultMap.put("page", page);
        resultMap.put("records", totalCount);
        resultMap.put("rows", cols);
        return resultMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Object> getPageCallbackData(Context ctx, Map<String, Object> requestMap, String sql, String orderFld, ICustomDataProcessor process, String type, Object[] conditionParams) throws BOSException, SQLException {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (StringUtils.isEmpty((String)sql)) {
            return resultMap;
        }
        Integer rows = MapUtils.toInt(requestMap, "rows");
        Integer page = MapUtils.toInt(requestMap, "page");
        String sidx = (String)requestMap.get("sidx");
        String sord = (String)requestMap.get("sord");
        String countSql = "select count(1) from (" + sql + ") as A";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)countSql, (Object[])conditionParams);
        int totalCount = CommonSQLUtil.getTotalCount(rowSet);
        int start = (page - 1) * rows;
        if (!StringUtils.isEmpty((String)sidx) && !"null".equals(sidx)) {
            sql = sql + " order by " + sidx;
            if (!StringUtils.isEmpty((String)sord)) {
                sql = sql + " " + sord;
            }
            if (!StringUtils.isEmpty((String)orderFld)) {
                String[] orderConditions = orderFld.split(",");
                StringBuilder sqlBuilder = new StringBuilder(sql);
                for (String orderCondition : orderConditions) {
                    if (orderCondition.contains(sidx)) continue;
                    sqlBuilder.append(",").append(orderCondition);
                }
                sql = sqlBuilder.toString();
            }
        } else if (!StringUtils.isEmpty((String)orderFld)) {
            sql = sql + " order by " + orderFld;
        }
        long top = (long)page.intValue() * (long)rows.intValue();
        sql = sql.trim().replaceFirst("SELECT", "SELECT TOP " + top);
        Connection conn = null;
        IRowSet rowset = null;
        List<?> cols = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            sql = new PagingHelper().getPagingSqlNoOptmize(KSqlUtil.getDbType((Connection)conn), sql, start, rows.intValue());
            rowset = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])conditionParams);
            cols = process.formatResultData(ctx, rowset, type);
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rowset, null, (Connection)conn);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rowset, null, (Connection)conn);
        if (totalCount % rows == 0) {
            resultMap.put("total", totalCount / rows);
        } else {
            resultMap.put("total", totalCount / rows + 1);
        }
        resultMap.put("page", page);
        resultMap.put("records", totalCount);
        resultMap.put("rows", cols);
        return resultMap;
    }

    public int getTotalCount(Context ctx, String sql) throws WfBizException {
        int totalCount;
        try {
            String countSql = "select count(1) from (" + sql + ") as A";
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)countSql);
            totalCount = CommonSQLUtil.getTotalCount(rowSet);
        }
        catch (BOSException e) {
            logger.error("BOSException: ", (Throwable)e);
            throw new WfBizException((Throwable)e);
        }
        return totalCount;
    }
}

