/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.workflow.serviceImpl;

import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.define.ProcessEvent;
import com.kingdee.bos.workflow.enactment.IWfProcess;
import com.kingdee.bos.workflow.enactment.handler.AbstractProcessEventHandler;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.shr.perfweb.util.GetEntityInfoUtils;
import com.kingdee.shr.perfweb.util.PerfDbUtil;
import java.sql.Timestamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkFlowServiceEventListener
extends AbstractProcessEventHandler {
    private static final Logger logger = LoggerFactory.getLogger(WorkFlowServiceEventListener.class);

    protected void handleBizObject(ProcessEvent e, IWfProcess process, String[] bizObjIds) {
        for (int i = 0; i < bizObjIds.length; ++i) {
            String id = bizObjIds[i];
            if (!e.equals((Object)ProcessEvent.OnProcessAborted)) continue;
            this.handleProcessAborted(process, id);
        }
    }

    private void handleProcessAborted(IWfProcess process, String id) {
        try {
            String bosType = BOSUuid.read((String)id).getType().toString();
            logger.error("[perfweb process aborted]current bosType string is " + bosType);
            Context ctx = process.getContext();
            UserInfo userInfo = GetEntityInfoUtils.getUserInfo(ctx);
            Timestamp now = new Timestamp(System.currentTimeMillis());
            String tableName = "";
            switch (bosType) {
                case "FE5E39A6": {
                    tableName = "T_TAR_TargetTransmitBill";
                    break;
                }
                case "789163AE": {
                    tableName = "T_TAR_TargetReviseBill";
                    break;
                }
                case "864B756E": {
                    tableName = "T_EVA_EvaResultAuditBill";
                    break;
                }
                case "97AE57A8": {
                    tableName = "T_EVA_EvaResultAppealBill";
                    break;
                }
                case "4C9697EC": {
                    tableName = "T_PEF_PerfSumResultAuditBill";
                    break;
                }
                case "169029DF": {
                    tableName = "T_PEF_SumCalResultAppealBill";
                    break;
                }
                case "65F48D40": {
                    tableName = "T_EVA_OrgEvaResultAuditBill";
                    break;
                }
                case "E4031DB8": {
                    tableName = "T_EVA_EvaResultAppealBill4Org";
                    break;
                }
                default: {
                    return;
                }
            }
            String updateSql = "update " + tableName + " set fbillState = 4, flastUpdateTime = ?, flastUpdateUserID = ? where fid = ?";
            PerfDbUtil.execute((Context)ctx, (String)updateSql, (Object[])new Object[]{now, userInfo.getId().toString(), id});
        }
        catch (Exception e) {
            logger.error("billId =" + id + ", handleProcessAborted error: ", (Throwable)e);
        }
    }
}

